package com.digiwin.mobile.mobileuibot.config;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;

/**
 * 初始化基础配置
 *
 * @author zhangjj
 * @date 2022/5/26 15:54
 */
@Configuration
public class BaseConfig {

    @Autowired
    private SysEnvConfig sysEnvConfig;

    @Autowired
    private LocaleService localeService;

    @PostConstruct
    public void init() {
        // 设置系统环境变量存入上下文
        AppContext.setApiUrlSetting(sysEnvConfig);
        localeService.cacheAllLanguageSourceList();
    }
}