package com.digiwin.mobile.mobileuibot.config;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.sysmanage.cache.CacheService;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import java.util.concurrent.TimeUnit;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CacheConfig
 * @Author: Zaregoto
 * @Date: 2021/11/25 0:07
 */
@Configuration
@EnableCaching
public class CacheConfig {

    @Bean(name = "systemCacheManager")
    @Primary
    public CaffeineCacheManager systemCacheManager() {
        CaffeineCacheManager cacheManager = new CaffeineCacheManager();
        cacheManager.setCaffeine(Caffeine.newBuilder()
                .recordStats()
                // 设置最后一次写入或访问后经过固定时间过期
                .expireAfterAccess(600, TimeUnit.SECONDS)
                // 初始的缓存空间大小
                .initialCapacity(64)
                // 缓存的最大条数
                .maximumSize(512));
        return cacheManager;
    }

    @Bean(name = "projectCacheManager")
    public CaffeineCacheManager projectCacheManager() {
        CaffeineCacheManager cacheManager = new CaffeineCacheManager();
        cacheManager.setCaffeine(Caffeine.newBuilder()
                .recordStats()
                // 设置最后一次写入或访问后经过固定时间过期
                .expireAfterAccess(60, TimeUnit.MINUTES)
                // 设置最后一次写入后经过固定时间会被刷新（前提是有被访问过）
                .refreshAfterWrite(5, TimeUnit.MINUTES)
                // 初始的缓存空间大小
                .initialCapacity(64)
                // 缓存的最大条数
                .maximumSize(512));
        cacheManager.setCacheLoader(new CacheLoader<Object, Object>() {
            @Override
            public @Nullable Object load(@NonNull Object o) throws Exception {
                CacheService cacheService = SpringContextHolder.getBean("cacheService");
                return cacheService.refreshByKey(o);
            }

            @Override
            public @Nullable Object reload(@NonNull Object key, @NonNull Object oldValue) throws Exception {
                System.out.println("reload cache activated...key is " + key + ", oldValue is " + JsonUtil.javaObjectToJsonString(oldValue));
                return CacheLoader.super.reload(key, oldValue);
            }
        });
        return cacheManager;
    }

    @Bean(name = "languageSourceCacheManager")
    public CaffeineCacheManager languageSourceCacheManager() {
        CaffeineCacheManager cacheManager = new CaffeineCacheManager();
        cacheManager.setCaffeine(Caffeine.newBuilder()
                .recordStats()
                // 初始的缓存空间大小
                .initialCapacity(64));
        return cacheManager;
    }
}
