package com.digiwin.mobile.mobileuibot.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;
import java.math.BigDecimal;

/**
 * <p>功能描述：通用Double类型的jackson序列化配置</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CommonDoubleJsonSerializer
 * @Author: zaregoto
 * @Date: 2024/2/20 19:44
 */
public class CommonDoubleJsonSerializer extends JsonSerializer<Double> {
    @Override
    public void serialize(Double aDouble, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        BigDecimal d = new BigDecimal(String.valueOf(aDouble));
        jsonGenerator.writeNumber(d.toPlainString());
    }
}
