package com.digiwin.mobile.mobileuibot.config;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMobileNotificationCategoryEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinI18nResourceFactory
 * @Author: Zaregoto
 * @Date: 2021/4/21 16:38
 */
public class DigiwinI18nResourceFactory {

    private static final Logger logger = LoggerFactory.getLogger(DigiwinI18nResourceFactory.class);

    private static final Locale[] SUPPORT_LOCALE =
            {Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE, Locale.US};
//
//    @Autowired
//    private HttpService httpService;
//
//    @Autowired
//    private SysEnvConfig sysEnvConfig;

    void init() {
//        String defaultI18nResourceUrl =
//                sysEnvConfig.getAthenaHost() + "/assets/i18n/%s/basic.json";
//        for (Locale locale : SUPPORT_LOCALE) {
//            String url = String.format(defaultI18nResourceUrl, locale.toString());
//            try {
//                ResponseEntity<Map> responseEntity = this.httpService.doGet(url, Map.class);
//                if (responseEntity.getStatusCode().is2xxSuccessful()) {
//                    Map<String, String> athenaI18nResource = responseEntity.getBody();
//                    athenaI18nResource.putAll(this.getMobileSpecificI18nResource(locale.toString()));
//
//                    AppContext.getDefaultI18nResourceMap().put(locale.toString(), athenaI18nResource);
//                    logger.debug("{} language resource load successfully...", locale);
//                }
//            } catch (Exception e) {
//                logger.error("{} language resource load error...", locale, e);
//            }
//        }
        for (Locale locale : SUPPORT_LOCALE) {
            try {
                AppContext.getDefaultI18nResourceMap().put(locale.toString(), this.getMobileSpecificI18nResource(locale.toString()));
                logger.debug("{} language resource load successfully...", locale);
            } catch (Exception e) {
                logger.error("{} language resource load error...", locale, e);
            }
        }
    }

    /**
     * 根据传入语言别参数获取I18N资源，若找不到则返回简体中文资源
     *
     * @param locale
     * @return
     */
    private Map<String, String> getMobileSpecificI18nResource(String locale) {
        if (Locale.TRADITIONAL_CHINESE.toString().equalsIgnoreCase(locale)) {
            return this.getMobileZhTwI18nResource();
        } else if (Locale.US.toString().equalsIgnoreCase(locale)) {
            return this.getMobileEnUsI18nResource();
        } else {
            return this.getMobileZhCnI18nResource();
        }
    }

    private Map<String, String> getMobileZhCnI18nResource() {
        Map<String, String> result = new LinkedHashMap<>();
        // 页面标题
        result.put("dj-mobile-" + PageSettingIdPresetEnum.INDEX, "首页");
        result.put("dj-mobile-" + AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT,
                "工作提醒");
        result.put("dj-mobile-" + AthenaMobileNotificationCategoryEnum.MOBILE_PROJECT_ASSISTANT,
                "项目助理");
        result.put("dj-mobile-" + AthenaMobileNotificationCategoryEnum.MOBILE_SYSTEM, "系统通知");
        result.put("dj-mobile-" + AthenaMobileNotificationCategoryEnum.MOBILE_MY_TODO, "我的待办");
        result.put("dj-mobile-" + AthenaMobileNotificationCategoryEnum.MOBILE_MY_PROJECT, "我的项目");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_APPROVAL_TASK_PROGRESS, "签核进度");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_AGREE, "同意");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_DISAGREE, "不同意");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_REAPPROVE,
                "退回重签");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_REEXECUTE,
                "退回重办");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_ADDTASK, "加签");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_REASSIGN,
                "转派");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_DETAIL_ITEM_DETAIL, "");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT, "项目追踪");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CC_PROJECT_DETAIL,
                "项目中控台详情");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.DASHBOARD, "工作台");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.GPT_AI, "娜娜");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.CONTACTS, "通讯录");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.ME, "我的");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.NOTIFICATION_PAGE, "消息");
        result.put("dj-mobile-WELCOME_TO_ATHENA", "欢迎你使用Athena，快来看看我可以做什么吧");
        result.put("dj-mobile-ATHENA_MY_PROJECT_PROMPT", "知晓进度情况，总览项目问题");

        result.put("dj-mobile-由转派", "由%s转派>");
        result.put("dj-mobile-首页任务提示逾期", "其中包含%d个逾期任务，请尽快处理\uD83D\uDCAA");
        result.put("dj-mobile-首页任务提示", "请及时处理\uD83D\uDCAA");
        result.put("dj-mobile-项目来源说明", "由 %s 等%d张%s组成");
        result.put("dj-mobile-多个任务正在进行中", "共%d个任务正在进行中");
        result.put("dj-mobile-多个任务逾期异常", "共%d个任务逾期/异常");
        result.put("dj-mobile-逾期天数", "逾期%d天");
        result.put("dj-mobile-标准项目来源", "共%d个分公司%d张%s组成");
        result.put("dj-mobile-逾期后完成", "逾期%d天完成");
        result.put("dj-mobile-逾期详情", "逾期%d项，最大逾期%d天");
        result.put("dj-mobile-总计", "共搜索%d笔结果");
        result.put("dj-mobile-我的页面提示title", "“我的”页面换地方咯～");
        result.put("dj-mobile-我的页面提示body", "点击这里即可进入，内含“切换租户、通讯录”等功能");
        result.put("dj-mobile-actualMinutesErrors", "分钟数必须是整数，大于等于0小于60");
        result.put("dj-mobile-actualHoursErrors", "小时数必须是整数");
        // PCC项目详情中的任务详情 任务分类是其他类型
        result.put("dj-mobile-close_status", "状态");
        result.put("dj-mobile-purchase_no", "单号");
        result.put("dj-mobile-purchase_seq", "项次");
        result.put("dj-mobile-item_no", "料号");
        result.put("dj-mobile-item_name_spec", "品名规格");
        result.put("dj-mobile-purchase_qty", "数量");
        result.put("dj-mobile-stock_in_qty", "入库数量");
        result.put("dj-mobile-complete_rate", "完成率");
        result.put("dj-mobile-attachment_remark", "任务说明");
        result.put("dj-mobile-purchaser_name", "采购人员");
        result.put("dj-mobile-purchase_sub_seq", "子项次");
        result.put("dj-mobile-issue_set_qty", "已发料套数");
        result.put("dj-mobile-plan_delivery_date", "预计交货日");

        // PCC项目详情中的任务详情 任务分类=ORD或REVIEW
        result.put("dj-mobile-plan_start_date", "预计开始日");
        result.put("dj-mobile-plan_finish_date", "预计完成日");
        result.put("dj-mobile-actual_start_date", "实际开始日");
        result.put("dj-mobile-remarks", "报工说明");
        result.put("dj-mobile-work_hours", "工时");
        result.put("dj-mobile-actual_finish_date", "实际完成日");
        result.put("dj-mobile-total_work_hours", "耗用总工时");
        result.put("dj-mobile-remark", "备注");
        result.put("dj-mobile-is_approve", "签核");
        result.put("dj-mobile-attachment", "交付物样板");
        result.put("dj-mobile-liable_person_name", "负责人名称");
        // PCC项目详情中的任务详情 任务分类=PLM
        result.put("dj-mobile-design_status", "设计任务状态");
        result.put("dj-mobile-project_no", "项目编号");
        result.put("dj-mobile-task_no", "任务编号");
        result.put("dj-mobile-design_no", "设计任务编号");
        result.put("dj-mobile-design_name", "设计任务名称");
        result.put("dj-mobile-report_work_description", "报工说明");
        // PCC项目详情中的任务详情 任务分类=PLM_PROJECT
        result.put("dj-mobile-task_status", "任务状态");
        result.put("dj-mobile-task_name", "任务名称");
        result.put("dj-mobile-task_complete_rate", "任务完成率");
        result.put("dj-mobile-is_on_schedule", "是否准时");
        result.put("dj-mobile-important", "重要性");
        result.put("dj-mobile-task_seq", "任务序号");
        result.put("dj-mobile-upper_level_task_no", "父级任务编号");
        result.put("dj-mobile-before_task_no", "前置任务编号");
        result.put("dj-mobile-milestone_type", "里程碑类型");
        result.put("dj-mobile-plan_work_days", "计划工期");
        result.put("dj-mobile-plan_work_hours", "计划工时");
        result.put("dj-mobile-executor_name", "执行人名称");
        result.put("dj-mobile-executor_role", "执行人角色");
        // PCC项目详情中的任务详情 任务分类=POSUM
        result.put("dj-mobile-reference_type_no", "参考单别");
        result.put("dj-mobile-reference_doc_no", "参考单号");
        result.put("dj-mobile-item_classification", "品号类别/群组");
        // PCC项目详情中的任务详情 任务分类=MES
        result.put("dj-mobile-status", "状态");
        result.put("dj-mobile-wo_no", "工单单号");
        result.put("dj-mobile-machine_no", "设备号");
        result.put("dj-mobile-production_qty", "生产数量");
        result.put("dj-mobile-plan_date_e", "预定完工日");
        result.put("dj-mobile-process_seq", "加工顺序");
        result.put("dj-mobile-op_name", "工艺名称");
        result.put("dj-mobile-op_type", "工艺性质");
        result.put("dj-mobile-supplier_name", "线别/厂商名称");
        result.put("dj-mobile-feed_qty", "投入数量");
        result.put("dj-mobile-complete_qty", "完成数量");
        result.put("dj-mobile-op_no", "工艺编号");
        result.put("dj-mobile-搜索你想知道的内容", "搜索");
        result.put("dj-mobile-本次采购存在单价异常物料共n项", "本次采购存在单价异常物料共%s项");
        result.put("dj-mobile-token过期", "登录过期，请重新登录");
        result.put("dj-mobile-验证码错误", "验证码错误，请重新获取");

        result.put("dj-mobile-二维码失效", "二维码已过期，请获取最新二维码重新扫描");
        result.put("dj-mobile-请扫码货运二维码", "扫一扫上面的二维码，添加车辆信息");

        result.put("dj-mobile-来自%s的分享", "来自%s的分享");
        result.put("dj-mobile-reassignContentTask", "转派后，你将无法查看该任务。");
        result.put("dj-mobile-reassignContentProject", "转派后，此项目将不由你负责，且无法查阅该项目。");
        return result;
    }

    private Map<String, String> getMobileZhTwI18nResource() {
        Map<String, String> result = new LinkedHashMap<>();
        // 特殊多语言
        result.put("dj-mobile-由转派", "由%s轉派>");
        result.put("dj-mobile-首页任务提示逾期", "其中包含%d個逾期任務，請儘快處理\uD83D\uDCAA");
        result.put("dj-mobile-首页任务提示", "請及時處理\uD83D\uDCAA");
        result.put("dj-mobile-项目来源说明", "由 %s 等%d張%s組成");
        ;
        result.put("dj-mobile-多个任务正在进行中", "共%d個任務正在進行中");
        result.put("dj-mobile-多个任务逾期异常", "共%d個任務逾期/異常");
        result.put("dj-mobile-逾期天数", "逾期%d天");
        result.put("dj-mobile-标准项目来源", "共%d個分公司%d張%s組成");
        result.put("dj-mobile-逾期后完成", "逾期%d天完成");
        result.put("dj-mobile-逾期详情", "逾期%d項，最大逾期%d天");
        result.put("dj-mobile-总计", "共搜索%d筆結果");
        result.put("dj-mobile-本次采购存在单价异常物料共n项", "本次採購存在單價異常物料共%s項");
        result.put("dj-mobile-来自%s的分享", "來自%s的分享");
        return result;
    }

    private Map<String, String> getMobileEnUsI18nResource() {
        Map<String, String> result = new LinkedHashMap<>();

        result.put("dj-mobile-由转派", "Transferred from %s>");
        result.put("dj-mobile-首页任务提示逾期", "You have %d overdue tasks. Let's check them out!\uD83D\uDCAA");
        result.put("dj-mobile-首页任务提示", "Please check them out!\uD83D\uDCAA");
        result.put("dj-mobile-项目来源说明", "There are %d %s such as %s");
        result.put("dj-mobile-多个任务正在进行中", "A total of %d tasks are in progress");
        result.put("dj-mobile-多个任务逾期异常", "A total of %d tasks are overdue or abnormal");
        result.put("dj-mobile-逾期天数", "%d days overdue");
        result.put("dj-mobile-标准项目来源", "A total of %d %s for %d branches");
        result.put("dj-mobile-逾期后完成", "Completed %d days overdue");
        result.put("dj-mobile-逾期详情", "%d items overdue, with a maximum overdue of %d days");
        result.put("dj-mobile-总计", "A total of %d results were searched");
        result.put("dj-mobile-本次采购存在单价异常物料共n项", "There are %s items of abnormal unit price materials in this purchase");
        result.put("dj-mobile-来自%s的分享", "Share from %s");
        return result;
    }
}