package com.digiwin.mobile.mobileuibot.config;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppEnvTypeEnum;
import com.digiwin.mobile.mobileuibot.mysql.service.OuterRequestRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * <p>功能描述：基于注解设定多线程定时任务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MultiThreadScheduleTask.java
 * @Author: wangjwc
 * @Date: created at 2023/7/10 10:12
 */
@Component
@EnableScheduling
@EnableAsync
public class MultiThreadScheduleTask {

    @Autowired
    private OuterRequestRecordService outerRequestRecordService;

    /**
     * 任务内容：清理outer_request_record表，仅保留最近三个月的api请求日志。
     * 定时任务运行间隔：每24小时运行一次（即1天清理一次）
     * 0 0 1 * * ?  -- 每天凌晨1点执行
     */
    @Async("defaultThreadPool")
    @Scheduled(cron = "${atnmobile_outer_request_record_data_wipe:0 0 1 * * ?}")
    public void clearOuterRequestRecord() {
//        int reserveDays = 3 * 30;
        // 默认保留三天
        int reserveDays = 3;
        if (AppEnvTypeEnum.PRODUCTION.getEnvType().equals(AppContext.getEnvType())){
            // 生产保留15天
            reserveDays = 15;
        }
        outerRequestRecordService.clear(reserveDays);
    }
}
