package com.digiwin.mobile.mobileuibot.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

/**
 * 系统级环境配置
 *
 * @author zhangjj
 * @date 2021/12/9 0009 13:59
 */
@Configuration
@Data
public class SysEnvConfig {
    // ====================================application.properties公共配置=======================================
    @Value("${application.version:unknown}")
    private String applicationVersion;
    @Value("${application.build.timestamp:unknown}")
    private String applicationBuildTimestamp;
    @Value("${mobile.iam.apptoken}")
    private String appToken;
    @Value("${mobile.iam.appsecret}")
    private String appSecret;
    @Value("${mobile.aes.key}")
    private String aesKey;
    @Value("${mobile.luckycola.userId}")
    private String luckycolaUserId;
    @Value("${mobile.luckycola.appKey}")
    private String luckycolaAppKey;
    @Value("${mobile.baidu.developer.appId}")
    private String baiduDeveloperAppId;
    @Value("${mobile.baidu.developer.secretKey}")
    private String baiduDeveloperSecretKey;
    @Value("${digiwin.ali.akId}")
    private String akId;
    @Value("${digiwin.ali.akSecret}")
    private String akSecret;

    // ====================================application.properties对应环境配置============================
    @Value("${mobile.base.host}")
    private String baseHost;
    @Value("${mobile.base.port}")
    private Integer basePort;
    @Value("${mobile.base.uri}")
    private String baseUri;
    @Value("${mobile.env.type}")
    private String envType;
    // 环境部署的地区，TW：台湾   CN：大陆
    @Value("${mobile.env.deploy.area}")
    private String envDeployArea;
    // 移动后端的具体环境，枚举有华为正式，华为测试，阿里Paas，微软正式，微软测试
    @Value("${mobile.env.deploy.environment}")
    private String envDeployEnvironment;
    @Value("${mobile.use.mock.data}")
    private Boolean useMockData;
    //与鼎捷移动旧平台解耦，先注释掉，隔两个迭代删除
    @Value("${mobile.use.digiwhale.login}")
    private Boolean useDigiWhaleLogin;
    @Value("${mobile.switch.tracking}")
    private Boolean switchTracking;
    @Value("${mobile.switch.outer.request.record}")
    private Boolean switchOuterRequestRecord;
    @Value("${mobile.jpush.type}")
    private String type;
    @Value("${mobile.jpush.app.key}")
    private String jpushAppKey;
    @Value("${mobile.jpush.master.secret}")
    private String jpushMasterSecret;
    @Value("${mobile.jpush.android.intent.component}")
    private String jpushAndroidIntentComponent;
    // IM type=3（openfire）配置 地端域名判断 -- 默认为空，对应环境部署时在启动脚本中配置即可
    @Value("${mobile.im.type.judge.local.url:}")
    private String imTypeJudgeLocalUrl;
    // openfire类型下 访问的本地ip配置 -- 默认为空，对应环境部署时在启动脚本中配置即可
    @Value("${mobile.im.type.openfire.local.url:}")
    private String imTypeOpenfireLocalUrl;
    @Value("${mobile.web.url}")
    private String webUrl;
    @Value("${digiwin.allow.origin}")
    private String allowedOrigin;
    // 路由租户
    @Value("${digiwin.ingress.routerKey}")
    private String routerKey;
    @Value("${digiwin.nana.line.clientId}")
    private String nanaLineClientId;
    @Value("${digiwin.nana.line.clientSecret}")
    private String nanaLineClientSecret;
    /**
     * 敏数下地专用字段,下地是true
     * 我的页面：是否显示 切换职能门户/我的收藏,云上环境默认false 显示
     * 配置文件添加配置参数：digiwin.agileData.privatization
     */
    @Value("${digiwin.agileData.privatization}")
    private Boolean agileDataPrivatization;
    // 是否启用MQTT服务。true或false的字符串
    @Value("${digiwin.enableMqtt}")
    private String enableMqtt;
    @Value("${digiwin.mqttPassword}")
    private String mqttPassword;
    // MQTT服务路径。示例值：/mqtt
    @Value("${digiwin.mqttPath}")
    private String mqttPath;
    @Value("${digiwin.mqttPort}")
    private String mqttPort;
    // MQTT服务地址。示例值：wss://emqx-athena.digiwincloud.com.cn
    @Value("${digiwin.mqttUrl}")
    private String mqttUrl;
    @Value("${digiwin.mqttUserName}")
    private String mqttUserName;
    @Value("${digiwin.mqttServerName}")
    private String serverName;
    // asa服务的mqtt topic
    @Value("${digiwin.asa.mqtt.serverName}")
    private String mqttTopicServerNameASA;
    // ania mqtt服务名称 -- 目前提供前端使用
    @Value("${digiwin.ania.mqtt.serverName}")
    private String aniaMqttServiceName;

    // 服务
    @Value("${digiwin.digiwhale.url}")
    private String digiwhaleUrl;
    @Value("${digiwin.ai.url}")
    private String aiUrl;
    @Value("${digiwin.sd.ai.url}")
    private String sdAiUrl;
    @Value("${digiwin.kbs.url}")
    private String kbsUrl;
    @Value("${digiwin.tbb.web.url}")
    private String tbbWebUrl;
    @Value("${digiwin.tbb.h5.url}")
    private String tbbH5Url;
    @Value("${digiwin.tbb.api.url}")
    private String tbbApiUrl;
    @Value("${digiwin.custom.task.template.url}")
    private String customTaskTemplateUrl;
    @Value("${digiwin.ai.kafka.url}")
    private String aikafkaUrl;
    @Value("${digiwin.ai.get.topic.qty.url}")
    private String aiGetTopicQtyUrl;
    @Value("${digiwin.aam.url}")
    private String aamUrl;
    @Value("${digiwin.adt.url}")
    private String adtUrl;
    @Value("${digiwin.aim.url}")
    private String aimUrl;
    @Value("${digiwin.atdm.url}")
    private String atdmUrl;
    @Value("${digiwin.atmc.url}")
    private String atmcUrl;
    @Value("${digiwin.audc.url}")
    private String audcUrl;
    @Value("${digiwin.uibot.url}")
    private String uibotUrl;
    @Value("${digiwin.bi.url}")
    private String biUrl;
    @Value("${digiwin.bpm.url}")
    private String bpmUrl;
    @Value("${digiwin.cac.url}")
    private String cacUrl;
    @Value("${digiwin.dmc.url}")
    private String dmcUrl;
    @Value("${digiwin.emc.url}")
    private String emcUrl;
    @Value("${digiwin.eoc.url}")
    private String eocUrl;
    @Value("${digiwin.esp.url}")
    private String espUrl;
    @Value("${digiwin.experience.url}")
    private String experienceUrl;
    @Value("${digiwin.iam.url}")
    private String iamUrl;
    @Value("${digiwin.im.url}")
    private String imUrl;
    @Value("${digiwin.knowledgeMaps.url}")
    private String knowledgeMapsUrl;
    @Value("${digiwin.themeMap.url}")
    private String themeMapUrl;
    @Value("${digiwin.lmc.url}")
    private String lmcUrl;
    @Value("${digiwin.mdc.url}")
    private String mdcUrl;
    @Value("${digiwin.mui.url}")
    private String muiUrl;
    @Value("${digiwin.nlpBot.url}")
    private String nlpBotUrl;
    @Value("${digiwin.ocrApi.url}")
    private String ocrApiUrl;
    @Value("${digiwin.smartData.url}")
    private String smartDataUrl;
    @Value("${digiwin.taskEngine.url}")
    private String taskEngineUrl;
    @Value("${digiwin.tdd.url}")
    private String tddUrl;
    //  cam（集成钉钉sso登录使用）
    @Value("${digiwin.cam.url}")
    private String camUrl;
    @Value("${digiwin.ptm.url}")
    private String ptmUrl;
    @Value("${digiwin.semc.url}")
    private String semcUrl;
    @Value("${digiwin.echo.url}")
    private String echoUrl;
    // tbb报表服务地址
    @Value("${digiwin.tbb.url}")
    private String tbbUrl;
    @Value("${digiwin.ade.url}")
    private String adeUrl;
    // kcf 地址 -- 目前提供前端使用
    @Value("${digiwin.chatFile.url}")
    private String chatFileUrl;
    // ai智能助手
    @Value("${digiwin.asa.url}")
    private String asaUrl;
    // ania web地址
    @Value("${digiwin.ania.web.url}")
    private String aniaWebUrl;
    // ai智能助手
    @Value("${digiwin.ania.url}")
    private String aniaUrl;
    // 前端使用
    @Value("${digiwin.ania.apps.url}")
    private String aniaAppsUrl;
    // kaiwis 地址 -- 目前提供前端使用
    @Value("${digiwin.kaiwis.url}")
    private String kaiwisUrl;
    //敏捷问数agileDataQuery服务地址
    @Value("${digiwin.adq.url}")
    private String agileDataQueryUrl;
    @Value("${digiwin.appmetadata.url}")
    private String appmetadataUrl;
    @Value("${digiwin.importexport.url}")
    private String importexportUrl;
    @Value("${digiwin.gateway.url}")
    private String gatewayUrl;
    //敏捷问数fileparsing服务地址
    @Value("${digiwin.fileparsing.url}")
    private String agileDataFileParsingUrl;
}