package com.digiwin.mobile.mobileuibot.config;

import com.alibaba.ttl.TtlCallable;
import com.alibaba.ttl.TtlRunnable;
import org.slf4j.MDC;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
 * 重写ThreadPoolTaskExecutor，使用MDC向线程池传入traceId
 *
 * @author zhangjj
 * @date 2021/12/22 0022 16:09
 */
public class ThreadPoolMdcExecutor extends ThreadPoolTaskExecutor {

    /**
     * 重写执行方法，将MDC传入
     *
     * @param task
     */
    @Override
    public void execute(Runnable task) {
        super.execute(TtlRunnable.get(ThreadPoolMdcFilter.wrap(task, MDC.getCopyOfContextMap())));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return super.submit(TtlCallable.get(ThreadPoolMdcFilter.wrap(task, MDC.getCopyOfContextMap())));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return super.submit(TtlRunnable.get(ThreadPoolMdcFilter.wrap(task, MDC.getCopyOfContextMap())));
    }
}
