package com.digiwin.mobile.mobileuibot.config;

import com.digiwin.mobile.mobileuibot.common.log.TraceIdUtil;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;

import java.util.Map;
import java.util.concurrent.Callable;

/**
 * @author zhangjj
 * @date 2021/12/22 0022 16:10
 */
public class ThreadPoolMdcFilter {

    public static void setTraceId() {
        if (StringUtils.hasLength(TraceIdUtil.get())) {
            MDC.put(TraceIdUtil.TRACE_ID, TraceIdUtil.get());
        }
    }

    public static <T> Callable<T> wrap(final Callable<T> callable, final Map<String, String> context) {
        return () -> {
            if (context == null) {
                MDC.clear();
            } else {
                MDC.setContextMap(context);
            }
            setTraceId();
            try {
                return callable.call();
            } finally {
                MDC.clear();
            }
        };
    }

    public static Runnable wrap(final Runnable runnable, final Map<String, String> context) {
        return () -> {
            if (context == null) {
                MDC.clear();
            } else {
                MDC.setContextMap(context);
            }
            setTraceId();
            try {
                runnable.run();
            } finally {
                MDC.clear();
            }
        };
    }

}
