package com.digiwin.mobile.mobileuibot.config.listener;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.context.ApplicationListener;

/**
 * <p>功能描述：AppContext中的静态配置先在这个监听器中初始化</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 * <p>
 * 已弃用，在BaseConfig中做相关配置
 *
 * @FileName: EnvironmentSettingListener
 * @Author: Zaregoto
 * @Date: 2021/6/20 15:59
 */
@Deprecated
public class EnvironmentSettingListener implements ApplicationListener<ApplicationStartingEvent> {

    private static final Logger logger = LoggerFactory.getLogger(EnvironmentSettingListener.class);

    @Override
    public void onApplicationEvent(ApplicationStartingEvent applicationStartingEvent) {
        AppContext.setBaseUrl(System.getProperty("mobile.base.host") + ":" +
                System.getProperty("mobile.base.port") + System.getProperty("mobile.base.uri"));
        AppContext.setUseMockData(Boolean.parseBoolean(System.getProperty("useMockData")));
        AppContext.setEnvType(System.getProperty("envType"));
        String logFormat = "AppContext Environment Setting Completed...\n" +
                "BaseUrl: %s\n" +
                "UseMockData: %s\n" +
                "EnvType: %s\n";
        System.out.println(
                String.format(logFormat,
                        AppContext.getBaseUrl(), AppContext.getUseMockData(), AppContext.getEnvType())
        );
    }
}
