package com.digiwin.mobile.mobileuibot.config.request;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppEnvDeployAreaEnum;
import com.digiwin.mobile.mobileuibot.common.log.TraceIdUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.runtime.PcUiBotRuntimes;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ChannelFilter
 * @Author: Zaregoto
 * @Date: 2021/5/27 10:24
 */
@Component
@WebFilter(urlPatterns = "/*", filterName = "channelFilter", asyncSupported = true)
public class ChannelFilter implements Filter {

    private static final Logger logger = LoggerFactory.getLogger(ChannelFilter.class);

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse,
                         FilterChain filterChain) throws IOException, ServletException {
        //设置traceId,日志中加入traceId
        try {
            TraceIdUtil.set();
            logger.debug("================进入过滤器======================");
            // form-data数据不做后续处理（会导致form-data中的数据消失）
            if (servletRequest.getContentType() != null && servletRequest.getContentType().contains("multipart/form-data;")) {
                filterChain.doFilter(servletRequest, servletResponse);
                //一次请求删除traceId
                TraceIdUtil.remove();
                return;
            }
            // 防止流读取一次后就没有了, 所以需要将流继续写出去
            HttpServletRequest httpServletRequest = (HttpServletRequest) servletRequest;
            RequestWrapper requestWrapper = new RequestWrapper(httpServletRequest);
            // 修改请求参数
            this.modifyRequestParams(requestWrapper);

            filterChain.doFilter(requestWrapper, servletResponse);

            //一次请求删除traceId
            TraceIdUtil.remove();
        } finally {
            PcUiBotRuntimes.clear();
        }
    }

    private void modifyRequestParams(RequestWrapper requestWrapper) {
        try {
            // 修改请求参数中的locale参数，只允许三种语言：简体中文、繁体中文、英文
            List<String> locales = Arrays.asList(Locale.SIMPLIFIED_CHINESE.toString(),
                    Locale.TRADITIONAL_CHINESE.toString(),
                    Locale.US.toString());
            // 默认语言--大陆区默认简体中文，台湾区默认繁体中文
            String defaultLocale = Locale.SIMPLIFIED_CHINESE.toString();
            if (AppEnvDeployAreaEnum.TW.name().equals(AppContext.getEnvDeployArea())) {
                defaultLocale = Locale.TRADITIONAL_CHINESE.toString();
            }
            if (requestWrapper.getContentType() != null && requestWrapper.getContentType().contains("application/json")) {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode jsonNode = objectMapper.readTree(requestWrapper.getBodyString());
                if (jsonNode.has("locale")) {
                    String locale = jsonNode.get("locale").asText();
                    if (!locales.contains(locale)) {
                        ((ObjectNode) jsonNode).put("locale", defaultLocale);
                        requestWrapper.setBody(objectMapper.writeValueAsBytes(jsonNode));
                    }
                } else {
                    String locale = requestWrapper.getParameter("locale");
                    if (StringUtils.hasLength(locale) && !locales.contains(locale)) {
                        requestWrapper.addParameter("locale", defaultLocale);
                    }
                }
            } else {
                String locale = requestWrapper.getParameter("locale");
                if (StringUtils.hasLength(locale) && !locales.contains(locale)) {
                    requestWrapper.addParameter("locale", defaultLocale);
                }
            }
        } catch (Exception e) {
            logger.error("modifyRequestParams error", e);
        }
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        Filter.super.init(filterConfig);
    }

    @Override
    public void destroy() {
        Filter.super.destroy();
    }
}