package com.digiwin.mobile.mobileuibot.config.request;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.model.db1.AppEntranceRecord;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * 常用应用接口访问的拦截器
 *
 * @author zhangjj
 * @date 2022/11/29 15:56
 */
@Component
public class CommonAppInterceptor implements HandlerInterceptor {

    private static final List<String> FILE_PATH_LIST = new ArrayList<>();

    static {
        FILE_PATH_LIST.add("/mobile/v1/file/");
        FILE_PATH_LIST.add("/mobile/v1/ocr/");
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String requestUri = AppRequestContext.getContextEntity().getRequestUri();
        AppEntranceRecord appEntranceRecord = new AppEntranceRecord();
        //附件相关功能的post请求也过滤
        if (!"POST".equalsIgnoreCase(request.getMethod()) || isContainUrl(requestUri)) {
            return HandlerInterceptor.super.preHandle(request, response, handler);
        }

        return HandlerInterceptor.super.preHandle(request, response, handler);
    }

    private boolean isContainUrl(String requestUrl) {
        return FILE_PATH_LIST.stream().anyMatch(item -> requestUrl.contains(item));
    }
}
