package com.digiwin.mobile.mobileuibot.config.request;

import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ResponseWrapper
 * @Author: Zaregoto
 * @Date: 2021/6/23 0:21
 */
public class ResponseWrapper extends HttpServletResponseWrapper {

    private final static Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;


    private ByteArrayOutputStream buffer = null;

    private ServletOutputStream out = null;

    private PrintWriter writer = null;

    public ResponseWrapper(HttpServletResponse response) throws IOException {
        super(response);

        buffer = new ByteArrayOutputStream();
        out = new WrapperedOutputStream(buffer);
        writer = new PrintWriter(new OutputStreamWriter(buffer, DEFAULT_CHARSET));
    }

    //重载父类获取outputstream的方法
    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return out;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return writer;
    }

    @Override
    public void flushBuffer() throws IOException {
        if (out != null) {
            out.flush();
        }
        if (writer != null) {
            writer.flush();
        }
    }

    @Override
    public void reset() {
        buffer.reset();
    }

    public String getResponseData(String charset) throws IOException {
        //将out、writer中的数据强制输出到WrapperedResponse的buffer里面，否则取不到数据
        flushBuffer();
        byte[] bytes = buffer.toByteArray();
        return new String(bytes, DEFAULT_CHARSET);
    }


    /**
     * 内部类，对ServletOutputStream进行包装，指定输出流的输出端
     */
    private class WrapperedOutputStream extends ServletOutputStream {

        private ByteArrayOutputStream bos = null;

        public WrapperedOutputStream(ByteArrayOutputStream stream) throws IOException {
            bos = stream;
        }

        //将指定字节写入输出流bos
        @Override
        public void write(int b) throws IOException {
            bos.write(b);
        }

        @Override
        public boolean isReady() {
            // TODO Auto-generated method stub
            return false;
        }

        @Override
        public void setWriteListener(WriteListener listener) {
            // TODO Auto-generated method stub
        }
    }

}
