package com.digiwin.mobile.mobileuibot.config.request.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * <p>功能描述：Controller处理性能日志拦截器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PerformanceLogInterceptor
 * @Author: Zaregoto
 * @Date: 2021/6/1 18:20
 */
@Component
public class PerformanceLogInterceptor implements HandlerInterceptor {

    private static final Logger logger = LoggerFactory.getLogger(PerformanceLogInterceptor.class);

    @Override public boolean preHandle(HttpServletRequest request, HttpServletResponse response,
        Object handler) throws Exception {
        StopWatch stopWatch = new StopWatch(request.getRequestURI());
        stopWatch.start(handler.toString());
        request.setAttribute("stopWatch", stopWatch);
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
        ModelAndView modelAndView) throws Exception {
        StopWatch stopWatch = (StopWatch) request.getAttribute("stopWatch");
        stopWatch.stop();
        logger.debug("{}, {} ms", stopWatch.shortSummary(), stopWatch.getTotalTimeMillis());
//        HandlerInterceptor.super.postHandle(request, response, handler, modelAndView);
    }

    @Override public void afterCompletion(HttpServletRequest request, HttpServletResponse response,
        Object handler, Exception ex) throws Exception {
        HandlerInterceptor.super.afterCompletion(request, response, handler, ex);
    }
}
