package com.digiwin.mobile.mobileuibot.config.request.mock;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 外部的mock数据存储 结构
 *
 * @author zhangjj
 * @date 2022/4/28 16:05
 */
@Data
@Accessors(chain = true)
public class OuterMockData implements Serializable {
    private static final long serialVersionUID = 4765652521424463739L;
    /**
     * 地址
     */
    private String url;
    /**
     * 方法名称
     */
    private String method;
    /**
     * 入参载体
     */
    private String payload;
    /**
     * 返回参数
     */
    private String response;
    /**
     * 语言
     */
    private String locale;
    /**
     * 模块
     */
    private String model;
    /**
     * 平台 移动端固定传app
     */
    private String platform = "app";
    /**
     * 应用下面的名称
     */
    private String applyName;
    /**
     * 顾问唯一标志
     */
    private String uid;
    /**
     * mock主表id
     */
    private String mockId;
}
