package com.digiwin.mobile.mobileuibot.config.scheduled;

import com.digiwin.mobile.mobileuibot.mysql.service.AppExpireNoticeRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * <p>功能描述：应用到期提醒数据库清空任务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppExpireNoticeScheduleTask
 * @Author: xujinc
 * @Date: created at 2023/10/12 10:12
 */
@Component
@EnableScheduling
@EnableAsync
public class AppExpireNoticeScheduleTask {

    @Autowired
    private AppExpireNoticeRecordService appExpireNoticeRecordService;

    /**
     * 任务内容：应用到期提醒数据库每天清空，这样第二天查询才会展示对应租户的所有提醒，而不用筛选
     * 定时任务运行间隔：每天0点执行
     */
    @Scheduled(cron = "0 0 0 * * ?")
    public void clearOuterRequestRecord() {
        appExpireNoticeRecordService.deleteAllData();
    }
}
