package com.digiwin.mobile.mobileuibot.configparam;


import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.configparam.dto.MobilePortalCacheConfigParamDTO;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;

import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

import lombok.RequiredArgsConstructor;

/**
 * 通用配置服务
 */
@RestController
@RequestMapping("/common/config/")
@RequiredArgsConstructor
public class MobileCommonConfigController {

    private final DigiwinSemcProxyService digiwinSemcProxyService;

    /**
     * 获取通用配置参数
     */
    @PostMapping("/getCommonConfig")
    public ApiResponse<Object> getCommonConfig(@RequestBody JSONObject param, HttpServletRequest request) {
        if (MapUtils.isEmpty(param) || StringUtils.isBlank(param.getString("key"))) {
            return ApiResponse.buildOK();
        }
        Object object = digiwinSemcProxyService.getCommonConfig(param.getString("key"),AthenaBasicHttpRequestHead.buildByRequest(request));
        return ApiResponse.buildOK().setData(object);
    }


    /**
     * 获取移动端门户缓存配置参数
     */
    @PostMapping("/getPortalCacheConfigParam")
    public ApiResponse<MobilePortalCacheConfigParamDTO> getMobilePortalCacheConfigParam(HttpServletRequest request) {
        MobilePortalCacheConfigParamDTO mobilePortalCacheConfigParam = digiwinSemcProxyService.getMobilePortalCacheConfigParam(AthenaBasicHttpRequestHead.buildByRequest(request));
        return ApiResponse.buildOK().setData(mobilePortalCacheConfigParam);
    }
}
