package com.digiwin.mobile.mobileuibot.contacts;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.pinyin.HypyUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMUser;
import com.digiwin.mobile.mobileuibot.proxy.im.service.DigiwinImProxyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.*;

/**
 * 通讯录
 *
 * @author zhangjj
 * @date 2021/8/27 0027 16:49
 */
@RestController
@RequestMapping("/mobile/v1/contacts")
public class ContactsController {

    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Autowired
    private DigiwinImProxyService digiwinImProxyService;

    /**
     * 获取所有部门
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/dept/list", method = RequestMethod.POST)
    public ApiResponse<Map> getDepts(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.get("iamUserToken");
        List<EocDept> eocDeptList = new ArrayList<>();

        EocDeptResponse eocDeptResponse = digiwinEocProxyService.getEocDeptList(iamUserToken, 100, 1);
        if (eocDeptResponse != null) {
            eocDeptList.addAll(eocDeptResponse.getList());
            Integer total = eocDeptResponse.getTotal();
            if (total > eocDeptList.size()) {
                int page = total / 100 + 1;
                for (int num = 2; num <= page; num++) {
                    EocDeptResponse eocDeptResp = digiwinEocProxyService.getEocDeptList(iamUserToken, 100, num);
                    if (eocDeptResp != null) {
                        eocDeptList.addAll(eocDeptResp.getList());
                    }
                }
            }
        }
        List<Map> mapList = new ArrayList<>();
        eocDeptList.stream().filter(Objects::nonNull).forEach(dept -> {
            Map map = new HashMap(3);
            map.put("sid", String.valueOf(dept.getSid()));
            map.put("name", dept.getName());
            map.put("parentSid", String.valueOf(dept.getParentSid()));
            mapList.add(map);
        });
        Map data = new HashMap();
        data.put("list", mapList);
        data.put("total", mapList.size());
        return ApiResponse.buildOK().setData(data);
    }


    /**
     * 获取部门员工列表
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/dept/emp/list", method = RequestMethod.POST)
    public ApiResponse<Map> getDeptEmps(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.get("iamUserToken");
        String sid = (String) params.get("sid");
        String tenantId = (String) params.get("tenantId");
        List<EocDeptPerson> eocDeptPersonList = new ArrayList<>();

        EocDeptPersonResponse eocDeptPersonResponse = digiwinEocProxyService.getEocDeptPersonList(sid, iamUserToken, 100, 1);
        if (eocDeptPersonResponse != null) {
            eocDeptPersonList.addAll(eocDeptPersonResponse.getList());
            Integer total = eocDeptPersonResponse.getTotal();
            if (total > eocDeptPersonList.size()) {
                int page = total / 100 + 1;
                for (int num = 2; num <= page; num++) {
                    EocDeptPersonResponse eocDeptPersonResp = digiwinEocProxyService.getEocDeptPersonList(sid, iamUserToken, 100, num);
                    if (eocDeptPersonResp != null) {
                        eocDeptPersonList.addAll(eocDeptPersonResp.getList());
                    }
                }
            }
        }
        List<Map> mapList = new ArrayList<>();
        eocDeptPersonList.stream().filter(Objects::nonNull).forEach(person -> {
            Map map = new HashMap(3);
            map.put("eocId", person.getId());
            map.put("userId", person.getUserId());
            map.put("name", person.getName());
            map.put("sortField", HypyUtil.getPinYin(person.getName()));
            map.put("dept", person.getMainDeptName() + "-" + person.getLevelName());
            map.put("accId", "");
            IMUser imUser = digiwinImProxyService.userGetAndCreate(iamUserToken, tenantId, person.getId());
            if (imUser != null && imUser.getAccid() != null) {
                map.put("accId", imUser.getAccid());
            }
            mapList.add(map);
        });
        Map data = new HashMap();
        data.put("list", mapList);
        data.put("total", mapList.size());
        return ApiResponse.buildOK().setData(data);
    }

    /**
     * 获取员工详细信息
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/emp/info", method = RequestMethod.POST)
    public ApiResponse<Map> getEmpInfo(HttpServletRequest request) throws IOException {
        Boolean useMock = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.get("iamUserToken");
        String id = (String) params.get("eocId");
        Integer type = (Integer) params.get("type");
        //如果没有传type，则默认为eocId
        if (type == null) {
            type = 1;
        }
        EocPersonInfo eocPersonInfo = digiwinEocProxyService.getEocPersonInfo(id, iamUserToken, type);
        if (eocPersonInfo == null) {
            return ApiResponse.buildError("not find emp by id");
        }
        if (useMock || modelTypeShow) {
            this.doEmpInfoMockData(eocPersonInfo);
        }
        return ApiResponse.buildOK().setData(eocPersonInfo);
    }

    /**
     * 行事历姓名搜索
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/emp/search", method = RequestMethod.POST)
    public ApiResponse<Map> searchEmpInfo(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.get("iamUserToken");
        String content = (String) params.get("content");
        EocPersonResponse eocPersonResponse = digiwinEocProxyService.getPersonList(iamUserToken, 999, 1, content);
        EocPersonResponse filterPersonResponse = new EocPersonResponse();
        if (eocPersonResponse != null && eocPersonResponse.getList().size() > 0) {
            List<EocPerson> list = new ArrayList<>(eocPersonResponse.getList().size());
            for (EocPerson person : eocPersonResponse.getList()) {
                if (person.getName().contains(content)) {
                    person.setSortField(HypyUtil.getPinYin(person.getName()));
                    person.setEocId(person.getId());
                    list.add(person);
                }
            }
            filterPersonResponse.setList(list);
            return ApiResponse.buildOK().setData(JsonUtil.objectToJavaObject(filterPersonResponse, Map.class));
        } else {
            return ApiResponse.buildOK().setData(Collections.emptyMap());
        }

    }

    private void doEmpInfoMockData(EocPersonInfo eocPersonInfo) {
        if (!StringUtils.hasLength(eocPersonInfo.getPhone())) {
            // 鼎捷移动总经理的手机号，用于mock演示使用
            eocPersonInfo.setPhone("13641629516");
        }
    }
}
