package com.digiwin.mobile.mobileuibot.core;

import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionService;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ActionController
 * @Author: Zaregoto
 * @Date: 2021/5/21 19:41
 */
@RestController
@RequestMapping("/mobile/v1/action")
public class ActionController {

    private static final Logger logger = LoggerFactory.getLogger(ActionController.class);

    @Autowired
    private ActionService actionService;

    @RequestMapping(value = "/submit", method = RequestMethod.POST)
    public ApiResponse<String> submit(
            @RequestBody ApiRequestSubmit request) {
        ActionSubmitResult submitResult;
        boolean useMockData = AppContext.getUseMockData();
        if (useMockData) {
            submitResult = new ActionSubmitResult();
            submitResult.setCompleted(true);
            submitResult.setPromptMsg(LocaleUtil.getMobileTextByKey(request.getLocale(), "提交成功"));
        } else {
            submitResult = this.actionService.submit(request);
        }
        if (null != submitResult) {
            if (!submitResult.getCompleted()) {
                return ApiResponse.buildServiceError(submitResult.getPromptMsg(), "");
            }
            return ApiResponse.buildOK().setData(submitResult);
        } else {
            return ApiResponse.buildError();
        }
    }
}
