package com.digiwin.mobile.mobileuibot.core;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiExtraParameter;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContentRequest;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntrance;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceDirectionEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.pageable.PageableListData;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabContentArea;
import com.digiwin.mobile.mobileuibot.core.component.webview.WebviewPanel;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcLayoutEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.index.*;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.DataViewService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.ProjectPageService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.TaskPageService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import com.digiwin.mobile.mobileuibot.recommend.RecommendService;
import com.digiwin.mobile.mobileuibot.test.TestController;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.*;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MobileUiBotController
 * @Author: Zaregoto
 * @Date: 2021/4/21 12:32
 */
@RestController
@RequestMapping("/mobile/v1/uibot")
public class UiBotController {
    private static final Logger logger = LoggerFactory.getLogger(UiBotController.class);

    @Autowired
    private PageSettingService pageSettingService;

    @Autowired
    private UiBotService uiBotService;

    @Autowired
    private RecommendService recommendService;

    @Autowired
    private IndexBuildTouristModeStrategy indexBuildTouristModeStrategy;

    @Autowired
    private IndexBuildNoTenantStrategy indexBuildNoTenantStrategy;

    @Autowired
    private IndexBuildDriverNoVehicleZtbStrategy indexBuildDriverNoVehicleZtbStrategy;

    @Autowired
    private IndexBuildNonSuperAdminNotSetAccountStrategy indexBuildNonSuperAdminNotSetAccountStrategy;

    @Autowired
    private ZhilinkService zhilinkService;

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private TaskPageService taskPageService;

    @Autowired
    private ProjectPageService projectPageService;

    @Autowired
    private DataViewService dataViewService;

    @Autowired
    private IndexBuildAgileDataPrivatizationStrategy agileDataPrivatizationStrategy;

    @Autowired
    private IndexBuildNoWorkStrategy indexBuildNoWorkStrategy;

    @RequestMapping(value = "/model", method = RequestMethod.POST)
    public ApiResponse<UiBotModel> buildRenderPageModel(
            @RequestBody ApiRequest apiRequest) throws IOException {
        //游客模式首页
        PageSettingIdPresetEnum pageIdEnum = PageSettingIdPresetEnum.getEnumByName(apiRequest.getPageId());

        //敏捷问数下地首页(排除工作提醒,否则点进去显示暂无数据)
        if (!PageSettingIdPresetEnum.MOBILE_ATHENA_ASSISTANT.equals(pageIdEnum) && BooleanUtils.isTrue(AppContext.getApiUrlSetting().getAgileDataPrivatization())) {
            return ApiResponse.buildOK().setData(agileDataPrivatizationStrategy.build(apiRequest));
        }

        if (PageSettingIdPresetEnum.INDEX.equals(pageIdEnum)
                && !StringUtils.hasLength(apiRequest.getIamUserToken())) {
            PageSetting pageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.INDEX_TOURIST_MODE.toString());
            return ApiResponse.buildOK().setData(indexBuildTouristModeStrategy.build(pageSetting, apiRequest));
        }
        //无租户账号首页
        if (PageSettingIdPresetEnum.INDEX.equals(pageIdEnum) && !StringUtils.hasLength(apiRequest.getTenantId())) {
            PageSetting pageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.INDEX_NO_TENANT.toString());
            return ApiResponse.buildOK().setData(indexBuildNoTenantStrategy.build(pageSetting, apiRequest));
        }
        if (!TestController.specialHandleSwitch()) {
            // 员工在未完成账号设定情况下，不可使用雅典娜，做「强提醒」管控 首页画面
            if (PageSettingIdPresetEnum.INDEX.equals(pageIdEnum) && uiBotService.nonSuperAdminNotSetAccount(apiRequest)) {
                PageSetting pageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.INDEX_NON_SUPER_ADMIN_NOT_SET_ACCOUNT.toString());
                return ApiResponse.buildOK().setData(indexBuildNonSuperAdminNotSetAccountStrategy.build(pageSetting, apiRequest));
            }
        }
        // 在途宝应用+“司机”角色+无车辆信息时出现如下画面
//        if (PageSettingIdPresetEnum.INDEX.equals(pageIdEnum) && this.checkZtbDriverNoVehicle(apiRequest)) {
//            PageSetting pageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.INDEX_DRIVER_NO_VEHICLE_ZTB.toString());
//            return ApiResponse.buildOK().setData(indexBuildDriverNoVehicleZtbStrategy.build(pageSetting, apiRequest));
//        }
        //对于老的页面是需要pageSetting的
        PageSetting pageSetting = pageSettingService.findById(apiRequest.getPageId());
        UiBotModel uiBotModel = null;
        /**
         * 处理通知页跳转过来时的按钮传参：方案是将ApiExtraParameter放到按钮rawData内。
         * 故如果在apiRequest.extraparameter拿不到，则再从rawData内拿
         */
        if (null == apiRequest.getExtraParameter()) {
            JSONObject apiExtraParameterJsonObj =
                    apiRequest.getRawData().getJSONObject("extraParameter");
            if (apiExtraParameterJsonObj != null) {
                ApiExtraParameter apiExtraParameter = JSONObject.toJavaObject(apiExtraParameterJsonObj, ApiExtraParameter.class);
                if (apiExtraParameter != null) {
                    apiRequest.setExtraParameter(apiExtraParameter);
                    apiRequest.getRawData().remove("extraParameter");
                }
            }
            Optional<Object> extraParameterOpt = Optional.ofNullable(apiRequest.getRawData()).map(e -> e.get("taskExtraParameter"));
            if (extraParameterOpt.isPresent()) {
                apiRequest.setExtraParameter(JsonUtil.objectToJavaObject(extraParameterOpt.get(), ApiExtraParameter.class));
            }
        }
        JSONObject executeContextJsonObj = apiRequest.getRawData().getJSONObject("executeContext");
        if (executeContextJsonObj != null) {
            apiRequest.setSourceType(executeContextJsonObj.getString("sourceType"));
        }
        uiBotModel = this.uiBotService.buildRenderPageModel(pageSetting, apiRequest);
        // 按钮新页面提交数据时用到
        if (null != uiBotModel) {
            if (MobileRenderMetaData.RENDER_VERSION_2.equals(uiBotModel.getRenderVersion()) &&
                    (ObjectUtils.isEmpty(uiBotModel.getRenderData()) || CollectionUtils.isEmpty(uiBotModel.getRenderData().getBody()))) {
                // V2版本的渲染数据为空时，添加一个空的组件到body
                uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
                uiBotModel.getRenderData().addEmptyComponentToBody();
            }
            // wjw FIXME: 2025/5/7 线上bug后端临时处理，下个迭代App发版后可移除，https://athena-devops-zentao.digiwincloud.com.cn/bug-view-162397.html
            if (CollectionUtils.isEmpty(uiBotModel.getAppbarButtonList()) && uiBotModel.getReassignButton() != null) {
                uiBotModel.setAppbarButtonList(Lists.newArrayList(uiBotModel.getReassignButton()));
                uiBotModel.setReassignButton(null);
            }
            return ApiResponse.buildOK().setData(uiBotModel);
        } else {
            return ApiResponse.buildError().setData(null);
        }
    }

    /**
     * 检查 在途宝应用+“司机”角色+无车辆信息时出现如下画面
     *
     * @param apiRequest
     * @return
     */
    private boolean checkZtbDriverNoVehicle(ApiRequest apiRequest) {
        try {
            if (!Optional.ofNullable(apiRequest.getIsZtbDriver()).orElse(false)) {
                return false;
            }
            // 是否无车辆信息
            return CollectionUtils.isEmpty(digiwinEspProxyService
                    .getDriverVehicle(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                            apiRequest.getLocale(), null));
        } catch (Exception e) {
            // 防止无在途宝接口时，首页报错
            logger.error("UiBotController[checkZtbDriverNoVehicle] error: ", e);
            return false;
        }
    }

    @RequestMapping(value = "/model/add", method = RequestMethod.POST)
    public ApiResponse<String> addPageModel(PageSetting pageSetting) {
        return null;
    }

    @RequestMapping(value = "/component", method = RequestMethod.POST)
    public ApiResponse<MobileComponent> buildComponentData(
            @RequestParam(name = "clientId", required = false) String clientId,
            @RequestParam(name = "tenantId", required = false) String tenantId,
            @RequestBody ApiRequest apiRequest) throws IOException {
        String requestId = apiRequest.getRequestId();
        if (!StringUtils.hasLength(requestId)) {
            return ApiResponse
                    .buildError("Component build failed with invalid requestId, please check your request")
                    .setData(null);
        }
        if (StringUtils.hasLength(clientId)) {
            apiRequest.setClientId(clientId);
        }
        if (StringUtils.hasLength(tenantId)) {
            apiRequest.setTenantId(tenantId);
        }
        ComponentSettingRequestIdEnum requestIdEnum = ComponentSettingRequestIdEnum.getEnumByName(requestId);
        MobileComponent mobileComponent = this.uiBotService.buildComponentDataModel(requestIdEnum, apiRequest);

        if (null != mobileComponent) {
            return ApiResponse.buildOK().setData(mobileComponent);
        } else {
            return ApiResponse.buildError().setData(null);
        }
    }

    @RequestMapping(value = "/component/list", method = RequestMethod.POST)
    public ApiResponse<List<MobileComponent>> buildComponentDataList(
            @RequestParam(name = "clientId", required = false) String clientId,
            @RequestParam(name = "tenantId", required = false) String tenantId,
            @RequestBody ApiRequest apiRequest) throws IOException {
        String requestId = apiRequest.getRequestId();
        if (!StringUtils.hasLength(requestId)) {
            return ApiResponse
                    .buildError("Component build failed with invalid requestId, please check your request");
        }
        if (StringUtils.hasLength(clientId)) {
            apiRequest.setClientId(clientId);
        }
        if (StringUtils.hasLength(tenantId)) {
            apiRequest.setTenantId(tenantId);
        }
        ComponentSettingRequestIdEnum requestIdEnum = ComponentSettingRequestIdEnum.getEnumByName(requestId);
        List<MobileComponent> mobileComponentList = this.uiBotService.buildComponentDataModelList(requestIdEnum, apiRequest);

        if (null != mobileComponentList) {
            return ApiResponse.buildOK().setData(mobileComponentList);
        } else {
            return ApiResponse.buildError();
        }
    }

    /**
     * 弃用
     *
     * @param apiRequest
     * @return
     * @throws IOException
     */
    @Deprecated
    @RequestMapping(value = "/component/pageablelist/data", method = RequestMethod.POST)
    public ApiResponse<MobileComponent> buildComponentPageableListData(
            @RequestBody ApiRequest apiRequest) throws IOException {
        //处理过程,放入PageableListData对象
        //当前页，默认1
        Integer page_no = null == apiRequest.getPageNum() ? 1 : apiRequest.getPageNum();
        //请求笔数，默认10
        Integer page_size = null == apiRequest.getPageSize() ? 10 : apiRequest.getPageSize();
        //是否启用分页，默认true
        Boolean use_has_next = null == apiRequest.getRawData().get("use_has_next") ? true : (Boolean) apiRequest.getRawData().get("use_has_next");
        Map<String, Object> parameter = new HashMap<>();
        //任务编号，必要参数
        parameter.put("task_no", apiRequest.getRawData().get("task_no"));
        //根据请求获取api数据
        PageableListData pageableListData = zhilinkService.getAsnBodyByTaskNo(page_no, page_size, use_has_next, parameter, apiRequest);

        if (null != pageableListData) {
            return ApiResponse.buildOK().setData(pageableListData);
        } else {
            return ApiResponse.buildError().setData(null);
        }
    }

    /**
     * 多层布局的切换tab签的数据
     *
     * @param apiRequest
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/universalparse/component/customtabitem", method = RequestMethod.POST)
    public ApiResponse<CustomTabContentArea> getTabItem(@RequestBody ApiRequest apiRequest) throws IOException {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        Map<String, Object> rawData = apiRequest.getRawData();
        UiBotModel tabUibotModel = this.digiwinPcUiBotProxyService.actionShow(locale, iamUserToken, JsonUtil.javaObjectToJsonString(rawData.get("rawData")));
        UiBotAction action = ModuleUtils.getDefaultAction(tabUibotModel);
        CustomTabContentArea contentArea = new CustomTabContentArea();
        List<CustomTabContentContainer> bodyArea = contentArea.getBodyArea();
        if (!ModuleUtils.uibotIsNotEmpty(tabUibotModel)) {
            bodyArea.add(CustomTabContentContainer.emptyContainer(locale));
        } else {
            List<UiBotLayout> tabLayouts = tabUibotModel.getLayout();
            UiBotPageData tabPageData = tabUibotModel.getPageData();
            List<UiBotLayout> searchAllModule = new ArrayList<>();
            ModuleUtils.searchAllModule(tabLayouts, searchAllModule);
            for (UiBotLayout tabLayout : searchAllModule) {
                CustomTabContentContainer container = new CustomTabContentContainer();
                String type = tabLayout.getType();
                String schema = tabLayout.getSchema();
                container.setContentCmptType(CustomGroup.COMPONENT_TYPE);
                if (type.equalsIgnoreCase(PcLayoutEnum.FORM_LIST.getValue())) {
                    //FORM_LIST组件
                    Map<String, Object> bizData = (Map<String, Object>) tabPageData.get(schema);
                    container.setData(ModuleUtils.buildFormList(tabLayout, bizData,
                            tabUibotModel.getExecuteContext(), locale, "",
                            tabUibotModel.getRules(), false, true, true, iamUserToken));
                    bodyArea.add(container);
                } else if (type.equalsIgnoreCase(PcLayoutEnum.ATHENA_TABLE.getValue())) {
                    //ATHENA_TABLE组件
                    List table = ModuleUtils.buildAthenaTable(tabUibotModel, tabLayout, locale, action);
                    contentArea.setSize(table != null ? table.size() : 0);
                    bodyArea.addAll(table);
                }
            }
        }

        BottomButtonList buttonList = (BottomButtonList) ModuleUtils.buildBottomButtonList(tabUibotModel, ActionTypeEnum.CALL_API_BACK_INDEX.getValue());
        if (buttonList != null && buttonList.size() > 0) {
            //底部按钮
            List<CustomTabContentContainer> bottomArea = contentArea.getBottomArea();
            CustomTabContentContainer buttonContainer = new CustomTabContentContainer();
            buttonContainer.setContentCmptType(BottomButtonDigiwinAthena.COMPONENT_TYPE);
            buttonContainer.setPosition(2);
            buttonContainer.setData(buttonList);
            bottomArea.add(buttonContainer);
        }

        return ApiResponse.buildOK().setData(contentArea);
    }

    /**
     * 为CustomContent组件调用外部服务，生成页面内容
     *
     * @param locale
     * @param useDap
     * @param getReportInOldWay
     * @param serviceUrl
     * @return
     * @throws IOException
     * @see com.digiwin.mobile.mobileuibot.core.component.custom.CustomContent
     * @see CustomContentRequest
     */
    @RequestMapping(value = "/customcontent/outer", method = RequestMethod.POST)
    public ApiResponse<UiBotModel> customContentOuter(@RequestParam(name = "locale") String locale,
                                                      @RequestParam(name = "useDap") String useDap,
                                                      @RequestParam(name = "getReportInOldWay") String getReportInOldWay,
                                                      @RequestParam(name = "serviceUrl") String serviceUrl,
                                                      @RequestBody CustomContentRequest customContentRequest) throws IOException {
        //是否需要ai推荐
        boolean recommend = false;
        if (customContentRequest.getSysParam().get("recommend") != null) {
            recommend = (boolean) customContentRequest.getSysParam().get("recommend");
        }

        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        String data;
        if (useMockData || modelTypeShow) {
            if (recommend) {
                // 首页推荐
                data = FileUtil.readText("static/appstore-use/index-recommend-see.json");
            } else {
                // 非首页推荐
                data = FileUtil.readText("static/dashboard-custom-content.json");
            }
            if (null != data && !data.isEmpty()) {
                UiBotModel uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
                return ApiResponse.buildOK().setData(uiBotModel);
            } else {
                return ApiResponse.buildError();
            }
        }

        Map<String, Object> queryParam = new HashMap<>();
        queryParam.put("locale", locale);
        queryParam.put("useDap", useDap);
        queryParam.put("serviceUrl", serviceUrl);

        boolean bGetReportInOldWay = Boolean.parseBoolean(getReportInOldWay);
        if (bGetReportInOldWay) {
            return ApiResponse.buildOK().setData(
                    this.uiBotService.buildCustomContentReportUseTbbApi(queryParam, customContentRequest));
        } else {
            return ApiResponse.buildOK().setData(
                    this.uiBotService.buildCustomContentReportUseAthenaApi(queryParam, customContentRequest));
        }
    }


    /**
     * 猜你想做-customContent数据接口
     *
     * @param userId
     * @param customContentRequest
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/customcontent/recommend/menu", method = RequestMethod.POST)
    public ApiResponse<UiBotModel> getRecommendMenu(@RequestParam(name = "userId") String userId,
                                                    @RequestBody CustomContentRequest customContentRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (useMockData || modelTypeShow) {
            String data = FileUtil.readText("static/appstore-use/index-recommend-do.json");
            if (null != data && !data.isEmpty()) {
                UiBotModel uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
                return ApiResponse.buildOK().setData(uiBotModel);
            } else {
                return ApiResponse.buildError();
            }
        }
        Map<String, Object> sysParam = customContentRequest.getSysParam();
        String locale = (String) sysParam.get("locale");
        String iamUserToken = (String) sysParam.get("iamUserToken");
        AppEntrance appEntrance = new AppEntrance();
        appEntrance.setDirection(AppEntranceDirectionEnum.HORIZONTAL.getValue());
        appEntrance.setAppLayoutType(AppEntranceLayoutTypeEnum.EQUAL_RATION.getValue());
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setLocale(locale);
        apiRequest.setIamUserToken(iamUserToken);
        apiRequest.setUserId(userId);
        appEntrance.getAppList().addAll(this.recommendService.getRecommendAppList(apiRequest));
        String schema = UUIDUtil.getUuid();
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        List<UiBotLayout> layoutList = new ArrayList<>();
        UiBotLayout layout = new UiBotLayout();
        layout.setSchema(schema);
        layout.setType(AppEntrance.COMPONENT_TYPE);
        layoutList.add(layout);
        uiBotModel.setLayout(layoutList);
        UiBotPageData pageData = new UiBotPageData();
        pageData.put(schema, appEntrance);
        uiBotModel.setPageData(pageData);

        return ApiResponse.buildOK().setData(uiBotModel);
    }

    @RequestMapping(value = "/customcontent/empty", method = RequestMethod.POST)
    public ApiResponse<UiBotModel> getCustomContent(@RequestBody CustomContentRequest request) {
        String data;
        Boolean useMockData = AppContext.getUseMockData();
        UiBotModel uiBotModel = null;
        if (!useMockData) {
            String schema = "panel";
            UiBotLayout layout = new UiBotLayout();
            layout.setSchema(schema);
            layout.setType(WebviewPanel.COMPONENT_TYPE);

            List<UiBotLayout> layoutList = new ArrayList<>();
            layoutList.add(layout);

            WebviewPanel webviewPanel = new WebviewPanel();
            webviewPanel.setTitle(LocaleUtil.getMobileTextByKey(
                    (String) request.getSysParam().get("locale"), "敬请期待") + "!");
            webviewPanel.setData(new ArrayList<>());

            uiBotModel = new UiBotModel(layoutList);
            uiBotModel.addPageData(schema, webviewPanel);

        } else {
            data = FileUtil.readText("static/dashboard-custom-content.json");
            if (null != data && !data.isEmpty()) {
                uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
            }
        }

        return ApiResponse.buildOK().setData(uiBotModel);
    }

    /**
     * 多层布局的切换tab签的数据
     *
     * @param apiRequest
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/action/show", method = RequestMethod.POST)
    public ApiResponse<UiBotModel> actionShow(@RequestBody ApiRequest apiRequest) {
        ApiRawData rawData = apiRequest.getRawData();
        PcUiBotExecuteContext executeContext = JsonUtil.objectToJavaObject(rawData.get("executeContext"),
                new TypeReference<PcUiBotExecuteContext>() {
                });
        executeContext.setAuthoredUser(new PcUiBotAuthoredUser()
                .setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId())
                .setToken(apiRequest.getIamUserToken()));
        PcUiBotTaskPageDefine pageDefine = JsonUtil.objectToJavaObject(rawData,
                new TypeReference<PcUiBotTaskPageDefine>() {
                });
        pageDefine.getExecuteContext().setAuthoredUser(executeContext.getAuthoredUser());

        UiBotModel uiBotModel;
        if (UiBotDesignerService.PAGECODE_PROJECT_DETAIL.equals(executeContext.getPageCode())) {
            // 项目详情页
            uiBotModel = projectPageService.createPage(executeContext, pageDefine, apiRequest);
        } else {
            uiBotModel = taskPageService.createPage(executeContext, pageDefine, apiRequest);
        }
        if (!CollectionUtils.isEmpty(uiBotModel.getRules())) {
            // 任务的追踪中、已完成、项目的待处理等需要去掉编辑类的规则
            this.filterEditRules(uiBotModel.getRules());
        }
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        if (MobileRenderMetaData.RENDER_VERSION_2.equals(uiBotModel.getRenderVersion()) &&
                (ObjectUtils.isEmpty(uiBotModel.getRenderData()) || CollectionUtils.isEmpty(uiBotModel.getRenderData().getBody()))) {
            // V2版本的渲染数据为空时，添加一个空的组件到body
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
            uiBotModel.getRenderData().addEmptyComponentToBody();
        }
        return ApiResponse.buildOK().setData(uiBotModel);
    }

    private void filterEditRules(List<UiBotRule> rules) {
        // 去掉只有在可编辑时才起作用的规则
        // 非编辑类：!x.containsKey("scope") || !Objects.equals("EDIT", x.get("scope")
        // 编辑类：x.containsKey("scope") && Objects.equals("EDIT", x.get("scope")
        rules.removeIf(rule -> Objects.equals("EDIT", rule.getScope()));
    }

    /**
     * 数据视图切换 tab签的数据
     *
     * @param apiRequest
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/dataView/show", method = RequestMethod.POST)
    public ApiResponse<UiBotModel> dataViewShow(@RequestBody ApiRequest apiRequest) {
        PcUiBotDataViewPageDefine dataViewPageDefine = JsonUtil.objectToJavaObject(apiRequest.getRawData(), PcUiBotDataViewPageDefine.class);
        dataViewPageDefine.getExecuteContext()
                .setAuthoredUser(new PcUiBotAuthoredUser()
                        .setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId())
                        .setToken(apiRequest.getIamUserToken()));

        UiBotModel uiBotModel = dataViewService.createDynamicForm(dataViewPageDefine, apiRequest);
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        if (MobileRenderMetaData.RENDER_VERSION_2.equals(uiBotModel.getRenderVersion()) &&
                (ObjectUtils.isEmpty(uiBotModel.getRenderData()) || CollectionUtils.isEmpty(uiBotModel.getRenderData().getBody()))) {
            // V2版本的渲染数据为空时，添加一个空的组件到body
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
            uiBotModel.getRenderData().addEmptyComponentToBody();
        }
        return ApiResponse.buildOK().setData(uiBotModel);
    }
}