package com.digiwin.mobile.mobileuibot.core;


import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;

/**
 * @Author: yanfeng
 * @Date: 2023/7/14
 */
@RestController
@RequestMapping("/mobile/v2/uibot")
public class UiBotControllerV2 {

    @Autowired
    private UiBotController controller;

    @RequestMapping(value = "/model", method = RequestMethod.POST)
    public ApiResponse<UiBotModel> buildRenderPageModel(
            @RequestBody ApiRequest apiRequest) throws IOException {
        // 必须要设置 renderVersion=2，走V2版本的逻辑(因走V1逻辑时会根据renderVersion，组装规则和其它一些参数)
        AppRequestContext.getContextEntity().setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        return controller.buildRenderPageModel(apiRequest);
    }

    @RequestMapping(value = "/component", method = RequestMethod.POST)
    public ApiResponse<BaseMobileComponentWrapper<BaseMobileComponent>> buildComponentData(
            @RequestParam(name = "clientId", required = false) String clientId,
            @RequestParam(name = "tenantId", required = false) String tenantId,
            @RequestBody ApiRequest apiRequest) throws IOException {
        ApiResponse<MobileComponent> v1ApiResponse = controller.buildComponentData(clientId, tenantId, apiRequest);
        BaseMobileComponent baseMobileComponent = (BaseMobileComponent) v1ApiResponse.getData();

        baseMobileComponent.forceSetCmptVersion2();
        BaseMobileComponentWrapper<BaseMobileComponent> wrappedComponent =
                new BaseMobileComponentWrapper<>(baseMobileComponent,
                        "DW_" + baseMobileComponent.returnComponentType(), UUIDUtil.getUuid());

        ApiResponse<BaseMobileComponentWrapper<BaseMobileComponent>> v2ApiResponse = new ApiResponse<>();
        v2ApiResponse.setCode(v1ApiResponse.getCode());
        v2ApiResponse.setMsg(v1ApiResponse.getMsg());
        v2ApiResponse.setTraceId(v1ApiResponse.getTraceId());
        v2ApiResponse.setErrorMsg(v1ApiResponse.getErrorMsg());
        v2ApiResponse.setData(wrappedComponent);

        return v2ApiResponse;
    }
}