package com.digiwin.mobile.mobileuibot.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MobileUiBotBuildServiceImpl
 * @Author: Zaregoto
 * @Date: 2021/4/24 23:31
 */
@Service("uiBotModelBuildService")
public class UiBotModelBuildServiceImpl implements UiBotModelBuildService {

    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildServiceImpl.class);

    @Autowired
    private PageSettingService pageSettingService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, Object data) {
        if (null != pageSetting) {
            UiBotModel pageModel = pageSetting.getPageModel();
            List<UiBotLayout> layoutList = pageModel.getLayout();
            // 如果没在数据库设置layout且没配置schema的值，则不返回数据
            if (null != layoutList && layoutList.size() > 0) {
                pageModel.addPageData(layoutList.get(0).getSchema(), data);
            }
            return pageModel;
        } else {
            return UiBotModel.emptyUiBotModel();
        }
    }

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, Object data, Boolean fullMount) {
        if (!fullMount) {
            return this.buildModel(pageSetting, data);
        } else {
            if (null != pageSetting) {
                UiBotModel pageModel = pageSetting.getPageModel();
                List<UiBotLayout> layoutList = pageModel.getLayout();
                // 如果没在数据库设置layout且没配置schema的值，则不返回数据
                if (!CollectionUtils.isEmpty(layoutList)) {
                    UiBotPageData uiBotPageData = JSON
                            .parseObject(JSON.toJSONString(data), new TypeReference<UiBotPageData>() {
                            });
                    List<UiBotLayout> bottomButtonLayoutList = pageModel.getLayout()
                            .stream().filter(layout -> BottomButtonDigiwinAthena.COMPONENT_TYPE.equalsIgnoreCase(layout.getType()))
                            .collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(bottomButtonLayoutList)) {
                        bottomButtonLayoutList.forEach(bottomButtonLayout -> {
                            JSONArray bottomButtonPageData = (JSONArray) uiBotPageData.get(bottomButtonLayout.getSchema());
                            if (CollectionUtils.isEmpty(bottomButtonPageData)) {
                                pageModel.getLayout().remove(bottomButtonLayout);
                                uiBotPageData.remove(bottomButtonLayout.getSchema());
                            }
                        });
                    }
                    pageModel.setPageData(uiBotPageData);
                }
                return pageModel;
            } else {
                return UiBotModel.emptyUiBotModel();
            }
        }
    }

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, UiBotPageData data) {
        if (null != pageSetting) {
            UiBotModel pageModel = pageSetting.getPageModel();
            List<UiBotLayout> layoutList = pageModel.getLayout();
            // 如果没在数据库设置layout且没配置schema的值，则不返回数据
            if (null != layoutList && layoutList.size() > 0) {
                pageModel.setPageData(data);
            }
            return pageModel;
        } else {
            return UiBotModel.emptyUiBotModel();
        }
    }
}
