package com.digiwin.mobile.mobileuibot.core;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContentRequest;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：Ui Bot服务类，核心入口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotService
 * @Author: Zaregoto
 * @Date: 2021/5/12 21:52
 */
public interface UiBotService {

    /**
     * 构造页面模型
     *
     * @param pageSetting 页面配置对象
     * @param apiRequest
     * @return
     * @throws IOException
     */
    UiBotModel buildRenderPageModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException;

    /**
     * 构造组件模型
     *
     * @param componentSettingRequestIdEnum 特定组件的构造请求ID，用于标识特定组件与构造逻辑
     * @param apiRequest
     * @return
     * @throws IOException
     */
    MobileComponent buildComponentDataModel(ComponentSettingRequestIdEnum componentSettingRequestIdEnum,
                                            ApiRequest apiRequest) throws IOException;

    /**
     * 构造组件模型
     *
     * @param componentSettingRequestIdEnum 特定组件的构造请求ID，用于标识特定组件与构造逻辑
     * @param apiRequest
     * @return
     * @throws IOException
     */
    List<MobileComponent> buildComponentDataModelList(ComponentSettingRequestIdEnum componentSettingRequestIdEnum,
                                                      ApiRequest apiRequest) throws IOException;

    /**
     * 旧方式：用tbb api，构建自定义渲染内容的报表
     *
     * @param queryParam
     * @param customContentRequest
     * @return
     */
    UiBotModel buildCustomContentReportUseTbbApi(Map<String, Object> queryParam,
                                                 CustomContentRequest customContentRequest);

    /**
     * 新方式：用athena api，构建自定义渲染内容的报表
     *
     * @param queryParam
     * @param customContentRequest
     * @return
     * @throws UnsupportedEncodingException
     */
    UiBotModel buildCustomContentReportUseAthenaApi(Map<String, Object> queryParam,
                                                    CustomContentRequest customContentRequest) throws UnsupportedEncodingException;

    /**
     * 员工在未完成账号设定情况下，不可使用雅典娜，做「强提醒」管控
     *
     * @param apiRequest
     * @return
     */
    boolean nonSuperAdminNotSetAccount(ApiRequest apiRequest);
}
