package com.digiwin.mobile.mobileuibot.core;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.appec.*;
import com.digiwin.mobile.mobileuibot.core.component.*;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionServiceImpl;
import com.digiwin.mobile.mobileuibot.core.component.action.BusinessRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.DigiwinActionSubmitParas;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContentRequest;
import com.digiwin.mobile.mobileuibot.core.component.search.SearchCategory;
import com.digiwin.mobile.mobileuibot.core.component.webview.Webview;
import com.digiwin.mobile.mobileuibot.core.component.webview.WebviewPanel;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.compdatabuild.UiBotCompDataBuildStrategyFactory;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategyFactory;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.BusinessTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.SourceCategoryEnum;
import com.digiwin.mobile.mobileuibot.model.db1.UserCardListFilter;
import com.digiwin.mobile.mobileuibot.mysql.service.UserCardListFilterService;
import com.digiwin.mobile.mobileuibot.proxy.ai.service.DigiwinAiProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.audc.model.DigiwinAudcActivityAccessible;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dap.DapResponse;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsTbbReport;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.UserIntegrity;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.mdc.model.EocSetInfo;
import com.digiwin.mobile.mobileuibot.proxy.mdc.service.DigiwinMdcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

/**
 * <p>功能描述：移动端UI Bot入口服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotServiceImpl
 * @Author: Zaregoto
 * @Date: 2021/5/12 21:54
 */
@Slf4j
@Service("uiBotService")
public class UiBotServiceImpl implements UiBotService {

    @Autowired
    private HttpService httpService;

    @Autowired
    private UiBotModelBuildStrategyFactory uiBotModelBuildStrategyFactory;

    @Autowired
    private UiBotCompDataBuildStrategyFactory uiBotCompDataBuildStrategyFactory;

    @Autowired
    private DigiwinAiProxyService digiwinAiProxyService;

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgemapsProxyService;

    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;

    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    @Autowired
    private DigiwinMdcProxyService digiwinMdcProxyService;

    @Resource(name = "defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Autowired
    private UserCardListFilterService userCardsFilterService;

    @Autowired
    ActionServiceImpl actionService;

    @Override
    public UiBotModel buildRenderPageModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModelBuildStrategy strategy = null;
        String pageId;
        if (pageSetting == null) {
            pageId = apiRequest.getPageId();
            pageSetting = new PageSetting();
            pageSetting.setPageId(pageId);
        } else {
            pageId = pageSetting.getPageId();
        }

        PageSettingIdPresetEnum pageIdEnum = PageSettingIdPresetEnum.getEnumByName(pageId);
        // wjw FIXME: 2023/9/7 V2版 - 与开发平台设计器集成后，pageId都是随机字符串，故需要特殊处理，跳转固定解析页面
        if (pageIdEnum == null) {
            if (SourceCategoryEnum.PROJECT.name().equals(apiRequest.getRawData().getString("sourceCategory"))) {
                // Athena V2版--当责者--默认解析--条目详情页面通用解析页面
                pageIdEnum = PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_MILESTONE_UNIVERSAL_PARSING_PAGE;
            } else if (SourceCategoryEnum.DATA_ENTRY.name().equals(apiRequest.getRawData().getString("sourceCategory"))) {
                // Athena V2版--数据录入--默认解析--条目详情页面通用解析页面
                pageIdEnum = PageSettingIdPresetEnum.MOBILE_ATHENA_BASIC_DATA_UNIVERSAL_PARSING_PAGE;
            } else if (SourceCategoryEnum.DATA_ENTRY_MODEL_DRIVEN.name().equals(apiRequest.getRawData().getString("sourceCategory"))) {
                // Athena V2版--任务卡--数据录入--模型驱动--流程设计--生成的任务卡--条目详情页面通用解析页面
                pageIdEnum = PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_DATA_ENTRY_DRIVEN_ITEM_PARSING_PAGE;
            } else if (SourceCategoryEnum.START_PROJECT.name().equals(apiRequest.getRawData().getString("sourceCategory"))) {
                // 发起项目解析
                pageIdEnum = PageSettingIdPresetEnum.MOBILE_ATHENA_START_PROJECT_DSL_UNIVERSAL_PARSING_PAGE;
            } else if (SourceCategoryEnum.WORK_REPORT_INFO.name().equals(apiRequest.getRawData().getString("sourceCategory"))) {
                // 报工查询解析
                pageIdEnum = PageSettingIdPresetEnum.MOBILE_ATHENA_PCC_WORK_REPORT_INFO_DSL_UNIVERSAL_PARSING_PAGE;
            } else if (SourceCategoryEnum.APC_STAND_PRODUCTION_PROGRESS.name().equals(apiRequest.getRawData().getString("sourceCategory"))) {
                // APC-机位生产进度
                pageIdEnum = PageSettingIdPresetEnum.MOBILE_ATHENA_APC_STAND_PRODUCTION_PROGRESS_UNIVERSAL_PARSING_PAGE;
            } else if (SourceCategoryEnum.WORKBENCH.name().equals(apiRequest.getRawData().getString("sourceCategory"))) {
                // 工作台解析
                pageIdEnum = PageSettingIdPresetEnum.MOBILE_ATHENA_WORKBENCH_UNIVERSAL_PARSING_PAGE;
            } else {
                // Athena V2版--任务卡--默认解析--条目详情页面通用解析页面
                pageIdEnum = PageSettingIdPresetEnum.MOBILE_ATHENA_DESIGNER_UNIVERSAL_PARSING_PAGE;
            }
        }
        Integer modelType = UibotModelTypeEnum.DEFAULT_PAGE_MODEL.getValue();
        // 完整的页面
        switch (pageIdEnum) {
            case INDEX_PORTAL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildIndexPortalStrategy");
                break;
            case INDEX:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildIndexStrategy");
                break;
            case NOTIFICATION_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildNotificationPageStrategy");
                break;
            case DASHBOARD:
                strategy = this.uiBotModelBuildStrategyFactory.get("uibotModelBuildDashboardStrategy");
                break;
            case MOBILE_MY_TODO:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildMyTaskListStrategy");
                break;
            case MOBILE_TRIPARTITE_TODO:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildTripartiteToDoListStrategy");
                break;
            case MOBILE_MY_BIZ_APPROVAL_TASK_DETAIL:
            case MOBILE_MY_BIZ_REPORT_TASK_DETAIL:
            case MOBILE_MY_BIZ_PROCESS_TASK_DETAIL:
            case MOBILE_ATHENA_SSC_EMPLOYEE_ATTEN_CONFIRM_TASK_DETAIL:
            case MOBILE_ATHENA_ZHILINK_BARCODEMAN_PRINT_TASK_DETAIL:
            case MOBILE_ATHENA_ZHILINK_BARCODEMAN_PASTE_TASK_DETAIL:
            case MOBILE_ATHENA_ZHILINK_BARCODEMAN_CHECKOUT_TASK_DETAIL:
            case MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_LIST:
            case MOBILE_ATHENA_APC_SUPPORT_HOUR_REPORT_LIST:
            case MOBILE_ATHENA_APC_PROJECT_SCHEDULE_REPORT_LIST:
            case MOBILE_MY_BIZ_ASSISTAN_TASK_DETAIL:
            case MOBILE_MY_BIZ_REPORT_TASK_DETAIL_QIANYE_UC:
            case MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL:
            case MOBILE_ATHENA_APC_ABNORMAL_REPORT_LIST:
            case MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_LIST:
            case MOBILE_ATHENA_APC_MERGE_WORK_HOUR_LIST:
            case MOBILE_ATHENA_MATERIAL_NOTICE_LIST:
            case MOBILE_ATHENA_APC_SUPPORT_NEEDS:
            case MOBILE_ATHENA_RECONCILIATION_PROGRESS_NOTICE_LIST:
            case MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD:
            case MOBILE_MY_BIZ_DATA_ENTRY_DRIVEN_TASK_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildMyTaskDetailStrategy");
                modelType = UibotModelTypeEnum.TASK_PAGE_MODEL.getValue();
                break;
            case MOBILE_MY_BIZ_APPROVAL_TASK_ITEM_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildMyApprovalTaskItemDetailStrategy");
                break;
            case MOBILE_APPROVAL_TASK_PROGRESS:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApprovalTaskProgressStrategy");
                break;
            case MOBILE_PROJECT_ASSISTANT:
            case MOBILE_ATHENA_ASSISTANT:
            case MOBILE_INTERNAL_PERSONAL:
            case MOBILE_SYSTEM:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildNotificationStrategy");
                break;
            case MOBILE_ATHENA_BIZ_APPROVAL_AGREE:
            case MOBILE_ATHENA_BIZ_APPROVAL_DISAGREE:
            case MOBILE_ATHENA_BIZ_APPROVAL_REAPPROVE:
            case MOBILE_ATHENA_BIZ_APPROVAL_REEXECUTE:
            case MOBILE_ATHENA_BIZ_APPROVAL_ADDTASK:
            case MOBILE_ATHENA_BIZ_APPROVAL_REASSIGN:
            case MOBILE_ATHENA_SHARE_OTHERS:
            case MOBILE_ATHENA_WORKFLOW_ABORT:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildActionPageStrategy");
                break;
            case MOBILE_ATHENA_PROJECT:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildProjectListStrategy");
                break;
            case MOBILE_JUMP_ATHENA_PROJECT_OR_TASK:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildJumpProjectOrTaskListStrategy");
                break;
            case MOBILE_ATHENA_PROJECT_CC_PROJECT_DETAIL:
            case MOBILE_ATHENA_PROJECT_CC_NEXT_LEVEL_TASK_LIST:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildPccProjectDetailStrategy");
                break;
            case MOBILE_ATHENA_PROJECT_NEXT_LEVEL_PROJECT_LIST:
                strategy = this.uiBotModelBuildStrategyFactory.get("projectDetailBuildProjectNextLevelListStrategy");
                break;
            case MOBILE_ATHENA_PROJECT_PLAN_CC_PROJECT_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildPccProjectPlanDetailStrategy");
                break;
            case MOBILE_ATHENA_PROJECT_PLAN_CC_PROJECT_BASIC_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildPccProjectPlanBasicDetailStrategy");
                break;
            case MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_DETAIL:
            case MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_NEXT_LEVEL_TASK_LIST:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildKscProjectDetailStrategy");
                break;
            case MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_PLAN_CHOOSE_TEMPLATE:
                strategy = this.uiBotModelBuildStrategyFactory.get("projectDetailBuildSystemCloudHouseKeeperChooseTemplateStrategy");
                break;
            case MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_TASK:
                strategy = this.uiBotModelBuildStrategyFactory.get("projectDetailBuildSystemCloudHouseKeeperEditTaskStrategy");
                break;
            case MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROCESS_REMARK:
                strategy = this.uiBotModelBuildStrategyFactory.get("projectDetailBuildSystemCloudHouseKeeperProcessRemarkStrategy");
                break;
            case MOBILE_ATHENA_DETAIL_ITEM_DETAIL:
            case MOBILE_ATHENA_ZHILINK_PASTE_DETAIL_ITEM_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildDetailItemDetailStrategy");
                break;
            case MOBILE_PROJECT_CREATE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildProjectCreateStrategy");
                break;
            case MOBILE_ATHENA_ECN_PROJECT_DETAIL:
            case MOBILE_ATHENA_ECN_PROJECT_ITEM_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelECNProjectDetailStrategy");
                break;
            case MOBILE_ATHENA_STANDARD_PROJECT_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelStandardProjectDetailStrategy");
                break;
            case MOBILE_SMART_SEARCH:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelSmartSearchStrategy");
                break;
            case MOBILE_SEARCH_ITEM_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelSearchItemDetailStrategy");
                break;
            case MOBILE_LEFT_SLIP:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelLeftSlipStrategy");
                break;
            case MOBILE_MANUAL_TASK_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildManualTaskDetailStrategy");
                break;
            case MOBILE_MANUAL_TASK_DETAIL_APPROVAL_AGREE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildManualTaskDetailActionStrategy");
                break;
            case MOBILE_ATHENA_PROJECT_CC_TAIL_TASK_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildPccTailTaskStrategy");
                break;
            case MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_TAIL_TASK_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildKscTailTaskStrategy");
                break;
            case MOBILE_ATHENA_PROJECT_CC_MATERIAL_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildPccMaterialStrategy");
                break;
            case MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_MATERIAL_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildKscMaterialStrategy");
                break;
            case MOBILE_ATHENA_SEARCH_ITEM_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildSearchItemDetailStrategy");
                break;
            //属于定制页面
            case MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcWorkingHourReportDetailStrategy");
                break;
            //属于定制页面
            case MOBILE_ATHENA_APC_PROJECT_SCHEDULE_REPORT_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcProjectScheduleReportDetailStrategy");
                break;
            //属于定制页面
            case MOBILE_ATHENA_APC_PROJECT_SCHEDULE_REPORT_MKP_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcProjectScheduleReportMkpDetailStrategy");
                break;
            //属于定制页面
            case MOBILE_ATHENA_APC_ABNORMAL_REPORT_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcAbnormalReportDetailStrategy");
                break;
            case MOBILE_ATHENA_APC_DIRECTOR_CHECK_PERSONNEL_ONLINE_STATE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildPersonnelOnlineStateStrategy");
                break;
            case MOBILE_ATHENA_APC_DIRECTOR_CHECK_PERSONNEL_ONLINE_GROUP:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildPersonnelOnlineGroupStrategy");
                break;
            case MOBILE_ATHENA_APC_DIRECTOR_CHECK_PERSONNEL_ONLINE_GROUP_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildPersonnelOnlineGroupDetailStrategy");
                break;
            case MOBILE_ZTB_CAR_MESSAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBCarMessageStrategy");
                break;
            case MOBILE_ZTB_CAR_LIST:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBCarListStrategy");
                break;
            case MOBILE_ZTB_CAR_CODE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBCarCodeStrategy");
                break;
            case MOBILE_ZTB_SCAN_RECEIVE_ORDER:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBScanReceiveOrderStrategy");
                break;
            case MOBILE_ZTB_SHIPPING_TASK:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBShippingTaskStrategy");
                break;
            case MOBILE_ZTB_SHIPPING_TASK_QR_CODE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBShippingTaskQrCodeStrategy");
                break;
            case MOBILE_ZTB_SHIPPING_TASK_VEHICLE_INFO:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBShippingTaskVehicleInfoStrategy");
                break;
            case MOBILE_ZTB_GOODS_DEPARTURE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBGoodsDepartureStrategy");
                break;
            case MOBILE_ZTB_GOODS_LOADING:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBGoodsLoadingStrategy");
                break;
            case MOBILE_ZTB_GOODS_LOADING_VEHICLE_INFO:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBGoodsLoadingVehicleInfoStrategy");
                break;
            case MOBILE_ZTB_TRANSPORT:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportStrategy");
                break;
            case MOBILE_ZTB_TRANSPORT_SHIPPING_SCHEDULE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportScheduleStrategy");
                break;
            case MOBILE_ZTB_TRANSPORT_VEHICLE_INFO:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportVehicleInfoStrategy");
                break;
            case MOBILE_ZTB_TRANSPORT_ABNORMAL_ALARM:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportAbnormalAlarmStrategy");
                break;
            case MOBILE_ZTB_TRANSPORT_FORWARDING_ALARM:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportForwardingAlarmStrategy");
                break;
            case MOBILE_ZTB_RECEIPT_CONFIRMATION_REJECTION:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBReceiptConfirmationRejectionStrategy");
                break;
            case MOBILE_ZTB_RECEIPT_PREPARATION:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBReceiptPreparationStrategy");
                break;
            case MOBILE_ZTB_CONFIRMATION_RECEIPT_PREPARATION:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBConfirmationReceiptPreparationStrategy");
                break;
            case MOBILE_ZTB_MODIFICATION_RECEIPT_SCHEDULE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBModificationReceiptScheduleStrategy");
                break;
            case MOBILE_ZTB_RECEIPT_CONFIRMATION:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBReceiptConfirmationStrategy");
                break;
            case MOBILE_ZTB_RECEIPT_SIGNATURE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBReceiptSignatureStrategy");
                break;
            case MOBILE_ZTB_RECEIPT_SCHEDULE_CHANGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBReceiptScheduleChangeStrategy");
                break;
            case MOBILE_ZTB_CARGO_INFORMATION:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBCargoInformationStrategy");
                break;
            case MOBILE_ZTB_PROJECT_LOGISTICS:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBProjectLogisticsStrategy");
                break;
            case MOBILE_ATHENA_REASSIGN_REPORT:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildReassignReportStrategy");
                break;
            case MOBILE_ATHENA_UIBOT_UNIVERSAL_PARSE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildUibotUniversalParseStrategy");
                break;
            case MOBILE_ATHENA_REPORT_LIST:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildReportListStrategy");
                break;
            case MOBILE_ATHENA_ABI_REPORT_INFO:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildAbiReportInfoStrategy");
                break;
            case MOBILE_ATHENA_ABI_REPORT_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildAbiReportDetailStrategy");
                break;
            case MOBILE_ATHENA_BOTTOM_WINDOW_INFO:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildBottomWindowInfoStrategy");
                break;
            case MOBILE_ATHENA_TEAM_TASK:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildTeamTaskStrategy");
                break;
            case MOBILE_ATHENA_TEAM_PROJECT:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildTeamProjectStrategy");
                break;
            case MOBILE_ATHENA_APC_PROJECT_SCHEDULE_REPORT_SUBMIT:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcProjectScheduleReportSubmitStrategy");
                break;
            case MOBILE_BASIC_DATA_ENTRANCE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildBasicDataEntranceStrategy");
                break;
            case MOBILE_BASIC_DATA_ENTRY_BASIC_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildBasicDataEntryBasicPageStrategy");
                break;
            case MOBILE_BASIC_DATA_ENTRY_BROWSE_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildBasicDataEntryBrowsePageStrategy");
                modelType = UibotModelTypeEnum.TASK_PAGE_MODEL.getValue();
                break;
            case MOBILE_BASIC_DATA_ENTRY_EDIT_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildBasicDataEntryEditPageStrategy");
                break;
            case MOBILE_ZTB_MODIFIY_ADDRESS:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBModifiyAddressStrategy");
                break;
            case MOBILE_ZTB_ADDRESS_BOOK:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBAddressBookStrategy");
                break;
            case MOBILE_ZTB_DELIVERY_LOADED_ITEM:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBDeliveryLoadedItemStrategy");
                break;
            case MOBILE_ZTB_CARGO_INFORMATION_LIST:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBCargoInformationListStrategy");
                break;
            case MOBILE_APC_PROJECT_SCHEDULE_REPORT_WAIT_DEAL_LIST:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcProjectScheduleReportWaitDealListStrategy");
                break;
            case MOBILE_ATHENA_APC_SUPPORT_BOTTOM:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcSupportBottomStrategy");
                break;
            case MOBILE_ATHENA_APC_TRANSFER_QUANTITY_SFT_DETAILS:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcProjectScheduleTransferQuantitySftDetailStrategy");
                break;
            case MOBILE_ATHENA_APC_TRANSFER_QUANTITY_MKP_DETAILS:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcProjectScheduleTransferQuantityMkpDetailStrategy");
                break;
            case MOBILE_ATHENA_APC_APPROVAL_REASSIGN_BOTTOM:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcApprovalReassignBottomStrategy");
                break;
            case MOBILE_ATHENA_APC_HANDEL_BOTTOM:
            case MOBILE_ATHENA_APC_ABNORMAL_CLOSURE_RETURN_BOTTOM:
            case MOBILE_ATHENA_APC_ABNORMAL_CLOSURE_PROGRESS_BOTTOM:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcHandelBottomStrategy");
                break;
            //需要走统一标准
            case MOBILE_ATHENA_APC_ABNORMAL_CLOSURE_DETAIL:
                // APC-异常结案已转V2，故此定制pageId废弃，统一走MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL
//                if (TestV1ToV2Util.checkV1ToV2(apiRequest)) {
//                    strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildMyTaskDetailV2Strategy");
//                } else {
//                    strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcAbnormalClosureStrategy");
//                }
//                modelType = UibotModelTypeEnum.TASK_PAGE_MODEL.getValue();
                break;
            case MOBILE_CUSTOM_PATTERN_TASK_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildCustomPatternTaskDetailStrategy");
                break;
            //需要走统一标准
            case MOBILE_ATHENA_APC_WORK_SHOP_ONLINE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcWorkShopOnlineStrategy");
                modelType = UibotModelTypeEnum.TASK_PAGE_MODEL.getValue();
                break;
            case MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_DEAL_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcWorkShopOnlineDealDetailStrategy");
                break;
            case MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_CANCEL_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcWorkShopOnlineCancelDetailStrategy");
                break;
            //需要走统一标准
            case MOBILE_ATHENA_APC_TEAM_DISPATCH:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcTeamDispatchStrategy");
                modelType = UibotModelTypeEnum.TASK_PAGE_MODEL.getValue();
                break;
            case MOBILE_ZTB_DELIVERY_LOAD_EDIT_ITEM:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBDeliveryLoadEditItemStrategy");
                break;
            case MOBILE_ATHENA_APC_TEAM_DISPATCH_DEAL_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcTeamDispatchDetailStrategy");
                break;
            case MOBILE_ATHENA_APC_TEAM_DISPATCH_ABNORMAL_REPORT_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcTeamDispatchAbnormalReportDetailStrategy");
                break;
            case MOBILE_APC_ONLINE_REPORT:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcOnlineReportStrategy");
                break;
            case MOBILE_ZTB_RECEIPT_SIGNATURE_UPLOAD:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBReceiptSignatureUploadStrategy");
                break;
            case MOBILE_ZTB_RECEIPT_SIGNATURE_SIGN:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBReceiptSignatureSignStrategy");
                break;
            case MOBILE_ZTB_ARRIVAL_SCAN_CONFIRM:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBArrivalScanConfirmStrategy");
                break;
            case MOBILE_ATHENA_APC_WORKING_HOUR_QUANTITY_CONFIRM_LIST:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcWorkHourQuantityConfirmStrategy");
                break;
            case MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildOutSourceWorkReportDetailStrategy");
                break;
            case MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_TASK_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildOutSourceWorkReportTaskDetailStrategy");
                break;
            case MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_COMPLETE_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildOutSourceWorkReportCompleteDetailStrategy");
                break;
            case MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_AREA_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcWorkShopOnlineAreaDetailStrategy");
                break;
            case MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_AREA_DETAIL_TAKE_EFFECT:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcWorkShopOnlineAreaTakeEffectDetailStrategy");
                break;
            case MOBILE_ZTB_TRANSPORT_STOP_ABNORMAL_ALARM:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportStopAbnormalAlarmStrategy");
                break;
            case MOBILE_ZTB_TRANSPORT_SHIFTING_ABNORMAL_ALARM:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportShiftingAbnormalAlarmStrategy");
                break;
            case MOBILE_ATHENA_APC_MERGE_WORK_HOUR_QUANTITY_CONFIRM:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcMergeWorkHourQuantityConfirmStrategy");
                break;
            case MOBILE_ATHENA_APC_COMMON_ATTACHMENT_UPLOAD_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcCommonAttachmentUploadStrategy");
                break;
            case MOBILE_ATHENA_APC_COMMON_ATTACHMENT_DETAIL_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcCommonAttachmentDetailStrategy");
                break;
            case MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_MODIFY_PARAM:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildTbdsProductionProcessRecordModifyParamStrategy");
                break;
            case MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_MODIFY_MATERIAL:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildTbdsProductionProcessRecordModifyMaterialStrategy");
                break;
            case MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_NEXT_STEP:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildTbdsProductionProgressRecordNextStepStrategy");
                break;
            case MOBILE_ZTB_ELECTRONIC_FENCE_LIST:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBElectronicFenceListStrategy");
                break;
            case MOBILE_ZTB_ELECTRONIC_FENCE_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBElectronicFenceDetailStrategy");
                break;
            case MOBILE_ZTB_TRANSPORT_COMING_SOON:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportComingSoonStrategy");
                break;
            case MOBILE_ZTB_TRANSPORT_FORWARDING_AGENT:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportForwardingAgentStrategy");
                break;
            case MOBILE_ZTB_TRANSPORT_FACTORY_GUIDE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportFactoryGuideStrategy");
                break;
            case MOBILE_ZTB_TRANSPORT_FACTORY_VOUCHER:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportFactoryVoucherStrategy");
                break;
            case MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_REJECT_SUBMIT:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildTbdsProductionProgressRecordRejectSubmitStrategy");
                break;
            case MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_REPORT_SUBMIT:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildTbdsProductionProgressRecordReportSubmitStrategy");
                break;
            case MOBILE_ATHENA_TBDS_PRODUCTION_PROGRESS_REPORT_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildTbdsProductionProgressReportDetailStrategy");
                break;
            case MOBILE_ATHENA_RECONCILIATION_PROGRESS_NOTICE_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildReconciliationProgressNoticeDetailStrategy");
                break;
            case MOBILE_ATHENA_RECONCILIATION_PROGRESS_REPORT:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildReconciliationProgressReportStrategy");
                break;
            case MOBILE_ATHENA_RECONCILIATION_PROGRESS_CALL_PAYMENT:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildReconciliationProgressCallPaymentStrategy");
                break;
            case MOBILE_ATHENA_INSPECTION_RESULTS_REGISTRATION_SUB_ITEM_CUSTOMIZE_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildDetectionDataDetailStrategy");
                break;
            case MOBILE_ATHENA_PREVIOUS_MANUAL_TASK_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildPreviousManualTaskDetailStrategy");
                break;
            case MOBILE_ATHENA_APC_REMARK_DETAIL_CONFIRM:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcRemarkDetailStrategy");
                break;
            case MOBILE_ATHENA_REPLACE_REPORT_TASK_EXECUTOR_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildReplaceReportTaskExecutorDetailStrategy");
                break;
            case MOBILE_ATHENA_REPLACE_REPORT_TASK_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildReplaceReportTaskDetailStrategy");
                break;
            case MOBILE_ATHENA_APC_PERSONEL_STATE_MERGE_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uibotModelBuildPersonelStateMergeDetailStrategy");
                break;
            case MOBILE_ATHENA_APC_PERSONEL_STATE_ONLINE_DETAIL:
                strategy = this.uiBotModelBuildStrategyFactory.get("uibotModelBuildPersonalStateOnlineDetailStrategy");
                break;
            // Athena V2版--任务卡--默认解析--条目详情页面通用解析页面
            case MOBILE_ATHENA_DESIGNER_UNIVERSAL_PARSING_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelDesignerUniversalParsingPageStrategy");
                break;
            // Athena V2版--数据录入--默认解析--条目详情页面通用解析页面
            case MOBILE_ATHENA_BASIC_DATA_UNIVERSAL_PARSING_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBasicDataUniversalParsingPageStrategy");
                break;
            // Athena V2版--任务卡--数据录入--模型驱动--流程设计--生成的任务卡--条目详情页面通用解析页面
            case MOBILE_ATHENA_BIZ_DATA_ENTRY_DRIVEN_ITEM_PARSING_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBizDataEntryDrivenItemParsingPageStrategy");
                break;
            // Athena V2版--任务卡--数据驱动DSL--从bpmdata中获取字段属性--条目详情页面通用解析页面
            case MOBILE_ATHENA_DATA_DRIVEN_DSL_UNIVERSAL_PARSING_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelDataDrivenDslUniversalParsingPageStrategy");
                break;
            // Athena V2版--数据录入--模型驱动--浏览页面--视图驱动DSL--条目详情页面通用解析页面
            case MOBILE_ATHENA_BASIC_DATA_BROWSE_DETAIL_VIEW_DRIVEN_PARSING_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBasicDataBrowseDetailViewDrivenParsingPageStrategy");
                break;
            // Athena 流程进度固定页面
            case MOBILE_ATHENA_WORKFLOW_PROGRESS_FIXATION_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildWorkflowProgressFixationPageStrategy");
                break;
            // Athena敏捷数据详情页面
            case MOBILE_ATHENA_AGILE_DATA_DETAIL_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildAgileDataDetailStrategy");
                break;
            // Athena V2版-发起项目，通用解析页面
            case MOBILE_ATHENA_PROJECT_CREATE_V2_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildProjectCreateV2Strategy");
                break;
            // Athena V2版--发起项目 通用解析的详情页面
            case MOBILE_ATHENA_START_PROJECT_DSL_UNIVERSAL_PARSING_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelStartProjectUniversalParsingPageStrategy");
                break;
            //第三方h5页面：不支持查看任务详情,返回空组件
            case MOBILE_ATHENA_EMPTY_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("emptyPageStrategy");
                break;
            //报工查询任务卡页面
            case MOBILE_ATHENA_PCC_WORK_REPORT_INFO_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildPccWorkReportInfoStrategy");
                break;
            //报工查询任务卡详情页面
            case MOBILE_ATHENA_PCC_WORK_REPORT_INFO_DSL_UNIVERSAL_PARSING_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildPccWorkReportInfoUniversalParsingStrategy");
                break;
            // 扫码搜索-任务列表页
            case MOBILE_ATHENA_QRCODE_SEARCH_TODO_LIST:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildQrCodeSearchTaskListStrategy");
                break;
            // Athena V2版-- cardList 转 table 页面
            case MOBILE_ATHENA_CARDLIST_CONVERT_TABLE_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildCardlistConvertTablePageStrategy");
                break;
            //PCC-未启动的项目卡页面
            case MOBILE_ATHENA_PROJECT_PCC_EMPTY_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("projectPccNotStartedStrategy");
                break;
            // APC-机位生产进度页面
            case MOBILE_ATHENA_APC_STAND_PRODUCTION_PROGRESS_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcStandProductionProgressPageStrategy");
                break;
            case MOBILE_ATHENA_APC_STAND_PRODUCTION_PROGRESS_UNIVERSAL_PARSING_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelApcStandProductionProgressUniversalParsingPageStrategy");
                break;
            // Athena 工作台页面
            case MOBILE_ATHENA_WORKBENCH_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildWorkbenchPageStrategy");
                break;
            case MOBILE_ATHENA_WORKBENCH_UNIVERSAL_PARSING_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelWorkbenchUniversalParsingPageStrategy");
                break;
            // Athena 项目卡--项目详情页面
            case MOBILE_ATHENA_PROJECT_V2_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildProjectV2PageStrategy");
                break;
            // Athena 项目卡--里程碑下--项目详情页面
            case MOBILE_ATHENA_PROJECT_MILESTONE_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildProjectMilestonePageStrategy");
                break;
            case MOBILE_ATHENA_PROJECT_MILESTONE_UNIVERSAL_PARSING_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelProjectMilestoneUniversalParsingPageStrategy");
                break;
            case MOBILE_ATHENA_FOUND_PAGE:
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildFoundPageStrategy");
                break;
            default:
                break;
        }
        handleUserCardListFilter(apiRequest);

        UiBotModel resultModel = null;
        if (null != strategy) {
            resultModel = strategy.buildModel(pageSetting, apiRequest);
        } else {
            resultModel = UiBotModel.emptyUiBotModel();
        }

        if (MobileRenderMetaData.RENDER_VERSION_2.equals(resultModel.getRenderVersion())) {
            handleLocalRule(resultModel);
        }

        // 新增dataId参数，方便前端拿取页面dataId，用于过滤群会话
        if (StringUtils.hasLength(apiRequest.getBizId())) {
            resultModel.setDataId(apiRequest.getBizId());
        } else {
            if (StringUtils.hasLength(apiRequest.getDataId()) && !StringUtils.hasLength(resultModel.getDataId())) {
                resultModel.setDataId(apiRequest.getDataId());
            }
        }
        if (resultModel.getSlip() != null && resultModel.getSlip().getSlipConfig() != null) {
            UiBotSlip slip = resultModel.getSlip();
            //只支持左滑
            if (slip.getSlipType() == SlipTypeEnum.ONLY_LEFT_SLIP.getValue()) {
                SlipConfigRight right = slip.getSlipConfig().getRight();
                dealWithRight(right, apiRequest);
                //只支持右滑滑
            } else if (slip.getSlipType() == SlipTypeEnum.ONLY_RIGHT_SLIP.getValue()) {
                SlipConfigLeft left = slip.getSlipConfig().getLeft();
                dealWithLeft(left, apiRequest);
                //同时左右滑
            } else if (slip.getSlipType() == SlipTypeEnum.LEFT_AND_RIGHT_SLIP.getValue()) {
                SlipConfigRight right = slip.getSlipConfig().getRight();
                SlipConfigLeft left = slip.getSlipConfig().getLeft();
                dealWithLeft(left, apiRequest);
                dealWithRight(right, apiRequest);
            }//可能存在其他情况
        }
        resultModel.setModelType(modelType);
        return resultModel;
    }

    /**
     * 处理用户cardList筛选记录
     *
     * @param apiRequest
     * @author yanfeng
     */
    public void handleUserCardListFilter(ApiRequest apiRequest) {
        //cardList筛选
        String businessType = apiRequest.getRawData().getBusinessType();
        if (null != businessType) {
            BusinessRawData businessRawData = apiRequest.getRawData().getBusinessRawData();
            if (null == businessRawData) {
                return;
            }
            if (BusinessTypeEnum.FILTER.getValue().equalsIgnoreCase(businessType) && businessRawData.getRefreshPageId().equalsIgnoreCase(apiRequest.getPageId())) {
                UserCardListFilter userCardListFilter = new UserCardListFilter();
                userCardListFilter.setPageId(businessRawData.getCurrentPageId());
                userCardListFilter.setUserId(apiRequest.getUserId());
                userCardListFilter.setTenantId(apiRequest.getTenantId());
                userCardListFilter.setComponentId(businessRawData.getComponentId());
                userCardListFilter.setDataId(businessRawData.getMobileDataId());
                userCardListFilter.setTmActivityId(businessRawData.getTmActivityId());
                List<DigiwinActionSubmitParas> digiwinActionSubmitParasList =
                        actionService.buildSubmitParasMap(apiRequest.getSubmitParam());
                digiwinActionSubmitParasList.removeIf(r -> PcUiBotConstants.MOBILE_SUBMIT_CARD_DATA_KEY.equals(r.getOriginalSchema()));
                digiwinActionSubmitParasList.removeIf(r -> PcUiBotConstants.MOBILE_LOCAL_ADD_CARD_DATA_KEY.equals(r.getOriginalSchema()));
                Map<String, Object> collect = digiwinActionSubmitParasList.stream().collect(Collectors.toMap(DigiwinActionSubmitParas::getSchema
                        , DigiwinActionSubmitParas::getValue, (c1, c2) -> c1));
                userCardListFilter.setData(JsonUtil.javaObjectToJsonString(collect));
                userCardsFilterService.insertOrUpdateUserCardListFilter(userCardListFilter);
            }
            if (BusinessTypeEnum.FILTER.getValue().equalsIgnoreCase(businessType)) {
                // 置空，筛选下，筛选页面数据不需要传递到其它页面 --- 否则会在条目详情页等页面会替换data中数据
                apiRequest.setSubmitParam(null);
                apiRequest.setSubmitParams(null);
                apiRequest.setCurrentSubmitParam(null);
            }
        }
    }

    /**
     * 处理局部规则
     */
    private void handleLocalRule(UiBotModel uiBotModel) {
        UiBotRenderData uiBotRenderData = uiBotModel.getRenderData();
        if (Objects.isNull(uiBotRenderData) || CollectionUtils.isEmpty(uiBotModel.getRules())) {
            return;
        }

        // 获取局部规则对应的组件
        List<BaseMobileComponent> useLocalRulesBaseMobileComponentList = new ArrayList<>();
        List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyList = uiBotRenderData.getBody();
        bodyList.forEach(e -> MobileRenderDataUtil.getUseLocalRulesBaseMobileComponent(e.getData(), e.getComponentType(), useLocalRulesBaseMobileComponentList));
        if (CollectionUtils.isEmpty(useLocalRulesBaseMobileComponentList)) {
            return;
        }

        // 获取局部规则对应的组件的CmptUuid集合方便后续筛选
        Set<String> localRuleCmptUuidList = useLocalRulesBaseMobileComponentList.stream().filter(e -> StringUtils.hasLength(e.getCmptUuid()))
                .map(BaseMobileComponent::getCmptUuid).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(localRuleCmptUuidList)) {
            return;
        }

        Map<String, List<UiBotRule>> localRules = uiBotModel.getRules().stream()
                .filter(rule -> localRuleCmptUuidList.contains(rule.getComponentId())).collect(Collectors.groupingBy(UiBotRule::getComponentId));
        uiBotModel.setLocalRules(localRules);

        uiBotModel.getRules().removeIf(rule -> localRuleCmptUuidList.contains(rule.getComponentId()));
    }

    private void dealWithLeft(SlipConfigLeft left, ApiRequest apiRequest) {
        left.setTitle(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), left.getTitle()));
        dealWithSlipTitle(left.getSubTitle(), apiRequest);
    }

    private void dealWithSlipTitle(SlipTitle subTitle, ApiRequest apiRequest) {
        subTitle.setPrefix(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), subTitle.getPrefix()));
        subTitle.setSuffix(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), subTitle.getSuffix()));
        if (subTitle.getNewLine() != null && subTitle.getNewLine().size() > 0) {
            List<String> newLines = new ArrayList<>(subTitle.getNewLine().size());
            for (String newLine : subTitle.getNewLine()) {
                newLines.add(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), newLine));
            }
            subTitle.setNewLine(newLines);
        }
    }

    private void dealWithRight(SlipConfigRight right, ApiRequest apiRequest) {
        right.setTitle(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), right.getTitle()));
        LeftHeader leftHeader = right.getHeader();
        dealWithSlipTitle(leftHeader.getSubTitle(), apiRequest);
        LeftFooter leftFooter = right.getFooter();
        leftFooter.setTitle(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), leftFooter.getTitle()));
        List<ComponentBox> componentBoxes = leftFooter.getComponentBox();
        for (ComponentBox componentBox : componentBoxes) {
            componentBox.setData(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), (String) componentBox.getData()));
            componentBox.setSearchCategories(dealWithSearchCategory(apiRequest.getLocale(), componentBox.getSearchCategories()));
        }
    }

    private List<SearchCategory> dealWithSearchCategory(String locale, List<SearchCategory> searchCategories) {
        for (SearchCategory searchCategory : searchCategories) {
            searchCategory.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, searchCategory.getName()));
        }
        return searchCategories;
    }

    @Override
    public MobileComponent buildComponentDataModel(
            ComponentSettingRequestIdEnum componentSettingRequestIdEnum, ApiRequest apiRequest)
            throws IOException {
        return this.uiBotCompDataBuildStrategyFactory.get(componentSettingRequestIdEnum.getReuqestId())
                .buildComponentData(apiRequest);
    }

    @Override
    public List<MobileComponent> buildComponentDataModelList(
            ComponentSettingRequestIdEnum componentSettingRequestIdEnum, ApiRequest apiRequest)
            throws IOException {
        return this.uiBotCompDataBuildStrategyFactory.get(componentSettingRequestIdEnum.getReuqestId())
                .buildComponentDataList(apiRequest);
    }

    @Override
    public UiBotModel buildCustomContentReportUseTbbApi(Map<String, Object> queryParam,
                                                        CustomContentRequest customContentRequest) {
        String locale = String.valueOf(queryParam.getOrDefault("locale", ""));
        String useDap = String.valueOf(queryParam.getOrDefault("useDap", ""));
        String serviceUrl = String.valueOf(queryParam.getOrDefault("serviceUrl", ""));
        //是否需要ai推荐
        boolean recommend = false;
        if (customContentRequest.getSysParam().get("recommend") != null) {
            recommend = (boolean) customContentRequest.getSysParam().get("recommend");
        }

        log.debug("useDap is {}", useDap);
        log.debug("servicUrl is {}", serviceUrl);
        log.debug("recommend is {}", recommend);

        String proxyBodyPayload = JsonUtil.javaObjectToJsonString(customContentRequest);
        log.debug("request body is {}", proxyBodyPayload);

        String iamUserToken = (String) customContentRequest.getSysParam().get("iamUserToken");
        String clientId = (String) customContentRequest.getSysParam().get("clientId");
        String tenantId = (String) customContentRequest.getSysParam().get("tenantId");
        String userId = (String) customContentRequest.getSysParam().get("userId");
        String digiwinGoodsCode = (String) customContentRequest.getSysParam().get("digiwinGoodsCode");

        ResponseEntity<DapResponse> responseEntity = this.httpService.doPost(serviceUrl,
                new AthenaBasicHttpRequestHead(iamUserToken), proxyBodyPayload, DapResponse.class);
        HttpStatus statusCode = responseEntity.getStatusCode();

        UiBotModel uiBotModel = null;
        if ((statusCode.is2xxSuccessful() && null != responseEntity.getBody() && Boolean.parseBoolean(useDap))) {
            uiBotModel = this.getUibotModelDataFromDapResponse(responseEntity.getBody());
            if (!recommend) {
                // 工作台界面，非推荐
                // 没有内容返回, 则提示欢迎用语
                if (null == uiBotModel) {
                    uiBotModel = UiBotModel.emptyUiBotModel();
                }
            } else {
                // 首页推荐
                // 根据AI推荐的报表code，调整uiBotModel
                // 目前推荐报表只支持PCC
                if ("PCC".equalsIgnoreCase(digiwinGoodsCode)) {
                    this.handleUiBotModelByAiRecommend(uiBotModel, locale, clientId, iamUserToken, tenantId, userId);
                } else {
                    uiBotModel = UiBotModel.emptyUiBotModel();
                }
            }
        } else {
            // TODO 遇到异常，或不使用DAP的情况再解析，目前先空着
            String errorMsg;
            if (!statusCode.is2xxSuccessful()) {
                errorMsg = "serviceUrl {} call returning a statusCode {}, and response is {},  use welcome data instead...;";
                log.debug(errorMsg, serviceUrl, statusCode.value(), responseEntity.getBody());
            } else {
                errorMsg = "serviceUrl {} DO NOT use dap, or, use welcome data instead...";
                log.debug(errorMsg, serviceUrl, statusCode.value(), responseEntity.getBody());
            }
            uiBotModel = UiBotModel.createCustomContentWelcomeModel(locale);
        }
        return uiBotModel;
    }

    @Override
    public UiBotModel buildCustomContentReportUseAthenaApi(Map<String, Object> queryParam,
                                                           CustomContentRequest customContentRequest) throws UnsupportedEncodingException {
        String locale = String.valueOf(queryParam.getOrDefault("locale", ""));
        String useDap = String.valueOf(queryParam.getOrDefault("useDap", ""));
        String serviceUrl = String.valueOf(queryParam.getOrDefault("serviceUrl", ""));
        //是否需要ai推荐
        boolean recommend = false;
        if (customContentRequest.getSysParam().get("recommend") != null) {
            recommend = (boolean) customContentRequest.getSysParam().get("recommend");
        }

        log.debug("useDap is {}", useDap);
        log.debug("servicUrl is {}", serviceUrl);
        log.debug("recommend is {}", recommend);

        String proxyBodyPayload = JsonUtil.javaObjectToJsonString(customContentRequest);
        log.debug("request body is {}", proxyBodyPayload);

        String iamUserToken = (String) customContentRequest.getSysParam().get("iamUserToken");
        String clientId = (String) customContentRequest.getSysParam().get("clientId");
        String tenantId = (String) customContentRequest.getSysParam().get("tenantId");
        String userId = (String) customContentRequest.getSysParam().get("userId");
        String digiwinGoodsCode = (String) customContentRequest.getSysParam().get("digiwinGoodsCode");

        List<KnowledgeMapsTbbReport> kgTbbReports = this.digiwinKnowledgemapsProxyService
                .getTbbReports(iamUserToken, locale, digiwinGoodsCode);
        //权限校验。从kg拿到的是有授权的，但不一定有权限可以看
        List<KnowledgeMapsTbbReport> accessibleKgTbbReports = new ArrayList<>();
        if (!CollectionUtils.isEmpty(kgTbbReports)) {
            List<DigiwinAudcActivityAccessible> digiwinAudcActivityAccessibleList = digiwinAudcProxyService.getAccessibleList(locale, iamUserToken,
                    tenantId,
                    kgTbbReports.stream().map(report -> report.getCode()).collect(Collectors.toList()),
                    1, "report");
            digiwinAudcActivityAccessibleList.stream().forEach(digiwinAudcActivityAccessible -> {
                if (digiwinAudcActivityAccessible.isAllow()) {
                    accessibleKgTbbReports.add(kgTbbReports.stream().filter(kgTbbReport
                            -> digiwinAudcActivityAccessible.getTmActivityId().equals(kgTbbReport.getCode())).findFirst().get());
                }
            });
        }
        UiBotModel uiBotModel;
        // 没有内容返回，则提示欢迎用语
        if (CollectionUtils.isEmpty(accessibleKgTbbReports)) {
            uiBotModel = UiBotModel.emptyUiBotModel();
            return uiBotModel;
        }

        WebviewPanel webviewPanel = new WebviewPanel();
        for (KnowledgeMapsTbbReport kgTbbReport : accessibleKgTbbReports) {
            // 每条数据的AppName是相同的，因为是通过相同的入参从KG查到的
            webviewPanel.setTitle(kgTbbReport.getAppName());
            webviewPanel.addWebview(KnowledgeMapsTbbReport.buildWebview(kgTbbReport, locale, iamUserToken));
        }
        uiBotModel = UiBotModel.createCustomContentSingleWebviewPanelModel(webviewPanel);

        if (!recommend) {
            // 工作台界面
            return uiBotModel;
        } else {
            // 首页推荐
            /**
             * 根据AI推荐的报表code，调整uiBotModel
             * 目前推荐报表只支持PCC。但现在PCC的报表不是通过AthenaAPI使用的，故这里不需要处理推荐的报表。
             */
            return UiBotModel.emptyUiBotModel();
        }
    }

    private UiBotModel getUibotModelDataFromDapResponse(DapResponse dapResponse) {
        Map<String, Object> data = (Map<String, Object>) dapResponse.getResponse().get("data");
        return JsonUtil.objectToJavaObject(data, UiBotModel.class);
    }

    /**
     * 根据AI推荐的报表code，调整uiBotModel
     *
     * @param uiBotModel
     */
    private void handleUiBotModelByAiRecommend(UiBotModel uiBotModel, String locale, String clientId, String iamUserToken, String tenantId, String userId) {
        if (uiBotModel.getLayout() == null || uiBotModel.getLayout().isEmpty()) {
            return;
        }
        //获取推荐的报表code
        List<String> recommendCodeList = new ArrayList<>();
        List<DigiwinAtmcTmData> tmDataList = this.digiwinAudcProxyService.getTmDataList(clientId, iamUserToken, tenantId, locale);
        Optional<DigiwinAtmcTmData> tmDataOptional = tmDataList.stream().filter(tmData -> "PCC".equalsIgnoreCase(tmData.getAppCode())).findFirst();
        DigiwinAtmcTmData tmData = tmDataOptional.isPresent() ? tmDataOptional.get() : null;
        if (tmData != null) {
            List<DigiwinAtmcTmDataReport> dtoList = tmData.getBaseItemDtoList();
            List<String> tmActivityIdList = dtoList.stream().map(dto -> dto.getCode()).collect(Collectors.toList());
            List<DigiwinAudcActivityAccessible> digiwinAudcActivityAccessibleList = digiwinAudcProxyService.getAccessibleList(locale, iamUserToken,
                    tenantId,
                    tmActivityIdList, 1, "report");
            tmActivityIdList.add("projectDelayEnter");
            tmActivityIdList.add("overdueEnter");
            recommendCodeList = digiwinAiProxyService.getRecommendedReport(tmActivityIdList, userId, iamUserToken, tenantId);
        }
//        if (recommendCodeList.isEmpty()) {
//            //没有获取到推荐时，先不做过滤
//            return;
//        }
        Iterator<UiBotLayout> layoutIterator = uiBotModel.getLayout().iterator();
        UiBotPageData pageData = uiBotModel.getPageData();
        while (layoutIterator.hasNext()) {
            UiBotLayout layout = layoutIterator.next();
            if (WebviewPanel.COMPONENT_TYPE.equals(layout.getType())) {
                WebviewPanel webviewPanel = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), WebviewPanel.class);
                //标题改为"为你推荐"
                //不需要此标题了
                webviewPanel.setTitle(null);
                List<Webview> webviewList = webviewPanel.getData();
                if (webviewList == null || webviewList.isEmpty()) {
                    continue;
                }
                List<Webview> recommendWebviewList = new ArrayList<>();
                List<String> finalRecommendCodeList = recommendCodeList;
                webviewList.stream().forEach(webview -> {
                    String code = getCodeByParseUrl(webview.getUrl());
                    if (finalRecommendCodeList.contains(code)) {
                        recommendWebviewList.add(webview);
                    }
                });
                webviewPanel.setData(recommendWebviewList);
                pageData.put(layout.getSchema(), webviewPanel);
            }
        }
    }

    /**
     * 解析报表view-url中报表code
     *
     * @param url 例：https://tbb.apps.digiwincloud.com.cn:8107/#/projectDelayEnter?locale=${locale}&mobile_user_token=${mobile_user_token}&dashboardtype=Template&name=%E9%A1%B9%E7%9B%AE%E8%BF%9B%E5%BA%A6%E5%BB%B6%E8%BF%9F%E9%A2%84%E8%AD%A6
     * @return
     */
    private String getCodeByParseUrl(String url) {
        if (url.contains("/#/") && url.contains("?")) {
            int start = url.indexOf("/#/") + 3;
            int end = url.indexOf("?");
            return url.substring(start, end);
        }
        return "";
    }

    @Override
    public boolean nonSuperAdminNotSetAccount(ApiRequest apiRequest) {
        try {
            // 使用Future方式执行多任务
            List<Future<?>> futureList = new ArrayList<>();
            Future<Boolean> superAdminFuture = this.threadPoolTaskExecutor.submit(
                    () -> digiwinIamProxyService.isSuperAdmin(apiRequest.getIamUserToken(), apiRequest.getUserId()));
            futureList.add(superAdminFuture);
            Future<EocSetInfo> eocSetInfoFuture = this.threadPoolTaskExecutor.submit(
                    () -> digiwinMdcProxyService.eocSetInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getUserId()));
            futureList.add(eocSetInfoFuture);
            Future<UserIntegrity> userIntegrityFuture = this.threadPoolTaskExecutor.submit(
                    () -> digiwinKnowledgemapsProxyService.userIntegrityCheck(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale()));
            futureList.add(userIntegrityFuture);

            Boolean superAdmin = false;
            EocSetInfo eocSetInfo = new EocSetInfo();
            UserIntegrity userIntegrity = new UserIntegrity();
            //查询任务执行的结果
            try {
                for (Future<?> future : futureList) {
                    // CPU高速轮询：每个future都并发轮循，判断完成状态然后获取结果，
                    // 这一行，是本实现方案的精髓所在。即有10个future在高速轮询，完成一个future的获取结果，就关闭一个轮询
                    while (true) {
                        // 获取future成功完成状态，如果想要限制每个任务的超时时间，取消本行的状态判断+future.get(1000*1, TimeUnit.MILLISECONDS)+catch超时异常使用即可。
                        if (future.isDone() && !future.isCancelled()) {
                            //获取结果
                            Object obj = future.get();
                            if (obj instanceof Boolean) {
                                superAdmin = (Boolean) obj;
                            } else if (obj instanceof EocSetInfo) {
                                eocSetInfo = (EocSetInfo) obj;
                            } else if (obj instanceof UserIntegrity) {
                                userIntegrity = (UserIntegrity) obj;
                            }
                            break;//当前future获取结果完毕，跳出while
                        } else {
                            //每次轮询休息1毫秒（CPU纳秒级），避免CPU高速轮循耗空CPU---》新手别忘记这个
                            Thread.sleep(1);
                        }
                    }
                }
            } catch (InterruptedException | ExecutionException e) {
                log.error(e.getLocalizedMessage());
                throw new ServiceException(e.getMessage());
            }

            if (Boolean.TRUE.equals(superAdmin)) {
                // 超级管理员处理逻辑
                if (Boolean.FALSE.equals(eocSetInfo.getRemindUnitSetting())) {
                    // 运营单元已设定 不弹窗
                    return false;
                }
            } else {
                // 普通用户处理逻辑
                if (Boolean.TRUE.equals(!eocSetInfo.getRemindUnitSetting()) && Boolean.TRUE.equals(userIntegrity.getUserIntegrity())) {
                    // 运营单元已设定，用户设定完整 不弹窗
                    return false;
                }
            }
            // 首页 强提醒使用
            ApiRawData rawData = apiRequest.getRawData();
            if (Objects.isNull(rawData)){
                rawData = new ApiRawData();
            }
            rawData.put("superAdmin", superAdmin);
            rawData.put("eocSetInfo", eocSetInfo);
            rawData.put("userIntegrity", userIntegrity);
            apiRequest.setRawData(rawData);
            return true;
        } catch (Exception e) {
            log.error(e.getLocalizedMessage());
            // 防止接口报错时，首页报错
            return false;
        }
    }
}