package com.digiwin.mobile.mobileuibot.core.appec;

import com.digiwin.mobile.mobileuibot.core.component.search.SearchCategory;
import com.digiwin.mobile.mobileuibot.core.component.search.SkipConfig;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author wuyang
 * @date 20220412
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ComponentBox<T> implements Serializable {
    private static final long serialVersionUID = 3554636341024024404L;

    /**
     * 搜索框提示语
     */
    private T data;
    /**
     * 跳转的路径
     */
    private SkipConfig jumpConfig;
    /**
     * 0：没有特殊设置，按组件在数组中的顺序展示，默认值；1：永远在顶部；2：永远在底部
     */
    private Integer position;
    /**
     * 1.搜索框：SEARCH_BOX；2.按钮：BUTTON
     */
    private String componentType;
    /**
     * 聚合搜索的分类
     */
    private List<SearchCategory> searchCategories;
}
