package com.digiwin.mobile.mobileuibot.core.appec;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogPerformer;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectPerformer;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocDept;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPerson;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonInfo;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonResponse;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

/**
 * <p>功能描述：UI Bot数据的SkipConfigLeft模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: SkipConfigLeft
 * @Author: wuyang
 * @Date: 2022/1/14 10:53
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SlipConfigLeft {

    /**
     * 右滑标题
     */
    private String title;
    /**
     * 右滑小标题
     */
    private SlipTitle subTitle;
    /**
     * 联系人集合
     */
    private List<EocPersonInfo> personList = new ArrayList<>();

    public static SlipConfigLeft build(String locale, String athenaTaskName) {
        SlipConfigLeft left = new SlipConfigLeft();
        //构造右滑摇人
        left.setTitle(LocaleUtil.getMobileTextByKey(locale, "协同"));
        SlipTitle slipTitle = new SlipTitle();
        slipTitle.setContent(athenaTaskName + " " + LocaleUtil.getMobileTextByKey(locale, "当前沟通"));
        left.setSubTitle(slipTitle);
        return left;
    }

    public static SlipConfigLeft setPersonList(SlipConfigLeft left,
                                               List<DigiwinAtmcProjectPerformer> projectPerformers,
                                               EocPersonResponse eocPersonResponse) {
        List<EocPersonInfo> personList = left.getPersonList();
        if (eocPersonResponse != null && eocPersonResponse.getTotal() > 0) {
            List<EocPerson> eocPersonList = eocPersonResponse.getList();
            for (DigiwinAtmcProjectPerformer projectPerformer : projectPerformers) {
                EocPersonInfo personInfo = new EocPersonInfo();
                for (EocPerson eocPerson : eocPersonList) {
                    if (projectPerformer.getPersonInCharge().equals(eocPerson.getUserId())) {
                        personList.add(setPersonInfo(eocPerson, personInfo,
                                projectPerformer.getNeteaseImAccId()));
                    }
                }
            }
        }
        left.setPersonList(personList.stream().collect(Collectors.collectingAndThen(
                Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(EocPersonInfo::getEocId))),
                ArrayList::new)));
        return left;
    }

    public static SlipConfigLeft setPersonListByBacklog(SlipConfigLeft left, List<DigiwinAtmcBacklogPerformer> backlogPerformers, EocPersonResponse eocPersonResponse) {
        List<EocPersonInfo> personList = left.getPersonList();
        if (eocPersonResponse != null && eocPersonResponse.getTotal() > 0) {
            List<EocPerson> eocPersonList = eocPersonResponse.getList();
            for (DigiwinAtmcBacklogPerformer backlogPerformer : backlogPerformers) {
                EocPersonInfo personInfo = new EocPersonInfo();
                for (EocPerson eocPerson : eocPersonList) {
                    if (backlogPerformer.getPerformerId().equals(eocPerson.getUserId())) {
                        personList.add(setPersonInfo(eocPerson, personInfo,
                                backlogPerformer.getNeteaseImAccId()));
                    }
                }
            }
        }
        left.setPersonList(personList.stream().collect(Collectors.collectingAndThen(
                Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(EocPersonInfo::getEocId))),
                ArrayList::new)));
        return left;
    }

    private static EocPersonInfo setPersonInfo(EocPerson eocPerson, EocPersonInfo personInfo, String accId) {
        DigiwinIamUserInfo userInfo = eocPerson.getUser();
        if (userInfo != null) {
            personInfo.setPhone(userInfo.getTelephone());
            personInfo.setEmail(userInfo.getEmail());
            personInfo.setTitleName(eocPerson.getTitleName());
        }
        personInfo.setEocId(eocPerson.getId());
        personInfo.setName(eocPerson.getName());
        List<EocDept> depts = eocPerson.getDepts();
        if (depts != null && depts.size() > 0) {
            for (EocDept dept : depts) {
                if (dept.isMainDept()) {
                    personInfo.setDept(dept.getName());
                    break;
                }
            }
        }
        personInfo.setUserId(eocPerson.getUserId());
        personInfo.setAccId(accId);
        return personInfo;
    }
}
