package com.digiwin.mobile.mobileuibot.core.appec;

import java.util.Objects;

/**
 * 滑动的类型枚举
 *
 * @author wuyang
 */
public enum SlipTypeEnum {

    /**
     * 0：不滑动
     */
    NO_SLIP(0),
    /**
     * 1：只支持左滑
     */
    ONLY_LEFT_SLIP(1),
    /**
     * 2：只支持右滑
     */
    ONLY_RIGHT_SLIP(2),
    /**
     * 3：同时支持左右滑动
     */
    LEFT_AND_RIGHT_SLIP(3);

    private int value;

    SlipTypeEnum(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    public static SlipTypeEnum getEnumByValue(int value) {
        for (SlipTypeEnum testedEnum : SlipTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
