package com.digiwin.mobile.mobileuibot.core.columntag;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.core.component.search.SkipConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;
import java.util.Map;

/**
 * <p>功能描述：字段与Tag关系对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ColumnTag
 * @Author: Zaregoto
 * @Date: 2021/7/21 11:26
 */
@Document(collection = "mobileColumnTag")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class ColumnTag implements Serializable {
    private static final long serialVersionUID = -1249371568401681256L;
    public static final String DEFAULT_BUSINESS_SEPERATOR = ";";
    public static final String DEFAULT_DISPLAY_SEPERATOR = " ";

    @Field("_id")
    private String id;
    private String schema;
    private String path;
    private ColumnTagDefinition tagDefinition;
    private String type;

    /**
     * 数值前缀文字
     */
    private String valuePrefixText;
    private String label;
    /**
     * 分组编号，从0开始
     */
    private Integer groupNo;

    /**
     * 组内元素编号，从0开始
     */
    private Integer groupItemNo;
    private Integer orderNo;

    /**
     * 多个字段被认为需要连接时，使用该separator的值与下个字段连接
     */
    private String separator;

    /**
     * 当前ColumnTag是否生效
     */
    private Boolean valid;

    private String pageId;

    /**
     * 是否展示栏位的名称
     */
    private Boolean showColumnLabel;

    /**
     * 是否与上一个字段同行展示
     */
    private Boolean parallel;
    /**
     * 是否支持字段跳转
     */
    private Boolean skip;
    /**
     * 字段跳转的相关配置
     */
    private SkipConfig skipConfig;
    /**
     * 是否显示标题（默认显示）
     */
    private Boolean showTitle;

    /**
     * 用于可通过不同情况搜索当前界面的唯一tag，防止重复
     */
    private String mTagId;

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private Map<String, String> mLabelText;

    public Map<String, String> getmLabelText() {
        return mLabelText;
    }

    public void setmLabelText(Map<String, String> mLabelText) {
        this.mLabelText = mLabelText;
    }

    public ColumnTag(String schema, String label) {
        this.schema = schema;
        this.label = label;
    }

    public ColumnTag(String schema, String type, String label) {
        this.schema = schema;
        this.type = type;
        this.label = label;
    }
}
