package com.digiwin.mobile.mobileuibot.core.columntag;

/**
 * <p>功能描述：所有支持的Tag Code的枚举类</p>
 * TODO 需要针对每个Tag编写各自的解析器，这样才可以复用Tag逻辑
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ColumnTagDefinitionCodeEnum
 * @Author: Zaregoto
 * @Date: 2021/7/21 11:49
 */
public enum ColumnTagDefinitionCodeEnum {
    /**
     * 展示类型：移动标题
     */
    DISPLAY_TITLE("mobile_DISPLAY_TITLE"),
    /**
     * 展示类型：移动副标题
     */
    DISPLAY_SUBTITLE("mobile_DISPLAY_SUBTITLE"),
    /**
     * 展示类型：移动重要
     */
    DISPLAY_IMPORTANT("mobile_DISPLAY_IMPORTANT"),
    /**
     * 展示类型：移动次要
     */
    DISPLAY_PROFILE("mobile_DISPLAY_PROFILE"),
    /**
     * 展示类型：移动主题事件标题
     */
    DISPLAY_THEME_TITLE("mobile_DISPLAY_THEME_TITLE"),
    /**
     * 展示类型：移动主题事件副标题
     */
    DISPLAY_THEME_SUBTITLE("mobile_DISPLAY_THEME_SUBTITLE"),
    /**
     * 展示类型：移动字段值比较
     */
    DISPLAY_COMPARE_VALUE("mobile_DISPLAY_COMPARE_VALUE"),
    /**
     * 展示类型：移动新旧值比较
     */
    DISPLAY_NEW_OLD_DIFF("mobile_DISPLAY_NEW_OLD_DIFF"),
    /**
     * 展示类型：移动长文本
     */
    DISPLAY_LONGTEXT("mobile_DISPLAY_LONGTEXT"),
    /**
     * 展示类型：移动图片
     */
    DISPLAY_PIC("mobile_DISPLAY_PIC"),

    /**
     * 展示类型：移动分组
     */
    DISPLAY_GROUP("mobile_DISPLAY_GROUP"),

    /**
     * 展示类型：移动展示在线图纸
     */
    DISPLAY_GRAPH_ONLINE_DRAWING("mobile_DISPLAY_GRAPH_ONLINE_DRAWING"),

    /**
     * 业务类型：移动唯一标识（ID）
     */
    BUSINESS_ID("mobile_BUSINESS_ID"),

    /**
     * 录入类型：移动录入签名
     */
    INPUT_SIGN("mobile_INPUT_SIGN"),

    /**
     * 录入类型：移动录入日期时间选择器
     */
    INPUT_DATETIME_PICKER("mobile_INPUT_DATETIME_PICKER"),

    ;

    private final String code;

    ColumnTagDefinitionCodeEnum(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }
}
