package com.digiwin.mobile.mobileuibot.core.columntag;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ColumnTagServiceImpl
 * @Author: Zaregoto
 * @Date: 2021/7/21 11:35
 */
@Service("columnTagService")
public class ColumnTagServiceImpl implements ColumnTagService {

    private static final Logger logger = LoggerFactory.getLogger(ColumnTagServiceImpl.class);

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public List<ColumnTag> listColumnTagsByPath(String path) {
        Query query = new Query();
        query.addCriteria(Criteria.where("path").is(path))
                .addCriteria(Criteria.where("valid").is(true));

        return this.mongoTemplate.find(query, ColumnTag.class);
    }

    @Override
    public List<ColumnTag> listColumnTagsByPathAndPageId(String path, String pageId) {
        Query query = new Query();
        query.addCriteria(Criteria.where("path").is(path))
                .addCriteria(Criteria.where("pageId").is(pageId))
                .addCriteria(Criteria.where("valid").is(true));

        return this.mongoTemplate.find(query, ColumnTag.class);
    }

    @Override
    public List<ColumnTag> listColumnTagsBymTagId(String mTagId) {
        Query query = new Query();
        query.addCriteria(Criteria.where("mTagId").is(mTagId))
                .addCriteria(Criteria.where("valid").is(true));
        return this.mongoTemplate.find(query, ColumnTag.class);
    }

    @Override
    public ColumnTag findColumnTagByPathAndSchema(String path, String schema) {
        Query query = new Query();
        query.addCriteria(Criteria.where("path").is(path))
                .addCriteria(Criteria.where("schema").is(schema))
                .addCriteria(Criteria.where("valid").is(true));

        return this.mongoTemplate.findOne(query, ColumnTag.class);
    }

    @Override
    public List<ColumnTag> listDisplayTitleTags(String path) {
        return null;
    }

    @Override
    public List<ColumnTag> listDisplayImportantTags(String path) {
        return null;
    }

    @Override
    public List<ColumnTag> listDisplayProfileTags(String path) {
        return null;
    }

    @Override
    public List<ColumnTag> listDisplayThemeTitleTags(String path) {
        return null;
    }

    @Override
    public List<ColumnTag> listDisplayThemeSubtitleTags(String path) {
        return null;
    }

    @Override
    public List<ColumnTag> listDisplayCompareValueTags(String path) {
        return null;
    }

    @Override
    public List<ColumnTag> listDisplayLongTextTags(String path) {
        return null;
    }

    @Override
    public List<ColumnTag> listDisplaySubtitleTags(String path) {
        return null;
    }

    @Override
    public List<ColumnTag> listBusinessIdTags(String path) {
        return null;
    }
}
