package com.digiwin.mobile.mobileuibot.core.common;

import java.util.Objects;

/**
 * @author wuyang
 * @desc 背景色枚举类
 */
public enum BackgroundColorEnum {

    /**
     * APP页面主流灰色
     */
    APP_MAIN_GREY("F6F7FB"),
    /**
     * APP页面主流白色（UibotModel页面默认）
     */
    APP_MAIN_WHITE("FFFFFF"),
    ;

    private String value;

    BackgroundColorEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static BackgroundColorEnum getEnumByValue(String value) {
        for (BackgroundColorEnum testedEnum : BackgroundColorEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
