package com.digiwin.mobile.mobileuibot.core.common;

import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;

import org.springframework.util.Assert;

/**
 * <p>功能描述：页面跳转工具类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: JumpPageUtil
 * @Author: Zaregoto
 * @Date: 2021/6/10 21:00
 */
public final class JumpPageUtil {

    /**
     * 获取任务详情页面标题
     *
     * @param tmPattern
     * @param tmCategory
     * @param taskName
     * @return
     */
    public static String getTaskDetailPageTitle(String tmPattern, String tmCategory, String taskName) {
        Assert.notNull(tmPattern, "tmPattern must not null");
        Assert.notNull(tmCategory, "tmCategory must not null");
        if (TaskStringUtil.isBizApproval(tmPattern, tmCategory)) {
            return taskName;
        } else if (TaskStringUtil.isBizReport(tmPattern, tmCategory)) {
            return "";
        } else {
            return "";
        }
    }

}
