package com.digiwin.mobile.mobileuibot.core.common;

import com.digiwin.mobile.mobileuibot.common.string.StringUtil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 用于过滤签核任务中特定4张PCM任务卡,走定制逻辑
 */
public final class PcmFilterUtil {

    /**
     * 费用签核：projectCostApproval_DTD
     * 材料签核：projectMaterialApproval_DTD
     * 项目预算确认：projectBudgetConfirmation_DTD
     * 项目预算签核：budgetProjectApprovals_DTD
     * 项目预算确认签核：projectBudgetConfirmationApproval_DTD
     */
    private static final List<String> PCM_ACTIVITY_ID =
            new ArrayList<>(Arrays.asList(
                    "budgetProjectApprovals_DTD","projectMaterialApproval_DTD","projectCostApproval_DTD","projectBudgetConfirmationApproval_DTD","projectBudgetConfirmation_DTD"));

    private static final List<String> PCM_PROJECT_ID =
            new ArrayList<>(Arrays.asList(
                    "ProjectBudget_userProject","ProjectBudgetCoordination_userProject","task_Project_Budget_Coordination"));

    public static  Boolean  isPcmCustomized(String tmActivityID,String tmProjectId){
        return PCM_ACTIVITY_ID.contains(tmActivityID) && PCM_PROJECT_ID.contains(tmProjectId);
    }

    public static  Boolean  isPcmCustomizedActivityId(String tmActivityID){
        if(StringUtil.isNotEmpty(tmActivityID)){
            return PCM_ACTIVITY_ID.contains(tmActivityID) || PCM_ACTIVITY_ID.contains(tmActivityID.toUpperCase());
        }else{
          return false;
        }
         }

}
