package com.digiwin.mobile.mobileuibot.core.common;

import java.util.Objects;

public interface PortalConstans {
    //任务卡
    public static final String TASK_CARD = "INDEX-MY_WORKSPACE-CARD_LIST";

    //项目卡
    public static final String PROJECT_CARD = "INDEX-MY_WORKSPACE-TODO_LIST";

    //自定义连接
    String CUSTOM ="Custom";

    //应用作业
    String CUSTOM_APPLICATION = "CustomApplication";

    //自定义页面
    String CUSTOM_PAGE = "CustomPage";

    //公告
    String MOBILE_NEWS = "MobileNews";

    //公告类型
    String MOBILE_NEWS_TYPE = "mobileNewsType";

    //自定义页面路由
    String CUSTOM_PAGE_ROUTER = "INDEX_PORTAL";

    //公告路由
    String MOBILE_NEWS_ROUTER = "NOTICE_DETAIL_PAGE";

    /**
     * Action 常用功能类型枚举
     */
    enum ActionEnum {
        //消息列表
        MOBILE_ATHENA_ASSISTANT(0, "工作提醒"),
        //行事历
        PAGE_CALENDAR(1, "行事历"),
        //通讯录
        CONTACT_DIRECTORY_PAGE(2, "通讯录"),
        //全局搜索
        APP_SEARCH(3, "全局搜索"),
        //项目追踪列表
        MOBILE_ATHENA_PROJECT(4, "项目追踪"),
        //扫码
        SCAN(5, "扫码"),
        //任务列表页
        MOBILE_MY_TODO(6, "我的任务"),
        //我的
        OWN(7, "我的"),
        //B娜
        AI_ASSISTANT(8, "B娜"),
        //新建任务
        MOBILE_MANUAL_TASK_DETAIL_APPROVAL_AGREE(9, "新建任务"),
        //公告列表
        NOTICE_LIST_PAGE(10, "公告列表");

        private Integer value;

        private String zhCNName;

        ActionEnum(Integer value, String zhCNName) {
            this.value = value;
            this.zhCNName = zhCNName;
        }

        public Integer getValue() {
            return value;
        }

        public String getZhCNName() {
            return zhCNName;
        }

        public static String getNameByValue(Integer value) {
            for (ActionEnum actionEnum : ActionEnum.values()) {
                if (Objects.equals(actionEnum.getValue(), value)) {
                    return actionEnum.name();
                }
            }
            return null;
        }

    }

    //金刚区交互类型
    enum DistrictinteractionTypeEnum{
        //全部展开
        EXPAND_ALL(0),
        //左右滑动
        SWIPE_LEFT_AND_RIGHT(1),
        //折叠展开
        COLLAPSE_TO_EXPAND(2);

        private Integer value;

        DistrictinteractionTypeEnum(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return value;
        }
    }


    //金刚区设置类型
    enum DistrictCustomTypeEnum{
        //默认租户设置
        TENANT_TYPE(0),
        //用户自定义设置
        USER_TYPE(1);

        private Integer value;

        DistrictCustomTypeEnum(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return value;
        }
    }


    /**
     * 预设组件枚举
     */
    enum PreComponentEnum {
        /**
         * 0-预设组件-金刚区
         */
        PRE_HONG_KIND_DISTRIC(0),

        /**
         * 1-预设组件-任务组件
         */
        PRE_TASK(1),

        /**
         * 2-预设组件-项目追踪组件
         */
        PRE_PROJECT(2),

        /**
         * 4-预设组件-轮播图
         */
        PRE_CAROUSEL(4),

        /**
         * 5-预设组件-公告
         */
        PRE_NEWS(5),
        /**
         * 6-预设组件-标题
         * @param value
         */
        TITLE(6),
        /**
         * 7-预设组件-分割线
         * @param value
         */
        DIVIDER(7),
        /**
         * 8-预设组件-三方待办
         * @param value
         */
        TRIPARTITE_TO_DO(8),
        /**
         * 9-预设组件-图片
         * @param value
         */
        PICTURE(9),
        /**
         * 10-预设组件-业务入口
         * @param value
         */
        BUSINESS_ENTRANCE(10),
        /**
         * 11-自定义部件-H5链接
         */
        H5_LINK(11),

        /**
         * 首页自定义
         */
        USER_CUSTOM_CONTAINER(12);

        PreComponentEnum(Integer value) {
            this.value = value;
        }

        private Integer value;

        public Integer getValue() {
            return value;
        }

    }

    /**
     * 金刚区跳转类型
     */
    enum JumpTypeEnum {
        //常用功能
        COMMONLY_USERD_FUNCTIONS(0),
        //自定义url
        CUSTOMIZE_URL(1),
        //SSO中的配置 即自定义应用
        SSO_CONFIGURATION(2),
        // 3-自定义页面
        CUSTOM_PAGE(3),
        // 4-公告
        MOBILE_NEWS(4),
        // 5-公告类型
        MOBILE_NEWS_TYPE(5);

        private Integer value;

        public Integer getValue() {
            return value;
        }

        JumpTypeEnum(Integer value) {
            this.value = value;
        }
    }

    /**
     * 移动门户类型（0：门户布局；1：自定义页面布局）
     */
     enum MobilePortalTypeEnum {
        PORTAL(0),

        CUSTOM_PORTAL(1);

        private Integer flag;

        MobilePortalTypeEnum(Integer flag) {
            this.flag = flag;
        }
        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 展示图标（0：不展示；1：展示）
     */
    enum IconFlagEnum {
        NO_SHOW(0),
        IS_SHOW(1);

        private Integer flag;

        IconFlagEnum(Integer flag) {
            this.flag = flag;
        }
        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 图标样式（0：色块、1：图标）
     */
    enum IconStyleEnum {
        COLOR(0),
        ICON(1);
        private Integer val;
        IconStyleEnum(Integer val) {
            this.val = val;
        }
        public Integer getVal() {
            return val;
        }
    }


    /**
     * 头部风格 0无 1色块 2图标
     */
    enum LeaderStyleEnum {
        EMPTY(0),
        COLOR(1),
        ICON(2);

        private Integer val;

        LeaderStyleEnum(Integer val) {
            this.val = val;
        }
        public Integer getVal() {
            return val;
        }
    }

    /**
     * 图标资源类型, 0-APP内部资源 1-IconFont 2-网络资源
     */
    enum IconTypeEnum {
        APP(0),
        ICON_FONT(1),
        NET_WORK(2);

        private Integer val;

        IconTypeEnum(Integer val) {
            this.val = val;
        }
        public Integer getVal() {
            return val;
        }
    }
}
