package com.digiwin.mobile.mobileuibot.core.common;

import java.util.Objects;

/**
 * @author wuyang
 * @desc 用于标识数量的枚举
 */
public enum SizeTypeEnum {
    /**
     * 数量-0
     */
    ZERO(0),
    /**
     * 数量-1
     */
    ONE(1),

    /**
     * 数量-2
     */
    TWO(2),

    /**
     * 数量-3
     */
    THREE(3),

    /**
     * 数量-4
     */
    FOUR(4),
    ;

    private final Integer value;

    SizeTypeEnum(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static SizeTypeEnum getEnumByValue(Integer value) {
        for (SizeTypeEnum testedEnum : SizeTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
