package com.digiwin.mobile.mobileuibot.core.component;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：Group类型组件基类。泛型的T表示要放在Group中的组件类型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BaseGroupMobileComponent
 * @Author: Zaregoto
 * @Date: 2023/2/9 12:06
 */
@Data
public abstract class BaseGroupMobileComponent<T extends BaseMobileComponent> extends BaseLayoutMobileComponent {
    private static final long serialVersionUID = 5841805925723066404L;

    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    protected List<BaseMobileComponentWrapper<T>> contentGroup;

    public BaseGroupMobileComponent() {
        this.contentGroup = new ArrayList<>();
    }

    public void addComponentToGroup(T component) {
        if (null != this.contentGroup) {
            this.contentGroup.add(new BaseMobileComponentWrapper<>(component));
        }
    }

    public void addComponentToGroup(T component, String customComponentType) {
        if (null != this.contentGroup) {
            this.contentGroup.add(new BaseMobileComponentWrapper<>(component, customComponentType));
        }
    }

    public void addAllComponentsToGroup(List<T> componentList) {
        if (null != this.contentGroup && null != componentList && !componentList.isEmpty()) {
            componentList.forEach(c -> this.contentGroup.add(new BaseMobileComponentWrapper<>(c)));
        }
    }

    public void addAllComponentsToGroup(List<T> componentList, String componentTypePrefix, String componentTypeSuffix) {
        if (null != this.contentGroup && null != componentList && !componentList.isEmpty()) {
            componentList.forEach(c -> this.contentGroup.add(new BaseMobileComponentWrapper<>(c, componentTypePrefix + c.returnComponentType() + componentTypeSuffix)));
        }
    }

    public void addAllComponentsToGroup(List<T> componentList, String customComponentType) {
        if (null != this.contentGroup && null != componentList && !componentList.isEmpty()) {
            componentList.forEach(c -> this.contentGroup.add(new BaseMobileComponentWrapper<>(c, customComponentType)));
        }
    }

    public void deleteComponentInGroup(int index) {
        if (null != this.contentGroup && index > -1) {
            this.contentGroup.remove(index);
        }
    }

    public void clearComponentsGroup() {
        if (null != this.contentGroup) {
            this.contentGroup.clear();
        }
    }
}
