package com.digiwin.mobile.mobileuibot.core.component;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleSubcategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRuleDate;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRuleText;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRule;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>功能描述：录入组件基础类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BaseInputMobileComponent
 * @Author: Zaregoto
 * @Date: 2021/6/22 22:15
 */
public abstract class BaseInputMobileComponent extends BaseMobileComponent {
    private static final long serialVersionUID = -1088809041057122311L;

    //false是置灰，不可编辑
    protected Boolean enable;
    /**
     * 错误提示
     */
    protected String errorMessage;
    /**
     * 提示文字
     */
    protected String placeholder;
    /**
     * 是否必填
     */
    protected Boolean required;
    protected List<ValidateRule> validateRuleList;
    protected RelationRule relationRule;
    protected String schema;
    /**
     * 是否隐藏
     */
    protected Boolean hidden;

    public BaseInputMobileComponent() {
    }

    public void addAllMobileRule(Map<String, Object> bizData, String schema, List<Rule> ruleList, String locale, ApiRequest apiRequest, Map<String, Object> variableMaps, String text) {
        List<Rule> validateRuleList = ruleList.stream().filter(
                        rule -> rule.getCategory().equalsIgnoreCase(RuleCategoryEnum.VALIDATE.getCategory())
                                && rule.getSchema().equalsIgnoreCase(schema))
                .collect(Collectors.toList());
        if (Rule.hasCustomMadeRule(apiRequest, validateRuleList)) {
            validateRuleList = Rule.compareRule(apiRequest, validateRuleList, RuleCategoryEnum.VALIDATE.getCategory());
        }

        List<Rule> relationRuleList = ruleList.stream().filter(
                        rule -> rule.getCategory().equalsIgnoreCase(RuleCategoryEnum.RELATION.getCategory())
                                && rule.getSchema().equalsIgnoreCase(schema))
                .collect(Collectors.toList());
        //判断是否走客制规则
        if (Rule.hasCustomMadeRule(apiRequest, relationRuleList)) {
            relationRuleList = Rule.compareRule(apiRequest, relationRuleList, RuleCategoryEnum.RELATION.getCategory());
        }


        /*validateRuleList.forEach(
                rule ->
                        this.getValidateRuleList().add(ValidateRule.create(rule, locale, bizData))
        );*/
        for (Rule validateRule : validateRuleList) {
            if (!validateRule.validWithBizData(bizData)) {
                continue;
            } else {
                if (!CollectionUtils.isEmpty(variableMaps) && validateRule.getInitConfig() != null && validateRule.getInitConfig().getKey() != null) {
                    if (!(Boolean) variableMaps.get(validateRule.getInitConfig().getKey())) {
                        this.getValidateRuleList().add(ValidateRule.create(validateRule, locale, bizData));
                    }
                } else {
                    this.getValidateRuleList().add(ValidateRule.create(validateRule, locale, bizData));
                }

            }

        }

        LocaleService localeService = SpringContextHolder.getBean(LocaleService.class);

        RelationRule resultRelationRule = new RelationRule();
        for (Rule relationRule : relationRuleList) {
            if (!relationRule.validWithBizData(bizData)) {
                continue;
            }
            if (relationRule.getSubcategory().equalsIgnoreCase(RuleSubcategoryEnum.DATE.getSubcategory())) {
                resultRelationRule.addRelationRuleDate(RelationRuleDate.create(bizData, relationRule));
            } else if (relationRule.getSubcategory().equalsIgnoreCase(RuleSubcategoryEnum.TEXT.getSubcategory())) {
                RelationRuleText relationRuleText = RelationRuleText.create(bizData, relationRule);
                if (!Objects.isNull(relationRuleText) && StringUtils.isNotEmpty(relationRuleText.getTargetPlaceholder())) {
                    relationRuleText.setTargetPlaceholder(localeService.getLanguageValue(locale, relationRuleText.getTargetPlaceholder()));
                }
                resultRelationRule.addRelationRuleText(relationRuleText);
            } else if (relationRule.getSubcategory().equalsIgnoreCase(RuleSubcategoryEnum.COMMON.getSubcategory())) {
                CommonRule commonRule = null;
                if (!CollectionUtils.isEmpty(variableMaps) && relationRule.getInitConfig() != null && StringUtil.isNotEmpty(relationRule.getInitConfig().getKey())) {
                    if ((Boolean) variableMaps.get(relationRule.getInitConfig().getKey())) {
                        commonRule = CommonRule.create(relationRule.getCommonRule(), text);
                    }
                } else {
                    commonRule = relationRule.getCommonRule();
                }
                if (!Objects.isNull(commonRule) && StringUtils.isNotEmpty(commonRule.getTargetPlaceholder())) {
                    commonRule.setTargetPlaceholder(localeService.getLanguageValue(locale, commonRule.getTargetPlaceholder()));
                }
                resultRelationRule.addCommonRule(commonRule);
            } else {

            }
        }
        this.setRelationRule(resultRelationRule);
    }

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getPlaceholder() {
        return placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public Boolean getRequired() {
        return required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public List<ValidateRule> getValidateRuleList() {
        if (null == this.validateRuleList) {
            this.validateRuleList = new ArrayList<>();
        }
        return validateRuleList;
    }

    public void setValidateRuleList(List<ValidateRule> validateRuleList) {
        this.validateRuleList = validateRuleList;
    }

    public RelationRule getRelationRule() {
        if (null == this.relationRule) {
            this.relationRule = new RelationRule();
        }
        return relationRule;
    }

    public void setRelationRule(RelationRule relationRule) {
        this.relationRule = relationRule;
    }

    public String getSchema() {
        return schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public Boolean getHidden() {
        return hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public void applyEditable(Boolean enable) {
        this.enable = enable;
    }


    @Override
    public void applyHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
    }
}
