package com.digiwin.mobile.mobileuibot.core.component;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.core.component.layout.ComponentLayoutTypeEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：列表类型组件基类。泛型的T表示要放在列表中的组件类型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BaseListMobileComponent
 * @Author: Zaregoto
 * @Date: 2021/6/16 22:39
 */
@Data
public abstract class BaseListMobileComponent<T extends BaseMobileComponent> extends BaseLayoutMobileComponent {
    private static final long serialVersionUID = -3463956265364418603L;

    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    protected List<BaseMobileComponentWrapper<T>> contentList;

    public BaseListMobileComponent() {
        this.contentList = new ArrayList<>();
    }

    public BaseListMobileComponent(List<BaseMobileComponentWrapper<T>> contentList) {
        this.contentList = contentList;
    }

    @Override
    public ComponentLayoutTypeEnum getComponentLayoutType() {
        return ComponentLayoutTypeEnum.VERTICAL;
    }

    public void add(BaseMobileComponentWrapper<T> wrappered) {
        if (null != this.getContentList()) {
            this.getContentList().add(wrappered);
        }
    }

    public void addAll(List<BaseMobileComponentWrapper<T>> wrapperedList) {
        if (null != this.getContentList()) {
            this.getContentList().addAll(wrapperedList);
        }
    }

    public void addComponentToList(T component) {
        if (null != this.getContentList()) {
            this.getContentList().add(new BaseMobileComponentWrapper<>(component));
        }
    }

    public void addComponentToList(T component, String customComponentType) {
        if (null != this.getContentList()) {
            this.getContentList().add(new BaseMobileComponentWrapper<>(component, customComponentType));
        }
    }

    public void addAllComponentsToList(List<T> componentList) {
        if (null != this.getContentList() && !CollectionUtils.isEmpty(componentList)) {
            componentList.forEach(c -> this.getContentList().add(new BaseMobileComponentWrapper<>(c)));
        }
    }

    public void addAllComponentsToList(List<T> componentList, String customComponentType) {
        if (null != this.getContentList() && !CollectionUtils.isEmpty(componentList)) {
            componentList.forEach(c -> this.getContentList().add(new BaseMobileComponentWrapper<>(c, customComponentType)));
        }
    }

    public void addAllComponentsToList(List<T> componentList, String componentTypePrefix, String componentTypeSuffix, String schema) {
        if (null != this.getContentList() && !CollectionUtils.isEmpty(componentList)) {
            String localPrefix = "";
            String localSuffix = "";
            if (StringUtils.hasLength(componentTypePrefix)) {
                localPrefix = componentTypePrefix;
            }
            if (StringUtils.hasLength(componentTypeSuffix)) {
                localSuffix = componentTypeSuffix;
            }
            for (T t : componentList) {
                this.getContentList().add(
                        new BaseMobileComponentWrapper<>(t, localPrefix + t.returnComponentType() + localSuffix, schema));
            }
        }
    }

    public void deleteComponentInList(int index) {
        if (null != this.contentList && index > -1) {
            this.contentList.remove(index);
        }
    }

    public void clearComponentsList() {
        if (null != this.contentList) {
            this.contentList.clear();
        }
    }

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public boolean isEmpty() {
        if (null != this.contentList) {
            return this.contentList.isEmpty();
        }
        return true;
    }

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public boolean isNotEmpty() {
        return !this.isEmpty();
    }
}
