package com.digiwin.mobile.mobileuibot.core.component;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.Optional;

/**
 * <p>功能描述：组件包装类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BaseMobileComponentWrapper
 * @Author: Zaregoto
 * @Date: 2022/3/4 18:48
 */
@Data
public class BaseMobileComponentWrapper<T extends BaseMobileComponent> implements Serializable {
    private static final long serialVersionUID = -4721350868250067627L;

    protected String componentType;
    protected T data;
    protected String schema;
    /**
     * schema全路径
     * 在与开发平台设计器集成后引入该字段，用于标识schema的读取数据路径,如：task_info.op_name -- V2版设计器新增属性
     */
    protected String mobilePath;

    /**
     * V2版DSL，提供前端schema不能为空，作用于规则校验
     *
     * @return
     */
    public String getSchema() {
        if (StringUtils.hasLength(this.schema)) {
            return this.schema;
        }
        return this.schema = Optional.ofNullable(this.data).map(BaseMobileComponent::getCmptUuid).orElse(UUIDUtil.getUuid());
    }

    /**
     * V2版DSL，组件中需要填充schema值，提供给前端，作用于规则校验
     *
     * @return
     */
    public T getData() {
        if (this.data == null) {
            return this.data;
        }
        // 组件中已存在schema值，返回
        if (StringUtils.hasLength(this.data.getSchema())) {
            return this.data;
        }
        this.data.setSchema(this.getSchema());
        return this.data;
    }

    /**
     * 获取data中的componentId
    * 注：不使用getComponentId是为了不让Jackson做序列化
    */
    public String returnComponentId() {
        if (this.data == null) {
            return "";
        }
        String componentId = this.data.getComponentId();
        return componentId == null ? "" : componentId;
    }

    public BaseMobileComponentWrapper(T data) {
        this.componentType = data.returnComponentType();
        this.data = data;
    }

    public BaseMobileComponentWrapper(T data, String componentType) {
        this.componentType = componentType;
        this.data = data;
    }

    public BaseMobileComponentWrapper(T data, String componentType, String schema) {
        this.componentType = componentType;
        this.data = data;
        this.schema = schema;
    }

    public BaseMobileComponentWrapper(T data, String componentType, String schema, String mobilePath) {
        this.componentType = componentType;
        this.data = data;
        this.schema = schema;
        this.mobilePath = mobilePath;
    }
}
