package com.digiwin.mobile.mobileuibot.core.component;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：针对<code>BaseMobileComponentWrapper</code>类的自定义JSON反序列化类 </p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BaseMobileComponentWrapperJsonDeserializer
 * @Author: wangjwc
 * @Date: 2023/6/29 17:56
 */
public class BaseMobileComponentWrapperJsonDeserializer extends JsonDeserializer<BaseMobileComponentWrapper<BaseMobileComponent>> {

    private static final Logger logger = LoggerFactory.getLogger(BaseMobileComponentWrapperJsonDeserializer.class);

    @Override
    public BaseMobileComponentWrapper<BaseMobileComponent> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext)
            throws IOException {
        logger.debug("BaseMobileComponentWrapperJsonDeserializer run to prehandle data to component instance...");
        JsonNode node = jsonParser.getCodec().readTree(jsonParser);
        String mobilePath = Optional.ofNullable(node.get("mobilePath")).map(JsonNode::asText).orElse("");
        String schema = Optional.ofNullable(node.get("schema")).map(JsonNode::asText).orElse("");
        String componentType = Optional.ofNullable(node.get("componentType")).map(JsonNode::asText).orElse("");

        if ("DW_CUSTOMIZE".equals(componentType)) {
            // 自定义组件，需要根据mappingComponent来确定实际的组件类型
            String mappingComponent = Optional.ofNullable(node.get("data")).map(data -> data.get("mappingComponent")).map(JsonNode::asText).orElse("");
            if (StringUtils.hasLength(mappingComponent)) {
                componentType = mappingComponent;
            }
        }

        // 如果反序列化前有前缀则继续加上前缀，场景如：设计器设计DSL就是带有前缀
        boolean existPrefix;
        if (existPrefix = componentType.startsWith("DW_")) {
            componentType = componentType.substring(3);
        }
        if (BooleanUtils.isTrue(AppRequestContext.getContextEntity().getIsUpgrade())) {
            // 升级场景下必有前缀
            existPrefix = true;
        }
        JsonNode data = node.get("data");
        Class<? extends BaseMobileComponent> cmptClazz = MobileRenderDataUtil.allMobileComponentsMap.get(componentType);
        BaseMobileComponent baseMobileComponent = null;
        if (null != cmptClazz) {
            if (Attachment.COMPONENT_TYPE.equals(componentType)) {
                baseMobileComponent = JsonUtil.jsonStringToObject(data.toString(), new TypeReference<Attachment<AttachmentRawDataDigiwinAthena>>() {
                });
            } else if (Button.COMPONENT_TYPE.equals(componentType)) {
                String string = data.toString();
                if (data.get("type") != null && data.get("type") instanceof TextNode) {
                    // wjw FIXME: 2023/10/18 因设计器配置的按钮"type" : "DW_BUTTON"，不是组件定义的Integer类型，故特殊处理删除掉此节点
                    Map map = JsonUtil.jsonStringToObject(string, Map.class);
                    map.remove("type");
                    string = JsonUtil.javaObjectToJsonString(map);
                }
                baseMobileComponent = JsonUtil.jsonStringToObject(string, cmptClazz);
            } else {
                baseMobileComponent = JsonUtil.jsonStringToObject(data.toString(), cmptClazz);
            }
        }
        return new BaseMobileComponentWrapper<>(baseMobileComponent, (existPrefix ? "DW_" : "") + componentType, schema, mobilePath);
    }

}
