package com.digiwin.mobile.mobileuibot.core.component;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.AppInfo;
import com.digiwin.mobile.mobileuibot.core.CommonRawDataParentType;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：组件构建中 上下文 -- 同ApiRequest</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ComponentContext.java
 * @Author: wangjwc
 * @Date: created at 2023/12/8 13:34
 */
@Data
@Accessors(chain = true)
public class ComponentContext implements Serializable {
    private static final long serialVersionUID = -94076383583690881L;

    protected String iamUserToken;
    protected String locale;
    protected String tenantId;
    protected String requestId;
    protected String clientId;

    private String pageId;

    private ApiRawData rawData;
    private List<ActionSubmitParam> submitParam;
    /**
     * APP相关信息 -- 控制是否去除优化rawData数据
     */
    private AppInfo appInfo;

    /**
     * 当前渲染页面下所有cardList的card全量数据 --- 自定义页面上下文参数
     */
    private List<ActionSubmitParam> cardAllDataList;
    /**
     * 当前渲染页面下所有cardList的filterFlag全局值 --- 自定义页面上下文参数
     * trueornull:默认不存在false
     */
    private Boolean cardListGlobalFilterFlag;

    /**
     * 是否新增全选按钮
     */
    private Boolean addAllSelectButton = false;

    /**
     * 当前cmpt是否用于底部的bottomDSL构建,默认false
     */
    private Boolean canBottomButton = false;

    private String choice;

    /**
     * 高级属性
     */
    private List<Map<String, Object>> hooks;

    /**
     * 修改card的dataId
     */
    private String modifyCardDataId;

    /**
     * 原始 Ui Bot 页面数据
     */
    private UiBotPageData rawUiBotPageData;

    /**
     * 组件数据为空时是否保留组件
     */
    private Boolean isReserveWhenEmpty = false;

    /**
     * 独立cardList、独立card、独立button --- 自定义页面上下文参数
     * 作用于rawData优化
     *
     * @see CommonRawDataParentType
     */
    private Integer commonRawDataParentType;
    private Boolean readOnly = null;
    private PcUiBotExecuteContext executeContext;
    private PcUiBotPageDefine pageDefine;
    private String userId;
    private String sourceType;

    /**
     * LIST_CONTAINER列表容器个数
     */
    private Integer listContainerCount = 0;

    /**
     * 页面数据源和节点信息
     *
     * @return
     */
    private Map<String, Map<String, Object>> pageLayoutInfo;

    /**
     * 是否跳过多数据源处理
     * true:跳过 false:不跳过
     */
    private Boolean skipMultiDataSource = false;

    public Boolean getReadOnly() {
        if (readOnly == null) {
            readOnly = justIsReadOnly(this);
        }
        return readOnly;
    }

    /**
     * 是否为只读
     */
    public static Boolean justIsReadOnly(ComponentContext buildContext) {
        if (buildContext == null
                || buildContext.getExecuteContext() == null
                || buildContext.pageDefine == null) {
            return false;
        }
        //如果是任务相关的显示
        if (buildContext.pageDefine instanceof PcUiBotTaskPageDefine) {
            if (buildContext.pageDefine.getExecuteContext() == null
                    || buildContext.pageDefine.getExecuteContext().getTaskWithBacklogData() == null
                    || buildContext.pageDefine.getExecuteContext().getTaskWithBacklogData().getBacklog() == null
                    || buildContext.pageDefine.getExecuteContext().getTaskWithBacklogData().getBacklog().size() == 0) {
                return false;
            }

            // “已搁置”页签，界面不允许编辑
            if (StringUtils.equals(PcUiBotActivityConstant.TASK_DATA_STATE_CODE_SHELVED, buildContext.pageDefine.getDataStateCode())) {
                return true;
            }

            String performerId = buildContext.pageDefine.getExecuteContext().getTaskWithBacklogData().getBacklog().get(0).getPerformerId();
            String userId = buildContext.getUserId();

            // 项目or任务是被分享的并且登录用户不是超级管理员，则组件只读、不可编辑
            boolean isSuperAndTaskEngine = BooleanUtils.isTrue(buildContext.getExecuteContext().getIsSuperAdmin()) &&
                    "PTM".equalsIgnoreCase(buildContext.getExecuteContext().getDataFrom());
            if (!userId.equals(performerId) && buildContext.getExecuteContext().isShared() && !isSuperAndTaskEngine) {
                return true;
            }
            PcUiBotTaskPageDefine taskPageDefine = (PcUiBotTaskPageDefine) buildContext.pageDefine;
            if (taskPageDefine.getFinished() != null && taskPageDefine.getFinished()) {
                return true;
            }

            //完成页签下的详情也不能编辑
            if (buildContext.getExecuteContext() != null
                    && buildContext.getExecuteContext().getDataStateCode() != null
                    && buildContext.getExecuteContext().getDataStateCode().equalsIgnoreCase(PcUiBotActivityConstant.TASK_DATA_STATE_CODE_COMPLETED)) {
                return true;
            }

            if (buildContext.getPageDefine() != null
                    && buildContext.getPageDefine().getDataStateCode() != null
                    && buildContext.getPageDefine().getDataStateCode().equalsIgnoreCase(PcUiBotActivityConstant.TASK_DATA_STATE_CODE_COMPLETED)) {
                return true;
            }
        }
        return false;
    }

    public static ComponentContext createEmpty() {
        return new ComponentContext();
    }

    public ApiRawData getRawData() {
        return this.rawData = Optional.ofNullable(rawData).orElse(new ApiRawData());
    }

    public List<ActionSubmitParam> getCardAllDataList() {
        return this.cardAllDataList = Optional.ofNullable(cardAllDataList).orElse(new ArrayList<>());
    }

    public UiBotPageData getRawUiBotPageData() {
        return this.rawUiBotPageData = Optional.ofNullable(rawUiBotPageData).orElse(new UiBotPageData());
    }
}
