package com.digiwin.mobile.mobileuibot.core.component;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.core.component.layout.ComponentLayoutTypeEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>功能描述：自定义列表组件 使用于 V1版本DSL列表组件转V2版本DSL</p>
 * <p>如：TabsComponent</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomList
 * @Author: wangjwc
 * @Date: 2023/6/5 12:06
 */
@Data
public class CustomList<T extends List> extends BaseLayoutMobileComponent {
    private static final long serialVersionUID = -6031239455081429262L;
    public static final String COMPONENT_TYPE = "CUSTOM_LIST";
    // content 是数组
    private T content;
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private String componentType;

    @Override
    public String returnComponentType() {
        return componentType;
    }

    @Override
    public ComponentLayoutTypeEnum getComponentLayoutType() {
        return ComponentLayoutTypeEnum.VERTICAL;
    }
}
