package com.digiwin.mobile.mobileuibot.core.component;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionParameterMapping;
import lombok.Data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 设计器数据源映射类
 *
 * @author yanfeng
 * @date 2024/1/18
 */
@Data
public class DataSource {

    /**
     * 数据源接口
     */
    private String actionId;

    /**
     * 数据源名称
     */
    private String actionName;

    /**
     * API 入参 参数转换设定
     */
    private List<PcUiBotActionParameterMapping> actionParams;

    /**
     * API 透传的CONSTANT类型入参，不需要转换
     */
    private Map<String, Object> paras;

    public Map<String, Object> getParas() {
        return paras = (paras == null) ? new HashMap<>() : paras;
    }
}
