package com.digiwin.mobile.mobileuibot.core.component;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;

import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MobileComponent
 * @Author: Zaregoto
 * @Date: 2021/5/23 22:29
 */
public interface MobileComponent {

    /**
     * 返回组件名称。
     * 注：不使用getComponentType是为了不让Jackson做序列化
     *
     * @return
     */
    String returnComponentType();

    /**
     * 处理需要展示的组件参数
     *
     * @param cmptContext       组件构建中 上下文
     * @param mobilePath        schema的全路径字段
     * @param schema            待查找的schema字段
     * @param data              当前页面的数据源数据
     * @param executeContext    上下文信息
     * @param mobilePageRawData 原始数据
     * @param args              组件处理需要的额外参数
     */
    default void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                      PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
    }

    /**
     * 设置组件是否可编辑
     *
     * @param enable true:可编辑；false:置灰不可编辑
     */
    default void applyEditable(Boolean enable) {
    }

    /**
     * 设置组件是否隐藏
     *
     * @param hidden true:隐藏；false：显示
     */
    default void applyHidden(Boolean hidden) {
    }
}
