package com.digiwin.mobile.mobileuibot.core.component;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：移动端组件构造工厂</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MobileComponentBuilderFactory
 * @Author: Zaregoto
 * @Date: 2021/7/9 15:15
 */
@Component("mobileComponentBuilderFactory")
public class MobileComponentBuilderFactory implements InitializingBean, ApplicationContextAware {

    private static final Map<String, MobileComponentBuilder> MOBILECOMPONENT_BUILD_MAP = new HashMap<>();

    private ApplicationContext appContext;

    public MobileComponentBuilder get(String key) {
        return MOBILECOMPONENT_BUILD_MAP.get(key);
    }

    @Override public void afterPropertiesSet() throws Exception {
        // 将 Spring 容器中所有的 MobileComponentBuilder 注册到 MOBILECOMPONENT_BUILD_MAP
        this.appContext.getBeansOfType(MobileComponentBuilder.class).values()
            .forEach(mobileComponentBuilder ->
                MOBILECOMPONENT_BUILD_MAP.put(
                    mobileComponentBuilder.getMobileComponentType(), mobileComponentBuilder)
            );
    }

    @Override public void setApplicationContext(ApplicationContext applicationContext)
        throws BeansException {
        this.appContext = applicationContext;
    }
}
