package com.digiwin.mobile.mobileuibot.core.component;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;

import java.util.List;

/**
 * <p>功能描述：组件构造接口。根据UiBotModel和组件Class类型，返回对应的组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MobileComponentListBuilder
 * @Author: Zaregoto
 * @Date: 2021/5/19 21:09
 */
public interface MobileComponentListBuilder<T extends MobileComponent> {

    String getMobileComponentType();

    List<T> build(ApiRequest locale, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<T> clazz, Object... args);
}
