package com.digiwin.mobile.mobileuibot.core.component;

import java.util.Objects;

/**
 * <p>功能描述：移动端画面布局类型枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MobileLayoutTypeEnum
 * @Author: zaregoto
 * @Date: 2023/2/22 13:47
 */
public enum MobileLayoutTypeEnum {

    /**
     * 其它布局
     */
    OTHER_PATTERN_LAYOUT("OTHER_PATTERN_LAYOUT"),

    /**
     * 单层布局
     */
    SINGLE_PATTERN_LAYOUT("SINGLE_PATTERN_LAYOUT"),

    /**
     * 多层布局
     */
    MULTI_PATTERN_LAYOUT("MULTI_PATTERN_LAYOUT"),

    ;

    private final String value;

    MobileLayoutTypeEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static MobileLayoutTypeEnum getEnumByValue(String value) {
        for (MobileLayoutTypeEnum testedEnum : MobileLayoutTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
