package com.digiwin.mobile.mobileuibot.core.component;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.SourceCategoryEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：页面操作的rawData数据</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MobilePageRawData.java
 * @Author: wangjwc
 * @Date: created at 2023/9/10 17:14
 */
@Data
@Accessors(chain = true)
public class MobilePageRawData implements Serializable {
    private static final long serialVersionUID = -709092440348757602L;
    /**
     * 原始的全量数据，存储的是数据源返回的数据，key：数据源名称，value：数据源返回的数据 ---- 只针对列表组件使用
     * <p>
     * 注意：现只在 数据驱动line场景下使用
     */
    private Map<String, Object> allRawMap;
    /**
     * 原始的单条数据，存储的是数据源列表中的单条数据 ---- 只针对列表组件使用
     * <p>
     * 详情页，整体数据是数组 --- rawMap=null，不可传入rawMap数据，否则会影响非任务详情页提交按钮中action的rawdata中data数据
     * 详情页，列表是数据源下的一个节点 --- rawMap=原始的单条数据
     * 条目详情页，存在列表 --- rawMap=原始的单条数据
     */
    private Map<String, Object> rawMap;
    /**
     * 作用于刷新页面和提交使用
     */
    private String dataId;
    /**
     * 元数据类型，object：对象，array：数组
     * 注意：只在任务/数据录入详情页加载时赋值
     */
    private String rawDataType;
    /**
     * 扩展字段  -- 作用于数据录入状态管理配置
     * 注意：只在数据录入详情页加载时赋值
     */
    private Map<String, Object> extendedFields;
    /**
     * 来源分类 默认任务卡来源
     * 注意：只在任务/项目/发起项目/数据录入详情页加载时赋值
     *
     * @see com.digiwin.mobile.mobileuibot.designer.uibot.enums.SourceCategoryEnum
     */
    private String sourceCategory;
    /**
     * 数据源返回的结果集中数据主键  -- 作用于编辑状态下，栏位不可编辑
     * 注意：现只在数据录入详情页加载时赋值
     */
    private List<String> dataKeys;

    /**
     * cardList组件的唯一标识
     * 注意：现只在 cardList筛选场景使用
     */
    private String componentId;

    public MobilePageRawData deepCopy() {
        return JsonUtil.objectToJavaObject(this, MobilePageRawData.class);
    }

    public String getSourceCategory() {
        return this.sourceCategory = Optional.ofNullable(this.sourceCategory).orElse(SourceCategoryEnum.TASK.name());
    }
}