package com.digiwin.mobile.mobileuibot.core.component.action;

import com.digiwin.mobile.mobileuibot.api.ApiExtraParameter;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.breadcrumb.BreadCrumbNode;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfig;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfigService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.BusinessTypeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterService;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtReportData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotDesignParameter;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.table.AgileDataTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.*;

/**
 * <p>功能描述：移动平台按钮点击事件对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ButtonAction
 * @Author: Zaregoto
 * @Date: 2021/5/20 14:48
 */
@Data
public class Action<T> implements Serializable {
    private static final long serialVersionUID = 1738609534637919415L;

    protected String dataId;

    /**
     * 要跳转页面的页面id。
     * 如果type不是跳转页面类型的，需要保持为null
     */
    protected String jumpPageId;

    /**
     * 要跳转页面的页面id。
     */
    protected String jumpPageTitle;
    /**
     * 需要刷新的页面id.
     * 用于告知前端在完成当前action指定的type后，需要刷新哪个页面的数据
     */
    protected String refreshPageId;

    /**
     * 需要刷新的card的dataId
     * 用于card列表组件，条目详情页有兄弟节点时，只刷新当前条目详情页，不刷新其它兄弟节点页面
     */
    protected String refreshDataId;

    protected String requestUrl;
    /**
     * 是否允许按钮操作后全屏截屏
     */
    protected Boolean screenShotSwitch = false;
    /**
     * 全屏截图数据绑定的字段
     */
    protected String screenShotSchema;

    /**
     * 点击事件类型
     *
     * @see ActionTypeEnum
     */
    protected Integer type;
    protected T rawData;
    protected String toastMsg;
    /**
     * 弹窗提示信息
     */
    protected PopPromptMsg popPromptMsg;
    /**
     * 新的二次弹窗
     */
    protected ConfirmPop confirmPop;
    protected String successMsg;
    protected ActionValidationConfig validationConfig;
    protected Boolean actionDone;
    /**
     * 点击时，获取定位信息，并提交
     * 可选值：0：不需位置信息；1：需定位，但不强制；2：强制定位信息，无位置信息不可往后执行。默认为0
     */
    protected Integer needPosition = 0;
    /**
     * 是否为第三方系统请求
     */
    protected Boolean isThirdPartyRequestUrl = false;
    /**
     * 仅请求接口，不动态渲染
     */
    protected Boolean onlyRequest = false;

    /**
     * 不支持跳转，默认为false
     */
    protected Boolean noSupport = false;
    /**
     * 使用父组件action
     */
    protected Boolean useParentAction = false;
    /**
     * 使用父组件的类
     */
    protected String parentComponent;

    /**
     * 扩展字段，作用于在途宝，首页浮层卡
     */
    private ApiExtraParameter extraParameter;

    private BreadCrumbNode crumbItem;

    /**
     * 运行态的扩展字段结构
     */
    private UiBotDesignParameter designParameter;

    /**
     * 设计器配置定制提交JS
     */
    private String actionJsEvent;

    /**
     * 业务类型
     * 'local-delete'   |   'local-add'  |  'local-save'  |  'other' | ‘filter’
     *
     * @see BusinessTypeEnum
     */
    private String businessType;


    /**
     * line场景 整批提交前端保存 且显示（暂存(n/m)、保存并提交）为save 或 submit
     * 现只用于模型驱动下手动赋值
     */
    private String saveType;
    /**
     * 娜娜消息ID，主要作用是APP中娜娜打开数据驱动任务卡，确定是否提交，提交的是哪个消息
     */
    private String nanaMessageId;

    /**
     * 提交时候使用，前端控制组件效验提示信息
     */
    private ActionSubmitRule submitRule;

    /**
     * 用APP的webview打开网页的页面title
     * 前端抓对方页面title, 如果为空则取用此字段(兜底)
     */
    private String openWebPageTitle;

    /**
     * detailPage提交后跳转到下一个条目
     */
    private Integer nextHandleIndex;

    /**
     * 业务数据
     * 后端需要使用的业务字段，前端透传此对象给到后端使用
     */
    private BusinessRawData businessRawData;

    /**
     * 仅使用当前的rawData刷新页面
     */
    private Boolean onlyUseNowRawData = false;

    private Integer calenderType;

    private String startDate;
    private String endDate;

    public Action() {
    }

    public Action(Integer type) {
        this.type = type;
    }

    public Action(String dataId, Integer type, String toastMsg) {
        this.dataId = dataId;
        this.type = type;
        this.toastMsg = toastMsg;
    }

    public Action(String dataId, String jumpPageId, String jumpPageTitle, Integer type,
                  String toastMsg) {
        this.dataId = dataId;
        this.jumpPageId = jumpPageId;
        this.jumpPageTitle = jumpPageTitle;
        this.type = type;
        this.toastMsg = toastMsg;
    }

    public Action(String dataId, String jumpPageId, String jumpPageTitle, Integer type, T rawData) {
        this.dataId = dataId;
        this.jumpPageId = jumpPageId;
        this.jumpPageTitle = jumpPageTitle;
        this.type = type;
        this.rawData = rawData;
    }

    public Action(String dataId, String jumpPageId, Integer type, T rawData) {
        this.dataId = dataId;
        this.jumpPageId = jumpPageId;
        this.type = type;
        this.rawData = rawData;
    }

    public Action(String jumpPageId, String jumpPageTitle, Integer type) {
        this.jumpPageId = jumpPageId;
        this.jumpPageTitle = jumpPageTitle;
        this.type = type;
    }

    /**
     * 转派记录按钮
     *
     * @param locale
     * @param reassignReportList
     * @return
     */
    public static Action createReassignReportAction(String locale, List<DigiwinReassignReport> reassignReportList) {
        Action action = new Action();
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_REASSIGN_REPORT.toString());
        action.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "转派记录"));
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        Map<String, Object> rawData = new HashMap<>(1);
        rawData.put("rawData", reassignReportList);
        action.setRawData(rawData);
        return action;
    }

    public static Action createReassignReportAction(String locale, Map<String, Object> rawData) {
        Action action = new Action();
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_REASSIGN_REPORT.toString());
        action.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "转派记录"));
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setRawData(rawData);
        return action;
    }

    /**
     * 跳转到abi报表展示页
     *
     * @param dataId
     * @param reportName
     * @param actionRawData
     * @return
     */
    public static Action jumpAbiReportDetailAction(String dataId, String reportName, Map<String, Object> actionRawData) {
        Action action = new Action();
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ABI_REPORT_DETAIL.toString());
        action.setJumpPageTitle(reportName);
        action.setRawData(actionRawData);
        action.setDataId(dataId);
        action.setType(ActionTypeEnum.BACK_REFRESH.getValue());
        return action;
    }

    /**
     * 异常回报定制参数
     *
     * @param locale
     * @param mainDataInfo
     * @param pcUiBotModel
     * @param businessUnit
     * @param executeContext
     * @param commonRawDataMap
     * @param dataId
     * @return
     */
    public static Action createAbnormalReportAction(String locale, Map<String, Object> mainDataInfo, UiBotModel pcUiBotModel, Map<String, Object> businessUnit,
                                                    UiBotExecuteContext executeContext, Map<String, Object> commonRawDataMap, String dataId) {
        Map<String, Object> abnormalReportRawData = new HashMap<>();
        List<Map<String, Object>> woOpReportAbnormalList = new ArrayList<>();
        woOpReportAbnormalList.add(mainDataInfo);
        abnormalReportRawData.put("wo_op_report_abnormal", woOpReportAbnormalList);

        //这块参数目前和web端前端开发人员确定是写死的，故移动端这边参数也是写死。这是获取异常原因的第一个api需要的参数
        Map<String, Object> queryActionParameter = new HashMap<>();
        Map<String, Object> tmAction = new HashMap<>();
        String serviceName = "bm.opsc.abnormal.reason.info.get";
        tmAction.put("actionId", "esp_" + serviceName);
        tmAction.put("title", LocaleUtil.getMobileTextByKey(locale, "取得异常资讯"));
        tmAction.put("actionParams", new ArrayList<>());
        Map<String, Object> paras = new HashMap<>();
        List<Map<String, Object>> abnormalReasonInfoList = new ArrayList<>();
        abnormalReasonInfoList.add(businessUnit);
        paras.put("abnormal_reason_info", abnormalReasonInfoList);
        tmAction.put("paras", paras);
        Map<String, Object> language = new HashMap<>();
        Map<String, Object> title = new HashMap<>();
        title.put("en_US", "recommend");
        title.put("zh_TW", "推薦");
        language.put("title", title);
        tmAction.put("language", language);
        tmAction.put("type", "ESP");
        tmAction.put("actionResponse", null);
        tmAction.put("serviceName", serviceName);
        tmAction.put("needProxyToken", null);
        tmAction.put("attachActions", null);
        tmAction.put("flatData", null);
        queryActionParameter.put("tmAction", tmAction);
        queryActionParameter.put("useHasNext", true);
        Map<String, Object> pageInfo = new HashMap<>();
        pageInfo.put("hasNext", true);
        pageInfo.put("pageNo", 1);
        pageInfo.put("pageSize", 20);
        queryActionParameter.put("pageInfo", pageInfo);
        queryActionParameter.put("executeContext", executeContext);
        abnormalReportRawData.put("pcUiBotModel", pcUiBotModel);
        abnormalReportRawData.put("queryActionParameter", queryActionParameter);
        abnormalReportRawData.putAll(commonRawDataMap);

        //异常回报按钮生成
        String jumpPageId = PageSettingIdPresetEnum.MOBILE_ATHENA_APC_ABNORMAL_REPORT_DETAIL.toString();
        String jumpPageTitle = LocaleUtil.getMobileTextByKey(locale, "异常回报");
        Integer type = ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue();
        return new Action(dataId, jumpPageId, jumpPageTitle, type, abnormalReportRawData);

    }

    public static Action getProjectAction(ProjectFilterService projectFilterService,
                                          DigiwinAtmcProxyService digiwinAtmcProxyService,
                                          LocaleService localeService,
                                          DigiwinAtmcSearchResult result, String locale, String tenantId,
                                          String iamUserToken) {
        Action action;
        DigiwinAtmcProject project = new DigiwinAtmcProject();
        project.setTmTaskId(result.getTmTaskId());
        String dataId = String.valueOf(result.getId());
        if (projectFilterService.isCenterConsoleProject(project, tenantId)) {
//            DigiwinAtmcCardDetail cardDetail = digiwinAtmcProxyService.getDigiwinAtmcProjectCardDetail(locale,
//                    iamUserToken, tenantId, dataId);
//            DigiwinAtmcSummaryLayout summaryLayout = cardDetail.getSummaryLayout();
//            List<UiBotLayout> layoutList = summaryLayout.getLayout();
//            UiBotPageData pageData = summaryLayout.getPageData();
//            Map<String, Object> bizData = new HashMap<>();
//            for (UiBotLayout layout : layoutList) {
//                if (layout.isTypeOfTable()) {
//                    List<Map<String, Object>> bizDataList = (List<Map<String, Object>>) pageData.get(layout.getSchema());
//                    if (!CollectionUtils.isEmpty(bizDataList)) {
//                        bizData = bizDataList.get(0);
//                    }
//                }
//            }
//            String projectStatus = (String) bizData.get("project_status");
//            if ("30".equalsIgnoreCase(projectStatus) || "50".equalsIgnoreCase(projectStatus)) {
//                Map<String, Object> rawData = new HashMap<>();
//                rawData.put("project_type", cardDetail.getTmTaskId());
//                action = new Action(
//                        dataId, PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CC_PROJECT_DETAIL.toString(),
//                        "", ActionTypeEnum.OPEN_NEW_PAGE.getValue(), rawData);
//            } else {
//                action = Action.getNoSupportAction(localeService, locale, "暂不支持查看该项目详情");
//            }
            action = new Action();
            action.setDataId(String.valueOf(result.getId()));
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            action.setRequestUrl("/mobile/v1/pattern/jump/info?type=search");
        } else if (projectFilterService.isStandardProject(project, tenantId)) {
            action = new Action(dataId,
                    PageSettingIdPresetEnum.MOBILE_ATHENA_STANDARD_PROJECT_DETAIL.toString(),
                    "", ActionTypeEnum.OPEN_NEW_PAGE.getValue(),
                    "");
        } else if (projectFilterService.isSystemCloudHouseKeeper(project, tenantId)) {
            // 修复bug：体系云管家类型项目卡，全局搜索下不可查阅处理，https://athena-devops-zentao.digiwincloud.com.cn/bug-view-160623.html
            action = new Action(dataId,
                    PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_DETAIL.toString(),
                    "", ActionTypeEnum.OPEN_NEW_PAGE.getValue(),
                    "");
        } else {
            action = Action.getNoSupportAction(localeService, locale, "APP不支持查看该项目详情，请前往web端查阅处理");

        }
        action.setRawData(result);
        return action;
    }


    /**
     * 获取任务跳转页面
     *
     * @param pageTaskRelationService
     * @param digiwinAtmcProxyService
     * @param localeService
     * @param customTaskConfigService
     * @param result
     * @param locale
     * @param tenantId
     * @param iamUserToken
     * @return
     */
    public static Action getTaskAction(PageTaskRelationService pageTaskRelationService,
                                       DigiwinAtmcProxyService digiwinAtmcProxyService,
                                       LocaleService localeService,
                                       CustomTaskConfigService customTaskConfigService,
                                       DigiwinAtmcSearchResult result, String locale, String tenantId,
                                       String iamUserToken,
                                       ActivityFilterService activityFilterService, String tenantVersion) {
        Action action = new Action<>();
        List<PageTaskRelation> pageTaskRelationList =
                activityFilterService.listAthenaOfPageTaskRelations(tenantId, tenantVersion);

        if (!StringUtils.hasLength(result.getTmActivityId()) || !StringUtils.hasLength(result.getTmPattern())
                || !StringUtils.hasLength(result.getTmTaskId()) || !StringUtils.hasLength(result.getTmCategory())) {
            //fixme 修改调用的接口
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = digiwinAtmcProxyService.
                    getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, String.valueOf(result.getId()));
            if (digiwinAtmcBacklogDetail.getFinished()) {
                return Action.getNoSupportAction(localeService, locale, "已完成任务，暂不支持点击查看");
            }
        }
        Optional<PageTaskRelation> optPageTaskRelationTaskIdAndActivityId =
                pageTaskRelationList.stream().filter(
                                pageTaskRelation -> pageTaskRelation.matchInTaskIdAndActivityId(
                                        result.getTmTaskId(), result.getTmActivityId()))
                        .findFirst();
        Optional<PageTaskRelation> optPageTaskRelationPattern = pageTaskRelationList.stream().filter(
                        pageTaskRelation -> pageTaskRelation.matchInPatternAndCategory(
                                result.getTmPattern(), result.getTmCategory()))
                .findFirst();
        String jumpPageId = optPageTaskRelationTaskIdAndActivityId.isPresent() ?
                optPageTaskRelationTaskIdAndActivityId.get().getPageId() :
                (optPageTaskRelationPattern.isPresent() ? optPageTaskRelationPattern.get().getPageId() : "");
        if ("uibotManualTask".equals(result.getTmActivityId())) {
            jumpPageId = PageSettingIdPresetEnum.MOBILE_MANUAL_TASK_DETAIL.toString();
        }

        List<CustomTaskConfig> customTaskConfigList = customTaskConfigService.listCustomTaskConfig();
        Optional<CustomTaskConfig> customTaskConfigOptional = customTaskConfigList.stream()
                .filter(customTaskConfig -> result.getTmTaskId().equalsIgnoreCase(customTaskConfig.getTmTaskId())
                        && result.getTmActivityId().equalsIgnoreCase(customTaskConfig.getTmActivityId())).findFirst();
        if (customTaskConfigOptional.isPresent()) {
            CustomTaskConfig customTaskConfig = customTaskConfigOptional.get();
            DigiwinAtmcBacklog digiwinAtmcBacklog = new DigiwinAtmcBacklog();
            digiwinAtmcBacklog.setTmPattern(result.getTmPattern());
            digiwinAtmcBacklog.setTmTaskId(result.getTmTaskId());
            digiwinAtmcBacklog.setTmCategory(result.getTmCategory());
            digiwinAtmcBacklog.setTmActivityId(result.getTmActivityId());
            digiwinAtmcBacklog.setTenantId(tenantId);
            digiwinAtmcBacklog.setBacklogId(result.getId());

            String requestUrl = customTaskConfig.getCustomTaskUrl(locale, iamUserToken, digiwinAtmcBacklog);
            if (StringUtils.hasLength(requestUrl)) {
                action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
                action.setRequestUrl(requestUrl);
            } else {
                action = Action.setJumpPageAction(action, jumpPageId, result);
            }

        } else {
            action = Action.setJumpPageAction(action, jumpPageId, result);
        }
        if (action.getType() == null) {
            action = getNoSupportAction(localeService, locale, "此作业未配置移动端界面，暂不支持查看\n请前往Web端查阅处理");
        }
        action.setRawData(result);
        return action;
    }

    /**
     * 暂不支持项目Action
     *
     * @param locale
     * @return
     */
    public static Action getNoSupportAction(LocaleService localeService, String locale, String toastMsg) {
        Action action = new Action();
        action.setNoSupport(true);
        action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
        action.setToastMsg(localeService.getLanguageValue(locale, toastMsg));
        return action;
    }

    public static Action setJumpPageAction(Action action, String jumpPageId, DigiwinAtmcSearchResult result) {
        if (StringUtils.hasLength(jumpPageId)) {
            action.setDataId(String.valueOf(result.getId()));
            action.setJumpPageId(jumpPageId);
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            Map<String, String> extraParamete = new HashMap<>(2);
            extraParamete.put("tmActivityId", result.getTmActivityId());
            extraParamete.put("tmTaskId", result.getTmTaskId());
            action.setRawData(extraParamete);
        }
        return action;
    }

    /**
     * 简报速递的action
     *
     * @param reportData
     * @return
     */
    public static Action createExpressButton(DigiwinAdtReportData reportData) {
        Action action = new Action();
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_AGILE_DATA_DETAIL_PAGE.toString());
        action.setDataId(reportData.getSnapshotId());
        action.setRawData(reportData);
        action.setJumpPageTitle("");
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        return action;
    }

    /**
     * 表格下钻的action
     *
     * @param column
     * @param executeContext
     * @return
     */
    public static Action createDrilDown(AgileDataTableColumn column, UiBotExecuteContext executeContext) {
        Action action = new Action();
        action.setDataId(column.getSchema());
        action.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/get/drill/data");
        Map<String, Object> rawData = column.parseExecuteContextToRawData(column, executeContext);
        action.setRawData(rawData);
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        return action;
    }

    /**
     * 表格下钻的action
     *
     * @param column
     * @param executeContext
     * @return
     */
    public static Action createDrilDown(UiBotTableColumn column, UiBotExecuteContext executeContext) {
        Action action = new Action();
        action.setDataId(column.getSchema());
        action.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/get/drill/data");
        Map<String, Object> rawData = column.parseExecuteContextToRawData(column, executeContext);
        action.setRawData(rawData);
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        return action;
    }

    public void convert(Action action) {
        if (null == action) {
            return;
        }
        if (null != action.getDataId()) {
            this.dataId = action.getDataId();
        }
        if (null != action.getJumpPageId()) {
            this.jumpPageId = action.getJumpPageId();
        }
        if (null != action.getJumpPageTitle()) {
            this.jumpPageTitle = action.getJumpPageTitle();
        }
        if (null != action.getRequestUrl()) {
            this.requestUrl = action.getRequestUrl();
        }
        if (null != action.getType()) {
            this.type = action.getType();
        }
    }
}