package com.digiwin.mobile.mobileuibot.core.component.action;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <p>功能描述：提交参数预处理结果封装类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ActionPreHandleResult
 * @Author: zaregoto
 * @Date: 2023/1/7 22:02
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ActionPreHandleResult {

    /**
     * 是否找到了匹配的操作
     */
    private Boolean actionFound;

    /**
     * 应用API名称
     */
    private String serviceName;

    /**
     * 扩展参数，用于放一些处理后的对象
     */
    private Object extendParam;

    /**
     * 预处理后需要继续往下执行的操作
     */
    private Action action;

    /**
     * 是否需要在提交成功后阻塞响应
     * FIXME因雅典娜平台任务引擎处理机制的设计问题，导致在PCC应用的任务卡提交后发现并未及时关闭任务卡，app端回首页后仍会展示它，但手动刷新后即消失。
     * 故和平台技术人员（ATMC负责人和SmartData负责人）了解与讨论后，尝试使用延迟来缓解该问题
     */
    private Boolean needBlockResponseAfterSubmitSuccess;

    /**
     * 需要阻塞响应的时间（单位毫秒）
     */
    private Long needBlockResponseMilliseconds;

    /**
     * 是否需要执行标准提交接口
     * 为了兼容之前业务场景，故默认true=需要
     * 因应用一些操作接口不需要调用标准提交接口，故增加属性控制
     */
    private Boolean needExecuteStandardSubmit = true;
}
