package com.digiwin.mobile.mobileuibot.core.component.action;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.image.ImageUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.common.PcmFilterUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.approval.ApprovalActionNameEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Executor;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.*;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascade;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeData;
import com.digiwin.mobile.mobileuibot.core.component.input.choosetaskprogress.ChooseTaskProgress;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.hidden.InputHidden;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.input.sign.InputSign;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.ButtonSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.InputGroupSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.InputSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitchStateEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.EditCard;
import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.EditCardList;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcModuleEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzerFactory;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.BottomWindowInfoTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.mock.v2.MockV2Constants;
import com.digiwin.mobile.mobileuibot.mock.v2.MockV2Model;
import com.digiwin.mobile.mobileuibot.mock.v2.MockV2Service;
import com.digiwin.mobile.mobileuibot.project.common.ProjectConstant;
import com.digiwin.mobile.mobileuibot.project.strategy.custom.ProjectDetailBuildSystemCloudHouseKeeperChooseTemplateStrategy;
import com.digiwin.mobile.mobileuibot.project.strategy.custom.ProjectDetailBuildSystemCloudHouseKeeperEditPlanStrategy;
import com.digiwin.mobile.mobileuibot.project.strategy.custom.ProjectDetailBuildSystemCloudHouseKeeperEditTaskStrategy;
import com.digiwin.mobile.mobileuibot.project.strategy.custom.ProjectDetailBuildSystemCloudHouseKeeperProcessRemarkStrategy;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.aam.model.AttachmentMessage;
import com.digiwin.mobile.mobileuibot.proxy.aam.model.AttachmentResponse;
import com.digiwin.mobile.mobileuibot.proxy.aam.service.DigiwinAamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmRequest;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogSubmitResult;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.MPersonCard;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.service.DigiwhaleProxyServie;
import com.digiwin.mobile.mobileuibot.proxy.dmc.config.DigiwinDmcConfig;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachment;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachmentData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.field.UiBotField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPatternUtil;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkZTBSubmitHandler;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.strategy.custom.UiBotModelBuildApcTeamDispatchStrategy;
import com.digiwin.mobile.mobileuibot.task.strategy.custom.aide.TaskDetailBuildOutSourceWorkReportTaskDetailStrategy;
import com.digiwin.mobile.mobileuibot.task.strategy.custom.experimentaloptimizationdetection.TaskDetailBuildDetectionDataDetailStrategy;
import com.digiwin.mobile.mobileuibot.task.strategy.custom.schedulereport.TaskDetailBuildApcCommonAttachmentUploadStrategy;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.mock.v2.MockV2Constants.MULTI_SPEED_TM_ACTIVITY_ID;

/**
 * <p>功能描述：提交按钮统一Service处理逻辑</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ActionServiceImpl
 * @Author: Zaregoto
 * @Date: 2021/5/25 15:52
 */
@Service("actionService")
public class ActionServiceImpl implements ActionService {

    /**
     * 车辆信息类型--新增
     */
    private static final String DRIVER_CAR_TYPE_ADD = "add";
    /**
     * 车辆信息类型--更新
     */
    private static final String DRIVER_CAR_TYPE_UPDATE = "update";
    /**
     * 车辆信息类型--删除
     */
    private static final String DRIVER_CAR_TYPE_DELETE = "delete";
    private static final String ABI_STATEMENT_RESID = "STATEMENT__resid";
    private static final String ABI_REPORT_NAME = "UIBOT__activityName";
    private static final String SELECT_TAG = "hashCode";
    private static final String PCC_TASK_ACTION_ID = "esp_task.info.update";
    private static final String CLOUD_STEWARD_MANUAL_WORK_REPORTING_ACTION_ID = "esp_bm.pisc.attachment.join.relation.update";


    private static final Logger logger = LoggerFactory.getLogger(ActionServiceImpl.class);

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    @Autowired
    private DigiwinAamProxyService digiwinAamProxyService;

    @Autowired
    private ZhilinkService zhilinkService;

    @Autowired
    private ComponentParamAnalyzerFactory componentParamAnalyzerFactory;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private DigiwinIamProxyService iamProxyService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private ZhilinkZTBSubmitHandler zhilinkZTBSubmitHandler;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private TaskDetailBuildOutSourceWorkReportTaskDetailStrategy taskDetailBuildOutSourceWorkReportTaskDetailStrategy;

    @Autowired
    private TaskDetailBuildDetectionDataDetailStrategy taskDetailBuildDetectionDataDetailStrategy;

    @Autowired
    private UiBotModelBuildApcTeamDispatchStrategy uiBotModelBuildApcTeamDispatchStrategy;

    @Autowired
    private TaskDetailBuildApcCommonAttachmentUploadStrategy taskDetailBuildApcCommonAttachmentUploadStrategy;

    @Autowired
    private ProjectDetailBuildSystemCloudHouseKeeperChooseTemplateStrategy projectDetailBuildSystemCloudHouseKeeperChooseTemplateStrategy;

    @Autowired
    private ProjectDetailBuildSystemCloudHouseKeeperEditTaskStrategy projectDetailBuildSystemCloudHouseKeeperEditTaskStrategy;

    @Autowired
    private ProjectDetailBuildSystemCloudHouseKeeperEditPlanStrategy projectDetailBuildSystemCloudHouseKeeperEditPlanStrategy;

    @Autowired
    private ProjectDetailBuildSystemCloudHouseKeeperProcessRemarkStrategy projectDetailBuildSystemCloudHouseKeeperProcessRemarkStrategy;

    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Autowired
    private DigiwhaleProxyServie digiwhaleProxyServie;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Autowired
    private MockV2Service mockV2Service;

    @Resource(name = "defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Override
    public ActionSubmitResult submit(ApiRequestSubmit apiRequestSubmit) {
        //进度回报:mockV2数据
        if (!ObjectUtils.isEmpty(apiRequestSubmit.getRawData()) && !ObjectUtils.isEmpty(apiRequestSubmit.getRawData().get("action"))) {
            Map action = JsonUtil.objectToJavaObject(apiRequestSubmit.getRawData().get("action"), Map.class);
            if (!ObjectUtils.isEmpty(action.get("executeContext"))) {
                Map executeContext = JsonUtil.objectToJavaObject(action.get("executeContext"), Map.class);
                String tmActivityId = String.valueOf(executeContext.get("tmActivityId"));
//                if (tmActivityId.contains(SINGLE_SPEED_TM_ACTIVITY_ID) || tmActivityId.contains(MULTI_SPEED_TM_ACTIVITY_ID)) {
                if (tmActivityId.contains(MULTI_SPEED_TM_ACTIVITY_ID)) {
                    MockV2Model mockV2Model = mockV2Service.getMockV2Model(MockV2Constants.SUBMIT);
                    if (!ObjectUtils.isEmpty(mockV2Model)) {
                        return mockV2Model.getSubmitData().get(MockV2Constants.SUBMIT);
                    }
                }
            }
        }
        //判断是正常签核还是特定的行事历进度回报定制页
        boolean isCalendarReport = false;
        boolean isDriverCarSave = false;
        boolean isElectronicFenceSave = false;
        boolean isDoublePattern = false;

        ApiRawData apiRawData = apiRequestSubmit.getRawData();
        String driverCarType = (String) apiRawData.get("driverCarType");
        String electronicFenceType = (String) apiRawData.get("electronicFenceType");
        /**
         * 是否转派标识
         */
        boolean isReassign = apiRawData.get("isReassign") == null ? false : (boolean) apiRawData.get("isReassign");
        /**
         * 是否分享标识
         */
        boolean isSharing = apiRawData.get("isSharing") == null ? false : (boolean) apiRawData.get("isSharing");
        /**
         * abi报表常用条件保存标识
         */
        boolean isAbi = apiRawData.get("isAbi") == null ? false : (boolean) apiRawData.get("isAbi");
        if (StringUtils.hasLength(driverCarType)) {
            isDriverCarSave = true;
        }
        if (StringUtils.hasLength(electronicFenceType)) {
            isElectronicFenceSave = true;
        }
        Map<String, Object> param = new HashMap<>(2);
        if (apiRawData.get("actions") != null) {
            if (apiRawData.get("actions") instanceof List) {
                List<Map<String, Object>> actions = (List<Map<String, Object>>) apiRawData.get("actions");
                for (Map<String, Object> action : actions) {
                    if ("SUBMIT".equals(action.get("trackCode"))) {
                        if ("MANUAL_TASK".equals(action.get("type")) || "manual-task-submit".equals(action.get("actionType"))) {
                            param.put("action", action);
                            isCalendarReport = true;
                            break;
                        }
                    }
                }
            }
        }
        if (apiRequestSubmit.getSubmitParams() != null) {
            for (ActionSubmitParam submitParam : apiRequestSubmit.getSubmitParams()) {
                if (CustomGroup.COMPONENT_TYPE.equalsIgnoreCase(submitParam.getType())) {
                    isDoublePattern = true;
                    break;
                }
            }
        }
        if (isCalendarReport) {
            //行事历提交
            return this.calendarReportSubmit(apiRequestSubmit, apiRawData, param);
        } else if (isDriverCarSave) {
            //在途宝的车辆信息提交（新增、保存、删除）
            return this.driverCarSaveSubmit(apiRequestSubmit, driverCarType);
        } else if (isElectronicFenceSave) {
            //在途宝的车辆信息提交（新增、保存、删除）
            return this.electronicFenceSaveSubmit(apiRequestSubmit);
        } else if (isReassign) {
            //转派记录的提交
            return this.reassignSubmit(apiRequestSubmit);
        } else if (isSharing) {
            //分享给他人的提交
            return this.sharingSubmit(apiRequestSubmit);
        } else if (isDoublePattern) {
            //标准多层布局提交
            return this.doubelPatternSubmit(apiRequestSubmit);
        } else if (isAbi) {
            //abi报表常用条件提交
            return this.abiSubmit(apiRequestSubmit);
        } else {
            JSONObject rawData = apiRequestSubmit.getRawData();
            JSONObject rawDataAction = rawData.getJSONObject("action");
            //定制提交
            String pageId = rawData.getString("pageId");
            //APC的支援请求提交
            if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_SUPPORT_NEEDS.toString().equals(pageId)) {
                List<Map<String, Object>> datas = (List<Map<String, Object>>) apiRawData.get("data");
                datas = detailSupport(datas, apiRequestSubmit.getSubmitParams());
                Map<String, Object> params = new HashMap<>(1);
                params.put("wo_op_request_support_demand_info", datas);
                apiRequestSubmit.getRawData().put("data", params);
                return ActionSubmitResult.pcUiBotSubmit(apiRequestSubmit, digiwinAtmcProxyService);
            } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_SUPPORT_BOTTOM.toString().equals(pageId)) {
                Map<String, Object> reportData = (Map<String, Object>) apiRawData.get("data");
                List<Map<String, Object>> datas = (List<Map<String, Object>>) reportData.get("wo_op_report_data");
                datas = detailSupportBottom(datas, apiRequestSubmit.getSubmitParams());
                apiRequestSubmit.getRawData().put("data", reportData);
                return ActionSubmitResult.pcUiBotSubmit(apiRequestSubmit, digiwinAtmcProxyService);
            } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_SUPPORT_HOUR_REPORT_LIST.toString().equals(pageId)) {
                List<Map<String, Object>> datas = (List<Map<String, Object>>) rawData.get("data");
                Map<String, Object> data = new HashMap<>(1);
                data.put("wo_op_report_data", datas);
                rawData.put("data", data);
                return ActionSubmitResult.pcUiBotSubmit(apiRequestSubmit, digiwinAtmcProxyService);
            } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_APPROVAL_REASSIGN_BOTTOM.toString().equals(pageId)) {
                List<Map<String, Object>> datas = (List<Map<String, Object>>) rawData.get("datas");
                String dataKey = rawData.getString("dataKey");
                for (Map<String, Object> oldData : datas) {
                    if (oldData.get("__DATA_KEY").equals(dataKey)) {
                        detailApcApprovalReassign(oldData, apiRequestSubmit.getSubmitParams(), dataKey);
                    }
                }
                Map<String, Object> data = new HashMap<>(1);
                data.put("wo_op_report_data", datas);
                rawData.put("data", data);
                return ActionSubmitResult.pcUiBotSubmit(apiRequestSubmit, digiwinAtmcProxyService);
            } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_ABNORMAL_CLOSURE_RETURN_BOTTOM.toString().equalsIgnoreCase(pageId)) {
                Map<String, Object> data = (Map<String, Object>) rawData.get("data");
                detailApcApprovalReassign(data, apiRequestSubmit.getSubmitParams(), "");
                data.put("report_date", DateTimeUtil.getTodayTimeUseDefaultPattern());
                data.put("process_case", "1");
                List<Map<String, Object>> datas = new ArrayList<>(1);
                datas.add(data);
                List<Map<String, Object>> returnDatas = digiwinEspProxyService.returnWoOpReportAbnormalInfoClosecase(
                        apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(),
                        apiRequestSubmit.getLocale(), datas);
                Map<String, Object> oneceData = (Map<String, Object>) rawData.get("oneData");
                Map<String, Object> actullyData = new HashMap<>(1);
                if (!CollectionUtils.isEmpty(returnDatas)) {
                    Map<String, Object> returnData = returnDatas.get(0);
                    actullyData.put("report_date", returnData.get("report_date"));
                    actullyData.put("process_case", "1");
                    actullyData.put("eoc_company_id", returnData.get("eoc_company_id"));
                    actullyData.put("eoc_site_id", returnData.get("eoc_site_id"));
                    actullyData.put("wo_no", returnData.get("wo_no"));
                    actullyData.put("plot_no", returnData.get("plot_no"));
                    actullyData.put("op_seq", returnData.get("op_seq"));
                    actullyData.put("op_no", oneceData.get("op_no"));
                    actullyData.put("reporter_no", oneceData.get("reporter_no"));
                    actullyData.put("reporter_name", oneceData.get("reporter_name"));
                    actullyData.put("abnormal_reason_no", returnData.get("abnormal_reason_no"));
                    actullyData.put("abnormal_reason_name", returnData.get("abnormal_reason_name"));
                    actullyData.put("abnormal_reason_description", returnData.get("abnormal_reason_description"));
                }
                List<Map<String, Object>> returnData = new ArrayList<>(1);
                returnData.add(actullyData);
                Map<String, Object> reportAbnormal = new HashMap<>(1);
                reportAbnormal.put("wo_op_report_abnormal", returnData);
                rawData.put("data", reportAbnormal);
                return pcUiBotSubmit(apiRequestSubmit);

            } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_ABNORMAL_CLOSURE_PROGRESS_BOTTOM.toString().equalsIgnoreCase(pageId)) {
                Map<String, Object> data = (Map<String, Object>) rawData.get("data");
                detailApcApprovalReassign(data, apiRequestSubmit.getSubmitParams(), "");
                data.put("report_date", DateTimeUtil.getTodayTimeUseDefaultPattern());
                data.put("process_case", "2");
                List<Map<String, Object>> datas = new ArrayList<>(1);
                datas.add(data);
                Boolean submit = digiwinEspProxyService.processWoOpReportAbnormalInfoClosecase(
                        apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(),
                        apiRequestSubmit.getLocale(), datas);
                if (submit) {
                    return pcUiBotSubmit(apiRequestSubmit);
                } else {
                    return ActionSubmitResult.create(false,
                            localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交失败"));
                }

            } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_HANDEL_BOTTOM.toString().equalsIgnoreCase(pageId)) {
                List<Map<String, Object>> datas = (List<Map<String, Object>>) rawData.get("datas");
                String dataKey = rawData.getString("dataKey");
                for (Map<String, Object> oldData : datas) {
                    if (oldData.get("__DATA_KEY").equals(dataKey)) {
                        detailApcApprovalReassign(oldData, apiRequestSubmit.getSubmitParams(), dataKey);
                    }
                }
                Map<String, Object> data = new HashMap<>(1);
                if (rawData.getBooleanValue("isReply")) {
                    Map<String, Object> bodys = new HashMap<>(2);
                    data.put("wo_op_report_abnormal", datas);
                    bodys.put("parameter", data);
                    bodys.put("actionId", rawData.get("actionId"));
                    return ActionSubmitResult.create(digiwinAtdmProxyService.submitDataQueryByActionId(apiRequestSubmit.getLocale(), apiRequestSubmit.getIamUserToken(), JsonUtil.javaObjectToJsonString(bodys), apiRequestSubmit.getTenantId()), localeService.getLanguageValue(apiRequestSubmit.getLocale(), "回复成功"));
                } else {
                    data.put("wo_op_report_data", datas);
                    rawData.put("data", data);
                }
                return ActionSubmitResult.pcUiBotSubmit(apiRequestSubmit, digiwinAtmcProxyService);
            } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_DEAL_DETAIL.toString().equalsIgnoreCase(pageId)) {
                //制令上线（工单上线）
                Map<String, Object> pcData = new HashMap<>(1);
                Map<String, Object> data = (Map<String, Object>) rawData.get("data");
                detailApcApprovalReassign(data, apiRequestSubmit.getSubmitParams(), "");

                // 兜底下，eoc_company_id，eoc_site_id使用的是team_name单选开窗的数据，可能会存在没值的情况
                String eocCompanyId = (String) MapUtil.getOrDefault(data, "eoc_company_id", "");
                String eocSiteId = (String) MapUtil.getOrDefault(data, "eoc_site_id", "");
                Map<String, Object> businessUnit = (Map<String, Object>) MapUtil.getOrDefault(data, "businessUnit", Collections.emptyMap());
                if (!StringUtils.hasLength(eocCompanyId)) {
                    data.put("eoc_company_id", businessUnit.get("eoc_company_id"));
                }
                if (!StringUtils.hasLength(eocSiteId)) {
                    data.put("eoc_site_id", businessUnit.get("eoc_site_id"));
                }

                List<Map<String, Object>> datas = new ArrayList<>(1);
                datas.add(data);
                pcData.put("wo_op_dispatch_data", datas);
                rawData.put("data", pcData);
                return ActionSubmitResult.pcUiBotSubmit(apiRequestSubmit, digiwinAtmcProxyService);
//                Boolean flag = digiwinEspProxyService.woOpDispatchDataProcess(apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId()
//                        , apiRequestSubmit.getLocale(), datas);
//                if (flag) {
//                    pcData.put("wo_op_dispatch_data", datas);
//                    rawData.put("data", pcData);
//                    return ActionSubmitResult.pcUiBotSubmit(apiRequestSubmit, digiwinAtmcProxyService);
//                } else {
//                    return returnSubmit(false, apiRequestSubmit.getLocale());
//                }
            } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_TASK_DETAIL.toString().equalsIgnoreCase(pageId)) {
                //委外报工报工明细
                return taskDetailBuildOutSourceWorkReportTaskDetailStrategy.submit(apiRequestSubmit);
            } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_INSPECTION_RESULTS_REGISTRATION_SUB_ITEM_CUSTOMIZE_DETAIL.toString().equalsIgnoreCase(pageId)) {
                //试验优测-试验结果录入
                return taskDetailBuildDetectionDataDetailStrategy.submit(apiRequestSubmit);
            } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_COMMON_ATTACHMENT_UPLOAD_PAGE.toString().equalsIgnoreCase(apiRequestSubmit.getPageId())) {
                // 进度回报，工时回报-上传附件页面
                return taskDetailBuildApcCommonAttachmentUploadStrategy.submit(apiRequestSubmit);
            } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_PLAN_CHOOSE_TEMPLATE.toString().equalsIgnoreCase(apiRequestSubmit.getPageId())) {
                // 体系云-未启动项目页面-选择模板
                return projectDetailBuildSystemCloudHouseKeeperChooseTemplateStrategy.submit(apiRequestSubmit);
            } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_TASK.toString().equalsIgnoreCase(rawData.getString("pageId"))) {
                // 体系云-未启动项目页面-编辑任务
                return projectDetailBuildSystemCloudHouseKeeperEditTaskStrategy.submit(apiRequestSubmit);
            } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_PLAN_DETAIL.toString().equalsIgnoreCase(rawData.getString("pageId"))) {
                // 体系云-未启动项目页面-启动项目
                return projectDetailBuildSystemCloudHouseKeeperEditPlanStrategy.submit(apiRequestSubmit);
            } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROCESS_REMARK.toString().equalsIgnoreCase(apiRequestSubmit.getPageId())) {
                // 体系云-未启动项目页面-过程备忘录
                return projectDetailBuildSystemCloudHouseKeeperProcessRemarkStrategy.submit(apiRequestSubmit);
            } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_CANCEL_DETAIL.toString().equalsIgnoreCase(pageId)) {
                return ActionSubmitResult.pcUiBotSubmit(apiRequestSubmit, digiwinAtmcProxyService);
            } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_TRANSFER_QUANTITY_SFT_DETAILS.toString().equalsIgnoreCase(pageId)) {
                // 进度回报-数量转移按钮提交 sft
                return this.transferQuantitySubmit(apiRequestSubmit);
            } else {
                String actionCategory = rawDataAction != null ? rawDataAction.getString("category") : "";
                String actionId = rawDataAction != null ? rawDataAction.getString("actionId") : "";
                String bizId = (String) rawData.get("biz_id");
                String executeCtxTmActivityId = Optional.ofNullable(rawDataAction)
                        .map(r -> r.getJSONObject("executeContext"))
                        .map(r -> r.getString("tmActivityId")).orElse("");
                if (StringUtils.hasLength(bizId)) {
                    if ("ZTB".equalsIgnoreCase(bizId)) {
                        //在途宝提交
                        return zhilinkZTBSubmitHandler.submit(apiRequestSubmit);
                    } else if ("TBDS".equalsIgnoreCase(bizId)) {
                        return tbdsSubmitHandler(apiRequestSubmit);
                    } else {
                        return new ActionSubmitResult();
                    }
                } else if ("EXCLUDED_RETURN_SUBMIT".equalsIgnoreCase(actionCategory)) {
                    // 项目发起-除外回报
                    return this.excludedReturnSubmit(apiRequestSubmit);
                } else if (ProjectConstant.INTELLIGENT_MATERIAL_INSPECTION_TM_ACTIVITY_ID.equals(executeCtxTmActivityId)) {
                    // 项目发起-智慧检料
                    return this.intelligentMaterialInspectionSubmit(apiRequestSubmit);
                } else {
                    //体系云管家-手动报工
                    if (CLOUD_STEWARD_MANUAL_WORK_REPORTING_ACTION_ID.equalsIgnoreCase(actionId)) {
                        JSONObject data = rawData.getJSONObject("data");
                        List<Map<String, Object>> mapList = (List<Map<String, Object>>) data.get("task_info");
                        //定制开发说：不加会报错，必须加上此字段提交
                        mapList.forEach(a -> a.put("new_now_date", DateUtil.formatDateTime(new Date())));
                        data.put("task_info", mapList);
                    }
                    this.removeExtendedFieldsFromApiRequestSubmit(apiRequestSubmit);

                    ActionPreHandleResult preHandleResult = this.addParasToApiRequestSubmit(apiRequestSubmit);

                    handleWeChatApproval(preHandleResult);

                    if (Boolean.TRUE.equals(preHandleResult.getActionFound())) {
                        // 可提交的情况
                        return this.standardSubmitHandle(apiRequestSubmit, preHandleResult);
                    } else {
                        // 不可提交的情况
                        if (preHandleResult.getAction() != null) {
                            return ActionSubmitResult.create(true, preHandleResult.getAction());
                        } else {
                            return ActionSubmitResult.create(false,
                                    LocaleUtil.getMobileTextByKey(apiRequestSubmit.getLocale(), "数据预处理异常") + ","
                                            + LocaleUtil.getMobileTextByKey(apiRequestSubmit.getLocale(), "提交中止"));
                        }
                    }
                }
            }
        }
    }

    /**
     * 第三方 h5 web页面：微信签核提交 type处理
     *
     * @param preHandleResult
     * @author yanfeng
     */
    private static void handleWeChatApproval(ActionPreHandleResult preHandleResult) {
        if (StringUtil.isNotEmpty(AppRequestContext.getContextEntity().getSourceType())) {
            String pageId1 = AppRequestContext.getContextEntity().getPageId();
            if (PageSettingIdPresetEnum.MOBILE_MY_BIZ_APPROVAL_TASK_DETAIL.toString().equalsIgnoreCase(pageId1)) {
                //pageId相同：修改type：401 -> 400
                preHandleResult.getAction().setType(ActionTypeEnum.REFRESH.getValue());
                logger.error("pageId相同:{}", preHandleResult.getAction().getType());
            } else {
                //pageId不相同：修改type：401
                preHandleResult.getAction().setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
                logger.error("pageId不相同:{}", preHandleResult.getAction().getType());
            }

        }
    }

    /**
     * 标准提交处理
     *
     * @param apiRequestSubmit
     * @param preHandleResult
     * @return
     */
    private ActionSubmitResult standardSubmitHandle(ApiRequestSubmit apiRequestSubmit, ActionPreHandleResult preHandleResult) {
        // 使用isFalse方法为了兼容之前提交场景，防止参数值为null
        if (BooleanUtils.isFalse(preHandleResult.getNeedExecuteStandardSubmit())) {
            // 不需要执行标准提交接口
            if (preHandleResult.getAction() != null) {
                return ActionSubmitResult.create(true, preHandleResult.getAction());
            }
            String promptMessage =
                    LocaleUtil.getMobileTextByKey(apiRequestSubmit.getLocale(), "提交成功");
            return ActionSubmitResult.create(true, promptMessage);
        }
        // 可提交的情况
        DigiwinAtmcBacklogSubmitResult atmcSubmitResult =
                this.digiwinAtmcProxyService.actionSubmit(apiRequestSubmit.getLocale(),
                        apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), apiRequestSubmit.getRawData());
        // FIXME 临时解法，待平台任务引擎机制更新后，即可去除以下设置阻塞的逻辑
        if (Boolean.TRUE.equals(preHandleResult.getNeedBlockResponseAfterSubmitSuccess())) {
            try {
                Thread.sleep(preHandleResult.getNeedBlockResponseMilliseconds());
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (null != atmcSubmitResult.getRequestData()) {
            if (preHandleResult.getAction() != null) {
                // 主要使用在进度回报 数据列表为1，提交进度100，且提交成功 使用
                // 异常回报需要返回异常单号 add by wuyang 20230403
                return ActionSubmitResult.create(true, preHandleResult.getAction());
            }
            String promptMessage =
                    LocaleUtil.getMobileTextByKey(apiRequestSubmit.getLocale(), "提交成功");
            return ActionSubmitResult.create(true, promptMessage);
        }
        return ActionSubmitResult.create(false, atmcSubmitResult.getErrorMessage());
    }

    /**
     * 试验北斗提交
     *
     * @param apiRequestSubmit
     * @return
     */
    private ActionSubmitResult tbdsSubmitHandler(ApiRequestSubmit apiRequestSubmit) {
        JSONObject rawData = apiRequestSubmit.getRawData();
        //定制提交
        String pageId = rawData.getString("pageId");
        List<Map<String, Object>> datas = new ArrayList<>(1);
        String reportNo = (String) rawData.get("report_no");
        //修改物料&修改参数
        if (PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_MODIFY_MATERIAL.toString().equalsIgnoreCase(pageId)) {
            Map<String, Object> data = (Map<String, Object>) rawData.get("data");
            List<Map<String, Object>> trialOpReportItemParameters = (List<Map<String, Object>>) data.get("trial_op_report_item_parameter");
            if (CollectionUtils.isEmpty(trialOpReportItemParameters)) {
                for (ActionSubmitParam param : apiRequestSubmit.getSubmitParams()) {
                    if (InputSingleText.COMPONENT_TYPE.equals(param.getType())) {
                        if (data.containsKey(param.getSchema())) {
                            InputSingleText text = (InputSingleText) param.getParams();
                            data.put(param.getSchema(), text.getText());
                        }
                    } else if (InputNumeric.COMPONENT_TYPE.equals(param.getType())) {
                        InputNumeric inputNumeric = (InputNumeric) param.getParams();
                        data.put(param.getSchema(), inputNumeric.getText());
                    } else if (InputMultiText.COMPONENT_TYPE.equals(param.getType())) {
                        InputMultiText inputNumeric = (InputMultiText) param.getParams();
                        data.put(param.getSchema(), inputNumeric.getText());
                    } else if (InputWindowSingleSelect.COMPONENT_TYPE.equals(param.getType())) {
                        InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect) param.getParams();
                        if (!CollectionUtils.isEmpty(inputWindowSingleSelect.getDetail())) {
                            data.putAll(inputWindowSingleSelect.getDetail());
                        } else {
                            data.put(param.getSchema(), inputWindowSingleSelect.getSelectId());
                            if ("unit_name".equals(param.getSchema())) {
                                // 物料编辑页面，单位不重新选择，名称显示为编号修复
                                data.put("unit_no", inputWindowSingleSelect.getSelectId());
                                data.put("unit_name", inputWindowSingleSelect.getTitle());
                            }
                        }
                    }
                }
            } else {
                for (Map<String, Object> parameter : trialOpReportItemParameters) {
                    for (ActionSubmitParam param : apiRequestSubmit.getSubmitParams()) {
                        if (InputSingleText.COMPONENT_TYPE.equals(param.getType())) {
                            if (param.getSchema().equals(parameter.get("parameter_no"))) {
                                InputSingleText text = (InputSingleText) param.getParams();
                                parameter.put("parameter_value", text.getText());
                                break;
                            } else {
                                if (data.containsKey(param.getSchema())) {
                                    InputSingleText text = (InputSingleText) param.getParams();
                                    data.put(param.getSchema(), text.getText());
                                }
                            }
                        } else if (InputNumeric.COMPONENT_TYPE.equals(param.getType())) {
                            InputNumeric inputNumeric = (InputNumeric) param.getParams();
                            data.put(param.getSchema(), inputNumeric.getText());
                        } else if (InputMultiText.COMPONENT_TYPE.equals(param.getType())) {
                            InputMultiText inputNumeric = (InputMultiText) param.getParams();
                            data.put(param.getSchema(), inputNumeric.getText());
                        } else if (InputWindowSingleSelect.COMPONENT_TYPE.equals(param.getType())) {
                            InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect) param.getParams();
                            if (!CollectionUtils.isEmpty(inputWindowSingleSelect.getDetail())) {
                                data.putAll(inputWindowSingleSelect.getDetail());
                            } else {
                                data.put(param.getSchema(), inputWindowSingleSelect.getSelectId());
                                if ("unit_name".equals(param.getSchema())) {
                                    // 物料编辑页面，单位不重新选择，名称显示为编号修复
                                    data.put("unit_no", inputWindowSingleSelect.getSelectId());
                                    data.put("unit_name", inputWindowSingleSelect.getTitle());
                                }
                            }
                        }
                    }
                }
            }

            Map<String, Object> noRawData = new HashMap<>();
            List<Map<String, Object>> trialOpReportItemList = (List<Map<String, Object>>) rawData.get("trial_op_report_item_list");
            if (rawData.get("nodeNo") != null && rawData.get("rawDataList") != null && !CollectionUtils.isEmpty((Collection<?>) rawData.get("rawDataList"))) {
                if (rawData.get("breadRecipt") != null && !(Boolean) rawData.get("breadRecipt")) {

                } else {
                    noRawData = ((List<Map<String, Object>>) rawData.get("rawDataList")).
                            get((Integer) rawData.get("nodeNo"));
                    trialOpReportItemList = (List<Map<String, Object>>)
                            noRawData.get("trial_op_report_item_list" + "_" + rawData.get("nodeNo"));
                }
            }
            List<Map<String, Object>> newTrialOpReportItemList = new ArrayList<>(trialOpReportItemList.size());
            for (Map<String, Object> item : trialOpReportItemList) {
                if (item.get("item_no").equals(data.get("item_no"))) {
                    //是否重新计算总用量 Y.是N.否 默认N.否
                    data.put("is_anew_calculate_total_qty", "N");
                    newTrialOpReportItemList.add(data);
                } else {
//                    //是否重新计算总用量 Y.是N.否 默认N.否
//                    data.put("is_anew_calculate_total_qty", "N");
                    newTrialOpReportItemList.add(item);
                }
            }
            if (!CollectionUtils.isEmpty(noRawData)) {
//                noRawData.remove("parameter_data");
                noRawData.put("trial_op_report_item_list", newTrialOpReportItemList);
                noRawData.put("isSubmit", true);
                noRawData.put("report_no", reportNo);
                datas.add(noRawData);
            } else {
//                rawData.remove("parameter_data");
                rawData.put("trial_op_report_item_list", newTrialOpReportItemList);
                rawData.put("isSubmit", true);
                rawData.put("report_no", reportNo);
                datas.add(rawData);
            }
        } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_MODIFY_PARAM.toString().equalsIgnoreCase(pageId)) {
            List<Map<String, Object>> parameterDatas = (List<Map<String, Object>>) rawData.get("data");
            for (Map<String, Object> data : parameterDatas) {
                for (ActionSubmitParam param : apiRequestSubmit.getSubmitParams()) {
                    if (InputSingleText.COMPONENT_TYPE.equals(param.getType())) {
                        if (param.getSchema().equals(data.get("parameter_no"))) {
                            InputSingleText text = (InputSingleText) param.getParams();
                            data.put("parameter_value", text.getText());
                            break;
                        }
                    }
                }

            }
            Map<String, Object> noRawData = new HashMap<>();
            if (rawData.get("nodeNo") != null && rawData.get("rawDataList") != null) {

                noRawData = ((List<Map<String, Object>>) rawData.get("rawDataList")).
                        get((Integer) rawData.get("nodeNo"));
                noRawData.remove("trial_op_report_item_list");
                noRawData.put("parameter_data", parameterDatas);
                noRawData.put("isSubmit", true);
                noRawData.put("report_no", reportNo);
                datas.add(noRawData);
            } else {
                rawData.remove("trial_op_report_item_list");
                rawData.put("parameter_data", parameterDatas);
                rawData.put("isSubmit", true);
                rawData.put("report_no", reportNo);
                datas.add(rawData);
            }
        } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_RESULT_CONFIRMATION.toString().equals(pageId)) {
            Map<String, Object> data = (Map<String, Object>) rawData.get("data");
            detailApcApprovalReassign(data, apiRequestSubmit.getSubmitParams(), "");
            if (data.get("document_info") != null && !CollectionUtils.isEmpty((Collection<?>) data.get("document_info"))) {
                buildTbdsDocumentInfo(data, (List<Map<String, Object>>) data.get("document_info"));
            }
            data.put("op_status", "30");
//            datas.add(data);
            Map<String, Object> submitRawData = new HashMap<>(2);
            submitRawData.put("action", rawData.get("action"));
            Map<String, Object> opData = new HashMap<>(1);
            opData.put("op_data", data);
            submitRawData.put("data", opData);
            apiRequestSubmit.setRawData(JsonUtil.objectToJavaObject(submitRawData, ApiRawData.class));

            Action action = new Action();
            action.setSuccessMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            action.setType(ActionTypeEnum.BACK_TWO_WITH_REFRESH.getValue());
            return progressSubmit(apiRequestSubmit, action);
        } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_REPORT_SUBMIT.toString().equals(pageId)) {
            Map<String, Object> data = (Map<String, Object>) rawData.get("data");
            detailTbdsSubmit(data, apiRequestSubmit.getSubmitParams(), pageId, apiRequestSubmit.getUserId());
            data.put("op_status", "30");

            // 获取执行人名称
            if (!StringUtils.hasLength((String) MapUtil.getOrDefault(data, "executor_name", ""))) {
                MPersonCard personCard = digiwhaleProxyServie.getPersonByUserId("userId=" + apiRequestSubmit.getUserId());
                if (!Objects.isNull(personCard)) {
                    data.put("executor_no", apiRequestSubmit.getUserId());
                    data.put("executor_name", personCard.getpName());
                }
            }

            Map<String, Object> submitRawData = new HashMap<>(2);
            submitRawData.put("action", rawData.get("action"));
            Map<String, Object> opData = new HashMap<>(1);
            opData.put("op_data", data);
            submitRawData.put("data", opData);
            apiRequestSubmit.setRawData(JsonUtil.objectToJavaObject(submitRawData, ApiRawData.class));

            Action action = new Action();
            action.setSuccessMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            action.setType(BooleanUtils.isTrue(MapUtils.getBoolean(rawData, "isNeedHandleNextProcess"))
                    ? ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue() : ActionTypeEnum.BACK_TWO_WITH_REFRESH.getValue());
            return progressSubmit(apiRequestSubmit, action);
        } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_REJECT_SUBMIT.toString().equals(pageId)) {
            Map<String, Object> data = new HashMap<>();
            for (ActionSubmitParam actionSubmitParam : apiRequestSubmit.getSubmitParams()) {
                String schema = actionSubmitParam.getSchema();
                String type = actionSubmitParam.getType();
                if (InputWindowSingleSelect.COMPONENT_TYPE.equals(type)) {
                    InputWindowSingleSelect select = (InputWindowSingleSelect) actionSubmitParam.getParams();
                    String selectOpSeq = select.getSelectId();
                    List<Map<String, Object>> mobileOpDataList = (List<Map<String, Object>>) rawData.get("mobileOpDatas");
                    Map<String, Object> mobileOpDataByOpSeq = mobileOpDataList.stream().filter(e -> selectOpSeq.equals(e.get("op_seq"))).findFirst().get();
                    data.put("project_no", mobileOpDataByOpSeq.get("project_no"));
                    data.put("eoc_company_id", mobileOpDataByOpSeq.get("eoc_company_id"));
                    data.put("eoc_site_id", mobileOpDataByOpSeq.get("eoc_site_id"));
                    data.put("trial_wo_no", mobileOpDataByOpSeq.get("trial_wo_no"));
                    data.put("sub_project_no", mobileOpDataByOpSeq.get("sub_project_no"));
                    data.put("op_seq", mobileOpDataByOpSeq.get("op_seq"));
                    data.put("op_no", mobileOpDataByOpSeq.get("op_no"));
                    data.put("op_name", mobileOpDataByOpSeq.get("op_name"));
                    data.put("plan_start_date", mobileOpDataByOpSeq.get("plan_start_date"));
                    data.put("plan_end_date", mobileOpDataByOpSeq.get("plan_end_date"));
                    data.put("operator_data", mobileOpDataByOpSeq.get("operator_data"));
                    data.put("reject_to_sort_index", mobileOpDataByOpSeq.get("sort_index"));

                    data.put("rework_times", Objects.isNull(mobileOpDataByOpSeq.get("rework_times"))
                            ? 1 : MapUtils.getIntValue(mobileOpDataByOpSeq, "rework_times") + 1);

                    //reject_to_op_seq
                    data.put(schema, selectOpSeq);
                }
                if (InputWindowMultiSelect.COMPONENT_TYPE.equals(type)) {
                    InputWindowMultiSelect multiSelect = (InputWindowMultiSelect) actionSubmitParam.getParams();
                    // 驳回用的参数
                    data.put("reject_to_operator_no", multiSelect.getSelectIdList());
                }
                if (InputMultiText.COMPONENT_TYPE.equals(type)) {
                    InputMultiText inputNumeric = (InputMultiText) actionSubmitParam.getParams();
                    //reject_desc
                    data.put(schema, inputNumeric.getText());
                }
            }

            //下面参数为当前点击驳回按钮对应的工艺，而不是选择框指定驳回的工艺
            Map<String, Object> currentOpData = (Map<String, Object>) rawData.get("data");
            data.put("reject_from_op_seq", currentOpData.get("op_seq"));
            data.put("reject_from_sort_index", currentOpData.get("sort_index"));
            data.put("activity__backLog__data", currentOpData.get("activity__backLog__data"));
            data.put("activity__data__status", currentOpData.get("activity__data__status"));

            Map<String, Object> submitRawData = new HashMap<>(2);
            submitRawData.put("action", rawData.get("action"));
            Map<String, Object> opData = new HashMap<>(1);
            opData.put("op_data", data);
            submitRawData.put("data", opData);
            apiRequestSubmit.setRawData(JsonUtil.objectToJavaObject(submitRawData, ApiRawData.class));

            Action action = new Action();
            action.setSuccessMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            return progressSubmit(apiRequestSubmit, action);
        }
        List<Map<String, Object>> opDatas = digiwinEspProxyService.createTbdsTrialProductionReport(apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId()
                , apiRequestSubmit.getLocale(), datas);
        if (!CollectionUtils.isEmpty(opDatas)) {
            Map<String, Object> opData = opDatas.get(0);
            rawData.putAll(opData);
            rawData.remove("data");
            rawData.remove("biz_id");
            rawData.remove("pageId");
            rawData.put("isSubmit", true);
        }
        Action action = new Action();
        action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
        action.setOnlyUseNowRawData(true);
        action.setRawData(rawData);
        action.setSuccessMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "保存成功"));
        return ActionSubmitResult.create(action);
    }

    private void detailTbdsSubmit(Map<String, Object> data, List<ActionSubmitParam> submitParams, String pageId, String userId) {
        List<Map<String, Object>> attachmentDataList = new ArrayList<>();
        for (ActionSubmitParam param : submitParams) {
            String schema = param.getSchema();
            String type = param.getType();
            if (InputWindowSingleSelect.COMPONENT_TYPE.equals(type)) {
                InputWindowSingleSelect select = (InputWindowSingleSelect) param.getParams();

                String unitName = "";
                if (!CollectionUtils.isEmpty(select.getDetail())) {
                    unitName = MapUtils.getString(select.getDetail(), "unit_name");
                }
                if ("qualified_product_unit_no".equalsIgnoreCase(schema)) {
                    data.put("qualified_product_unit_name", unitName);
                } else if ("unqualified_product_unit_no".equalsIgnoreCase(schema)) {
                    data.put("unqualified_product_unit_name", unitName);
                }
                data.put(schema, select.getSelectId());
            } else if (InputNumeric.COMPONENT_TYPE.equals(type)) {
                InputNumeric inputNumeric = (InputNumeric) param.getParams();
                data.put(schema, inputNumeric.getText());
            } else if (InputMultiText.COMPONENT_TYPE.equals(type)) {
                InputMultiText text = (InputMultiText) param.getParams();
                data.put(schema, text.getText());
            } else if (InputDateTimePicker.COMPONENT_TYPE.equals(type)) {
                InputDateTimePicker picker = (InputDateTimePicker) param.getParams();
                data.put(schema, InputDateTime.getDateTypeDateStringByType(picker.getDatetimeValue(),
                        InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR_MINUTE.getType()));
            }
            if (InputWindowMultiSelect.COMPONENT_TYPE.equals(type)) {
                InputWindowMultiSelect multiSelect = (InputWindowMultiSelect) param.getParams();
                // 驳回用的参数
                data.put("reject_to_operator_no", multiSelect.getSelectIdList());
            } else if (Picture.COMPONENT_TYPE.equals(type)) {
                Picture picture = (Picture) param.getParams();
                List<AttachmentFile> attachmentFiles = picture.getFileList();
                attachmentFiles = attachmentFiles.stream().filter(e -> !"DELETE".equals(e.getStatus())).collect(Collectors.toList());
                if ("resource_data".equals(schema)) {
                    List<Map<String, Object>> resourceDatas = new ArrayList<>();
                    if (!CollectionUtils.isEmpty(attachmentFiles)) {
                        for (AttachmentFile file : attachmentFiles) {
                            Map<String, Object> resourceData = new HashMap<>(5);
                            resourceData.put("resource_base", "1");

                            // 0 图片 1 视频
                            if (FileUtil.fileExtendNameIsImage(file.getFileExtension())) {
                                resourceData.put("resource_type", "0");
                            } else {
                                resourceData.put("resource_type", "1");
                                resourceData.put("is_cover", "Y");
                            }
                            resourceData.put("source_id", file.getFileId());
                            resourceData.put("video_cover_id", file.getCoverId());
                            resourceDatas.add(resourceData);
                        }
                    }
                    data.put("resource_data", resourceDatas);
                }

            } else if (Attachment.COMPONENT_TYPE.equals(type)) {
                Attachment attachment = (Attachment) param.getParams();
                List<AttachmentFile> attachmentFiles = attachment.getFileList();
                // 历史附件和附件需要合并，后续赋值给document_info里的data
                List<Map<String, Object>> documentInfoData = (List<Map<String, Object>>) MapUtil.getOrDefault(data, "document_info", Collections.emptyList());
                List<Map<String, Object>> attachmentInfoData = Optional
                        .ofNullable(documentInfoData)
                        .map(filesList ->
                                filesList.stream()
                                        .map(file -> Optional
                                                .ofNullable((Map<String, Object>) file.get("attachment"))
                                                .orElse(new HashMap<>()))
                                        .map(attachmentInfo -> Optional
                                                .ofNullable((List<Map<String, Object>>) attachmentInfo.get("data"))
                                                .orElse(new ArrayList<>()))
                                        .flatMap(Collection::stream)
                                        .collect(Collectors.toList()))
                        .orElse(new ArrayList<>());
                Map<String, String> attachmentInfoDataMapById = attachmentInfoData.stream().collect(
                        Collectors.toMap(e -> (String) e.get("id"), e -> (String) e.get("seq"), (key1, key2) -> key2));

                // 历史附件
                if ("historical_attachments".equals(schema)) {
                    for (AttachmentFile file : attachmentFiles) {
                        Map<String, Object> attachmentData = new HashMap<>(12);
                        attachmentData.put("category", DigiwinDmcConfig.TBDS_BUCKET);
                        attachmentData.put("create_date", file.getUploadTime());
                        attachmentData.put("id", file.getFileId());
                        attachmentData.put("name", file.getFileName());
                        attachmentData.put("size", file.getFileSize());

                        // 附件新增不需要传seq，应用自动生成，更新必须要带对应seq来更新，否则附件直接干没。。
                        if (StringUtils.hasLength(attachmentInfoDataMapById.get(file.getFileId()))) {
                            attachmentData.put("seq", attachmentInfoDataMapById.get(file.getFileId()));
                        }
                        attachmentData.put("uid", UUIDUtil.getUuid());
                        attachmentData.put("upload_state", 2);
                        attachmentData.put("upload_user_id", userId);
                        attachmentData.put("upload_user_name", file.getUploader());
                        attachmentDataList.add(attachmentData);
                    }
                }

                // 附件
                if ("attachments".equals(schema)) {
                    for (AttachmentFile file : attachmentFiles) {
                        Map<String, Object> attachmentData = new HashMap<>(12);
                        attachmentData.put("category", DigiwinDmcConfig.CTP_BUCKET);
                        attachmentData.put("create_date", file.getUploadTime());
                        attachmentData.put("id", file.getFileId());
                        attachmentData.put("name", file.getFileName());
                        attachmentData.put("size", file.getFileSize());

                        // 附件新增不需要传seq，应用自动生成，更新必须要带对应seq来更新，否则附件直接干没。。
                        if (StringUtils.hasLength(attachmentInfoDataMapById.get(file.getFileId()))) {
                            attachmentData.put("seq", attachmentInfoDataMapById.get(file.getFileId()));
                        }
                        attachmentData.put("uid", UUIDUtil.getUuid());
                        attachmentData.put("upload_state", 2);
                        attachmentData.put("upload_user_id", userId);
                        attachmentData.put("upload_user_name", file.getUploader());
                        attachmentDataList.add(attachmentData);
                    }
                }
            }
        }

        // 历史附件和附件合并后，并赋值给document_info里的data
        Map<String, Object> documentInfo = new HashMap<>(8);
        documentInfo.put("eoc_company_id", data.get("eoc_company_id"));
        documentInfo.put("eoc_site_id", data.get("eoc_site_id"));
        documentInfo.put("trial_wo_no", data.get("trial_wo_no"));
        documentInfo.put("document_type", "2");
        documentInfo.put("op_seq", data.get("op_seq"));
        documentInfo.put("op_no", data.get("op_no"));
        documentInfo.put("op_name", data.get("op_name"));
        if (CollectionUtils.isEmpty(attachmentDataList)) {
            Map<String, Object> documentAttachment = new HashMap<>(2);
            documentAttachment.put("row_data", "");
            documentAttachment.put("data", Collections.emptyList());
            documentInfo.put("attachment", documentAttachment);
        } else {
            Map<String, Object> attachmentMap = new HashMap<>();
            attachmentMap.put("data", attachmentDataList);
            documentInfo.put("attachment", attachmentMap);
        }
        data.put("document_info", Collections.singletonList(documentInfo));
    }

    private void buildTbdsDocumentInfo(Map<String, Object> data, List<Map<String, Object>> documentInfos) {
        List<Map<String, Object>> newDocumentInfos = new ArrayList<>(documentInfos.size());

        Map<String, Object> newDocumentInfo = new HashMap<>(8);
        newDocumentInfo.put("eoc_company_id", data.get("eoc_company_id"));
        newDocumentInfo.put("eoc_site_id", data.get("eoc_site_id"));
        newDocumentInfo.put("trial_wo_no", data.get("trial_wo_no"));
        newDocumentInfo.put("op_seq", data.get("op_seq"));
        newDocumentInfo.put("op_no", data.get("op_no"));
        newDocumentInfo.put("op_name", data.get("op_name"));
        newDocumentInfo.put("document_type", "2");

        newDocumentInfo.put("attachment", buildTbdsAttatchMent(documentInfos));
        newDocumentInfos.add(newDocumentInfo);
        data.put("document_info", newDocumentInfos);
    }

    private Map<String, Object> buildTbdsAttatchMent(List<Map<String, Object>> documentInfos) {
        int i = 1;
        Map<String, Object> newAttachment = new HashMap<>(2);
        List<Map<String, Object>> newDatas = new ArrayList<>(1);
        for (Map<String, Object> documentInfo : documentInfos) {
            Map<String, Object> attachment = (Map<String, Object>) documentInfo.get("attachment");
            newAttachment.put("row_data", attachment.get("row_data"));
            Map<String, Object> data = ((List<Map<String, Object>>) attachment.get("data")).get(0);
            Map<String, Object> newData = new HashMap<>(7);
            newData.put("seq", i);
            newData.put("id", data.get("id"));
            newData.put("name", data.get("name"));
            newData.put("category", "CTP");
            newData.put("size", data.get("size"));
            newData.put("upload_user_name", data.get("upload_user_name"));
            newData.put("create_date", data.get("create_date"));
            newDatas.add(newData);
            i++;
        }
        newAttachment.put("data", newDatas);
        return newAttachment;
    }

    /**
     * 项目发起-智慧检料提交:参数处理
     *
     * @param apiRequestSubmit
     * @return
     */
    private ActionSubmitResult intelligentMaterialInspectionSubmit(ApiRequestSubmit apiRequestSubmit) {
        Map<String, Object> params = new HashMap<>(2);
        JSONObject rawData = apiRequestSubmit.getRawData();
        Map<String, Object> data = rawData.getJSONObject("data");
        Map<String, Object> aiCheckMaterial = JsonUtil.objectToJavaObject(data.get("ai_check_material"), Map.class);
        List<ActionSubmitParam> submitParams = apiRequestSubmit.getSubmitParams();
        submitParams.forEach(actionSubmitParam -> {
            Map map = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), Map.class);
            aiCheckMaterial.put("sales_order_detail", map.get("selectDetailList"));
        });
        params.put("action", rawData.get("action"));
        Map<String, Object> datas = new HashMap<>(2);
        datas.put("ai_check_material", aiCheckMaterial);
        params.put("data", datas);
        return returnSubmit(digiwinAtmcProxyService.intelligentMaterialInspectionProject(apiRequestSubmit.getIamUserToken(),
                        apiRequestSubmit.getTenantId(), apiRequestSubmit.getLocale(), params),
                apiRequestSubmit.getLocale());
    }

    /**
     * 进度回报：数量转移按钮提交
     */
    private ActionSubmitResult transferQuantitySubmit(ApiRequestSubmit apiRequestSubmit) {
//        JSONObject rawData = apiRequestSubmit.getRawData();
//        List<Map<String, Object>> list = (List<Map<String, Object>>) rawData.get("wo_op_report_data");
//        Map<String, Object> woOpReportData = digiwinEspProxyService.updateProcessInfoTransferReport(apiRequestSubmit.getIamUserToken(),
//                apiRequestSubmit.getTenantId(), apiRequestSubmit.getLocale(), list);
//        Map<String, Object> stringObjectMap = list.get(0);
//
//        Map<String, Object> stringObjectMap1 = (Map<String, Object>) MapUtil.getOrDefault(woOpReportData, "data", Collections.emptyMap());
//        List<Map<String, Object>> list1 = (List<Map<String, Object>>) MapUtil.getOrDefault(stringObjectMap1, "wo_op_report_data", Collections.emptyList());
//        if (!CollectionUtils.isEmpty(list1)) {
//            Map<String, Object> stringObjectMap2 = list1.get(0);
//            //atmc  2024-03-11 马建伏说明：合并任务一定得加此字段(只针对submit接口)：activity__backLog__data
//            stringObjectMap2.put("activity__backLog__data", stringObjectMap.get("activity__backLog__data"));
//        }
        return returnMsgSubmit(apiRequestSubmit);
    }

    public ActionSubmitResult returnMsgSubmit(ApiRequestSubmit apiRequestSubmit) {
        JSONObject rawData = apiRequestSubmit.getRawData();
        HashMap<String, Object> paramsMap = new HashMap<>(2);
        paramsMap.put("action", rawData.get("action"));
        Map<String, Object> woOpReportDataMap = new HashMap<>(1);
        woOpReportDataMap.put("wo_op_report_data", rawData.get("wo_op_report_data"));
        paramsMap.put("data", woOpReportDataMap);
        DigiwinAtmcBacklogSubmitResult submitResult =
                this.digiwinAtmcProxyService.actionSubmit(apiRequestSubmit.getLocale(),
                        apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), paramsMap);
        if (null != submitResult.getRequestData()) {
            return ActionSubmitResult.create(true, LocaleUtil.getMobileTextByKey(apiRequestSubmit.getLocale(), "提交成功"));
        } else {
            return ActionSubmitResult.create(false, LocaleUtil.getMobileTextByKey(apiRequestSubmit.getLocale(), submitResult.getErrorMessage()));
        }
    }

    private void detailApcApprovalReassign
            (Map<String, Object> oldData, List<ActionSubmitParam> submitParams, String dataKey) {
        for (ActionSubmitParam param : submitParams) {
            String schema = param.getSchema();
            String type = param.getType();
            if (InputWindowSingleSelect.COMPONENT_TYPE.equals(type)) {
                InputWindowSingleSelect select = (InputWindowSingleSelect) param.getParams();
                if ("transfer_abnormal_reason_name".equalsIgnoreCase(schema)) {
                    Map<String, Object> details = select.getDetail();
                    if (!CollectionUtils.isEmpty(details)) {
                        oldData.put("transfer_abnormal_reason_no", details.get("abnormal_reason_no"));
                        oldData.put("transfer_abnormal_reason_name", details.get("abnormal_reason_name"));
                    } else {
                        oldData.putAll(select.getDetail());
                    }
                } else {
                    if (!CollectionUtils.isEmpty(select.getDetail())) {
                        oldData.putAll(select.getDetail());
                    }
                }
            } else if (InputSingleText.COMPONENT_TYPE.equals(type)) {
                InputSingleText inputSingleText = (InputSingleText) param.getParams();
                oldData.put(schema, inputSingleText.getText());
            } else if (InputWindowMultiSelect.COMPONENT_TYPE.equals(type)) {
                InputWindowMultiSelect select = (InputWindowMultiSelect) param.getParams();
                List<Object> objects = select.getSelectDetailList();
                if (!CollectionUtils.isEmpty(objects)) {
                    List<String> areaNos = new ArrayList<>(objects.size());
                    List<String> areaNames = new ArrayList<>(objects.size());
                    if ("area_name".equalsIgnoreCase(schema)) {
                        for (Object obj : objects) {
                            Map<String, Object> objectMap = (Map<String, Object>) obj;
                            areaNames.add(objectMap.get(schema).toString());
                            areaNos.add(objectMap.get("area_no").toString());
                        }
                    }
                    oldData.put(schema, CollUtil.join(areaNames, ";"));
                    oldData.put("area_no", CollUtil.join(areaNos, ";"));
                }
            } else if (InputCalendar.COMPONENT_TYPE.equals(type)) {
                InputCalendar inputCalendar = (InputCalendar) param.getParams();
                oldData.put(schema, DateTimeUtil.getInputCalendarDateUseDefaultPattern(inputCalendar.getInputText()));
            } else if (InputNumeric.COMPONENT_TYPE.equals(type)) {
                InputNumeric inputNumeric = (InputNumeric) param.getParams();
                oldData.put(schema, inputNumeric.getText());
            } else if (InputMultiText.COMPONENT_TYPE.equals(type)) {
                InputMultiText inputMultiText = (InputMultiText) param.getParams();
                oldData.put(schema, inputMultiText.getText());
            } else if (ButtonSingleSelect.COMPONENT_TYPE.equals(type)) {
                ButtonSingleSelect buttonSingleSelect = (ButtonSingleSelect) param.getParams();
                oldData.put(schema, buttonSingleSelect.getSelectId());
            } else if (Attachment.COMPONENT_TYPE.equals(type)) {
                if ("document_info".equals(schema)) {
                    continue;
                }
                Attachment attachment = (Attachment) param.getParams();
                List<AttachmentFile> attachmentFiles = attachment.getFileList();
                if (attachmentFiles != null && attachmentFiles.size() > 0) {
                    UiBotAttachment uiBotAttachment = new UiBotAttachment();
                    List<UiBotAttachmentData> dataList = new ArrayList<>(attachmentFiles.size());
                    for (AttachmentFile attachmentFile : attachmentFiles) {
                        UiBotAttachmentData data = new UiBotAttachmentData();
                        data.setCreateDate(attachmentFile.getUploadTime());
                        data.setId(attachmentFile.getFileId());
                        data.setName(attachmentFile.getFileName());
                        data.setUploadUserName(attachmentFile.getUploader());
                        dataList.add(data);
                    }
                    uiBotAttachment.setRowData(dataKey);
                    uiBotAttachment.setData(dataList);
                    oldData.put(schema, uiBotAttachment);
                } else {
                    Map<String, Object> attachments = new HashMap<>(2);
                    attachments.put("row_data", dataKey);
                    attachments.put("data", Collections.emptyList());
                    oldData.put(schema, attachments);
                }
            }
        }
    }

    private Map<String, Object> handleOutSourceReportReq
            (Map<String, Object> oldData, List<ActionSubmitParam> submitParams) {
        Map<String, Object> req = new HashMap<>();
        //根据工单单号，工艺段编号，报工工序，协作单位编号确认唯一
        req.put("wo_no", oldData.get("wo_no"));
        req.put("operation_section_no", oldData.get("operation_section_no"));
        req.put("operation_seq", oldData.get("operation_seq"));
        req.put("supplier_no", oldData.get("supplier_no"));
        for (ActionSubmitParam param : submitParams) {
            String schema = param.getSchema();
            String type = param.getType();
            if (InputWindowSingleSelect.COMPONENT_TYPE.equals(type)) {
                InputWindowSingleSelect select = (InputWindowSingleSelect) param.getParams();
                req.putAll(select.getDetail());
            } else if (InputCalendar.COMPONENT_TYPE.equals(type)) {
                InputCalendar inputCalendar = (InputCalendar) param.getParams();
                req.put(schema, DateTimeUtil.getInputCalendarDateUseDefaultPattern(inputCalendar.getInputText()));
            } else if (InputNumeric.COMPONENT_TYPE.equals(type)) {
                InputNumeric inputNumeric = new InputNumeric();
                req.put(schema, inputNumeric.getText());
            }
        }

        BigDecimal purchaseQty = new BigDecimal((String) oldData.get("purchase_qty"));
        BigDecimal reportQty = new BigDecimal((String) oldData.get("report_qty"));
        req.put("remaining_report_qty", purchaseQty.subtract(reportQty));
        return req;
    }

    private List<Map<String, Object>> detailSupportBottom
            (List<Map<String, Object>> datas, List<ActionSubmitParam> submitParams) {
        Map<String, Object> data = datas.get(0);
        for (ActionSubmitParam param : submitParams) {
            String type = param.getType();
            String schema = param.getSchema();
            if (InputWindowSingleSelect.COMPONENT_TYPE.equals(type)) {
                InputWindowSingleSelect select = (InputWindowSingleSelect) param.getParams();
                data.putAll(select.getDetail());
            } else if (InputNumeric.COMPONENT_TYPE.equals(type)) {
                InputNumeric inputNumeric = (InputNumeric) param.getParams();
                data.put(schema, inputNumeric.getText());
            } else if (InputCalendar.COMPONENT_TYPE.equals(type)) {
                InputCalendar calendar = (InputCalendar) param.getParams();
                if ("support_date".equals(schema)) {
                    String[] times = calendar.getInputText().split("\\^");
                    data.put("support_date_start", DateTimeUtil.convert(times[0], DateTimeUtil.DEFAULT_DATE_PATTERN));
                    data.put("support_date_end", DateTimeUtil.convert(times[1], DateTimeUtil.DEFAULT_DATE_PATTERN));
                }
            }
        }
        return datas;
    }

    private List<Map<String, Object>> detailSupport
            (List<Map<String, Object>> datas, List<ActionSubmitParam> submitParams) {
        for (Map<String, Object> data : datas) {
            String dataSchema = MapUtils.getString(data, "dataSchema");
            for (ActionSubmitParam param : submitParams) {
                String type = param.getType();
                if (!StringUtils.hasLength(param.getSchema())
                        || !param.getSchema().endsWith(dataSchema)) {
                    continue;
                }
                String schema = param.getSchema().split("_mobile_")[0];
                if (InputWindowMultiSelect.COMPONENT_TYPE.equals(type)) {
                    if (ObjectUtils.isEmpty(param.getParams())) {
                        // 支援人员没有选择也需要带上改字段，否则流程会有问题
                        data.put(schema, Collections.emptyList());
                        continue;
                    }
                    InputWindowMultiSelect select = (InputWindowMultiSelect) param.getParams();
                    // 目前只有单条数据的情况
                    data.put(schema, Objects.isNull(select.getSelectDetailList())
                            ? Collections.emptyList() : select.getSelectDetailList());
                }
            }
        }
        return datas;
    }

    /**
     * 除外回报 提交
     * <p>
     * 场景1：校验成功且没有在线工时
     * <p>
     * 场景2：校验成功有在线工时，提交需告知用户在线的报工清单，由应用确定是否在做自动下线处理
     * <p>
     * 场景3：校验失败时，提示用户因这些工时数据重叠导致无法提交成功
     *
     * @param apiRequestSubmit 提交参数
     * @return
     */
    private ActionSubmitResult excludedReturnSubmit(ApiRequestSubmit apiRequestSubmit) {
        final String locale = apiRequestSubmit.getLocale();

        Map<String, Object> data = this.buildRequestParam(apiRequestSubmit);
        //性质：1:固定时间 ; 2: 班别时间
        if ("1".equalsIgnoreCase(String.valueOf(data.get("except_property")))) {
            Action<Map<String, Object>> action = new Action<>();
            action.setType(ActionTypeEnum.CONTROL_COMPONENT_VALIDATION_PROMPT.getValue());
            ActionSubmitRule actionSubmitRule = new ActionSubmitRule();
            actionSubmitRule.setPageId(apiRequestSubmit.getPageId());
            List<ActionSubmitRule.SubmitRuleItem> submitRuleList = new ArrayList<>();
            String start = data.get("datetime_s").toString() + ":00";
            String end = data.get("datetime_e").toString() + ":00";
            if (DateTimeUtil.compareTimeHourMinute(start, end)) {
                ActionSubmitRule.SubmitRuleItem submitRuleItem = new ActionSubmitRule.SubmitRuleItem();
                submitRuleItem.setComponentType(InputDateTimePicker.COMPONENT_TYPE);
                submitRuleItem.setTargetShowSubmitErrorMessage(true);
                //开始时间大于等于结束时间
                submitRuleItem.setSchema("datetime_s");
                submitRuleItem.setTargetSubmitErrorMessage(localeService.getLanguageValue(locale, "开始时间需早于结束时间"));
                submitRuleList.add(submitRuleItem);
                actionSubmitRule.setSubmitRuleList(submitRuleList);
                action.setSubmitRule(actionSubmitRule);
                return ActionSubmitResult.create(true, action);
            }
        }
        /*
         *判斷當前用戶有【已上線、未下線】的報工記錄，將清單內的所有[下線時間] 代入當前系統時間，新增除外回報工時記錄，调API:65.except.report.verify.info.process
         */
        Map<String, Object> reportVerifyInfoProcess = digiwinEspProxyService.
                exceptReportVerifyInfoProcess(apiRequestSubmit.getIamUserToken(),
                        apiRequestSubmit.getTenantId(), locale, data);
        if (StringUtils.hasLength((String) reportVerifyInfoProcess.get("description"))) {
            final Action<Map<String, Object>> action = new Action<>();
            action.setToastMsg((String) reportVerifyInfoProcess.get("description"));
            action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
            return ActionSubmitResult.create(true, action);
        }
        List<Map<String, Object>> woOpReportData = (List<Map<String, Object>>) reportVerifyInfoProcess.get("wo_op_report_data");
        /*
         * 1.除外回报时间重叠;2.工时回报时间重叠;3.已上线未下线;4.自动下线询问
         *      2:工时回报重叠指的是「工时有上线有下线，且除外工时和在线工时发成重叠」
         *      3:已上线未下线是指「已上线的工时(11:10)大于除外回报开始时间(12:10)」
         *      4：自动下线询问是指「已上线时间(11:10)需要小于除外回报开始时间(10:10)」覆盖上线工时时间
         */
        String errorType = (String) reportVerifyInfoProcess.get("error_type");
        String errorMsg = (String) reportVerifyInfoProcess.get("error_msg");
        if (!StringUtils.hasLength(errorType) || CollectionUtils.isEmpty(woOpReportData)) {
            // 1、效验成功且没有在线工时
            return ActionSubmitResult.create(true,
                    LocaleUtil.getMobileTextByKey(locale, "提交成功"));
        }

        final ApiRawData rawData = apiRequestSubmit.getRawData();
        if (BottomWindowInfoTypeEnum.EXCEPT_RETURN_CHECK_IN_DATA.name().equals(rawData.getString("type"))) {
            /*
             * 判斷當前用户【無已上線、未下線】的報工記錄，新增除外回報工時記錄，调API:66.except.report.info.process
             */
            Boolean submit = digiwinEspProxyService
                    .exceptReportInfoProcess(apiRequestSubmit.getIamUserToken(),
                            apiRequestSubmit.getTenantId(), locale, data,
                            (List<Map<String, Object>>) woOpReportData.get(0).get("work_hours_overlap_data"));
            if (submit) {
                return ActionSubmitResult.create(true,
                        LocaleUtil.getMobileTextByKey(locale, "提交成功"));
            }
            return ActionSubmitResult.create(false,
                    LocaleUtil.getMobileTextByKey(locale, "数据预处理异常") + ","
                            + LocaleUtil.getMobileTextByKey(locale, "提交中止"));
        }

        final Action<Map<String, Object>> action = new Action<>();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BOTTOM_WINDOW_INFO.name());
        if (Arrays.asList("1").contains(errorType)) {
            action.setJumpPageTitle(localeService.getLanguageValue(locale, "提交失败，请排除以下状况"));
            rawData.put("type", BottomWindowInfoTypeEnum.EXCEPT_WORK_HOURS_OVERLAP_DATA.name());
            String message = StringUtils.hasLength(errorMsg) ? errorMsg :
                    localeService.getLanguageValue(locale, "选取的日期时间内已存在除外回报记录，不可[提交] 请重新选择日期时间");
            rawData.put("message", message);
            rawData.put(BottomWindowInfoTypeEnum.EXCEPT_WORK_HOURS_OVERLAP_DATA.name(), woOpReportData.get(0).get("except_report_data"));
            action.setRawData(rawData);
            return ActionSubmitResult.create(true, action);
        }
        if (Arrays.asList("2", "3").contains(errorType)) {
            // 校验失败时，提示用户因这些工时数据重叠导致无法提交成功
            action.setJumpPageTitle(localeService.getLanguageValue(locale, "提交失败，请排除以下状况"));
            rawData.put("type", BottomWindowInfoTypeEnum.EXCEPT_RETURN_WORK_HOURS_OVERLAP_DATA.name());
            String message = StringUtils.hasLength(errorMsg) ? errorMsg :
                    localeService.getLanguageValue(locale, "选取的日期时间内有报工记录，不可提交请重新选择日期时间");
            rawData.put("message", message);
            rawData.put(BottomWindowInfoTypeEnum.EXCEPT_RETURN_WORK_HOURS_OVERLAP_DATA.name(), woOpReportData.get(0).get("work_hours_overlap_data"));
            action.setRawData(rawData);
            return ActionSubmitResult.create(true, action);
        }
        // 校验成功有在线工时，提交需告知用户在线的报工清单，由应用确定是否在做自动下线处理
        action.setJumpPageTitle(localeService.getLanguageValue(locale, "报工清单"));
        rawData.put("type", BottomWindowInfoTypeEnum.EXCEPT_RETURN_CHECK_IN_DATA.name());
        String message = StringUtils.hasLength(errorMsg) ? errorMsg :
                localeService.getLanguageValue(locale, "以下工时记录将于「提交」后由系统自动下线");
        rawData.put("message", message);
        rawData.put(BottomWindowInfoTypeEnum.EXCEPT_RETURN_CHECK_IN_DATA.name(), woOpReportData.get(0).get("work_hours_overlap_data"));
        rawData.put("submit_button", true);
        // 将提交数据需要透传前端，前端获取到才能再次传递给我
        rawData.put("submitParams", apiRequestSubmit.getSubmitParams());
        action.setRawData(rawData);
        return ActionSubmitResult.create(true, action);
    }

    /**
     * 除外回报 构建请求外部参数
     *
     * @param apiRequestSubmit
     * @return
     */
    private Map<String, Object> buildRequestParam(ApiRequestSubmit apiRequestSubmit) {
        Map<String, Object> data = new HashMap<>();

        //this.dealReporterWorkerInfo(apiRequestSubmit, data);

        List<ActionSubmitParam> submitParams = apiRequestSubmit.getSubmitParams();
        List<String> time = new ArrayList<>(2);
        for (ActionSubmitParam actionSubmitParam : submitParams) {
            String schema = actionSubmitParam.getSchema();
            Object paramObj = actionSubmitParam.getParams();
            Object analyzedParam = new Object();
            String type = actionSubmitParam.getType();
            if (!Attachment.COMPONENT_TYPE.equals(type)) {
                ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                if (null == componentParamAnalyzer) {
                    logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                            schema, JsonUtil.javaObjectToJsonString(paramObj));
                    continue;
                }
                analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
            }

            switch (actionSubmitParam.getType()) {
                case SingleSelectList.COMPONENT_TYPE:
                    SingleSelectList singleSelectList = (SingleSelectList) paramObj;
                    data.put(schema, singleSelectList.getSelectId());
                    break;
                case Field.COMPONENT_TYPE:
                    Field field = (Field) paramObj;
                    data.put(schema, field.getValue());
                    data.put("reporter_no", field.getHideValue());
                    break;
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect) paramObj;
                    Map<String, Object> detail = inputWindowSingleSelect.getDetail();
                    if (Objects.equals("except_name", schema)) {
                        if (CollectionUtils.isEmpty(detail)) {
                            data.put("except_no", "");
                        } else {
                            data.put("except_no", detail.get("except_no"));
                        }

                    } else if (Objects.equals("reporter_name", schema)) {
                        if (CollectionUtils.isEmpty(detail)) {
                            data.put("reporter_no", "");
                        } else {
                            data.put("reporter_no", detail.get("reporter_no"));
                        }

                    }
                    data.put(schema, inputWindowSingleSelect.getTitle());
                    break;
                case InputDateTimePicker.COMPONENT_TYPE:
                    InputDateTime inputDateTime = (InputDateTime) analyzedParam;
                    String inputDateTimeResultString = "";
                    if ("date".equalsIgnoreCase(schema)) {
                        inputDateTimeResultString = InputDateTime.getDateTypeDateStringByType(inputDateTime, InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType());
                        data.put(schema, inputDateTimeResultString);
                    } else if ("time_start".equalsIgnoreCase(schema)) {
                        inputDateTimeResultString = InputDateTime.getDateTypeDateStringByType(inputDateTime, InputDateTimePickerTypeEnum.HOUR_MINUTE.getType());
                        time.add(inputDateTimeResultString);
                    } else if ("time_end".equalsIgnoreCase(schema)) {
                        inputDateTimeResultString = InputDateTime.getDateTypeDateStringByType(inputDateTime, InputDateTimePickerTypeEnum.HOUR_MINUTE.getType());
                        time.add(inputDateTimeResultString);
                    } else {
                        inputDateTimeResultString = InputDateTime.getDateTypeDateStringByType(inputDateTime, InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR_MINUTE.getType());
                        /**
                         * modify by mowj 20230104
                         * 应用api字段已改为datetime_s与datetime_e，且它们格式是：yyyy/MM/dd HH:mm，精确到分钟。
                         * 故需要将精确到秒钟的字符串做截取。
                         */
                        inputDateTimeResultString = inputDateTimeResultString.substring(0, inputDateTimeResultString.length() - 3);
                        data.put(schema, inputDateTimeResultString);
                    }
                    break;
                case InputCascade.COMPONENT_TYPE:
                    List<Map<String, Object>> cf = (List<Map<String, Object>>) analyzedParam;
                    for (Map<String, Object> cfParam : cf) {
                        data.put((String) cfParam.get("schema"), cfParam.get("id"));
                    }
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    data.put(schema, analyzedParam);
                    break;
                default:
                    break;
            }
        }
        data.put("time", time);
        return data;
    }

    /**
     * 除外回报 处理报工人员信息
     *
     * @param apiRequestSubmit
     * @param data
     */
    private void dealReporterWorkerInfo(ApiRequestSubmit apiRequestSubmit, Map<String, Object> data) {
        String eocCompanyId = "";
        String eocSiteId = "";
        for (ActionSubmitParam param : apiRequestSubmit.getSubmitParams()) {
            if (InputCascade.COMPONENT_TYPE.equals(param.getType())) {
                List<Map<String, Object>> maps = (ArrayList<Map<String, Object>>) param.getParams();
                for (Map<String, Object> map : maps) {
                    InputCascadeData inputCascadeData = JsonUtil.objectToJavaObject(map, InputCascadeData.class);
                    if (param.getSchema().equals(inputCascadeData.getSchema())) {
                        eocCompanyId = inputCascadeData.getId();
                    } else {
                        eocSiteId = inputCascadeData.getId();
                    }
                }
            }
        }
        // 是否为部门主管
        Boolean deptDirector = digiwinEspProxyService
                .isDeptDirector(apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), apiRequestSubmit.getLocale(),
                        eocCompanyId, eocSiteId);
        if (deptDirector) {
            return;
        }

        DigiwinIamUserInfo digiwinIamUserInfo = iamProxyService
                .userInfoById(apiRequestSubmit.getUserId(), apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getLocale());
        String nameKey = "reporter_name";
        String noKey = "reporter_no";
        if (digiwinIamUserInfo == null) {
            HashMap<String, Object> rawDataData = (HashMap) (apiRequestSubmit.getRawData().get("data"));
            HashMap<String, Object> exceptionReportData = (HashMap) (rawDataData.get("exception_report_data"));
            data.put(nameKey, exceptionReportData.get(nameKey));
            data.put(noKey, exceptionReportData.get(noKey));
        } else {
            data.put(nameKey, digiwinIamUserInfo.getName());
            data.put(noKey, digiwinIamUserInfo.getUserId());
        }
        // 防呆处理：若遇到noKey的值还是为空的情况，取nameKey的值。若还没，则取请求参数中的userId
        if (StringUtils.hasLength(String.valueOf(data.get(noKey)))) {
            return;
        }
        String nameValue = String.valueOf(data.get(nameKey));
        if (StringUtils.hasLength(nameValue)) {
            data.put(noKey, nameValue);
        } else {
            data.put(noKey, apiRequestSubmit.getUserId());
        }
    }


    private ActionSubmitResult sharingSubmit(ApiRequestSubmit apiRequestSubmit) {
        List<ActionSubmitParam> submitParams = apiRequestSubmit.getSubmitParams();
        Map<String, Object> data = new HashMap<>(5);
        ApiRawData apiRawData = apiRequestSubmit.getRawData();
        data.put("mainTaskId", apiRawData.get("id"));

        // 平台新增必传参数，1是项目，2是任务
        // 目前添加至他人Athena 这个功能只涉及项目卡，故固定传1
        data.put("type", 1);
        for (ActionSubmitParam actionSubmitParam : submitParams) {
            String schema = actionSubmitParam.getSchema();
            switch (actionSubmitParam.getType()) {
                case MultiFunctionList.COMPONENT_TYPE:
                    MultiFunctionList multiFunctionList = (MultiFunctionList) actionSubmitParam.getParams();
                    // 临时解法，改变结构并permission默认read
                    List<Map<String, Object>> selectDetailList = multiFunctionList.getSelectDetailList();
                    if (!CollectionUtils.isEmpty(selectDetailList)) {
                        selectDetailList.forEach(map -> map.put("permission", "read"));
                    }
                    data.put(schema, selectDetailList);
                    break;
                default:
                    break;
            }
        }
        return returnSubmit(digiwinAtmcProxyService.insertTaskPinning(apiRequestSubmit.getIamUserToken(),
                        apiRequestSubmit.getTenantId(), apiRequestSubmit.getLocale(), data),
                apiRequestSubmit.getLocale());
    }

    private ActionSubmitResult doubelPatternSubmit(ApiRequestSubmit apiRequestSubmit) {
        JSONObject rawData = apiRequestSubmit.getRawData();
        Map<String, Object> rawDataData = (Map<String, Object>) rawData.get("data");
        Map<String, Object> data = new HashMap<>();
        String dataKey = "";
        Boolean isHasKey = false;
        for (String key : rawDataData.keySet()) {
            dataKey = key;
            if (rawDataData.get(key) instanceof Map) {
                data = (Map<String, Object>) rawDataData.get(key);
                break;
            } else {
                if (rawDataData.get(key) instanceof List) {
                    isHasKey = true;
                    data = rawDataData;
                }
                break;
            }
        }
        List<Map<String, Object>> listData = new ArrayList<>();
        for (String key : data.keySet()) {
            if (data.get(key) instanceof List) {
                listData = (List<Map<String, Object>>) data.get(key);
                break;
            }
        }
        List<ActionSubmitParam> submitParams = apiRequestSubmit.getSubmitParams();
        int i = 0;
        for (ActionSubmitParam submitParam : submitParams) {
            if (CustomGroup.COMPONENT_TYPE.equalsIgnoreCase(submitParam.getType())) {
                CustomGroup customGroup = (CustomGroup) submitParam.getParams();
                //单身的需要放到内map中
                if (customGroup.getHasDetail() == null || !customGroup.getHasDetail()) {
                    setSubmitData(customGroup.getParams(), data);
                    //单头在外层map中
                } else {
                    setSubmitData(customGroup.getParams(), listData.get(i));
                    i++;
                }
            }
        }
        /**
         * 上面解了一层，所以必须在包回去
         */
        Map<String, Object> map = new HashMap<>(1);
        if (!isHasKey) {
            map.put(dataKey, data);
            rawData.put("data", map);
        } else {
            rawData.put("data", data);
        }

        DigiwinAtmcBacklogSubmitResult atmcSubmitResult =
                this.digiwinAtmcProxyService.actionSubmit(apiRequestSubmit.getLocale(),
                        apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), rawData);
        if (null != atmcSubmitResult.getRequestData()) {
            String promptMessage =
                    LocaleUtil.getMobileTextByKey(apiRequestSubmit.getLocale(), "提交成功");
            return ActionSubmitResult.create(true, promptMessage);
        } else {
            return ActionSubmitResult.create(false, atmcSubmitResult.getErrorMessage());
        }
    }

    /**
     * 1.看是否保存为常用条件，是的话，多走一个save接口
     * 2.点击查询获取对应的hashKey和resid
     *
     * @param apiRequestSubmit
     * @return
     */
    private ActionSubmitResult abiSubmit(ApiRequestSubmit apiRequestSubmit) {
        JSONObject rawData = apiRequestSubmit.getRawData();
        UiBotPageData pageData = JsonUtil.objectToJavaObject(rawData.get("data"), UiBotPageData.class);
        List<UiBotLayout> layouts = ModuleUtils.listMapToListObject((List) rawData.get("layout"), UiBotLayout.class);
        UiBotLayout layout = layouts.get(0);
        Map<String, Object> data = ((List<Map<String, Object>>) pageData.get(layout.getSchema())).get(0);
        Map<String, List<String>> relationSchemas = new HashMap<>();
        List<UiBotField> uiBotFields = new ArrayList<>(layouts.size());
        for (UiBotLayout group : layout.getGroup()) {
            if (PcModuleEnum.FORM_OPERATION_EDITOR.getValue().equals(group.getType())
                    || PcModuleEnum.OPERATION_EDITOR.getValue().equals(group.getType())
            ) {
                if (!CollectionUtils.isEmpty(group.getRelationSchemas())) {
                    relationSchemas.put(group.getSchema(), group.getRelationSchemas());
                    uiBotFields.add(JsonUtil.objectToJavaObject(group, UiBotField.class));
                }
            }
        }
        String dataId = rawData.getString("dataId");
        String conditionName = "";
        Boolean isSave = false;
        for (ActionSubmitParam params : apiRequestSubmit.getSubmitParams()) {
            String schema = params.getSchema();
            Object paramObj = params.getParams();
            Object analyzedParam = this.componentParamAnalyzerFactory.get(params.getType()).analyzeSubmitParam(paramObj);
            switch (params.getType()) {
                case InputSwitch.COMPONENT_TYPE:
                    if (InputSwitchStateEnum.SWITCH_STATE_OPEN.getState().equals((Integer) analyzedParam)) {
                        isSave = true;
                    }
                    break;
                case InputSingleText.COMPONENT_TYPE:
                case InputWindowSingleSelect.COMPONENT_TYPE:
                case InputMultiText.COMPONENT_TYPE:
                case SingleSelectList.COMPONENT_TYPE:
                    if ("conditionName".equals(schema)) {
                        conditionName = (String) analyzedParam;
                    } else {
                        data.put(schema, analyzedParam);
                    }
                    break;
                case InputWindowMultiSelect.COMPONENT_TYPE:
                    InputWindowMultiSelect multiSelect = (InputWindowMultiSelect) paramObj;
                    if (multiSelect != null) {
                        List<Object> detailList = multiSelect.getSelectDetailList();
                        List<Map<String, Object>> dataListMap = new ArrayList<>(detailList.size());
                        for (Object detail : detailList) {
                            Map<String, Object> detailMap = (Map<String, Object>) detail;
                            Map<String, Object> dataMap = new HashMap<>(detailMap.size());
                            if (relationSchemas.containsKey(schema)) {
                                for (UiBotField field : uiBotFields) {
                                    if (field.getSchema().equals(schema)) {
                                        Map<String, String> backFills = field.getBackFills();
                                        for (String key : backFills.keySet()) {
                                            dataMap.put(backFills.get(key), detailMap.get(key));
                                        }
                                    } else {
                                        data.put(schema, Collections.emptyList());
                                    }

                                }
                                dataListMap.add(dataMap);
                            }
                        }
                        data.put(schema, dataListMap);
                    } else {
                        data.put(schema, Collections.emptyList());
                    }

                    break;
                case InputDateTimePicker.COMPONENT_TYPE:
                    InputDateTime inputDateTime = (InputDateTime) analyzedParam;
                    data.put(schema, InputDateTime.getDateTypeDateStringByType(
                            inputDateTime, InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType()));
                    break;
                default:
                    break;
            }
        }
        Map<String, Object> actionRawData = new HashMap<>(8);
        //如果要保存为常用条件
        if (isSave) {
            Map<String, Object> params = new HashMap<>(3);
            params.put("activityCode", dataId);
            params.put("conditionName", conditionName);
            String schema = (String) pageData.get("UIBOT__schema");
            pageData.put(schema, data);
            params.put("conditionValue", pageData);
            Map<String, Object> condition = digiwinAtmcProxyService.saveAbiCondition(apiRequestSubmit.getIamUserToken(),
                    apiRequestSubmit.getTenantId(), apiRequestSubmit.getLocale(), params, conditionName);
            if (CollectionUtils.isEmpty(condition)) {
                logger.error("常用条件：" + conditionName + "保存失败！！！");
            } else {
                actionRawData.put("conditionName", conditionName);
                actionRawData.put("conditionId", String.valueOf(condition.get("id")));
            }
        }
        UiBotAction uiBotAction = JsonUtil.objectToJavaObject(rawData.get("action"), UiBotAction.class);
        Map<String, Object> params = new HashMap<>(2);
        params.put("action", uiBotAction);
        List<Map<String, Object>> datas = new ArrayList<>(1);
        datas.add(data);
        Map<String, Object> value = new HashMap<>();
        value.put(layout.getSchema(), datas);
        params.put("data", value);
        String hashCode = digiwinAtmcProxyService.getAbiDataCache(apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), apiRequestSubmit.getLocale(), params);
        String resid = (String) pageData.get(ABI_STATEMENT_RESID);
        String reportName = (String) pageData.get(ABI_REPORT_NAME);
        ActionSubmitResult result = new ActionSubmitResult();
        actionRawData.put(SELECT_TAG, hashCode);
        actionRawData.put(ABI_STATEMENT_RESID, resid);
        actionRawData.put("action", uiBotAction);
        actionRawData.put("data", data);
        actionRawData.put("useCommon", isSave);
        result.setAction(Action.jumpAbiReportDetailAction(dataId, reportName, actionRawData));
        return result;
    }

    private Map<String, Object> setSubmitData
            (List<ActionSubmitParam> actionSubmitParams, Map<String, Object> data) {
        for (ActionSubmitParam params : actionSubmitParams) {
            String schema = params.getSchema();
            Object paramObj = params.getParams();
            Object analyzedParam = new Object();
            if (!Attachment.COMPONENT_TYPE.equals(params.getType())) {
                String type = params.getType();
                ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                if (null == componentParamAnalyzer) {
                    logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                            schema, JsonUtil.javaObjectToJsonString(paramObj));
                    continue;
                }
                analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
            }
            switch (params.getType()) {
                case Field.COMPONENT_TYPE:
                case InputMultiText.COMPONENT_TYPE:
                case InputSingleText.COMPONENT_TYPE:
                case InputNumeric.COMPONENT_TYPE:
                    if (analyzedParam instanceof String) {
                        if (((String) analyzedParam).equalsIgnoreCase("-")) {
                            data.put(schema, "");
                        } else {
                            data.put(schema, analyzedParam);
                        }
                    } else {
                        data.put(schema, analyzedParam);
                    }
                    break;
                case InputSwitch.COMPONENT_TYPE:
                    if (InputSwitchStateEnum.SWITCH_STATE_CLOSE.getState().equals(analyzedParam)) {
                        data.put(schema, false);
                    } else {
                        data.put(schema, true);
                    }
                    break;
                case InputDateTimePicker.COMPONENT_TYPE:
                    InputDateTime inputDateTime = (InputDateTime) analyzedParam;
                    data.put(schema, InputDateTime.getDateTypeDateStringByType(inputDateTime, inputDateTime.getType()));
                    break;
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    InputWindowSingleSelect windowSingleSelect = (InputWindowSingleSelect) paramObj;
                    if (windowSingleSelect.getDetail() != null && windowSingleSelect.getDetail().size() > 0) {
                        Map<String, Object> details = windowSingleSelect.getDetail();
                        for (String id : details.keySet()) {
                            if (details.get(id) instanceof String &&
                                    windowSingleSelect.getSelectId().equalsIgnoreCase(
                                            (String) details.get(id))) {
                                data.put(id, windowSingleSelect.getSelectId());
                                break;
                            }
                        }
                        data.put(schema, windowSingleSelect.getTitle());
                    } else {
                        if (StringUtils.hasLength(windowSingleSelect.getTitle())) {
                            data.put(schema, windowSingleSelect.getTitle());
                        }
                    }
                    break;
                case Attachment.COMPONENT_TYPE:
                    Attachment attachment = (Attachment) paramObj;
                    if (attachment.getFileList() != null && attachment.getFileList().size() > 0) {
                        List<Map<String, Object>> newFiles = new ArrayList<>();
                        Map<String, Object> attachments = (Map<String, Object>) data.get(schema);
                        if (attachments != null && attachments.get("data") != null) {
                            List<Map<String, Object>> files = (List<Map<String, Object>>) attachments.get("data");
                            for (Object fileList : attachment.getFileList()) {
                                for (Map<String, Object> file : files) {
                                    if (((AttachmentFile) fileList).getFileId().equalsIgnoreCase((String) file.get("id"))) {
                                        newFiles.add(file);
                                        break;
                                    }
                                }
                            }
                            attachments.put("data", newFiles);
                        }
                        data.put(schema, attachments);
                    } else {
                        Map<String, Object> attachments = new HashMap<>(2);
                        attachments.put("row_data", ";");
                        attachments.put("data", Collections.emptyList());
                        data.put(schema, attachments);
                    }
                    break;
                default:
                    break;
            }
        }
        return data;
    }


    private ActionSubmitResult reassignSubmit(ApiRequestSubmit apiRequestSubmit) {
        List<ActionSubmitParam> submitParams = apiRequestSubmit.getSubmitParams();
        Map<String, Object> data = new HashMap<>(5);
        ApiRawData apiRawData = apiRequestSubmit.getRawData();

        String category = (String) apiRawData.get("category");
        data.put("category", category);
        data.put("id", apiRawData.get("id"));
        for (ActionSubmitParam actionSubmitParam : submitParams) {
            String schema = actionSubmitParam.getSchema();
            Object paramObj = actionSubmitParam.getParams();
            Object analyzedParam = new Object();
            if (!Attachment.COMPONENT_TYPE.equals(actionSubmitParam.getType())) {
                String type = actionSubmitParam.getType();
                ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                if (null == componentParamAnalyzer) {
                    logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                            schema, JsonUtil.javaObjectToJsonString(paramObj));
                    continue;
                }
                analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
            }
            switch (actionSubmitParam.getType()) {
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect) paramObj;
                    Map<String, Object> detail = inputWindowSingleSelect.getDetail();
                    data.put(schema, analyzedParam);
                    if (!CollectionUtils.isEmpty(detail)) {
                        data.put("newDeptId", detail.get("deptId"));
                    }
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    data.put(schema, analyzedParam);
                    break;
                default:
                    break;
            }
        }
        if (digiwinAtmcProxyService.reassignSubmit(apiRequestSubmit.getIamUserToken(),
                apiRequestSubmit.getTenantId(), apiRequestSubmit.getLocale(), data)) {
            return returnSubmit(true, apiRequestSubmit.getLocale());
        } else {
            data.remove("newDeptId");
            data.put("id", Long.valueOf((String) data.get("id")));
            return returnSubmit(digiwinAtmcProxyService.reassignSubmit(apiRequestSubmit.getIamUserToken(),
                    apiRequestSubmit.getTenantId(), apiRequestSubmit.getLocale(), data), apiRequestSubmit.getLocale());
        }

    }

    private ActionSubmitResult driverCarSaveSubmit(ApiRequestSubmit apiRequestSubmit, String driverCarType) {
        List<ActionSubmitParam> submitParams = apiRequestSubmit.getSubmitParams();
        Map<String, Object> data = new HashMap<>(6);
        Boolean submit = false;
        for (ActionSubmitParam actionSubmitParam : submitParams) {
            String schema = actionSubmitParam.getSchema();
            Object paramObj = actionSubmitParam.getParams();
            Object analyzedParam = new Object();
            if (!Attachment.COMPONENT_TYPE.equals(actionSubmitParam.getType())) {
                String type = actionSubmitParam.getType();
                ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                if (null == componentParamAnalyzer) {
                    logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                            schema, JsonUtil.javaObjectToJsonString(paramObj));
                    continue;
                }
                analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
            }
            switch (actionSubmitParam.getType()) {
                case Field.COMPONENT_TYPE:
                case InputSingleText.COMPONENT_TYPE:
                    data.put(schema, analyzedParam);
                    break;
                case SingleSelectList.COMPONENT_TYPE:
                    SingleSelectList selectList = (SingleSelectList) paramObj;
                    data.put(schema, selectList.getText());
                    break;
                case InputSwitch.COMPONENT_TYPE:
                    InputSwitch inputSwitch = (InputSwitch) paramObj;
                    data.put(schema, Optional.ofNullable(inputSwitch.getSwitchState()).orElse(0) == 1);
                    break;
                case Picture.COMPONENT_TYPE:
                    UiBotAttachment uiBotAttachment = (UiBotAttachment) analyzedParam;
                    List<UiBotAttachmentData> attachmentDataList = uiBotAttachment.getData();
                    if (!CollectionUtils.isEmpty(attachmentDataList)) {
                        data.put(schema, attachmentDataList.get(0).getId());
                    }
                    break;
                default:
                    break;
            }
        }
        String message = "";
        if (DRIVER_CAR_TYPE_ADD.equalsIgnoreCase(driverCarType)) {
            message = "提交";
            submit = digiwinEspProxyService.addDriverVehicle(apiRequestSubmit.getIamUserToken(),
                    apiRequestSubmit.getTenantId(), apiRequestSubmit.getLocale(), data);
        }
        if (DRIVER_CAR_TYPE_UPDATE.equalsIgnoreCase(driverCarType)) {
            message = "提交";
            submit = digiwinEspProxyService.updateDriverVehicle(apiRequestSubmit.getIamUserToken(),
                    apiRequestSubmit.getTenantId(), apiRequestSubmit.getLocale(), data);
        }
        if (DRIVER_CAR_TYPE_DELETE.equalsIgnoreCase(driverCarType)) {
            message = "删除";
            ApiRawData rawData = apiRequestSubmit.getRawData();
            Map<String, Object> data1 = (Map<String, Object>) rawData.get("data");
            if (data1 != null && data1.size() > 0) {
                data.put("vehicle_info_id", data1.get("vehicle_info_id"));
            }
            submit = digiwinEspProxyService.deleteDriverVehicle(apiRequestSubmit.getIamUserToken(),
                    apiRequestSubmit.getTenantId(), apiRequestSubmit.getLocale(), data);
        }
        if (submit) {
            String promptMessage = message + "成功";
            return ActionSubmitResult.create(true,
                    localeService.getLanguageValue(apiRequestSubmit.getLocale(), promptMessage));
        } else {
            String promptMessage = message + "异常";
            return ActionSubmitResult.create(false,
                    localeService.getLanguageValue(apiRequestSubmit.getLocale(), promptMessage));
        }
    }

    private ActionSubmitResult electronicFenceSaveSubmit(ApiRequestSubmit apiRequestSubmit) {
        List<ActionSubmitParam> submitParams = apiRequestSubmit.getSubmitParams();
        Map<String, Object> data = new HashMap<>(6);
        for (ActionSubmitParam actionSubmitParam : submitParams) {
            String schema = actionSubmitParam.getSchema();
            Object paramObj = actionSubmitParam.getParams();
            Object analyzedParam = new Object();
            if (!Attachment.COMPONENT_TYPE.equals(actionSubmitParam.getType())) {
                String type = actionSubmitParam.getType();
                ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                if (null == componentParamAnalyzer) {
                    logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                            schema, JsonUtil.javaObjectToJsonString(paramObj));
                    continue;
                }
                analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
            }
            switch (actionSubmitParam.getType()) {
                case Field.COMPONENT_TYPE:
                case InputNumeric.COMPONENT_TYPE:
                    data.put(schema, analyzedParam);
                    break;
                case InputSwitch.COMPONENT_TYPE:
                    InputSwitch inputSwitch = (InputSwitch) paramObj;
                    data.put(schema, Optional.ofNullable(inputSwitch.getSwitchState()).orElse(0) == 1 ? "Y" : "N");
                    break;
                default:
                    break;
            }
        }
        String message = "提交";
        Boolean submit = digiwinEspProxyService.saveElectronicFence(apiRequestSubmit.getIamUserToken(),
                apiRequestSubmit.getTenantId(), apiRequestSubmit.getLocale(), data);
        if (submit) {
            String promptMessage = message + "成功";
            return ActionSubmitResult.create(true,
                    localeService.getLanguageValue(apiRequestSubmit.getLocale(), promptMessage));
        } else {
            String promptMessage = message + "异常";
            return ActionSubmitResult.create(false,
                    localeService.getLanguageValue(apiRequestSubmit.getLocale(), promptMessage));
        }
    }

    /**
     * 行事历提交
     *
     * @param apiRequestSubmit
     * @param apiRawData
     * @param param
     * @return
     */
    private ActionSubmitResult calendarReportSubmit(ApiRequestSubmit apiRequestSubmit, ApiRawData
            apiRawData, Map<String, Object> param) {
        List<ActionSubmitParam> submitParams = apiRequestSubmit.getSubmitParams();
        Map<String, Object> data = (Map<String, Object>) apiRawData.get("data");
        List<String> actualRange = new ArrayList<>(2);
        Boolean isCreate = false;
        String executeState = "";
        if (data.get("executeState") instanceof Integer) {
            executeState = String.valueOf(data.get("executeState"));
        }
        if (!StringUtils.hasLength(executeState)) {
            data.put("executeState", 0);
            data.put("creatorUserId", apiRequestSubmit.getUserId());
            DigiwinIamUserInfo digiwinIamUserInfo = iamProxyService.userInfoById(apiRequestSubmit.getUserId(), apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getLocale());
            data.put("creatorUserName", digiwinIamUserInfo.getName());
            data.put("creatorTenantId", apiRequestSubmit.getTenantId());
            isCreate = true;
        }
        for (ActionSubmitParam actionSubmitParam : submitParams) {
            String schema = actionSubmitParam.getSchema();
            Object paramObj = actionSubmitParam.getParams();
            Object analyzedParam = new Object();
            if (!Attachment.COMPONENT_TYPE.equals(actionSubmitParam.getType())) {
                String type = actionSubmitParam.getType();
                ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                if (null == componentParamAnalyzer) {
                    logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                            schema, JsonUtil.javaObjectToJsonString(paramObj));
                    continue;
                }
                analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
            }
            switch (actionSubmitParam.getType()) {
                case Field.COMPONENT_TYPE:
                    if ("executorList".equals(schema)) {
                        Field field = (Field) actionSubmitParam.getParams();
                        List<Executor> executors = new ArrayList<>();
                        executors.add(field.getExecutor());
                        data.put(schema, executors);
                    } else {
                        data.put(schema, analyzedParam);
                    }
                    break;
                case InputMultiText.COMPONENT_TYPE:
                case InputSingleText.COMPONENT_TYPE:
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    data.put(schema, analyzedParam);
                    break;
                case ButtonSingleSelect.COMPONENT_TYPE:
                    ButtonSingleSelect buttonSingleSelect = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), ButtonSingleSelect.class);
                    if (StringUtils.hasLength(buttonSingleSelect.getSelectId())) {
                        data.put(schema, Integer.valueOf(buttonSingleSelect.getSelectId()));
                    }
                    break;
                case InputWindowMultiSelect.COMPONENT_TYPE:
                    List<Map<String, Object>> details = (List<Map<String, Object>>) analyzedParam;
                    if (details.size() == 1) {
                        data.put("executorUserName", details.get(0).get("executorUserName"));
                    }
                    data.put(schema, analyzedParam);
                    break;
                case InputDateTimePicker.COMPONENT_TYPE:
                    InputDateTime inputDateTime = (InputDateTime) analyzedParam;
                    data.put(schema, InputDateTime.getDateTypeDateStringByType(inputDateTime, null));
                    actualRange.add(InputDateTime.getDateTypeDateStringByType(inputDateTime, null));
                    break;
                case InputSwitch.COMPONENT_TYPE:
                    if (InputSwitchStateEnum.SWITCH_STATE_CLOSE.getState().equals(analyzedParam)) {
                        data.put(schema, false);
                    } else {
                        data.put(schema, true);
                    }
                    break;
                case InputGroupSingleSelect.COMPONENT_TYPE:
                    data.put(schema, analyzedParam);
                    break;
                case Attachment.COMPONENT_TYPE:
                    Attachment attachment = (Attachment) actionSubmitParam.getParams();
                    List<AttachmentFile> attachmentFiles = attachment.getFileList();
                    if (attachmentFiles != null && attachmentFiles.size() > 0) {
                        List<Map<String, Object>> dataList = new ArrayList<>(attachmentFiles.size());
                        for (AttachmentFile attachmentFile : attachmentFiles) {
                            Map<String, Object> dataPar = new HashMap<>();
                            dataPar.put("category", "calendar_file_category");
                            dataPar.put("category_id", digiwinDmcProxyService.getDirIdByName("calendar_file_category"));
                            dataPar.put("create_date", attachmentFile.getUploadTime());
                            dataPar.put("id", attachmentFile.getFileId());
                            dataPar.put("name", attachmentFile.getFileName());
                            dataPar.put("size", attachmentFile.getFileSize());
                            dataPar.put("upload_user_name", attachmentFile.getUploader());
                            dataList.add(dataPar);
                        }
                        Map<String, Object> par = new HashMap<>(1);
                        par.put("data", dataList);
                        data.put(schema, par);
                    }

                    break;
                default:
                    break;
            }
        }
        if (isCreate) {
            data.put("range", actualRange);
        } else {
            data.put("actualRange", actualRange);
        }
        Map<String, Object> dataIn = new HashMap<>(1);
        dataIn.put("data", data);
        param.put("data", dataIn);
        return returnSubmit(digiwinAtdmProxyService.actionExecute(apiRequestSubmit.getLocale(),
                apiRequestSubmit.getIamUserToken(), param, apiRequestSubmit.getTenantId()), apiRequestSubmit.getLocale());
    }


    public ActionSubmitResult returnSubmit(Boolean submit, String locale) {
        if (submit) {
            String promptMessage =
                    LocaleUtil.getMobileTextByKey(locale, "提交成功");
            return ActionSubmitResult.create(true, promptMessage);
        } else {
            return ActionSubmitResult.create(false,
                    LocaleUtil.getMobileTextByKey(locale, "提交异常"));
        }
    }

    public ActionSubmitResult returnSubmit(Boolean submit, String locale, String prefixTip) {
        if (submit) {
            return ActionSubmitResult.create(true, prefixTip + localeService.getLanguageValue(locale, "成功"));
        } else {
            return ActionSubmitResult.create(false, prefixTip + localeService.getLanguageValue(locale, "失败"));
        }
    }

    /**
     * 去除在App操作过程中封装的扩展字段参数。放置位置参考如下。扩展字段参数是给弹出二级页面中的接口调用参数用的，如果二级页面中没有调用额外参数的，则不会有这个extendedFields字段
     *
     * @param apiRequestSubmit
     * @see
     */
    private void removeExtendedFieldsFromApiRequestSubmit(ApiRequestSubmit apiRequestSubmit) {
        ApiRawData apiRawData = apiRequestSubmit.getRawData();
        JSONObject dataJsonObj = apiRawData.getJSONObject("data");
        if (dataJsonObj != null) {
            dataJsonObj.remove("extendedFields");
        }
    }

    /**
     * 根据不同按钮，将移动端提交的参数放入Athena需要的提交参数中
     * TODO 方法需要重构。本方法现有两个问题；
     * 1. 每个按钮内的处理都是定制，且有很多重复代码
     * 2. 每新增一个提交类型的组件，就需要在每个按钮内写新的layout判断
     *
     * @param apiRequestSubmit
     * @return true-表示找到了匹配的按钮，且参数已经处理完成；false-表示未找到匹配的按钮，没有处理参数，需要调用方中断后续主流程
     */
    private ActionPreHandleResult addParasToApiRequestSubmit(ApiRequestSubmit apiRequestSubmit) {
        boolean actionFound = true;
        ActionPreHandleResult preHandleResult = new ActionPreHandleResult();
        preHandleResult.setActionFound(actionFound);

        JSONObject rawData = apiRequestSubmit.getRawData();
        JSONObject rawDataAction = rawData.getJSONObject("action");
        JSONObject rawDataData = rawData.getJSONObject("data");
        // 从rawData获取当前移动端画面布局信息
        MobileLayoutTypeEnum mobileLayoutTypeEnum = rawData.getObject("mobileLayoutType", MobileLayoutTypeEnum.class);

        String actionId = rawDataAction.getString("actionId");
        String actionTitle = rawDataAction.getString("title");
        String actionCategory = rawDataAction.getString("category");
        String actionServiceIdName = rawDataAction.getJSONObject("serviceId").getString("name");
        String actionServiceIdTenantId =
                rawDataAction.getJSONObject("serviceId").getString("tenant_id");
        String actionSubmitTypeSchema = "";
        if (rawDataAction.getJSONObject("submitType") != null) {
            actionSubmitTypeSchema = rawDataAction.getJSONObject("submitType").getString("schema");
        }

        String executeCtxPattern =
                rawDataAction.getJSONObject("executeContext").getString("pattern");
        String executeCtxCategory =
                rawDataAction.getJSONObject("executeContext").getString("category");
        String executeCtxTmProjectId =
                rawDataAction.getJSONObject("executeContext").getString("tmProjectId");
        String executeCtxTmActivityId =
                rawDataAction.getJSONObject("executeContext").getString("tmActivityId");

        // key是鼎捷uibot中action提交时需要的参数key，value是这个key对应的值
        Map<String, Object> digiwinActionSubmitParasMap = new HashMap<>(5);
//        esp_day.energy.consume.abnormal.info.update
//        day.energy.consume.abnormal.info.update

        // actionServiceIdName对应的attachAction
        JSONObject actionServiceIdNameAttachAction = rawDataAction;
        // actionServiceIdName对应的category
        String actionServiceIdNameCategory = actionCategory;
        //先判断actionServiceIdName是否有值且该值在不在枚举类中。是的话则直接用actionServiceIdName，不是的话需要进一步提取值、判断、赋值
        if (null == actionServiceIdName || "".equals(actionServiceIdName) || null == ApprovalActionNameEnum.getEnumByValue(actionServiceIdName)) {
            JSONArray attachActionsList = rawDataAction.getJSONArray("attachActions");
            //先判断attachActions数组中是否有serviceId.name在枚举类中的，是的话则将该值赋值给actionServiceIdName。否则依然走原有逻辑
            if (!CollectionUtils.isEmpty(attachActionsList)) {
                for (int i = 0; i < attachActionsList.size(); i++) {
                    JSONObject jsonObject = attachActionsList.getJSONObject(i);
                    UiBotAction attachAction = JsonUtil.objectToJavaObject(jsonObject, UiBotAction.class);
                    String serviceIdName = String.valueOf(attachAction.getServiceId().get("name"));
                    if (null != ApprovalActionNameEnum.getEnumByValue(serviceIdName)) {
                        actionServiceIdName = serviceIdName;
                        actionServiceIdNameCategory = attachAction.getCategory();
                        actionServiceIdNameAttachAction = jsonObject;
                        //只要数组中找到一组符合则直接跳出该循环
                        break;
                    }
                }
            }
        }

        if (SubmitStrategyEnum.DSL.equals(rawData.getObject("submitStrategyEnum", SubmitStrategyEnum.class))) {
            // wjw FIXME: 2023/8/16 移动设计态到运行态，提交走此逻辑
            return this.designerUniversalParsingHandle(
                    apiRequestSubmit,
                    preHandleResult);
        } else if (PcUiBotPatternUtil.isBaseData(executeCtxPattern)
                && ApprovalActionNameEnum.WORKFLOW_ABORT.getValue().equalsIgnoreCase(actionServiceIdName)
                && "workflow".equalsIgnoreCase(actionCategory)
        ) {
            // 数据录入-模型驱动-撤审按钮
            for (ActionSubmitParam submitParam : apiRequestSubmit.getSubmitParams()) {
                String type = submitParam.getType();
                // 跳过不处理
                if (Field.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    continue;
                }

                String schema = submitParam.getSchema();
                Object paramObj = submitParam.getParams();
                ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                if (null == componentParamAnalyzer) {
                    logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                            schema, JsonUtil.javaObjectToJsonString(paramObj));
                    continue;
                }
                Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
                if (InputSingleText.COMPONENT_TYPE.equalsIgnoreCase(type)
                        || InputMultiText.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    digiwinActionSubmitParasMap.put(schema, analyzedParam);
                }
            }
            JSONObject submitActionParas = rawDataAction.getJSONObject("paras");
            if (submitActionParas == null) {
                submitActionParas = new JSONObject();
            }
            for (String key : digiwinActionSubmitParasMap.keySet()) {
                submitActionParas.put(key, digiwinActionSubmitParasMap.get(key));
            }
            rawDataAction.put("paras", submitActionParas);

            Action action = new Action();
            action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            action.setSuccessMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            action.setToastMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            preHandleResult.setAction(action);
        } else if ((TaskStringUtil.isBizApproval(executeCtxPattern, executeCtxCategory)
                && (actionServiceIdName.equalsIgnoreCase(ApprovalActionNameEnum.APPROVAL_AGREE.getValue())
                || actionServiceIdName.equalsIgnoreCase(ApprovalActionNameEnum.APPROVAL_DISPATCH.getValue())
                //不同意也要输入原因，处理逻辑跟同意一样了，故添加以下两项
                || actionServiceIdName.equalsIgnoreCase(ApprovalActionNameEnum.APPROVAL_TERMINATE.getValue())
                || actionServiceIdName.equalsIgnoreCase(ApprovalActionNameEnum.APPROVAL_DISAGREE.getValue()))
                && ("WF".equalsIgnoreCase(actionCategory)
                || "ESP".equalsIgnoreCase(actionCategory)
                || "TaskEngine".equalsIgnoreCase(actionCategory))
        ) || (TaskStringUtil.isBizDataEntryDriven(executeCtxPattern, executeCtxCategory)
                && (
                ((
                        // 同意/不同意
                        ApprovalActionNameEnum.WORKFLOW_ACT_AGREE.getValue().equalsIgnoreCase(actionServiceIdName)
                                || ApprovalActionNameEnum.WORKFLOW_ACT_DISAGREE.getValue().equalsIgnoreCase(actionServiceIdName))
                        && "workflow".equalsIgnoreCase(actionServiceIdNameCategory)
                ) || ((
                        // 同意/不同意
                        ApprovalActionNameEnum.APPROVAL_AGREE.getValue().equalsIgnoreCase(actionServiceIdName)
                                || ApprovalActionNameEnum.APPROVAL_DISAGREE.getValue().equalsIgnoreCase(actionServiceIdName))
                        && "TaskEngine".equalsIgnoreCase(actionServiceIdNameCategory))
        )
        )
        ) {
            // 签核型任务-同意按钮、不同意按钮
            for (ActionSubmitParam submitParam : apiRequestSubmit.getSubmitParams()) {
                String type = submitParam.getType();
                // 跳过不处理
                if (Field.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    continue;
                }

                String schema = submitParam.getSchema();
                Object paramObj = submitParam.getParams();
                ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                if (null == componentParamAnalyzer) {
                    logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                            schema, JsonUtil.javaObjectToJsonString(paramObj));
                    continue;
                }
                Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
                if (InputSingleText.COMPONENT_TYPE.equalsIgnoreCase(type)
                        || InputMultiText.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    digiwinActionSubmitParasMap.put(schema, analyzedParam);
                }

                if (Attachment.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    UiBotAttachment uiBotAttachment = (UiBotAttachment) analyzedParam;
                    digiwinActionSubmitParasMap.put(schema, uiBotAttachment.getData());
                }

            }
            JSONObject submitActionParas = rawDataAction.getJSONObject("paras");
            if (TaskStringUtil.isBizDataEntryDriven(executeCtxPattern, executeCtxCategory)) {
                //兼容数据驱动2.0 action第一级字段没有paras，需要从action里的attachActions中取对应paras
                if (Objects.isNull(submitActionParas)) {
                    rawDataAction = actionServiceIdNameAttachAction;
                    submitActionParas = rawDataAction.getJSONObject("paras");
                }
            }
            if (submitActionParas == null) {
                submitActionParas = new JSONObject();
            }
            for (String key : digiwinActionSubmitParasMap.keySet()) {
                submitActionParas.put(key, digiwinActionSubmitParasMap.get(key));
            }
            rawDataAction.put("paras", submitActionParas);

            Action action = new Action();
            action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            action.setSuccessMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            action.setToastMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            preHandleResult.setAction(action);

            if (ApprovalActionNameEnum.APPROVAL_DISAGREE.getValue().equalsIgnoreCase(actionServiceIdName)
                    && PcmFilterUtil.isPcmCustomized(executeCtxTmActivityId, executeCtxTmProjectId)) {
                // PCM_项目预算签核定制  不同意按钮额外逻辑处理
                PcUiBotExecuteContext executeContext = JsonUtil.objectToJavaObject(rawDataAction.get("executeContext"), PcUiBotExecuteContext.class);
                CompletableFuture.runAsync(() -> this.customizePcmBudgetProjectApprovals(executeContext), threadPoolTaskExecutor);
            }

//        } else if (TaskStringUtil.isBizApproval(executeCtxPattern, executeCtxCategory)
//                && ("athena_bpm_disagree".equalsIgnoreCase(actionId)
//                || "disagree".equalsIgnoreCase(actionServiceIdName))
//                && ("WF".equalsIgnoreCase(actionCategory) || "TaskEngine".equalsIgnoreCase(actionCategory))
//        ) {
//            // 签核型任务-拒绝/终止

        } /*else if (TaskStringUtil.isBizApproval(executeCtxPattern, executeCtxCategory)
                && ("reapprove".equalsIgnoreCase(actionId)
                || "athena_bpm_reapprove".equalsIgnoreCase(actionId)
                || "reapprove".equalsIgnoreCase(actionServiceIdName))
                && ("WF".equalsIgnoreCase(actionCategory) || "TaskEngine".equalsIgnoreCase(actionCategory))
        )*/ else if (
                (TaskStringUtil.isBizApproval(executeCtxPattern, executeCtxCategory)
                        && actionServiceIdName.equalsIgnoreCase(ApprovalActionNameEnum.APPROVAL_REAPPROVE.getValue())
                        && (
                        "WF".equalsIgnoreCase(actionCategory)
                                || "TaskEngine".equalsIgnoreCase(actionCategory))
                ) || (TaskStringUtil.isBizDataEntryDriven(executeCtxPattern, executeCtxCategory)
                        && (
                        (ApprovalActionNameEnum.WORKFLOW_ACT_RETURN.getValue().equalsIgnoreCase(actionServiceIdName)
                                && "workflow".equalsIgnoreCase(actionServiceIdNameCategory)
                        ) || (ApprovalActionNameEnum.APPROVAL_REAPPROVE.getValue().equalsIgnoreCase(actionServiceIdName)
                                && "TaskEngine".equalsIgnoreCase(actionServiceIdNameCategory))
                )
                )
        ) {
            // 签核型任务-退回重签
            for (ActionSubmitParam submitParam : apiRequestSubmit.getSubmitParams()) {
                String type = submitParam.getType();
                // 跳过不处理
                if (Field.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    continue;
                }

                String schema = submitParam.getSchema();
                Object paramObj = submitParam.getParams();
                ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                if (null == componentParamAnalyzer) {
                    logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                            schema, JsonUtil.javaObjectToJsonString(paramObj));
                    continue;
                }
                Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
                if (InputSingleText.COMPONENT_TYPE.equalsIgnoreCase(type)
                        || InputMultiText.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    digiwinActionSubmitParasMap.put(schema, analyzedParam);
                } else if (ChooseTaskProgress.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    digiwinActionSubmitParasMap.put(schema, analyzedParam);
                }

                if (Attachment.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    UiBotAttachment uiBotAttachment = (UiBotAttachment) analyzedParam;
                    digiwinActionSubmitParasMap.put(schema, uiBotAttachment.getData());
                }

            }
            JSONObject submitActionParas = rawDataAction.getJSONObject("paras");
            //兼容数据驱动2.0退回action第一级字段没有paras，需要从action里的attachActions中取对应paras
            if (Objects.isNull(submitActionParas)) {
                submitActionParas = actionServiceIdNameAttachAction.getJSONObject("paras");
            }
            for (String key : digiwinActionSubmitParasMap.keySet()) {
                submitActionParas.put(key, digiwinActionSubmitParasMap.get(key));
                if ("taskId".equalsIgnoreCase(key)) {
                    //兼容任务引擎
                    submitActionParas.put("activityId", digiwinActionSubmitParasMap.get(key));
                }
            }

            Action action = new Action();
            action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            action.setSuccessMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            action.setToastMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            preHandleResult.setAction(action);
        } /*else if (TaskStringUtil.isBizApproval(executeCtxPattern, executeCtxCategory)
                && ("esp_fields.value.update".equalsIgnoreCase(actionId)
                || "esp_po.temp.modify.process".equalsIgnoreCase(actionId)
                || "esp_task.info.update".equalsIgnoreCase(actionId)
                || "reexecute".equalsIgnoreCase(actionServiceIdName)
                || "esp_purchase.change.info.update".equalsIgnoreCase(actionId))
                && ("ESP".equalsIgnoreCase(actionCategory) || "TaskEngine".equalsIgnoreCase(actionCategory))
        ) */ else if (TaskStringUtil.isBizApproval(executeCtxPattern, executeCtxCategory)
                && actionServiceIdName.equalsIgnoreCase(ApprovalActionNameEnum.APPROVAL_REEXECUTE.getValue())
                && ("ESP".equalsIgnoreCase(actionCategory) || "TaskEngine".equalsIgnoreCase(actionCategory))
        ) {
            // 签核型任务-退回重办
            for (ActionSubmitParam submitParam : apiRequestSubmit.getSubmitParams()) {
                String type = submitParam.getType();
                // 跳过不处理
                if (Field.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    continue;
                }

                String schema = submitParam.getSchema();
                Object paramObj = submitParam.getParams();
                ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                if (null == componentParamAnalyzer) {
                    logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                            schema, JsonUtil.javaObjectToJsonString(paramObj));
                    continue;
                }
                Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
                if (InputSingleText.COMPONENT_TYPE.equalsIgnoreCase(type)
                        || InputMultiText.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    digiwinActionSubmitParasMap.put(schema, analyzedParam);
                }

                if (Attachment.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    UiBotAttachment uiBotAttachment = (UiBotAttachment) analyzedParam;
                    digiwinActionSubmitParasMap.put(schema, uiBotAttachment.getData());
                }

                JSONObject submitActionParas = rawDataAction.getJSONObject("paras");
                if (submitActionParas == null) {
                    submitActionParas = new JSONObject();
                }
                for (String key : digiwinActionSubmitParasMap.keySet()) {
                    submitActionParas.put(key, digiwinActionSubmitParasMap.get(key));
                }
                rawDataAction.put("paras", submitActionParas);
            }
            JSONArray submitAttachActions = rawDataAction.getJSONArray("attachActions");
            for (int i = 0; i < submitAttachActions.size(); i++) {
                JSONObject attachAction = submitAttachActions.getJSONObject(i);
                Map<String, Object> serivceId = (Map<String, Object>) attachAction.get("serviceId");
                String name = (String) serivceId.get("name");
                String newActionId = (String) attachAction.get("actionId");
                Map<String, Object> extendedFields = (Map<String, Object>) attachAction.get("extendedFields");
                if (newActionId.toLowerCase().contains("reexecute") ||
                        (StringUtils.hasLength(name) && name.toLowerCase().contains("reexecute")) ||
                        ((extendedFields != null && extendedFields.size() > 0 && extendedFields.containsKey("reexecute"))
                        )) {
                    JSONObject attachActionParas = attachAction.getJSONObject("paras");
                    for (String key : digiwinActionSubmitParasMap.keySet()) {
                        attachActionParas.put(key, digiwinActionSubmitParasMap.get(key));
                    }
                    rawDataAction.put("paras", attachActionParas);
                }
            }

            Action action = new Action();
            action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            action.setSuccessMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            action.setToastMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            preHandleResult.setAction(action);
        } /*else if (TaskStringUtil.isBizApproval(executeCtxPattern, executeCtxCategory)
                && ("reassign".equalsIgnoreCase(actionId)
                || "athena_bpm_reassign".equalsIgnoreCase(actionId))
                && ("WF".equalsIgnoreCase(actionCategory) || "TaskEngine".equalsIgnoreCase(actionCategory))
        )*/ else if (
                (TaskStringUtil.isBizApproval(executeCtxPattern, executeCtxCategory)
                        && actionServiceIdName.equalsIgnoreCase(ApprovalActionNameEnum.APPROVAL_REASSIGN.getValue())
                        && ("WF".equalsIgnoreCase(actionCategory) || "TaskEngine".equalsIgnoreCase(actionCategory))
                ) || (
                        // 数据转派
                        "data-reassignment-action".equalsIgnoreCase(actionId)
                                && ("UIBOT".equalsIgnoreCase(actionCategory)))
        ) {
            // 签核型任务-转派
            for (ActionSubmitParam submitParam : apiRequestSubmit.getSubmitParams()) {
                String type = submitParam.getType();
                // 跳过不处理
                if (Field.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    continue;
                }

                String schema = submitParam.getSchema();
                Object paramObj = submitParam.getParams();
                ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                if (null == componentParamAnalyzer) {
                    logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                            schema, JsonUtil.javaObjectToJsonString(paramObj));
                    continue;
                }
                Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
                if (InputSingleText.COMPONENT_TYPE.equalsIgnoreCase(type)
                        || InputMultiText.COMPONENT_TYPE.equalsIgnoreCase(type)
                        || InputSingleSelect.COMPONENT_TYPE.equalsIgnoreCase(type)
                        || InputWindowSingleSelect.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    digiwinActionSubmitParasMap.put(schema, analyzedParam);
                } else {

                }
            }
            JSONObject submitActionParas = rawDataAction.getJSONObject("paras");
            if (submitActionParas == null) {
                submitActionParas = new JSONObject();
            }
            for (String key : digiwinActionSubmitParasMap.keySet()) {
                submitActionParas.put(key, digiwinActionSubmitParasMap.get(key));
            }
            rawDataAction.put("paras", submitActionParas);

            Action action = new Action();
            // 数据转派
            if ("data-reassignment-action".equalsIgnoreCase(actionId) && ("UIBOT".equalsIgnoreCase(actionCategory))) {
                action.setType(ActionTypeEnum.BACK_TWO_WITH_REFRESH.getValue());
            } else {
                action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            }
            action.setSuccessMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            action.setToastMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            preHandleResult.setAction(action);
        } /*else if (TaskStringUtil.isBizApproval(executeCtxPattern, executeCtxCategory)
                && ("add-task".equalsIgnoreCase(actionId)
                || "athena_bpm_add_task".equalsIgnoreCase(actionId))
                && ("WF".equalsIgnoreCase(actionCategory) || "TaskEngine".equalsIgnoreCase(actionCategory))
        )*/ else if (
                (TaskStringUtil.isBizApproval(executeCtxPattern, executeCtxCategory)
                        && actionServiceIdName.equalsIgnoreCase(ApprovalActionNameEnum.APPROVAL_ADD_TASK.getValue())
                        && (
                        "WF".equalsIgnoreCase(actionCategory)
                                || "TaskEngine".equalsIgnoreCase(actionCategory))
                ) || (TaskStringUtil.isBizDataEntryDriven(executeCtxPattern, executeCtxCategory)
                        // 加签
                        && (
                        (ApprovalActionNameEnum.WORKFLOW_ACT_ADD.getValue().equalsIgnoreCase(actionServiceIdName)
                                && "workflow".equalsIgnoreCase(actionCategory)
                        ) || (ApprovalActionNameEnum.APPROVAL_ADD_TASK.getValue().equalsIgnoreCase(actionServiceIdName)
                                && "TaskEngine".equalsIgnoreCase(actionCategory)))
                )
        ) {
            // 签核型任务-加签
            for (ActionSubmitParam submitParam : apiRequestSubmit.getSubmitParams()) {
                String type = submitParam.getType();
                // 跳过不处理
                if (Field.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    continue;
                }

                String schema = submitParam.getSchema();
                Object paramObj = submitParam.getParams();
                ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                if (null == componentParamAnalyzer) {
                    logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                            schema, JsonUtil.javaObjectToJsonString(paramObj));
                    continue;
                }
                Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
                if (InputSingleText.COMPONENT_TYPE.equalsIgnoreCase(type)
                        || InputMultiText.COMPONENT_TYPE.equalsIgnoreCase(type)
                        || InputSingleSelect.COMPONENT_TYPE.equalsIgnoreCase(type)
                        || InputWindowSingleSelect.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    digiwinActionSubmitParasMap.put(schema, analyzedParam);
                }

                if (Attachment.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    UiBotAttachment uiBotAttachment = (UiBotAttachment) analyzedParam;
                    digiwinActionSubmitParasMap.put(schema, uiBotAttachment.getData());
                }

            }
            JSONObject submitActionParas = rawDataAction.getJSONObject("paras");
            for (String key : digiwinActionSubmitParasMap.keySet()) {
                if (!"performers".equalsIgnoreCase(key)) {
                    submitActionParas.put(key, digiwinActionSubmitParasMap.get(key));
                }
            }
            //流程引擎
            JSONArray taskList = submitActionParas.getJSONArray("taskList");
            if (!CollectionUtils.isEmpty(taskList)) {
                taskList.getJSONObject(0)
                        .put("addType", digiwinActionSubmitParasMap.get("addType"));
                taskList.getJSONObject(0)
                        .put("performers", digiwinActionSubmitParasMap.get("performers"));
            }
            //任务引擎
            JSONArray activities = submitActionParas.getJSONArray("activities");
            if (!CollectionUtils.isEmpty(activities)) {
                // activities里的addType需要变成选中的前置还是后置类型
                activities.getJSONObject(0)
                        .put("addType", digiwinActionSubmitParasMap.get("addType"));
                activities.getJSONObject(0)
                        .put("performerIds", digiwinActionSubmitParasMap.get("performers"));
            }

            Action action = new Action();
            action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            action.setSuccessMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            action.setToastMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            preHandleResult.setAction(action);
        } else if (
                ((TaskStringUtil.isBizReport(executeCtxPattern, executeCtxCategory)
                        || TaskStringUtil.isSscEmployeeInduction(executeCtxTmProjectId, executeCtxTmActivityId)
                        // FIXME 因PCC项目中控台 进度回报任务（手动报工任务）在使用任务引擎之后，也是BizProcess类型，故写在这边做兼容处理
                        || TaskStringUtil.isBizProcess(executeCtxPattern, executeCtxCategory))
                        && BottomButtonBizReportBuilder.BUTTON_MAP.containsKey(actionId)
                        && "ESP".equalsIgnoreCase(actionCategory)
                ) || MobileLayoutTypeEnum.SINGLE_PATTERN_LAYOUT.equals(mobileLayoutTypeEnum)
        ) {
            // 从rawData清除当前移动端画面布局信息，保证后续提交时rawData是干净的
            rawData.remove("mobileLayoutType");
            // 回报型任务-提交
            // 回报型任务的提交是录入，所以提交的数据需要更新到原始数据中相同的字段内
            for (ActionSubmitParam submitParam : apiRequestSubmit.getSubmitParams()) {

                String type = submitParam.getType();
                // 跳过不处理
                if (Field.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    continue;
                }
                String schema = submitParam.getSchema();
                Object paramObj = submitParam.getParams();
                if (Attachment.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    Attachment attachment = (Attachment) paramObj;
                    UiBotAttachment uiBotAttachment;
                    // PCC手动任务-文件删除是通过delete状态来，所以不能过滤到delete状态的文件
                    if (PCC_TASK_ACTION_ID.equalsIgnoreCase(actionId)) {
                        uiBotAttachment = attachment.parseToUiBotAttachmentNotFilterDelete(attachment, digiwinDmcProxyService);
                    } else {
                        uiBotAttachment = attachment.parseToUiBotAttachment(attachment, digiwinDmcProxyService);
                    }
                    uiBotAttachment.getData().forEach(attachmentData -> {
                        attachmentData.setTenantId(actionServiceIdTenantId);
                        attachmentData.setProjectId(executeCtxTmProjectId);
                        attachmentData.setTaskId(executeCtxTmActivityId);
                    });
                    digiwinActionSubmitParasMap.put(schema, uiBotAttachment);
                } else if ("esp_uc.task.info.update".equalsIgnoreCase(actionId) && InputSwitch.COMPONENT_TYPE.equals(type)) {
                    //Fixme 乾冶参数解析客制
                    InputSwitch inputSwitch = (InputSwitch) paramObj;
                    if (inputSwitch.getSwitchState() == 0) {
                        digiwinActionSubmitParasMap.put(schema, false);
                    } else {
                        digiwinActionSubmitParasMap.put(schema, true);
                    }
                } else {
                    ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                    if (null == componentParamAnalyzer) {
                        logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                                schema, JsonUtil.javaObjectToJsonString(paramObj));
                        continue;
                    }
                    Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
                    if (analyzedParam instanceof Map) {
                        digiwinActionSubmitParasMap.putAll((Map<? extends String, ?>) analyzedParam);
                    } else {
                        // 提交内容暂存下来
                        digiwinActionSubmitParasMap.put(schema, analyzedParam);
                    }
                }
            }
            /**
             * 因提交的整体数据结构如下，故变量命名有些长：
             * {
             *     "action":{
             *         ...
             *         "submitType":{
             *             "isBatch": true,
             *             "schema": "project_info",
             *             "submitAll": false
             *         }
             *         ...
             *     },
             *     "data":{
             *         "project_info":[
             *             {},
             *             ...
             *         ]
             *     }
             * }
             */
            JSONObject submitActionSubmitType = rawDataAction.getJSONObject("submitType");
            String rawDataDataSchema = submitActionSubmitType.getString("schema");

            if (!rawDataData.containsKey(rawDataDataSchema)) {
                preHandleResult.setActionFound(!actionFound);
                return preHandleResult;
            }

            if (rawDataData.get(rawDataDataSchema) instanceof List) {
                JSONArray rawDataDataSchemaData = rawDataData.getJSONArray(rawDataDataSchema);
                // 针对每一笔数据，将暂存下来的字段录入数据更新进去
                for (int i = 0; i < rawDataDataSchemaData.size(); i++) {
                    JSONObject schemaData = rawDataDataSchemaData.getJSONObject(i);
                    for (String key : digiwinActionSubmitParasMap.keySet()) {
                        schemaData.put(key, digiwinActionSubmitParasMap.get(key));
                    }
                }
            } else if (rawDataData.get(rawDataDataSchema) instanceof Map) {
                JSONObject schemaData = rawDataData.getJSONObject(rawDataDataSchema);
                for (String key : digiwinActionSubmitParasMap.keySet()) {
                    schemaData.put(key, digiwinActionSubmitParasMap.get(key));
                }
            }

            // FIXME 临时解法，待平台任务引擎机制更新后，即可去除以下设置阻塞的逻辑
            preHandleResult.setNeedBlockResponseAfterSubmitSuccess(true);
            /**
             * FIXME 临时解法做调整：因原来3000毫秒太长，用户感觉像超时一样卡住，影响操作；
             * 且询问平台SD和小AI的人后，发现原来的机制还是有可能出现时间差，导致提交完成但任务卡未关闭。
             * 所以先减少为1500毫秒的等待，观察效果。
             * 参考bug：https://athena-devops-zentao.digiwincloud.com.cn/bug-view-99108.html
             */
            preHandleResult.setNeedBlockResponseMilliseconds(1500L);

        } else if (TaskStringUtil.isBizProcess(executeCtxPattern, executeCtxCategory)
                && "esp_wo.status.info.update".equalsIgnoreCase(actionId) && "ESP".equalsIgnoreCase(
                actionCategory)
        ) {

            // 通用处理型任务-提交
            // 通用处理型任务的提交是录入，所以提交的数据需要更新到原始数据中相同的字段内。

            // 提交的内容可能是多笔，所以需要按提交参数中的数据ID分组处理
            Map<String, List<ActionSubmitParam>> submitParamsGroupedById =
                    apiRequestSubmit.getSubmitParams().stream()
                            .collect(Collectors.groupingBy(ActionSubmitParam::getId));

            JSONObject submitActionSubmitType = rawDataAction.getJSONObject("submitType");
            String rawDataDataSchema = submitActionSubmitType.getString("schema");

            if (!rawDataData.containsKey(rawDataDataSchema)) {
                preHandleResult.setActionFound(!actionFound);
                return preHandleResult;
            }

            JSONArray rawDataDataSchemaData = rawDataData.getJSONArray(rawDataDataSchema);
            // 针对每一笔DATA_KEY与id匹配的原始数据，将暂存下来的字段值更新进去，并删除不在提交内的数据项
            Iterator<Object> iterator = rawDataDataSchemaData.iterator();
            while (iterator.hasNext()) {
                Map<String, Object> schemaData = (Map<String, Object>) iterator.next();
                String schemaDataKey = (String) schemaData.get("__DATA_KEY");
                // 原始数据的DATA_KEY与提交的ID匹配
                if (submitParamsGroupedById.containsKey(schemaDataKey)) {
                    schemaData.put("uibot_checked", true);
                    List<ActionSubmitParam> groupedSubmitParams =
                            submitParamsGroupedById.get(schemaDataKey);
                    for (ActionSubmitParam groupedSubmitParam : groupedSubmitParams) {
                        String type = groupedSubmitParam.getType();
                        // 跳过不处理
                        if (Field.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                            continue;
                        }

                        String schema = groupedSubmitParam.getSchema();
                        Object paramObj = groupedSubmitParam.getParams();
                        ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                        if (null == componentParamAnalyzer) {
                            logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                                    schema, JsonUtil.javaObjectToJsonString(paramObj));
                            continue;
                        }
                        Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
                        // 提交内容暂存下来
                        digiwinActionSubmitParasMap.put(schema, analyzedParam);
                    }

                    for (String key : digiwinActionSubmitParasMap.keySet()) {
                        schemaData.put(key, digiwinActionSubmitParasMap.get(key));
                    }
                } else {
                    // 原始数据的DATA_KEY与提交的ID不匹配
                    iterator.remove();
                }
                digiwinActionSubmitParasMap.clear();
            }
        } else if ("sd_manual.project.create".equalsIgnoreCase(actionId)
                && "MANUALPROJECT_NEW".equalsIgnoreCase(actionCategory)
        ) {
            //发起项目--项目备案、问题快反
            //先处理单选类组件
            List<ActionSubmitParam> submitParamList = apiRequestSubmit.getSubmitParams();
            submitParamList.stream().forEach(submitParam -> {
                if (InputWindowSingleSelect.COMPONENT_TYPE.equalsIgnoreCase(submitParam.getType())) {
                    InputWindowSingleSelect windowSingleSelect = (InputWindowSingleSelect) submitParam.getParams();
                    if (windowSingleSelect.getDetail() != null) {
                        digiwinActionSubmitParasMap.putAll(windowSingleSelect.getDetail());
                    }
                }
            });
            for (ActionSubmitParam submitParam : apiRequestSubmit.getSubmitParams()) {
                String type = submitParam.getType();
                if (InputWindowSingleSelect.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    continue;
                }
                String schema = submitParam.getSchema();
                Object paramObj = submitParam.getParams();
                ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                if (null == componentParamAnalyzer) {
                    logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                            schema, JsonUtil.javaObjectToJsonString(paramObj));
                    continue;
                }
                Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
                if (Picture.COMPONENT_TYPE.equalsIgnoreCase(submitParam.getType()) && analyzedParam != null) {
                    UiBotAttachment uiBotAttachment = (UiBotAttachment) analyzedParam;
                    List<UiBotAttachmentData> attachmentDataList = uiBotAttachment.getData();
                    if (attachmentDataList != null && !attachmentDataList.isEmpty()) {
                        List<Map<String, Object>> dataList = new ArrayList<>();
                        for (UiBotAttachmentData attachmentData : attachmentDataList) {
                            Map<String, Object> map = new HashMap<>();
                            map.put("picture_id", attachmentData.getId());
                            dataList.add(map);
                        }
                        analyzedParam = dataList;
                    }
                }
                // 提交内容暂存下来
                digiwinActionSubmitParasMap.put(schema, analyzedParam);
                //客户选择栏位需要传客户id与客户名称，故单选先这样处理下（以上InputWindowSingleSelect已处理该逻辑）
//                if (InputWindowSingleSelect.COMPONENT_TYPE.equalsIgnoreCase(type)) {
//                    InputWindowSingleSelect select = (InputWindowSingleSelect) paramObj;
//                    Map<String, Object> detail = select.getDetail();
//                    if (detail != null) {
//                        if (detail.containsKey("customer_no")) {
//                            digiwinActionSubmitParasMap.put("customer_no",
//                                    detail.get("customer_no"));
//                        }
//                        if (detail.containsKey("customer_name")) {
//                            digiwinActionSubmitParasMap.put("customer_name",
//                                    detail.get("customer_name"));
//                        }
//                    }
//                }
            }

            if ("athena_questionAnswer_create".equalsIgnoreCase(executeCtxTmActivityId)) {
                List<Map<String, Object>> questionSourceInfoList = (List<Map<String, Object>>) MapUtil.getOrDefault(digiwinActionSubmitParasMap, "question_source_info", Collections.emptyList());
                if (!CollectionUtils.isEmpty(questionSourceInfoList)) {
                    digiwinActionSubmitParasMap.putAll(questionSourceInfoList.get(0));
                    digiwinActionSubmitParasMap.put("question_source_oid", questionSourceInfoList.get(0).get("question_source_id"));
                }
            }

            JSONObject submitActionSubmitType = rawDataAction.getJSONObject("submitType");
            String rawDataDataSchema = submitActionSubmitType.getString("schema");
            if (!rawDataData.containsKey(rawDataDataSchema)) {
                preHandleResult.setActionFound(!actionFound);
                return preHandleResult;
            }
            JSONObject rawDataDataSchemaData = rawDataData.getJSONObject(rawDataDataSchema);
            for (String key : digiwinActionSubmitParasMap.keySet()) {
                rawDataDataSchemaData.put(key, digiwinActionSubmitParasMap.get(key));
            }
            logger.debug("rawDataDataSchemaData is {}", rawDataDataSchemaData.toJSONString());
            digiwinActionSubmitParasMap.clear();
        } else if ("esp_upload.attendance.result.confirm.attachment.process".equalsIgnoreCase(actionId)
                && "ESP".equalsIgnoreCase(actionCategory)
        ) {
            // SSC应用 考勤确认任务
            JSONObject submitActionSubmitType = rawDataAction.getJSONObject("submitType");
            String rawDataDataSchema = submitActionSubmitType.getString("schema");
            if (!rawDataData.containsKey(rawDataDataSchema)) {
                preHandleResult.setActionFound(!actionFound);
                return preHandleResult;
            }
            JSONArray rawDataDataSchemaData = rawDataData.getJSONArray(rawDataDataSchema);

            // FIXME 考勤确认只有一笔数据，所以可以这样做。
            Iterator<Object> iterator = rawDataDataSchemaData.iterator();
            while (iterator.hasNext()) {
                Map<String, Object> schemaData = (Map<String, Object>) iterator.next();
                String schemaDataKey = (String) schemaData.get("__DATA_KEY");
                for (ActionSubmitParam submitParam : apiRequestSubmit.getSubmitParams()) {
                    String type = submitParam.getType();
                    String schema = submitParam.getSchema();
                    Object paramObj = submitParam.getParams();
                    ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                    if (null == componentParamAnalyzer) {
                        logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                                schema, JsonUtil.javaObjectToJsonString(paramObj));
                        continue;
                    }
                    Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
                    if (InputSign.COMPONENT_TYPE.equalsIgnoreCase(type)
                            || InputHidden.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                        String base64Content = (String) analyzedParam;
                        AttachmentMessage aamAttachmentParam =
                                this.buildAttachmentMessageInAamForEmployeeAttendanceConfirm(
                                        base64Content, apiRequestSubmit, actionServiceIdTenantId,
                                        schemaDataKey);
                        if (null != aamAttachmentParam) {
                            // 提交的图片base64上传到dmc后，转换为Attachment对象后，暂存下来
                            digiwinActionSubmitParasMap.put(schema, aamAttachmentParam);
                        }
                    } else {
                        // 提交内容暂存下来
                        digiwinActionSubmitParasMap.put(schema, analyzedParam);
                    }
                }

                for (String key : digiwinActionSubmitParasMap.keySet()) {
                    schemaData.put(key, digiwinActionSubmitParasMap.get(key));
                }
                digiwinActionSubmitParasMap.clear();
            }
        } else if (TaskStringUtil.isZhilinkBarCodePrint(executeCtxTmProjectId, executeCtxTmActivityId)
                && "esp_zhilink.wo.info.update".equalsIgnoreCase(actionId)
                && "ESP".equalsIgnoreCase(actionCategory)
        ) {
            // 智互联 打印标签任务
            // 需要将rawDataData.wo_data数组，替换为rawDataData.wo_data.wo_data数组
            // wo_data这个schema名称，从action中动态获取
            JSONArray schemaDataArray = rawDataData.getJSONArray(actionSubmitTypeSchema);
            JSONArray newSchemaDataArray = new JSONArray();
            for (int i = 0; i < schemaDataArray.size(); i++) {
                JSONObject schemaDataArrayItem = schemaDataArray.getJSONObject(i);
                JSONArray schemaDataArrayItemDetailArray = schemaDataArrayItem.getJSONArray(actionSubmitTypeSchema);
                for (int j = 0; j < schemaDataArrayItemDetailArray.size(); j++) {
                    JSONObject schemaDataArrayItemDetailArrayItem = schemaDataArrayItemDetailArray.getJSONObject(j);
                    newSchemaDataArray.add(schemaDataArrayItemDetailArrayItem);
                }
            }
            rawDataData.put(actionSubmitTypeSchema, newSchemaDataArray);

        } else if (TaskStringUtil.isZhilinkBarCodePaste(executeCtxTmProjectId, executeCtxTmActivityId)
                && "submit-data".equalsIgnoreCase(actionId) && "TaskEngine".equalsIgnoreCase(
                actionCategory)
        ) {
            // 智互联 扫码粘贴任务
            // 要先通过ATDM更新工单信息。若更新失败，则提交中止；若更新成功，没有其他步骤，直接提交到ATMC即可
            boolean updateResult =
                    this.zhilinkService.updateWoInfoBeforeSubmitToAtmcInPasteTask(apiRequestSubmit);
            if (!updateResult) {
                logger.debug(
                        "updateWoInfoBeforeSubmitToAtmcInPasteTask returned false...commit action aborted...");
                actionFound = false;
            }

        } else if (TaskStringUtil.isZhilinkBarCodeCheckout(executeCtxTmProjectId, executeCtxTmActivityId)
                && "submit-data".equalsIgnoreCase(actionId) && "TaskEngine".equalsIgnoreCase(
                actionCategory)
        ) {
            // 智互联 扫码出厂任务
            // 要先通过ATDM更新工单信息。若更新失败，则提交中止；若更新成功，没有其他步骤，直接提交到ATMC即可
            boolean updateResult =
                    this.zhilinkService.updateWoInfoBeforeSubmitToAtmcInCheckoutTask(apiRequestSubmit);
            if (!updateResult) {
                logger.debug(
                        "updateWoInfoBeforeSubmitToAtmcInCheckoutTask returned false...commit action aborted...");
                actionFound = false;
            }
        } else if (TaskStringUtil.isCustomProcess(executeCtxPattern, executeCtxCategory)
                && ("submit-data".equalsIgnoreCase(actionId)
                || "submit-data".equalsIgnoreCase(actionServiceIdName))
                && ("PTM".equalsIgnoreCase(actionCategory))) {
            // 班组派工
            if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_TEAM_DISPATCH.toString().equalsIgnoreCase(rawData.getString("pageId"))) {
                return uiBotModelBuildApcTeamDispatchStrategy.actionBeforeSubmit(apiRequestSubmit);
            }
            //APC装配进度控制应用：工时回报，人员下线按钮，提交
            preHandleResult.setActionFound(true);
            return preHandleResult;
        } else if (TaskStringUtil.isBusinessReply(executeCtxPattern, executeCtxCategory)
                && "esp_ca.cim.issue.notice.info.update".equalsIgnoreCase(actionId)
                && "ESP".equalsIgnoreCase(actionCategory)) {
            // 领料通知
            preHandleResult.setActionFound(true);
            return preHandleResult;
        } else if (TaskStringUtil.isOutSourceReport(executeCtxTmProjectId, executeCtxTmActivityId)
                && "submit-data".equalsIgnoreCase(actionId)
                && "PTM".equalsIgnoreCase(actionCategory)) {

            String proxyToken = Optional.ofNullable(rawDataAction).map(e -> (Map<String, Object>) e.get("executeContext")).map(e -> (String) e.get("proxyToken")).orElse("");
            rawData.put("digi-proxy-token", proxyToken);
            // 委外报工
            String locale = apiRequestSubmit.getLocale();
            String iamUserToken = apiRequestSubmit.getIamUserToken();
            String tenantId = apiRequestSubmit.getTenantId();

            Map<String, Object> verCheckDataParams = rawData.getJSONObject("verCheckData").getInnerMap();
            DigiwinAthenaApiResponse<JSONObject> verCheckDataParamsRes = digiwinAtdmProxyService
                    .handleByActionId(locale, iamUserToken, tenantId, proxyToken, verCheckDataParams);
            if (verCheckDataParamsRes.getStatus() != 200) {
                preHandleResult.setActionFound(false);
                return preHandleResult;
            }

            Map<String, Object> detailInfoCheckDataParams = rawData.getJSONObject("detailInfoCheckData").getInnerMap();
            DigiwinAthenaApiResponse<JSONObject> detailInfoCheckDataResp = digiwinAtdmProxyService
                    .handleByActionId(locale, iamUserToken, tenantId, proxyToken, detailInfoCheckDataParams);
            if (detailInfoCheckDataResp.getStatus() != 200) {
                preHandleResult.setActionFound(false);
                return preHandleResult;
            }

            // 场内外协需要维护报工明细
            Optional reportInfo = Optional.ofNullable(detailInfoCheckDataResp.getResponse()).map(e -> e.get("report_info"));
            if (reportInfo.isPresent()) {
                List<Map<String, Object>> reportInfoList = (List<Map<String, Object>>) reportInfo.get();
                if (!CollectionUtils.isEmpty(reportInfoList)) {
                    List<String> reportTipInfoList = reportInfoList.stream().map(e -> "工单号:" + e.get("wo_no") + "工艺段编号:" + e.get("operation_section_no") + "工艺序:" + e.get("operation_seq") + "请维护报工明细").collect(Collectors.toList());
                    String reportTip = org.apache.commons.lang3.StringUtils.join(reportTipInfoList, "\n");
                    Action<Map<String, Object>> action = new Action<>();
                    action.setConfirmPop(ConfirmPop.create(localeService.getLanguageValue(locale, reportTip), true));
                    action.setType(ActionTypeEnum.SHOW_CONFIRM_POP.getValue());
                    preHandleResult.setAction(action);
                    preHandleResult.setActionFound(false);
                    return preHandleResult;
                }
            }

            // 参数值替换为提交参数里的内容
            Map<String, Object> dataMap = rawData.getJSONObject("data").getInnerMap();
            if (!CollectionUtils.isEmpty(apiRequestSubmit.getSubmitParams())) {
                List<Map<String, Object>> outsourcingReportMapList = (List<Map<String, Object>>) dataMap.get("outsourcing_report");
                if (!CollectionUtils.isEmpty(outsourcingReportMapList)) {
                    Map<String, Object> outsourcingReportMap = outsourcingReportMapList.get(0);
                    List<ActionSubmitParam> actionSubmitParamList = apiRequestSubmit.getSubmitParams();
                    Map<String, Object> paramMap = null;
                    for (ActionSubmitParam actionSubmitParam : actionSubmitParamList) {
                        if (actionSubmitParam.getSchema().equals("report_qty")) {
                            paramMap = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), Map.class);
                            outsourcingReportMap.put("report_qty", paramMap.get("text"));
                        }
                        if (actionSubmitParam.getSchema().equals("report_date")) {
                            InputCalendar inputCalendar = (InputCalendar) actionSubmitParam.getParams();
                            String reportDate = inputCalendar.getInputText();
                            if (StringUtils.hasLength(reportDate)) {
                                reportDate = reportDate.replace(".", "-");
                            }
                            outsourcingReportMap.put("report_date", reportDate);
                        }
                        if (actionSubmitParam.getSchema().equals("resource_code")) {
                            paramMap = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), Map.class);

                            //工序号
                            outsourcingReportMap.put("resource_code", paramMap.get("selectId"));

                            // 类别
                            Map<String, Object> detailMap = JsonUtil.objectToJavaObject(paramMap.get("detail"), Map.class);
                            if (detailMap != null) {
                                outsourcingReportMap.put("work_procedure_type", detailMap.get("work_procedure_type"));
                            }
                        }
                        if (actionSubmitParam.getSchema().equals("shift_no") || actionSubmitParam.getSchema().equals("others_qty")) {
                            paramMap = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), Map.class);
                            outsourcingReportMap.put(actionSubmitParam.getSchema(), paramMap.get("text"));
                        }
                    }
                }
            }

            Map<String, Object> reportInfoUpdateDataParams = rawData.getJSONObject("reportInfoUpdateData").getInnerMap();
            reportInfoUpdateDataParams.put("parameter", dataMap);

            DigiwinAthenaApiResponse<JSONObject> reportInfoUpdateDataResp = digiwinAtdmProxyService
                    .handleByActionId(locale, iamUserToken, tenantId, proxyToken, reportInfoUpdateDataParams);
            if (reportInfoUpdateDataResp.getStatus() != 200) {
                preHandleResult.setActionFound(false);
                return preHandleResult;
            }

            preHandleResult.setActionFound(true);
            return preHandleResult;

        } else if (("wo.op.report.progress.info.process".equalsIgnoreCase(actionServiceIdName))
                && ("apc_ProgressToSubmit".equalsIgnoreCase(rawData.getString("type"))
                || "ESP".equalsIgnoreCase(actionCategory))) {
            //APC装配进度控制应用：进度回报，进度提交按钮，提交
            String locale = apiRequestSubmit.getLocale();
            String iamUserToken = apiRequestSubmit.getIamUserToken();
            Map<String, Object> requestParams = rawData.getJSONObject("extendFields").getInnerMap();
            String tenantId = apiRequestSubmit.getTenantId();

            List<ActionSubmitParam> submitParamList = JsonUtil.objectToJavaObject(apiRequestSubmit.getSubmitParams(), new TypeReference<List<ActionSubmitParam>>() {
            });

            List<Map<String, Object>> woOpReportDataByDataField = (List<Map<String, Object>>) MapUtil.getOrDefault(rawDataData, "wo_op_report_data", Collections.emptyList());
            if (!CollectionUtils.isEmpty(woOpReportDataByDataField)) {
                // 处理进度百分比和备注信息
                handleRemarkDetail(submitParamList, woOpReportDataByDataField.get(0));
            }

            if (!ObjectUtils.isEmpty(requestParams.get("parameter"))) {
                Map<String, Object> parameter = (Map<String, Object>) requestParams.get("parameter");
                if (!ObjectUtils.isEmpty(parameter)) {
                    List<Map<String, Object>> woOpReportDataByExtendFields = (List<Map<String, Object>>) parameter.get("wo_op_report_data");
                    if (!CollectionUtils.isEmpty(woOpReportDataByExtendFields)) {
                        // 处理进度百分比和备注信息
                        handleRemarkDetail(submitParamList, woOpReportDataByExtendFields.get(0));

                        Map<String, String> businessUnit = new HashMap<>(2);
                        businessUnit.put("eoc_company_id", String.valueOf(woOpReportDataByExtendFields.get(0).get("eoc_company_id")));
                        businessUnit.put("eoc_site_id", String.valueOf(woOpReportDataByExtendFields.get(0).get("eoc_site_id")));
                        requestParams.put("businessUnit", businessUnit);
                    }
                }
            }
            DigiwinAthenaApiResponse<JSONObject> apiResponse = digiwinAtdmProxyService
                    .projectScheduleSubmin(locale, iamUserToken, requestParams, tenantId);

//            //这边是因为web端进度回报定制画面，提交的时候category值由apc_ProgressToSubmit变成了ESP，故在这边重新赋值，以确保提交成功
//            rawDataAction.put("category", "ESP");

            JSONArray woOpReportAbnormals = apiResponse.getResponse().getJSONArray("wo_op_report_abnormal");
            if (CollectionUtils.isEmpty(woOpReportAbnormals)) {

                //进度回报按钮调用submit接口，参数封装
                List<Map<String, Object>> dataMap = (List<Map<String, Object>>) rawDataData.get("wo_op_report_data");
                Map<String, Object> objectMap = dataMap.get(0);
                List<Map<String, Object>> woOpReportData = (List<Map<String, Object>>) apiResponse.getResponse().get("wo_op_report_data");
                if (!CollectionUtils.isEmpty(woOpReportData)) {
                    Map<String, Object> woOpReportDataMap = woOpReportData.get(0);
                    for (String s : woOpReportDataMap.keySet()) {
                        objectMap.put(s, woOpReportDataMap.get(s));
                    }
                    if (!ObjectUtils.isEmpty(woOpReportDataMap.get("is_warehousing")) && (boolean) woOpReportDataMap.get("is_warehousing")) {
                        List<Map<String, Object>> data = (List<Map<String, Object>>) woOpReportDataMap.get("production_stock_in_application_data");
                        Map<String, Object> map = data.get(0);
                        for (String s : map.keySet()) {
                            objectMap.put(s, map.get(s));
                        }
                    }
                }

                Integer total = rawData.getInteger("total");
                // 总数为1
                if (Integer.valueOf(1).equals(total)) {
                    // 获取提交进度100
                    Integer progressPercentage = rawData.getJSONObject("extendFields").getJSONObject("parameter")
                            .getJSONArray("wo_op_report_data").getJSONObject(0)
                            .getInteger("progress_percentage");
                    if (Integer.valueOf(100).equals(progressPercentage)) {
                        // 总数为1且提交进度100，则提交成功后跳转到首页并刷新
                        final Action<Map<String, Object>> action = new Action<>();
                        action.setType(ActionTypeEnum.BACK_INDEX_WITH_REFRESH.getValue());
                        action.setSuccessMsg(localeService.getLanguageValue(locale, "提交成功"));
                        action.setToastMsg(localeService.getLanguageValue(locale, "提交成功"));
                        preHandleResult.setAction(action);
                    }
                }
                actionFound = true;
                preHandleResult.setActionFound(actionFound);
                return preHandleResult;
            } else {
                actionFound = false;
                JSONArray onlineReporterDetails = woOpReportAbnormals.getJSONObject(0).getJSONArray("online_reporter_detail");
                JSONArray waitProcessAbnormalDetails = woOpReportAbnormals.getJSONObject(0).getJSONArray("wait_process_abnormal_detail");

                Action<Map<String, Object>> action = new Action<>();
                if (onlineReporterDetails.size() > 0) {
                    Map<String, Object> data = new HashMap<>(1);
                    data.put("online_reporter_detail", onlineReporterDetails);
                    action.setRawData(data);
                    action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_PROJECT_SCHEDULE_REPORT_SUBMIT.name());
                    action.setJumpPageTitle(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交失败"));
                } else if (waitProcessAbnormalDetails.size() > 0) {
                    Map<String, Object> data = new HashMap<>(2);
                    data.put("wo_op_report_abnormal", woOpReportAbnormals);
                    data.put("isGetDataByApi", false);
                    action.setRawData(data);
                    action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_TEAM_DISPATCH_ABNORMAL_REPORT_DETAIL.name());
                    action.setJumpPageTitle(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "待处理异常原因清单"));
                }
                preHandleResult.setAction(action);
                preHandleResult.setActionFound(actionFound);
                preHandleResult.setServiceName(actionServiceIdName);
                preHandleResult.setExtendParam(onlineReporterDetails);
                return preHandleResult;
            }
        } else if (("wo.op.report.progress.info.process".equalsIgnoreCase(actionServiceIdName))
                && ("apc_ProgressToAbnormal".equalsIgnoreCase(actionCategory)
                || "ESP".equalsIgnoreCase(actionCategory))) {
            //APC装配进度控制应用：进度回报页面异常回报，异常提交按钮，提交
            String locale = apiRequestSubmit.getLocale();
            String iamUserToken = apiRequestSubmit.getIamUserToken();
            List<ActionSubmitParam> submitParams = apiRequestSubmit.getSubmitParams();
            String tenantId = apiRequestSubmit.getTenantId();
            ActionSubmitParam abnormalReasonsParam = submitParams.stream().filter(
                    item -> item.getSchema().equalsIgnoreCase("abnormalReasons")
            ).findFirst().orElse(null);
            InputWindowSingleSelect inputWindowSingleSelect = JsonUtil.objectToJavaObject(abnormalReasonsParam.getParams(), InputWindowSingleSelect.class);
            String abnormalReasonName = inputWindowSingleSelect.getTitle();
            String abnormalReasonNo = inputWindowSingleSelect.getSelectId();
            ActionSubmitParam commentParam = submitParams.stream().filter(
                    item -> item.getSchema().equalsIgnoreCase("comment")
            ).findFirst().orElse(null);
            InputMultiText inputMultiText = JsonUtil.objectToJavaObject(commentParam.getParams(), InputMultiText.class);
            String abnormalReasonDescription = inputMultiText.getText();

            ActionSubmitParam attachmentParam = submitParams.stream().filter(
                    item -> item.getSchema().equalsIgnoreCase("abnormal_reason_attachment")
            ).findFirst().orElse(null);
            Attachment attachment = (Attachment) attachmentParam.getParams();
            List<AttachmentFile> attachmentFiles = attachment.getFileList();
            Map<String, Object> abnormalReasonAttachment = new HashMap<>(2);
            abnormalReasonAttachment.put("row_data", attachment.getRawData());
            if (!CollectionUtils.isEmpty(attachmentFiles)) {
                List<Map<String, Object>> dataList = new ArrayList<>(attachmentFiles.size());
                for (AttachmentFile attachmentFile : attachmentFiles) {
                    Map<String, Object> dataPar = new HashMap<>(7);
                    if (attachment.getRawData() != null) {
                        dataPar.put("category", ((AttachmentRawDataDigiwinAthena) attachment.getRawData()).getUploadCategory());
                        dataPar.put("category_id", ((AttachmentRawDataDigiwinAthena) attachment.getRawData()).getUploadCategoryId());
                    } else {
                        dataPar.put("category", "");
                        dataPar.put("category_id", "");
                    }
                    dataPar.put("create_date", attachmentFile.getUploadTime());
                    dataPar.put("id", attachmentFile.getFileId());
                    dataPar.put("name", attachmentFile.getFileName());
                    dataPar.put("size", attachmentFile.getFileSize());
                    dataPar.put("upload_user_name", attachmentFile.getUploader());
                    dataList.add(dataPar);
                }
                abnormalReasonAttachment.put("data", dataList);
            } else {
                abnormalReasonAttachment.put("data", Collections.emptyList());
            }

            Map<String, Object> requestParams = (Map<String, Object>) rawData.get("extendFields");
            Map<String, Object> parameter = (Map<String, Object>) requestParams.get("parameter");
            List<Map<String, Object>> woOpReportDataList = (List<Map<String, Object>>) parameter.get("wo_op_report_data");
            for (Map<String, Object> woOpReportDataMap : woOpReportDataList) {
                woOpReportDataMap.put("abnormal_reason_name", abnormalReasonName);
                woOpReportDataMap.put("abnormal_reason_no", abnormalReasonNo);
                woOpReportDataMap.put("abnormal_reason_description", abnormalReasonDescription);
                woOpReportDataMap.put("abnormal_reason_attachment", abnormalReasonAttachment);
                woOpReportDataMap.put("new_card_flag", woOpReportDataMap.get("new_card_flag") == null ? false : woOpReportDataMap.get("new_card_flag"));
            }
            Map<String, Object> apiResponse = digiwinAtdmProxyService
                    .abnormalReportSubmin(locale, iamUserToken, requestParams, tenantId);
            //这边是因为web端进度回报定制画面，异常提交的时候category值由apc_ProgressToAbnormal变成了ESP，故在这边重新赋值，以确保提交成功。
            rawDataAction.put("category", "ESP");
            //进度回报异常提交定制参数
            rawDataData.put("wo_op_report_data", woOpReportDataList);

            actionFound = true;
            String content = "";
            if (actionFound && apiResponse.get("wo_op_report_abnormal") != null) {
                List<Map<String, Object>> woOpReportAbnormal = (List<Map<String, Object>>) apiResponse.get("wo_op_report_abnormal");
                if (!CollectionUtils.isEmpty(woOpReportAbnormal)) {
                    for (Map<String, Object> woOpReportDataMap : woOpReportDataList) {
                        woOpReportDataMap.put("abnormal_reason_name", abnormalReasonName);
                        woOpReportDataMap.put("abnormal_reason_no", abnormalReasonNo);
                        woOpReportDataMap.put("abnormal_reason_description", abnormalReasonDescription);
                        woOpReportDataMap.put("abnormal_reason_attachment", abnormalReasonAttachment);
                        woOpReportDataMap.put("abnormal_doc_no", woOpReportAbnormal.get(0).get("abnormal_doc_no") == null ? "" : woOpReportAbnormal.get(0).get("abnormal_doc_no"));
                        woOpReportDataMap.put("report_date", woOpReportAbnormal.get(0).get("report_date") == null ? "" : woOpReportAbnormal.get(0).get("report_date"));
                        woOpReportDataMap.put("plan_lot_no", woOpReportAbnormal.get(0).get("plan_lot_no") == null ? "" : woOpReportAbnormal.get(0).get("plan_lot_no"));
                        woOpReportDataMap.put("project_no", woOpReportAbnormal.get(0).get("project_no") == null ? "" : woOpReportAbnormal.get(0).get("project_no"));
                        requestParams.put("actionId", "bm.wrsc.wo.op.report.abnormal.create");
                    }
                    parameter.remove("wo_op_report_data");
                    parameter.put("wo_op_report_abnormal", parameter.get("wo_op_report_data"));
                    content = (String) woOpReportAbnormal.get(0).get("abnormal_doc_no");
                }
            }

            Action bottomAction = new Action();
            bottomAction.setType(ActionTypeEnum.POP_PROMPT.getValue());
            PopPromptMsg popPromptMsg = new PopPromptMsg();
            popPromptMsg.setTitle(localeService.getLanguageValue(locale, "异常单号"));
            popPromptMsg.setContent(content);
            List<Button> buttonList = new ArrayList<>(1);
            Button buttonDigiwinAthena = new Button();
            buttonDigiwinAthena.setType(BottomButtonStyleEnum.STRESS.getValue());
            buttonDigiwinAthena.setName(localeService.getLanguageValue(locale, "我知道了"));
            Action returnAction = new Action();
            returnAction.setType(ActionTypeEnum.BACK_TWO_WITH_REFRESH.getValue());
            returnAction.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_PROJECT_SCHEDULE_REPORT_LIST.toString());
            buttonDigiwinAthena.setAction(returnAction);
            buttonList.add(buttonDigiwinAthena);
            popPromptMsg.setButtonList(buttonList);
            popPromptMsg.setProhibitReturn(true);
            bottomAction.setPopPromptMsg(popPromptMsg);
            preHandleResult.setAction(bottomAction);
            preHandleResult.setActionFound(actionFound);
            return preHandleResult;
//        } else if (TaskStringUtil.isCustomProcess(executeCtxPattern, executeCtxCategory)
//                && ("submit-data".equalsIgnoreCase(actionId)
//                || "submit-data".equalsIgnoreCase(actionServiceIdName))
//                && ("PTM".equalsIgnoreCase(actionCategory))
//        ) {
//            //APC装配进度控制应用：工时回报页面异常回报，异常提交按钮，提交
//            String locale = apiRequestSubmit.getLocale();
//            String iamUserToken = apiRequestSubmit.getIamUserToken();
//            List<ActionSubmitParam> submitParams = apiRequestSubmit.getSubmitParams();
//            String tenantId = apiRequestSubmit.getTenantId();
//            ActionSubmitParam abnormalReasonsParam = submitParams.stream().filter(
//                    item -> item.getSchema().equalsIgnoreCase("abnormalReasons")
//            ).findFirst().orElse(null);
//            InputWindowSingleSelect inputWindowSingleSelect = JsonUtil.objectToJavaObject(abnormalReasonsParam.getParams(), InputWindowSingleSelect.class);
//            String abnormalReasonName = inputWindowSingleSelect.getTitle();
//            String abnormalReasonNo = inputWindowSingleSelect.getSelectId();
//            ActionSubmitParam commentParam = submitParams.stream().filter(
//                    item -> item.getSchema().equalsIgnoreCase("comment")
//            ).findFirst().orElse(null);
//            InputMultiText inputMultiText = JsonUtil.objectToJavaObject(commentParam.getParams(), InputMultiText.class);
//            String abnormalReasonDescription = inputMultiText.getText();
//
//            Map<String, Object> requestParams = (Map<String, Object>) rawData.get("extendFields");
//            Map<String, Object> parameter = (Map<String, Object>) requestParams.get("parameter");
//            List<Map<String, Object>> woOpReportAbnormalList = (List<Map<String, Object>>) parameter.get("wo_op_report_abnormal");
//            for (Map<String, Object> woOpReportAbnormalMap : woOpReportAbnormalList) {
//                woOpReportAbnormalMap.put("process_status", "0");
//                woOpReportAbnormalMap.put("abnormal_reason_name", abnormalReasonName);
//                woOpReportAbnormalMap.put("abnormal_reason_no", abnormalReasonNo);
//                woOpReportAbnormalMap.put("abnormal_reason_description", abnormalReasonDescription);
//            }
//
//
//            Boolean hasAbnormalReportSubmin = digiwinAtdmProxyService.abnormalReportSubmin(locale, iamUserToken, requestParams, tenantId);
//
//            actionFound = hasAbnormalReportSubmin;
//            preHandleResult.setActionFound(actionFound);
//            return preHandleResult;
        } else if ("start-new-process".equalsIgnoreCase(actionId) || "submit-data".equalsIgnoreCase(actionId)) {
            //管理异常套件任务卡
            preHandleResult.setActionFound(true);
            return preHandleResult;
        } else if (TaskStringUtil.isBizDataEntryDriven(executeCtxPattern, executeCtxCategory)
                && ApprovalActionNameEnum.WORKFLOW_ACT_SUBMIT.getValue().equalsIgnoreCase(actionServiceIdName)
        ) {
            // 模型驱动-人工任务卡，V1版提交按钮处理 --- 未使用
            Action action = new Action();
            action.setType(ActionTypeEnum.REFRESH.getValue());
            action.setSuccessMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            action.setToastMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            preHandleResult.setAction(action);
        } else if (TaskStringUtil.isBizDataEntryDriven(executeCtxPattern, executeCtxCategory)
                && "basic-data-update".equalsIgnoreCase(rawDataAction.getString("actionType"))
        ) {
            // 模型驱动-人工任务卡，V1版保存按钮处理 --- 未使用
            Action action = new Action();
            action.setType(ActionTypeEnum.REFRESH.getValue());
            action.setSuccessMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "保存成功"));
            action.setToastMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "保存成功"));
            preHandleResult.setAction(action);
        } else {
            // 没有匹配的按钮，返回false
            actionFound = false;
        }

        preHandleResult.setActionFound(actionFound);
        return preHandleResult;
    }

    private void customizePcmBudgetProjectApprovals(PcUiBotExecuteContext executeContext) {
        Map<String, Object> bpmData = Optional.ofNullable(executeContext.getBpmData()).orElse(new HashMap<>());
        Map<String, Object> parameter = new HashMap<>(2);
        parameter.put("project_no", bpmData.get("project_no"));
        parameter.put("version_no", bpmData.get("version_no"));
        DigiwinAtdmRequest request = DigiwinAtdmRequest.create("bm.pcsc.budget.get",
                parameter,
                JsonUtil.objectToJavaObject(executeContext, Map.class),
                JsonUtil.objectToJavaObject(executeContext.getBusinessUnit(), Map.class)
        );
        DigiwinAthenaApiResponse<Map<String, Object>> athenaApiResponse = digiwinAtdmProxyService
                .dataQueryByActionId(
                        AppRequestContext.getContextEntity().getLocale(),
                        AppRequestContext.getContextEntity().getIamUserToken(),
                        JsonUtil.javaObjectToJsonString(request),
                        AppRequestContext.getContextEntity().getTenantId()
                );
        if (athenaApiResponse == null) {
            return;
        }
        Map<String, Object> map = athenaApiResponse.getResponse();
        if (map == null) {
            return;
        }

        // 1.保存; 2.提交; 3.同意; 4.终止; 5.确认提交
        map.put("operation_type", "4");
        DigiwinAtdmRequest updata = DigiwinAtdmRequest.create("bm.pcsc.budget.update",
                map,
                JsonUtil.objectToJavaObject(executeContext, Map.class),
                JsonUtil.objectToJavaObject(executeContext.getBusinessUnit(), Map.class)
        );
        digiwinAtdmProxyService.dataQueryByActionId(
                AppRequestContext.getContextEntity().getLocale(),
                AppRequestContext.getContextEntity().getIamUserToken(),
                JsonUtil.javaObjectToJsonString(updata),
                AppRequestContext.getContextEntity().getTenantId()
        );
    }

    private boolean designerButtomNewHandle(ApiRequestSubmit apiRequestSubmit, ActionPreHandleResult preHandleResult) {
        JSONObject rawData = apiRequestSubmit.getRawData();
        JSONObject rawDataAction = rawData.getJSONObject("action");
        JSONObject rawDataData = rawData.getJSONObject("data");
        // 从rawData获取当前移动端画面布局信息
        MobileLayoutTypeEnum mobileLayoutTypeEnum = rawData.getObject("mobileLayoutType", MobileLayoutTypeEnum.class);
// key是鼎捷uibot中action提交时需要的参数key，value是这个key对应的值
        Map<String, Object> digiwinActionSubmitParasMap = new HashMap<>(5);
        String actionId = rawDataAction.getString("actionId");
        String actionTitle = rawDataAction.getString("title");
        String actionCategory = rawDataAction.getString("category");
        String actionServiceIdName = rawDataAction.getJSONObject("serviceId").getString("name");
        String actionServiceIdTenantId =
                rawDataAction.getJSONObject("serviceId").getString("tenant_id");
        String actionSubmitTypeSchema = "";
        if (rawDataAction.getJSONObject("submitType") != null) {
            actionSubmitTypeSchema = rawDataAction.getJSONObject("submitType").getString("schema");
        }

        String executeCtxPattern =
                rawDataAction.getJSONObject("executeContext").getString("pattern");
        String executeCtxCategory =
                rawDataAction.getJSONObject("executeContext").getString("category");
        String executeCtxTmProjectId =
                rawDataAction.getJSONObject("executeContext").getString("tmProjectId");
        String executeCtxTmActivityId =
                rawDataAction.getJSONObject("executeContext").getString("tmActivityId");


        if (TaskStringUtil.isBizApproval(executeCtxPattern, executeCtxCategory)
                && actionServiceIdName.equalsIgnoreCase(ApprovalActionNameEnum.APPROVAL_REEXECUTE.getValue())
                && ("ESP".equalsIgnoreCase(actionCategory) || "TaskEngine".equalsIgnoreCase(actionCategory))
        ) {
            // 签核型任务-退回重办
            for (ActionSubmitParam submitParam : apiRequestSubmit.getSubmitParams()) {
                String type = submitParam.getType();
                // 跳过不处理
                if (Field.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    continue;
                }

                String schema = submitParam.getSchema();
                Object paramObj = submitParam.getParams();
                ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                if (null == componentParamAnalyzer) {
                    logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                            schema, JsonUtil.javaObjectToJsonString(paramObj));
                    continue;
                }
                Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
                if (InputSingleText.COMPONENT_TYPE.equalsIgnoreCase(type)
                        || InputMultiText.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    digiwinActionSubmitParasMap.put(schema, analyzedParam);
                }

                if (Attachment.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    UiBotAttachment uiBotAttachment = (UiBotAttachment) analyzedParam;
                    digiwinActionSubmitParasMap.put(schema, uiBotAttachment.getData());
                }

                JSONObject submitActionParas = rawDataAction.getJSONObject("paras");
                if (submitActionParas == null) {
                    submitActionParas = new JSONObject();
                }
                for (String key : digiwinActionSubmitParasMap.keySet()) {
                    submitActionParas.put(key, digiwinActionSubmitParasMap.get(key));
                }
                rawDataAction.put("paras", submitActionParas);
            }
            JSONArray submitAttachActions = rawDataAction.getJSONArray("attachActions");
            for (int i = 0; i < submitAttachActions.size(); i++) {
                JSONObject attachAction = submitAttachActions.getJSONObject(i);
                Map<String, Object> serivceId = (Map<String, Object>) attachAction.get("serviceId");
                String name = (String) serivceId.get("name");
                String newActionId = (String) attachAction.get("actionId");
                Map<String, Object> extendedFields = (Map<String, Object>) attachAction.get("extendedFields");
                if (newActionId.toLowerCase().contains("reexecute") ||
                        (StringUtils.hasLength(name) && name.toLowerCase().contains("reexecute")) ||
                        ((extendedFields != null && extendedFields.size() > 0 && extendedFields.containsKey("reexecute"))
                        )) {
                    JSONObject attachActionParas = attachAction.getJSONObject("paras");
                    for (String key : digiwinActionSubmitParasMap.keySet()) {
                        attachActionParas.put(key, digiwinActionSubmitParasMap.get(key));
                    }
                    rawDataAction.put("paras", attachActionParas);
                }
            }

            Action action = new Action();
            action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            action.setSuccessMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            action.setToastMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            preHandleResult.setAction(action);
            return true;
        } else if ((TaskStringUtil.isBizApproval(executeCtxPattern, executeCtxCategory)
                && (actionServiceIdName.equalsIgnoreCase(ApprovalActionNameEnum.APPROVAL_AGREE.getValue())
                || actionServiceIdName.equalsIgnoreCase(ApprovalActionNameEnum.APPROVAL_DISPATCH.getValue())
                //不同意也要输入原因，处理逻辑跟同意一样了，故添加以下两项
                || actionServiceIdName.equalsIgnoreCase(ApprovalActionNameEnum.APPROVAL_TERMINATE.getValue())
                || actionServiceIdName.equalsIgnoreCase(ApprovalActionNameEnum.APPROVAL_DISAGREE.getValue()))
                && ("WF".equalsIgnoreCase(actionCategory)
                || "ESP".equalsIgnoreCase(actionCategory)
                || "TaskEngine".equalsIgnoreCase(actionCategory))
        ) || (TaskStringUtil.isBizDataEntryDriven(executeCtxPattern, executeCtxCategory)
                && (
                // 同意/不同意
                ApprovalActionNameEnum.WORKFLOW_ACT_AGREE.getValue().equalsIgnoreCase(actionServiceIdName)
                        || ApprovalActionNameEnum.WORKFLOW_ACT_DISAGREE.getValue().equalsIgnoreCase(actionServiceIdName))
                && ("ESP".equalsIgnoreCase(actionCategory) // 同意category为ESP
                || "workflow".equalsIgnoreCase(actionCategory))
        )
        ) {
            // 签核型任务-同意按钮、不同意按钮
            for (ActionSubmitParam submitParam : apiRequestSubmit.getSubmitParams()) {
                String type = submitParam.getType();
                // 跳过不处理
                if (Field.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    continue;
                }

                String schema = submitParam.getSchema();
                Object paramObj = submitParam.getParams();
                ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                if (null == componentParamAnalyzer) {
                    logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                            schema, JsonUtil.javaObjectToJsonString(paramObj));
                    continue;
                }
                Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
                if (InputSingleText.COMPONENT_TYPE.equalsIgnoreCase(type)
                        || InputMultiText.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    digiwinActionSubmitParasMap.put(schema, analyzedParam);
                }

                if (Attachment.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    UiBotAttachment uiBotAttachment = (UiBotAttachment) analyzedParam;
                    digiwinActionSubmitParasMap.put(schema, uiBotAttachment.getData());
                }

            }
            if (TaskStringUtil.isBizDataEntryDriven(executeCtxPattern, executeCtxCategory)
                    // 同意
                    && ApprovalActionNameEnum.WORKFLOW_ACT_AGREE.getValue().equalsIgnoreCase(actionServiceIdName)
                    // 同意category为ESP
                    && "ESP".equalsIgnoreCase(actionCategory)
            ) {
                JSONArray attachActionsList = rawDataAction.getJSONArray("attachActions");
                if (!CollectionUtils.isEmpty(attachActionsList)) {
                    // 同意按钮，存在attachActions，则取第一个修改
                    rawDataAction = attachActionsList.getJSONObject(0);
                }
            }
            rawDataAction.getJSONObject("submitType").put("schema", "project_budget_info");
            rawDataAction.getJSONObject("submitType").put("submitAll", false);
            JSONObject submitActionParas = rawDataAction.getJSONObject("paras");
            if (submitActionParas == null) {
                submitActionParas = new JSONObject();
            }
            for (String key : digiwinActionSubmitParasMap.keySet()) {
                submitActionParas.put(key, digiwinActionSubmitParasMap.get(key));
            }
            rawDataAction.put("paras", submitActionParas);

            Action action = new Action();
            action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            action.setSuccessMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            action.setToastMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            preHandleResult.setAction(action);

            if (ApprovalActionNameEnum.APPROVAL_DISAGREE.getValue().equalsIgnoreCase(actionServiceIdName)
                    && PcmFilterUtil.isPcmCustomized(executeCtxTmActivityId, executeCtxTmProjectId)) {
                // PCM_项目预算签核定制  不同意按钮额外逻辑处理
                PcUiBotExecuteContext executeContext = JsonUtil.objectToJavaObject(rawDataAction.get("executeContext"), PcUiBotExecuteContext.class);
                CompletableFuture.runAsync(() -> this.customizePcmBudgetProjectApprovals(executeContext), threadPoolTaskExecutor);
            }

            return true;
        }

        return false;
    }

    /**
     * 移动设计态到运行态，提交通用解析处理
     *
     * @param apiRequestSubmit
     * @param preHandleResult
     * @return
     */
    private ActionPreHandleResult designerUniversalParsingHandle(ApiRequestSubmit apiRequestSubmit, ActionPreHandleResult preHandleResult) {

        //区别V1,设计器拉出来的的签核类型按钮走以下逻辑，目前逻辑中包含同意不同意，退回重办
        if (designerButtomNewHandle(apiRequestSubmit, preHandleResult)) {
            return preHandleResult;
        }
        JSONObject rawData = apiRequestSubmit.getRawData();
        JSONObject rawDataAction = rawData.getJSONObject("action");
        JSONObject rawDataData = rawData.getJSONObject("data");
        Action<Map<String, Object>> actionAfterSubmit = JsonUtil.objectToJavaObject(rawData.get("actionAfterSubmit"),
                new TypeReference<Action<Map<String, Object>>>() {
                });
        String dataId = rawData.getString("dataId");
        JSONObject rawDataRawData = rawData.getJSONObject("rawData");
        Boolean submitSelectCardData = rawData.getBoolean("submitSelectCardData");

        // 从rawData清除当前信息，保证后续提交时rawData是干净的
        rawData.remove("actionAfterSubmit");
        rawData.remove("submitStrategyEnum");
        rawData.remove("rawData");
        rawData.remove("submitSelectCardData");

        String actionServiceIdTenantId =
                rawDataAction.getJSONObject("serviceId").getString("tenant_id");
        String executeCtxTmProjectId =
                rawDataAction.getJSONObject("executeContext").getString("tmProjectId");
        String executeCtxTmActivityId =
                rawDataAction.getJSONObject("executeContext").getString("tmActivityId");

        if ("UT_InspectionResultsRegistration".equalsIgnoreCase(executeCtxTmActivityId)) {
            // 试验优测定制 - 条目详情页保存按钮操作
            this.UtInspectionResultsRegistrationSave(apiRequestSubmit, rawDataAction, rawDataData,
                    actionAfterSubmit, preHandleResult);
            return preHandleResult;
        }

        if (rawDataRawData != null && "submit".equals(rawDataRawData.getString("saveType"))) {
            // 数据驱动（line）场景下，第二个页面提交按钮定制处理
            this.handleSubmitParamsOfDataDriven(apiRequestSubmit, rawDataRawData);
        }

        List<DigiwinActionSubmitParas> digiwinActionSubmitParasList = new ArrayList<>(
                this.buildSubmitParasMap(apiRequestSubmit.getSubmitParams())
                        .stream()
                        .filter(distinctByKey(obj -> obj.getOriginalSchema() + "-" + obj.getMobilePath())).collect(Collectors.toList()));

        JSONObject submitActionSubmitType = rawDataAction.getJSONObject("submitType");
        String rawDataDataSchema = submitActionSubmitType.getString("schema");
        Boolean rawDataDataSubmitAll = submitActionSubmitType.getBoolean("submitAll");
        Boolean rawDataDataIsBatch = submitActionSubmitType.getBoolean("isBatch");

        if (!rawDataData.containsKey(rawDataDataSchema)) {
            preHandleResult.setActionFound(false);
            return preHandleResult;
        }
        List<DigiwinActionSubmitParas> submitCardRawDataList = digiwinActionSubmitParasList.stream()
                .filter(r -> PcUiBotConstants.MOBILE_LOCAL_ADD_CARD_DATA_KEY.equals(r.getOriginalSchema()))
                .findFirst()
                .map(r -> (List<DigiwinActionSubmitParas>) r.getValue())
                .orElse(new ArrayList<>());

        List<DigiwinActionSubmitParas> submitCardList = digiwinActionSubmitParasList.stream()
                .filter(r -> PcUiBotConstants.MOBILE_SUBMIT_CARD_DATA_KEY.equals(r.getOriginalSchema()))
                .findFirst()
                .map(r -> (List<DigiwinActionSubmitParas>) r.getValue())
                .orElse(new ArrayList<>());
        digiwinActionSubmitParasList.removeIf(r -> PcUiBotConstants.MOBILE_SUBMIT_CARD_DATA_KEY.equals(r.getOriginalSchema()));
        digiwinActionSubmitParasList.removeIf(r -> PcUiBotConstants.MOBILE_LOCAL_ADD_CARD_DATA_KEY.equals(r.getOriginalSchema()));

        // 是否外层的列表中数据 提交
        boolean isOuterListData = submitCardRawDataList.stream().anyMatch(r -> rawDataDataSchema.equals(r.getMobilePath()))
                || submitCardList.stream().anyMatch(r -> rawDataDataSchema.equals(r.getMobilePath()));
        if (rawDataData.get(rawDataDataSchema) instanceof List) {
            JSONArray rawDataDataSchemaData = rawDataData.getJSONArray(rawDataDataSchema);
            //提交参数的特殊处理
            digiwinActionSubmitParasList = specialHandle(rawDataDataSchemaData, digiwinActionSubmitParasList, apiRequestSubmit, executeCtxTmActivityId);

            if (isOuterListData) {
                // 卡片操作外层列表数据
                if (BooleanUtils.isTrue(submitSelectCardData)) {
                    // 开启选择功能情况下
                    List<JSONObject> deleteList = new ArrayList<>();
                    for (int i = 0; i < rawDataDataSchemaData.size(); i++) {
                        JSONObject schemaData = rawDataDataSchemaData.getJSONObject(i);
                        // card 组件提交处理
                        boolean isDelete = this.handleOuterSubmitOfCard(submitCardList, schemaData, submitSelectCardData, rawDataDataIsBatch);
                        if (!BooleanUtils.isTrue(rawDataDataSubmitAll) && isDelete) {
                            // submitAll != true，则删除未勾选的数据  注意：不可根据isBatch字段来判断，因设计态配置的值运行态会动态改变
                            deleteList.add(schemaData);
                        }
                    }
                    rawDataDataSchemaData.removeAll(deleteList);
                } else {
                    // 新增或其它场景 --- 直接替换rawdata
                    JSONObject map = new JSONObject();
                    map.put(rawDataDataSchema, new ArrayList<>());
                    this.handleSubmitOfCardRawData(submitCardRawDataList, map);
                    rawDataDataSchemaData.clear();
                    rawDataDataSchemaData.addAll(map.getJSONArray(rawDataDataSchema));
                }
            } else {
                // 针对每一笔数据，将暂存下来的字段录入数据更新进去
                for (int i = 0; i < rawDataDataSchemaData.size(); i++) {
                    JSONObject schemaData = rawDataDataSchemaData.getJSONObject(i);
                    // 处理简单组件提交的数据
                    this.handleSubmitOfSimple(dataId, digiwinActionSubmitParasList, schemaData);
                    // card 组件提交处理
                    this.handleSubmitOfCardRawData(submitCardRawDataList, schemaData);
                    this.handleSubmitOfCard(submitCardList, schemaData);
                }
            }
        } else if (rawDataData.get(rawDataDataSchema) instanceof Map) {
            JSONObject schemaData = rawDataData.getJSONObject(rawDataDataSchema);
            // 处理简单组件提交的数据
            this.handleSubmitOfSimple(dataId, digiwinActionSubmitParasList, schemaData);
            // card 组件提交处理
            this.handleSubmitOfCardRawData(submitCardRawDataList, schemaData);
            this.handleSubmitOfCard(submitCardList, schemaData);
        }
        preHandleResult.setAction(actionAfterSubmit);
        return preHandleResult;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap<Object, Boolean> map = new ConcurrentHashMap<>();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private void handleSubmitParamsOfDataDriven(ApiRequestSubmit apiRequestSubmit, JSONObject rawDataRawData) {
        // [{"schema": "aaa","type": "DW_CARD","mobilePath": "decision_action","params": {"dataId": "aaa","submitParams": []}}]
        List<ActionSubmitParam> multiSubmitParamList = apiRequestSubmit.getMultiSubmitParamList();
        if (CollectionUtils.isEmpty(multiSubmitParamList)) {
            return;
        }
        apiRequestSubmit.setSubmitParams(multiSubmitParamList);
    }

    /**
     * 处理简单组件提交的数据
     *
     * @param dataId                       card卡片的dataid设置一个唯一值，作用于详情页保存后更新原始数据查找的标志，与card的按钮、detailPage的dataid相同
     * @param digiwinActionSubmitParasList 提交参数(去除card组件提交参数)
     * @param schemaData                   元数据
     */
    public void handleSubmitOfSimple(String dataId, List<DigiwinActionSubmitParas> digiwinActionSubmitParasList, Map<String, Object> schemaData) {
        if (CollectionUtils.isEmpty(digiwinActionSubmitParasList)) {
            return;
        }
        digiwinActionSubmitParasList.forEach(submitParas -> {
            // 根据mobilePath和schema获取schema所在的对象
            Map<String, Object> currentSchemaData =
                    this.getSchemaObjectOfPathAndSchema(dataId, schemaData, submitParas.getMobilePath(), submitParas.getOriginalSchema());
            currentSchemaData.put(submitParas.getSchema(), submitParas.getValue());
        });
    }

    /**
     * 根据mobilePath和schema获取schema所在的对象
     *
     * @param dataId     card卡片的dataid唯一值
     * @param schemaData 元数据
     * @param mobilePath schema全路径
     * @param schema     待查找的schema字段
     * @return
     */
    private Map<String, Object> getSchemaObjectOfPathAndSchema(String dataId, Map<String, Object> schemaData, String mobilePath, String schema) {
        String path = schema;
        if (StringUtils.hasLength(mobilePath)) {
            path = mobilePath;
        }
        if (!StringUtils.hasLength(path)) {
            return schemaData;
        }
        if (!path.contains(".")) {
            return schemaData;
        }
        String[] keys = path.split("\\.");
        for (int i = 0; i < keys.length - 1; i++) {
            Object o = schemaData.get(keys[i]);
            // wjw FIXME: 2023/11/8 注意：o==null,说明当前路径下字段不在元数据中，则必须继续向下查找，不能直接return
            if (o != null) {
                if (o instanceof Map) {
                    schemaData = (Map<String, Object>) o;
                } else if (o instanceof List) {
                    List<Map<String, Object>> list = (List<Map<String, Object>>) o;
                    if (i == keys.length - 2) {
                        boolean isExist = false;
                        // schema父节点是数组，则获取对应数组中的条目
                        for (Map<String, Object> map : list) {
                            String rawDataId = StringUtil.valueOf(map.get(PcUiBotConstants.MOBILE_CARD_DATAID_KEY));
                            if (StringUtils.hasLength(dataId) && dataId.equals(rawDataId)) {
                                schemaData = map;
                                isExist = true;
                                break;
                            }
                        }
                        if (!isExist) {
                            // 列表中都不满足条件，则取第一个
                            if (!CollectionUtils.isEmpty(list)) {
                                schemaData = list.get(0);
                            }
                        }
                    } else {
                        if (!CollectionUtils.isEmpty(list)) {
                            schemaData = list.get(0);
                        }
                    }
                } else {
                    // 留空，不是集合则不做处理，继续向下查找
                }
            }
        }
        return schemaData;
    }

    /**
     * 处理card组件提交的数据
     *
     * @param submitCardList       card组件提交参数构建的结构
     * @param schemaData           元数据
     * @param submitSelectCardData 是否只提交选择的卡片数据
     * @param rawDataDataIsBatch   是否分批
     */
    private boolean handleOuterSubmitOfCard(List<DigiwinActionSubmitParas> submitCardList, JSONObject schemaData,
                                            Boolean submitSelectCardData, Boolean rawDataDataIsBatch) {
        if (CollectionUtils.isEmpty(submitCardList)) {
            return false;
        }
        List<String> dataIdList = submitCardList.stream().map(DigiwinActionSubmitParas::getOriginalSchema).filter(StringUtils::hasLength).collect(Collectors.toList());
        Map<String, List<DigiwinActionSubmitParas>> mobilePathMap = submitCardList.stream().collect(Collectors.groupingBy(DigiwinActionSubmitParas::getMobilePath));
        for (Map.Entry<String, List<DigiwinActionSubmitParas>> entry : mobilePathMap.entrySet()) {
            String mobilePath = entry.getKey();
            List<DigiwinActionSubmitParas> mobilePathList = entry.getValue();
            // 根据card组件的path(根据列表节点的path)，获取对应的列表数据
            List<Map<String, Object>> allSchemaData = Optional.ofNullable(UiBotDesignerRenderService.getDataByPath(schemaData, mobilePath, true)).orElse(new ArrayList<>());

            // 判断是否是外层的列表中数据
            boolean outerListData = allSchemaData.size() == 1 && allSchemaData.get(0) == schemaData;
            if (outerListData && BooleanUtils.isTrue(submitSelectCardData)) {
                // 开启选择功能情况下，先默认false
                allSchemaData.forEach(r -> r.put("uibot_checked", false));
                // 外层列表数据，并且只提交选中的卡片数据
                allSchemaData = allSchemaData.stream().filter(r -> dataIdList.contains(StringUtil.valueOf(r.get(PcUiBotConstants.MOBILE_CARD_DATAID_KEY)))).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(allSchemaData)) {
                    return true;
                }
                if (BooleanUtils.isTrue(rawDataDataIsBatch)) {
                    // 分批提交下，设置选中的数据 uibot_checked=true
                    allSchemaData.forEach(r -> r.put("uibot_checked", true));
                }
            }

            List<Map<String, Object>> finalAllSchemaData = allSchemaData;
            mobilePathList.forEach(submitCard -> {
                String dataId = submitCard.getOriginalSchema();
                List<DigiwinActionSubmitParas> submitCardData = Optional.ofNullable((List<DigiwinActionSubmitParas>) submitCard.getValue()).orElse(new ArrayList<>());
                // 获取列表数据对应的条目进行修改
                finalAllSchemaData.stream()
                        .filter(map -> StringUtils.hasLength(dataId) && dataId.equals(StringUtil.valueOf(map.get(PcUiBotConstants.MOBILE_CARD_DATAID_KEY))))
                        .findFirst()
                        .ifPresent(map -> submitCardData.forEach(r -> map.put(r.getSchema(), r.getValue())));
            });
        }
        return false;
    }

    /**
     * 处理card组件提交的数据
     *
     * @param submitCardList card组件提交参数构建的结构
     * @param schemaData     元数据
     */
    private void handleSubmitOfCard(List<DigiwinActionSubmitParas> submitCardList, JSONObject schemaData) {
        if (CollectionUtils.isEmpty(submitCardList)) {
            return;
        }
        Map<String, List<DigiwinActionSubmitParas>> mobilePathMap = submitCardList.stream().collect(Collectors.groupingBy(DigiwinActionSubmitParas::getMobilePath));
        for (Map.Entry<String, List<DigiwinActionSubmitParas>> entry : mobilePathMap.entrySet()) {
            String mobilePath = entry.getKey();
            List<DigiwinActionSubmitParas> mobilePathList = entry.getValue();
            // 根据card组件的path(根据列表节点的path)，获取对应的列表数据
            List<Map<String, Object>> allSchemaData = Optional.ofNullable(UiBotDesignerRenderService.getDataByPath(schemaData, mobilePath, true)).orElse(new ArrayList<>());
            mobilePathList.forEach(submitCard -> {
                String dataId = submitCard.getOriginalSchema();
                List<DigiwinActionSubmitParas> submitCardData = Optional.ofNullable((List<DigiwinActionSubmitParas>) submitCard.getValue()).orElse(new ArrayList<>());
                // 获取列表数据对应的条目进行修改
                allSchemaData.stream()
                        .filter(map -> StringUtils.hasLength(dataId) && dataId.equals(StringUtil.valueOf(map.get(PcUiBotConstants.MOBILE_CARD_DATAID_KEY))))
                        .findFirst()
                        .ifPresent(map -> submitCardData.forEach(r -> map.put(r.getSchema(), r.getValue())));
            });
        }
    }

    /**
     * 处理card组件提交的数据 --- 只存在rawData时，全量替换
     *
     * @param submitCardRawDataList card组件提交rawdata数据
     * @param schemaData            元数据
     */
    private void handleSubmitOfCardRawData(List<DigiwinActionSubmitParas> submitCardRawDataList, JSONObject schemaData) {
        if (CollectionUtils.isEmpty(submitCardRawDataList)) {
            return;
        }
        submitCardRawDataList.stream()
                .collect(Collectors.groupingBy(DigiwinActionSubmitParas::getMobilePath))
                .forEach((mobilePath, list) -> {
                    // 根据card组件的path(根据列表节点的path)，获取对应的列表数据
                    Optional<List<Map<String, Object>>> optional = Optional.ofNullable(UiBotDesignerRenderService.getDataByPath(schemaData, mobilePath, true));
                    if (optional.isPresent()) {
                        // 原节点存在，直接覆盖
                        List<Map<String, Object>> allSchemaData = optional.get();
                        allSchemaData.clear();
                        list.forEach(r -> allSchemaData.add(Optional.ofNullable((Map<String, Object>) r.getValue()).orElse(new HashMap<>())));
                    } else {
                        // 原节点不存在，取上一级节点，覆盖
                        if (mobilePath.contains(".")) {
                            String preMobilePath = mobilePath.substring(0, mobilePath.lastIndexOf("."));
                            Map<String, Object> preSchemaData = this.getSchemaObjectOfPathAndSchema(null, schemaData, preMobilePath, preMobilePath);
                            List<Map<String, Object>> allSchemaData = list.stream().map(r -> (Map<String, Object>) r.getValue()).collect(Collectors.toList());

                            String schema = mobilePath.substring(mobilePath.lastIndexOf(".") + 1);
                            preSchemaData.put(schema, allSchemaData);
                        }
                    }
                });
    }

    public List<DigiwinActionSubmitParas> buildSubmitParasMap(List<ActionSubmitParam> submitParams) {
        if (CollectionUtils.isEmpty(submitParams)) {
            return new ArrayList<>();
        }
        List<DigiwinActionSubmitParas> digiwinActionSubmitParasList = new ArrayList<>();
        for (ActionSubmitParam submitParam : submitParams) {
            String type = submitParam.getType();
            // 跳过不处理
            if (Field.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                continue;
            }
            String schema = submitParam.getSchema();
            Object paramObj = submitParam.getParams();
            String mobilePath = submitParam.getMobilePath();
            if (paramObj == null) {
                continue;
            }
            switch (type) {
                case Picture.COMPONENT_TYPE:
                case Attachment.COMPONENT_TYPE:
                    Attachment attachment = (Attachment) paramObj;
                    UiBotAttachment uiBotAttachment = attachment.parseToUiBotAttachment(attachment, digiwinDmcProxyService);
                    digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas(schema, mobilePath, BooleanUtils.isTrue(attachment.getIsArray()) ? Lists.newArrayList(uiBotAttachment) : uiBotAttachment));
                    break;
                case InputCalendar.COMPONENT_TYPE:
                    InputCalendar calendar = (InputCalendar) paramObj;
                    if (InputCalendarTypeEnum.SELECT_DATE_RANGE.getValue().equals(calendar.getType())) {
                        // 前端传递结构如："2023.12.10^2023.12.22"
                        String[] times = calendar.getInputText().split("\\^");
                        digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas(schema, mobilePath, DateTimeUtil.convert(times[0], DateTimeUtil.DEFAULT_DATE_PATTERN)));
                        digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas(calendar.getEndSchema(), calendar.getEndSchemaPath(), DateTimeUtil.convert(times[1], DateTimeUtil.DEFAULT_DATE_PATTERN)));
                    } else {
                        // 如果是 单个日期 让他走default逻辑
                        Object analyzedParam = this.componentParamAnalyzerFactory.get(type).analyzeSubmitParam(paramObj);
                        digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas(schema, mobilePath, analyzedParam));
                    }
                    break;
                case InputDateTimePicker.COMPONENT_TYPE:
                    InputDateTimePicker picker = (InputDateTimePicker) paramObj;
                    if (picker.getDatetimeValue() != null) {
                        digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas(schema, mobilePath, InputDateTime.getDateTypeDateStringByType(picker.getDatetimeValue(), picker.getType())));
                    }
                    break;
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    InputWindowSingleSelect singleSelect = (InputWindowSingleSelect) paramObj;
                    Map<String, Object> detail = singleSelect.getDetail();
                    if (CollectionUtils.isEmpty(detail)) {
                        digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas(schema, mobilePath, singleSelect.getSelectId()));
                    } else {
                        detail.remove("__DATA_KEY");
                        detail.forEach((k, v) -> digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas(k, mobilePath, v)));
                    }
                    break;
                case EditCardList.COMPONENT_TYPE:
                    EditCardList editCardList = (EditCardList) paramObj;
                    if (editCardList != null && !CollectionUtils.isEmpty(editCardList.getSubmitParams())) {
                        digiwinActionSubmitParasList.addAll(this.buildSubmitParasMap(editCardList.getSubmitParams()));
                    }
                    break;
                case EditCard.COMPONENT_TYPE:
                    EditCard editCard = (EditCard) paramObj;
                    if (editCard != null && StringUtils.hasLength(editCard.getDataId()) && !CollectionUtils.isEmpty(editCard.getSubmitParams())) {
                        DigiwinActionSubmitParas digiwinActionSubmitParas = null;
                        for (DigiwinActionSubmitParas paras : digiwinActionSubmitParasList) {
                            if (PcUiBotConstants.MOBILE_SUBMIT_CARD_DATA_KEY.equals(paras.getOriginalSchema())) {
                                digiwinActionSubmitParas = paras;
                                break;
                            }
                        }
                        if (null == digiwinActionSubmitParas) {
                            digiwinActionSubmitParas = new DigiwinActionSubmitParas(PcUiBotConstants.MOBILE_SUBMIT_CARD_DATA_KEY, null, new ArrayList<>());
                            digiwinActionSubmitParasList.add(digiwinActionSubmitParas);
                        }
                        List<DigiwinActionSubmitParas> cardSubmitParasList = (List<DigiwinActionSubmitParas>) digiwinActionSubmitParas.getValue();
                        // schema=dataid，value=editcard提交的参数Map
                        List<DigiwinActionSubmitParas> submitParas = this.buildSubmitParasMap(editCard.getSubmitParams());
                        submitParas.removeIf(r -> PcUiBotConstants.MOBILE_SUBMIT_CARD_DATA_KEY.equals(r.getOriginalSchema()));
                        submitParas.removeIf(r -> PcUiBotConstants.MOBILE_LOCAL_ADD_CARD_DATA_KEY.equals(r.getOriginalSchema()));
                        cardSubmitParasList.add(new DigiwinActionSubmitParas(editCard.getDataId(), mobilePath, submitParas));

                        // 把卡片的submitParams参数放到卡片的rawdata中,并存入dataId
                        Map<String, Object> submitMap = submitParas.stream().filter(r -> Objects.nonNull(r.getValue())).collect(Collectors.toMap(DigiwinActionSubmitParas::getSchema, DigiwinActionSubmitParas::getValue, (c1, c2) -> c1));
                        Map<String, Object> rawData = editCard.getRawData();
                        if (rawData == null) {
                            rawData = new HashMap<>();
                            editCard.setRawData(rawData);
                        }
                        rawData.put(PcUiBotConstants.MOBILE_CARD_DATAID_KEY, editCard.getDataId());
                        rawData.putAll(submitMap);
                    }
                    if (editCard != null && StringUtils.hasLength(editCard.getDataId()) && !CollectionUtils.isEmpty(editCard.getRawData())) {
                        DigiwinActionSubmitParas digiwinActionSubmitParas = null;
                        for (DigiwinActionSubmitParas paras : digiwinActionSubmitParasList) {
                            if (PcUiBotConstants.MOBILE_LOCAL_ADD_CARD_DATA_KEY.equals(paras.getOriginalSchema())) {
                                digiwinActionSubmitParas = paras;
                                break;
                            }
                        }
                        if (null == digiwinActionSubmitParas) {
                            digiwinActionSubmitParas = new DigiwinActionSubmitParas(PcUiBotConstants.MOBILE_LOCAL_ADD_CARD_DATA_KEY, null, new ArrayList<>());
                            digiwinActionSubmitParasList.add(digiwinActionSubmitParas);
                        }
                        List<DigiwinActionSubmitParas> cardSubmitParasList = (List<DigiwinActionSubmitParas>) digiwinActionSubmitParas.getValue();
                        // schema=dataid，value=card的rawdata
                        cardSubmitParasList.add(new DigiwinActionSubmitParas(editCard.getDataId(), mobilePath, editCard.getRawData()));
                    }
                    break;
                case Card.COMPONENT_TYPE:
                    Card card = (Card) paramObj;
                    if (card != null && StringUtils.hasLength(card.getDataId()) && !CollectionUtils.isEmpty(card.getSubmitParams())) {
                        DigiwinActionSubmitParas digiwinActionSubmitParas = null;
                        for (DigiwinActionSubmitParas paras : digiwinActionSubmitParasList) {
                            if (PcUiBotConstants.MOBILE_SUBMIT_CARD_DATA_KEY.equals(paras.getOriginalSchema())) {
                                digiwinActionSubmitParas = paras;
                                break;
                            }
                        }
                        if (null == digiwinActionSubmitParas) {
                            digiwinActionSubmitParas = new DigiwinActionSubmitParas(PcUiBotConstants.MOBILE_SUBMIT_CARD_DATA_KEY, null, new ArrayList<>());
                            digiwinActionSubmitParasList.add(digiwinActionSubmitParas);
                        }
                        List<DigiwinActionSubmitParas> cardSubmitParasList = (List<DigiwinActionSubmitParas>) digiwinActionSubmitParas.getValue();
                        // schema=dataid，value=card详情页提交的参数Map
                        List<DigiwinActionSubmitParas> submitParas = this.buildSubmitParasMap(card.getSubmitParams());
                        submitParas.removeIf(r -> PcUiBotConstants.MOBILE_SUBMIT_CARD_DATA_KEY.equals(r.getOriginalSchema()));
                        submitParas.removeIf(r -> PcUiBotConstants.MOBILE_LOCAL_ADD_CARD_DATA_KEY.equals(r.getOriginalSchema()));
                        cardSubmitParasList.add(new DigiwinActionSubmitParas(card.getDataId(), mobilePath, submitParas));

                        // 把卡片的submitParams参数放到卡片的rawdata中,并存入dataId
                        Map<String, Object> submitMap = submitParas.stream().filter(r -> Objects.nonNull(r.getValue())).collect(Collectors.toMap(DigiwinActionSubmitParas::getSchema, DigiwinActionSubmitParas::getValue, (c1, c2) -> c1));
                        Map<String, Object> rawData = card.getRawData();
                        if (rawData == null) {
                            rawData = new HashMap<>();
                            card.setRawData(rawData);
                        }
                        rawData.put(PcUiBotConstants.MOBILE_CARD_DATAID_KEY, card.getDataId());
                        rawData.putAll(submitMap);
                    }
                    if (card != null && StringUtils.hasLength(card.getDataId()) && !CollectionUtils.isEmpty(card.getRawData())) {
                        DigiwinActionSubmitParas digiwinActionSubmitParas = null;
                        for (DigiwinActionSubmitParas paras : digiwinActionSubmitParasList) {
                            if (PcUiBotConstants.MOBILE_LOCAL_ADD_CARD_DATA_KEY.equals(paras.getOriginalSchema())) {
                                digiwinActionSubmitParas = paras;
                                break;
                            }
                        }
                        if (null == digiwinActionSubmitParas) {
                            digiwinActionSubmitParas = new DigiwinActionSubmitParas(PcUiBotConstants.MOBILE_LOCAL_ADD_CARD_DATA_KEY, null, new ArrayList<>());
                            digiwinActionSubmitParasList.add(digiwinActionSubmitParas);
                        }
                        List<DigiwinActionSubmitParas> cardSubmitParasList = (List<DigiwinActionSubmitParas>) digiwinActionSubmitParas.getValue();
                        // schema=dataid，value=card的rawdata
                        cardSubmitParasList.add(new DigiwinActionSubmitParas(card.getDataId(), mobilePath, card.getRawData()));
                    }
                    break;
                case PageButton.COMPONENT_TYPE:
                    PageButton pageButton = (PageButton) paramObj;
                    if (!CollectionUtils.isEmpty(pageButton.getSubmitParam())) {
                        List<DigiwinActionSubmitParas> pageButtonDigiwinActionSubmitParasList = this.buildSubmitParasMap(pageButton.getSubmitParam());
                        pageButtonDigiwinActionSubmitParasList.removeIf(r -> PcUiBotConstants.MOBILE_SUBMIT_CARD_DATA_KEY.equals(r.getOriginalSchema()));
                        pageButtonDigiwinActionSubmitParasList.removeIf(r -> PcUiBotConstants.MOBILE_LOCAL_ADD_CARD_DATA_KEY.equals(r.getOriginalSchema()));
                        if (!CollectionUtils.isEmpty(pageButtonDigiwinActionSubmitParasList)) {
                            digiwinActionSubmitParasList.addAll(pageButtonDigiwinActionSubmitParasList);
                        }
                    }
                    break;
                case InputSwitch.COMPONENT_TYPE:
                    InputSwitch inputSwitch = (InputSwitch) paramObj;
                    digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas(schema, mobilePath, (Optional.ofNullable(inputSwitch.getSwitchState()).orElse(0) == 1)));
                    break;
                case InputCascade.COMPONENT_TYPE:
                    // InputCascade组件 V2版 提交时，传递的是InputCascade对象
                    InputCascade inputCascade = (InputCascade) paramObj;
                    Optional.ofNullable(inputCascade).map(InputCascade::getData)
                            .orElse(new ArrayList<>())
                            .forEach(cfParam -> {
                                if (cfParam == null || !StringUtils.hasLength(cfParam.getSchema()) || !StringUtils.hasLength(cfParam.getId())) {
                                    // 如果对象中scheme、Id都是空，则返回
                                    return;
                                }
                                String currMobilePath = mobilePath;
                                if (StringUtils.hasLength(currMobilePath)) {
                                    currMobilePath = currMobilePath.replace(schema, cfParam.getSchema());
                                }
                                digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas(cfParam.getSchema(), currMobilePath, cfParam.getId()));
                            });
                    break;
                default:
                    ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                    if (null == componentParamAnalyzer) {
                        logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                                schema, JsonUtil.javaObjectToJsonString(paramObj));
                        continue;
                    }
                    Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
                    if (analyzedParam instanceof Map) {
                        Map<String, Object> map = (Map<String, Object>) analyzedParam;
                        map.forEach((k, v) -> digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas(k, mobilePath, v)));
                    } else {
                        // 提交内容暂存下来
                        if ("progress_percentage".equals(schema)) {
                            // 进度回报-进度提交，值为数值
                            String analyzedParamData = StringUtil.isEmpty(analyzedParam.toString()) ? "0" : analyzedParam.toString();
                            digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas(schema, mobilePath, Double.valueOf(analyzedParamData)));
                        } else {
                            digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas(schema, mobilePath, analyzedParam));
                        }
                    }
                    break;
            }
        }
        return digiwinActionSubmitParasList;
    }

    private void UtInspectionResultsRegistrationSave(ApiRequestSubmit apiRequestSubmit, JSONObject rawDataAction,
                                                     JSONObject rawDataData, Action<Map<String, Object>> actionAfterSubmit,
                                                     ActionPreHandleResult preHandleResult) {
        // key是鼎捷uibot中action提交时需要的参数key，value是这个key对应的值
        Map<String, Object> digiwinActionSubmitParasMap = new LinkedHashMap<>(5);

        if ("UT_InspectionResultsRegistration_Save".equals(rawDataAction.getString("type"))) {
            // 试验优测定制 - 条目详情页保存按钮操作
            preHandleResult.setNeedExecuteStandardSubmit(false);
            if (actionAfterSubmit != null) {
                // wjw TODO: 2023/9/15 因设计器暂未可配置提示语，故先写死，后面改成从设计器获取
                actionAfterSubmit.setSuccessMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "保存成功"));
            }
        } else {
            // 提交按钮
            preHandleResult.setNeedExecuteStandardSubmit(true);
            // 提交时，设置状态为2，由待处理变成已处理
            digiwinActionSubmitParasMap.put("item_status", "2");
            if (actionAfterSubmit != null) {
                // wjw TODO: 2023/9/15 因设计器暂未可配置提示语，故先写死，后面改成从设计器获取
                actionAfterSubmit.setSuccessMsg(localeService.getLanguageValue(apiRequestSubmit.getLocale(), "提交成功"));
            }
        }
        for (ActionSubmitParam submitParam : apiRequestSubmit.getSubmitParams()) {
            String type = submitParam.getType();
            // 跳过不处理
            if (Field.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                continue;
            }
            String schema = submitParam.getSchema();
            Object paramObj = submitParam.getParams();
            switch (type) {
                case Attachment.COMPONENT_TYPE:
                    Map<String, Object> uiBotAttachment = new HashMap<>();
                    Attachment<?> attachment = (Attachment) paramObj;
                    AttachmentRawDataDigiwinAthena attachmentRawData = (AttachmentRawDataDigiwinAthena) attachment.getRawData();
                    List<AttachmentFile> attachmentFiles = attachment.getFileList().stream().filter(e -> !"DELETE".equals(e.getStatus())).collect(Collectors.toList());
                    if ("video_attachment".equals(schema)) {
                        List<Map<String, Object>> resourceDatas = new ArrayList<>();
                        if (!CollectionUtils.isEmpty(attachmentFiles)) {
                            for (AttachmentFile file : attachmentFiles) {
                                boolean isImage = FileUtil.isImage(file.getFileName());

                                Map<String, Object> resourceData = new HashMap<>(5);
                                resourceData.put("id", file.getFileId());
                                resourceData.put("name", file.getFileName());
                                resourceData.put("is_cover", isImage ? "N" : "Y");
                                resourceData.put("upload_user_id", file.getFileId());
                                resourceData.put("video_cover_id", file.getCoverId());
                                resourceData.put("category", AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2/file/CTP/preview/" + (isImage ? file.getFileId() : file.getCoverId()));
                                // 只有两种类型，视频和图片，  0为图片，1为视频
                                resourceData.put("row_data", isImage ? "0" : "1");
                                resourceDatas.add(resourceData);
                            }
                        }
                        uiBotAttachment.put("data", resourceDatas);
                    } else if ("report_attachment".equals(schema)) {
                        List<Map<String, Object>> resourceDatas = new ArrayList<>();
                        if (!CollectionUtils.isEmpty(attachmentFiles)) {
                            for (AttachmentFile file : attachmentFiles) {
                                Map<String, Object> resourceData = new HashMap<>();
                                resourceData.put("id", file.getFileId());
                                resourceData.put("name", file.getFileName());
                                resourceDatas.add(resourceData);
                            }
                        }
                        uiBotAttachment.put("data", resourceDatas);
                    }
                    uiBotAttachment.put("row_data", attachmentRawData.getRowData());
                    digiwinActionSubmitParasMap.put(schema,
                            BooleanUtils.isTrue(true)
                                    ? Lists.newArrayList(uiBotAttachment) : uiBotAttachment);
                    break;
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect) paramObj;
                    Map<String, Object> detail = inputWindowSingleSelect.getDetail();
                    if (CollectionUtils.isEmpty(detail)) {
                        digiwinActionSubmitParasMap.put(schema, inputWindowSingleSelect.getSelectId());
                    } else {
                        detail.remove("__DATA_KEY");
                        digiwinActionSubmitParasMap.putAll(detail);
                    }
                    break;
                case InputDateTimePicker.COMPONENT_TYPE:
                    InputDateTimePicker inputDateTimePicker = (InputDateTimePicker) paramObj;
                    // 试验优测，日期组件暂不处理，因条目详情页保存时不用保存
                    break;
                default:
                    ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                    if (null == componentParamAnalyzer) {
                        logger.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                                schema, JsonUtil.javaObjectToJsonString(paramObj));
                        continue;
                    }
                    Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
                    if (analyzedParam instanceof Map) {
                        digiwinActionSubmitParasMap.putAll((Map<? extends String, ?>) analyzedParam);
                    } else {
                        // 提交内容暂存下来
                        digiwinActionSubmitParasMap.put(schema, analyzedParam);
                    }
                    break;
            }
        }
        JSONObject submitActionSubmitType = rawDataAction.getJSONObject("submitType");
        String rawDataDataSchema = submitActionSubmitType.getString("schema");

        if (!rawDataData.containsKey(rawDataDataSchema)) {
            preHandleResult.setActionFound(false);
            return;
        }

        if (rawDataData.get(rawDataDataSchema) instanceof List) {
            JSONArray rawDataDataSchemaData = rawDataData.getJSONArray(rawDataDataSchema);

            // 针对每一笔数据，将暂存下来的字段录入数据更新进去
            for (int i = 0; i < rawDataDataSchemaData.size(); i++) {
                JSONObject schemaData = rawDataDataSchemaData.getJSONObject(i);
                for (String key : digiwinActionSubmitParasMap.keySet()) {
//                    if ("video_attachment".equals(key) || "report_attachment".equals(key)) {
//                        // 只修改变更的数据
//                        List<Map<String, Object>> oldList = (List<Map<String, Object>>) schemaData.get(key);
//                        if (!CollectionUtils.isEmpty(oldList)) {
//                            Map<String, Map<String, Object>> oldDataMap = Optional
//                                    .ofNullable((List<Map<String, Object>>) oldList.get(0).get("data"))
//                                    .orElse(new ArrayList<>())
//                                    .stream()
//                                    .collect(Collectors.toMap(k -> StringUtil.valueOf(k.get("id")), c -> c, (c1, c2) -> c1));
//
//                            List<Map<String, Object>> newList = (List<Map<String, Object>>) digiwinActionSubmitParasMap.get(key);
//                            if (CollectionUtils.isEmpty(newList) || null == newList.get(0).get("data")) {
//                                schemaData.put(key, digiwinActionSubmitParasMap.get(key));
//                            } else {
//                                List<Map<String, Object>> newDataList = Optional
//                                        .ofNullable((List<Map<String, Object>>) newList.get(0).get("data"))
//                                        .orElse(new ArrayList<>())
//                                        .stream()
//                                        .map(map -> oldDataMap.getOrDefault(StringUtil.valueOf(map.get("id")), map))
//                                        .collect(Collectors.toList());
//                                newList.get(0).put("data", newDataList);
//                            }
//                        }
//                    }
                    schemaData.put(key, digiwinActionSubmitParasMap.get(key));
                }
                if (schemaData.containsKey("inspection_parameter_info")) {
                    List<Map<String, Object>> inspectionParameterInfoList = (List<Map<String, Object>>) schemaData.get("inspection_parameter_info");
                    if (!CollectionUtils.isEmpty(inspectionParameterInfoList)) {
                        for (Map<String, Object> inspectionParameterInfo : inspectionParameterInfoList) {
                            List<Map<String, Object>> judgmentStandardList = (List<Map<String, Object>>) inspectionParameterInfo.get("judgment_standard_list");
                            if (!CollectionUtils.isEmpty(judgmentStandardList)) {
                                Map<String, Map<String, Object>> judgmentSeq = judgmentStandardList.stream()
                                        .collect(Collectors.toMap(k -> StringUtil.valueOf(k.get("judgment_seq")), c -> c, (c1, c2) -> c1));
                                inspectionParameterInfo.putAll(judgmentSeq);
                            }
                        }
                    }
                }
            }
        } else if (rawDataData.get(rawDataDataSchema) instanceof Map) {
            JSONObject schemaData = rawDataData.getJSONObject(rawDataDataSchema);
            for (String key : digiwinActionSubmitParasMap.keySet()) {
                schemaData.put(key, digiwinActionSubmitParasMap.get(key));
            }
        }
        preHandleResult.setAction(actionAfterSubmit);

        // 更新应用数据
        Map<String, Object> params = new HashMap<>();
        String actionId = rawDataAction.getJSONObject("serviceId").getString("name");
        if ("submit-data".equals(actionId)) {
            actionId = "bm.qmsc.quality.inspection.application.item.update";
        }
        params.put("actionId", actionId);
        params.put("businessUnit", rawDataAction.getJSONObject("executeContext").getJSONObject("businessUnit"));
        params.put("executeContext", rawDataAction.getJSONObject("executeContext"));
        params.put("parameter", rawDataData);
        DigiwinAthenaApiResponse<JSONObject> result =
                digiwinAtdmProxyService
                        .handleByActionId(apiRequestSubmit.getLocale(), apiRequestSubmit.getIamUserToken(),
                                apiRequestSubmit.getTenantId(), "", params);
        if (result.getStatus() != 200) {
            preHandleResult.setActionFound(false);
        }
    }

    /**
     * 在考勤确认任务中，根据base64图片数据，上传到DMC，并落到AAM，得到返回的数据
     *
     * @param base64
     * @param apiRequest
     * @param tenantId
     * @param rowDataKey
     * @return
     */
    private AttachmentMessage buildAttachmentMessageInAamForEmployeeAttendanceConfirm(String base64,
                                                                                      ApiRequest apiRequest, String tenantId, String rowDataKey) {
        AttachmentMessage attachmentMessage = null;
        File tempImageFile = ImageUtil.generateImage(base64, ".png");
        if (null != tempImageFile && tempImageFile.canRead()) {
            String uploadCategory = "employeeAttendanceConfirmation_attachment";
            String uploadCategoryId = digiwinDmcProxyService.getDirIdByName(uploadCategory);
            if (uploadCategoryId.isEmpty()) {
                uploadCategoryId = this.digiwinDmcProxyService.createDir(uploadCategory).getId();
            }
            FileInfo fileInfo =
                    this.digiwinDmcProxyService.uploadFile(tempImageFile, uploadCategoryId);
            String fileId = fileInfo.getId();

            // 上传文件信息到Athena
            attachmentMessage = new AttachmentMessage();
            attachmentMessage.setId(fileId);
            attachmentMessage.setName(fileInfo.getFileName());
            attachmentMessage.setSize(fileInfo.getSize());
            attachmentMessage.setCategory(uploadCategory);
            attachmentMessage.setCategoryId(uploadCategoryId);
            attachmentMessage.setTenantId(tenantId);
            attachmentMessage.setRowDataKey(rowDataKey);
            attachmentMessage.setProjectId(
                    TaskStringUtil.CUSTOM_PROJECT_CODE_ATTENDANCE_CONFIRMATION);
            attachmentMessage.setTaskId(
                    TaskStringUtil.CUSTOM_TASK_CODE_EMPLOYEE_ATTENDANCE_CONFIRMATION);

            AttachmentResponse attachmentResponse =
                    digiwinAamProxyService.uploadFile(attachmentMessage, apiRequest.getIamUserToken());

            if (attachmentResponse.getStatus() != HttpStatus.OK.value()) {
                AttachmentMessage errorAttachmentMessage = new AttachmentMessage();
                errorAttachmentMessage.setDescription(
                        "上传到aam失败，原因：" + attachmentResponse.getStatusDescription());
                return errorAttachmentMessage;
            }
            if (tempImageFile.exists()) {
                try {
                    if (Files.deleteIfExists(tempImageFile.toPath())) {
                        logger.error("tempImageFile {} did not exists, so delete failed...", tempImageFile.getAbsoluteFile());
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

            return attachmentMessage;
        } else {
            attachmentMessage = new AttachmentMessage();
        }
        return attachmentMessage;
    }

    /**
     * pcUibot任务引擎提交
     *
     * @param apiRequest
     * @return
     */
    private ActionSubmitResult pcUiBotSubmit(ApiRequestSubmit apiRequest) {
        DigiwinAtmcBacklogSubmitResult atmcSubmitResult =
                this.digiwinAtmcProxyService.actionSubmit(apiRequest.getLocale(),
                        apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getRawData());
        if (null != atmcSubmitResult.getRequestData()) {
            String promptMessage =
                    LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "提交成功");
            return ActionSubmitResult.create(true, promptMessage);
        } else {
            return ActionSubmitResult.create(false, atmcSubmitResult.getErrorMessage());
        }
    }

    private ActionSubmitResult progressSubmit(ApiRequestSubmit apiRequest, Action action) {
        DigiwinAtmcBacklogSubmitResult atmcSubmitResult =
                this.digiwinAtmcProxyService.actionSubmit(apiRequest.getLocale(),
                        apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getRawData());
        if (null != atmcSubmitResult.getRequestData()) {
            return ActionSubmitResult.create(action);
        } else {
            return ActionSubmitResult.create(false, atmcSubmitResult.getErrorMessage());
        }
    }

    private List<DigiwinActionSubmitParas> specialHandle(JSONArray rawDataDataSchemaData, List<DigiwinActionSubmitParas> digiwinActionSubmitParasList, ApiRequestSubmit apiRequestSubmit, String executeCtxTmActivityId) {
        // 问题评审
        if ("questionIdentify".equalsIgnoreCase(executeCtxTmActivityId)) {
            List<DigiwinActionSubmitParas> copyDigiwinActionSubmitParasList = new ArrayList<>();
            LocaleService localeService = SpringContextHolder.getBean(LocaleServiceImpl.class);

            // 项目阶段目前前端detail 没带过来，需要从selectId 和title取
            digiwinActionSubmitParasList = digiwinActionSubmitParasList.stream().filter(e -> !"project_stage_no".equals(e.getSchema()) && !"project_stage_name".equals(e.getSchema())).collect(Collectors.toList());
            Optional<ActionSubmitParam> pageButtonParam = apiRequestSubmit.getSubmitParams().stream().filter(e -> PageButton.COMPONENT_TYPE.equalsIgnoreCase(e.getType())).findFirst();
            if (pageButtonParam.isPresent()) {
                PageButton pageButton = JsonUtil.objectToJavaObject(pageButtonParam.get().getParams(), PageButton.class);
                List<ActionSubmitParam> submitParamList = pageButton.getSubmitParam();

                if (!CollectionUtils.isEmpty(submitParamList)) {
                    ActionSubmitParam projectStageNoParam = submitParamList.stream().filter(e -> "project_stage_no".equals(e.getSchema())).findFirst().orElse(new ActionSubmitParam());
                    InputWindowSingleSelect inputWindowSingleSelect = JsonUtil.objectToJavaObject(projectStageNoParam.getParams(), InputWindowSingleSelect.class);

                    ActionSubmitParam projectStageNameParam = submitParamList.stream().filter(e -> "project_stage_name".equals(e.getSchema())).findFirst().orElse(new ActionSubmitParam());
                    InputSingleText inputSingleText = JsonUtil.objectToJavaObject(projectStageNameParam.getParams(), InputSingleText.class);

                    if (StringUtils.hasLength(inputWindowSingleSelect.getSelectId())) {
                        digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas("project_stage_no",
                                "question_result.question_basic_info.project_stage_no", inputWindowSingleSelect.getSelectId()));
                        digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas("project_stage_name",
                                "question_result.question_basic_info.project_stage_name", inputWindowSingleSelect.getTitle()));
                    } else {
                        digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas("project_stage_no",
                                "question_result.question_basic_info.project_stage_no", ""));
                        digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas("project_stage_name",
                                "question_result.question_basic_info.project_stage_name", inputSingleText.getText()));
                    }

                    // 工序detail前端没值
                    ActionSubmitParam processNameParam = submitParamList.stream().filter(e -> "process_name".equals(e.getSchema())).findFirst().orElse(new ActionSubmitParam());
                    InputWindowSingleSelect processNameParamInputWindowSingleSelect = JsonUtil.objectToJavaObject(processNameParam.getParams(), InputWindowSingleSelect.class);
                    if (StringUtils.hasLength(processNameParamInputWindowSingleSelect.getSelectId())) {
                        digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas("process_id",
                                "question_result.question_detail_info.process_id", processNameParamInputWindowSingleSelect.getSelectId()));
                        digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas("process_name",
                                "question_result.question_detail_info.process_name", processNameParamInputWindowSingleSelect.getTitle()));
                    }
                } else {
                    // 详细信息有默认值但是如果没有点保存，也需要处理才能提交到下一步流程出来
                    Map<String, Object> data = (Map<String, Object>) MapUtil.getOrDefault(apiRequestSubmit.getRawData().getInnerMap(), "data", Collections.emptyMap());
                    handleDigiwinActionSubmitParasList(data, digiwinActionSubmitParasList, "question_result.question_basic_info.project_no", "project_no");
                    handleDigiwinActionSubmitParasList(data, digiwinActionSubmitParasList, "question_result.question_basic_info.project_name", "project_name");
                    handleDigiwinActionSubmitParasList(data, digiwinActionSubmitParasList, "question_result.question_basic_info.project_stage_no", "project_stage_no");
                    handleDigiwinActionSubmitParasList(data, digiwinActionSubmitParasList, "question_result.question_basic_info.project_stage_name", "project_stage_name");
                    handleDigiwinActionSubmitParasList(data, digiwinActionSubmitParasList, "question_result.question_basic_info.equipment_no", "equipment_no");
                    handleDigiwinActionSubmitParasList(data, digiwinActionSubmitParasList, "question_result.question_basic_info.equipment_name", "equipment_name");
                    handleDigiwinActionSubmitParasList(data, digiwinActionSubmitParasList, "question_result.question_basic_info.station", "station");
                    handleDigiwinActionSubmitParasList(data, digiwinActionSubmitParasList, "question_result.question_basic_info.abnormal_work_hours", "abnormal_work_hours");
                }
            }

            for (DigiwinActionSubmitParas digiwinActionSubmitParas : digiwinActionSubmitParasList) {
                String schema = digiwinActionSubmitParas.getSchema();
                Object value = digiwinActionSubmitParas.getValue();
                if (ObjectUtils.isEmpty(value)) {
                    continue;
                }

                // 问题处理，重要性，紧急度，是否看板用了弹窗单选，值是String，pc接口接受是int,需要转化
                if ("question_process_result".equalsIgnoreCase(schema)
                        || "important".equalsIgnoreCase(schema)
                        || "urgency".equalsIgnoreCase(schema)
                        || "is_upload_kanban".equalsIgnoreCase(schema)) {
                    if (StringUtils.hasLength(String.valueOf(value))) {
                        digiwinActionSubmitParas.setValue(Integer.parseInt(String.valueOf(value)));
                    }
                }

                // 异常工时数字组件需要将值转化为字符串
                if ("abnormal_work_hours".equalsIgnoreCase(schema)) {
                    digiwinActionSubmitParas.setValue(String.valueOf(value));
                }

                // 风险等级信息不仅question_basic_info需要，question_identify_info节点也需要传进去，否则提交失败
                if ("risk_level_id".equalsIgnoreCase(schema)
                        || "risk_level_no".equalsIgnoreCase(schema)
                        || "risk_level_name".equalsIgnoreCase(schema)
                        || "important".equalsIgnoreCase(schema)
                        || "urgency".equalsIgnoreCase(schema)) {
                    String replaceMpbilePath = digiwinActionSubmitParas.getMobilePath().replace("question_basic_info", "question_identify_info");
                    DigiwinActionSubmitParas copyDigiwinActionSubmitParas = new DigiwinActionSubmitParas(digiwinActionSubmitParas.getSchema(),
                            replaceMpbilePath, digiwinActionSubmitParas.getValue());
                    copyDigiwinActionSubmitParasList.add(copyDigiwinActionSubmitParas);
                }

                // 项目信息,阶段信息，设备信息，展示时是从question_basic_info取的，但是提交时候question_detail_info节点也需要传进去，否则后续流程信息会丢失
                if ("project_no".equalsIgnoreCase(schema)
                        || "project_name".equalsIgnoreCase(schema)
                        || "project_stage_name".equalsIgnoreCase(schema)
                        || "project_stage_no".equalsIgnoreCase(schema)
                        || "equipment_name".equalsIgnoreCase(schema)
                        || "equipment_no".equalsIgnoreCase(schema)
                        || "station".equalsIgnoreCase(schema)
                        || "abnormal_work_hours".equalsIgnoreCase(schema)) {
                    String replaceMpbilePath = digiwinActionSubmitParas.getMobilePath().replace("question_basic_info", "question_detail_info");
                    DigiwinActionSubmitParas copyDigiwinActionSubmitParas = new DigiwinActionSubmitParas(digiwinActionSubmitParas.getSchema(),
                            replaceMpbilePath, digiwinActionSubmitParas.getValue());
                    copyDigiwinActionSubmitParasList.add(copyDigiwinActionSubmitParas);
                }

                // 应用接口返回的问题图片和附件不是标准格式，需要再转化成应用接口需要的格式
                if ("question_picture".equalsIgnoreCase(schema) || "attachment_info".equalsIgnoreCase(schema)
                        || "problem_review_attachment".equalsIgnoreCase(schema)) {
                    if (CollectionUtils.isEmpty((List) value)) {
                        continue;
                    }
                    UiBotAttachment uiBotAttachment = JsonUtil.objectToJavaObject(((List<?>) value).get(0), UiBotAttachment.class);
                    List<UiBotAttachmentData> uiBotAttachmentList = uiBotAttachment.getData();
                    if (CollectionUtils.isEmpty(uiBotAttachmentList)) {
                        digiwinActionSubmitParas.setValue(Collections.emptyList());
                        continue;
                    }

                    List<Map<String, Object>> attachmentInfoList;
                    if ("question_picture".equalsIgnoreCase(schema)) {
                        attachmentInfoList = uiBotAttachmentList.stream().map(e -> {
                            Map<String, Object> questionPictureMap = new HashMap<>(1);
                            questionPictureMap.put("picture_id", e.getId());
                            return questionPictureMap;
                        }).collect(Collectors.toList());
                    } else {
                        Optional<ActionSubmitParam> attachmentInfo = apiRequestSubmit.getSubmitParams().stream().filter(e -> "attachment_info".equals(e.getSchema())).findFirst();
                        List<String> problemFeedbackFileIdList;
                        if (attachmentInfo.isPresent()) {
                            Attachment attachment = (Attachment) attachmentInfo.get().getParams();
                            Optional rawDataOpt = Optional.ofNullable(attachment).map(Attachment::getRawData);
                            if (rawDataOpt.isPresent()) {
                                AttachmentRawDataDigiwinAthena attachmentRawDataDigiwinAthena = JsonUtil.objectToJavaObject(rawDataOpt.get(), AttachmentRawDataDigiwinAthena.class);
                                problemFeedbackFileIdList = Optional.ofNullable(attachmentRawDataDigiwinAthena).map(AttachmentRawDataDigiwinAthena::getExtendParam).map(e -> (List<String>) e.get("problemFeedbackFileIdList")).orElse(Collections.emptyList());
                            } else {
                                problemFeedbackFileIdList = new ArrayList<>();
                            }
                        } else {
                            problemFeedbackFileIdList = new ArrayList<>();
                        }

                        attachmentInfoList = uiBotAttachmentList.stream().map(e -> {
                            Map<String, Object> attachmentInfoMap = new HashMap<>(1);
                            attachmentInfoMap.put("attachment_id", e.getId());
                            attachmentInfoMap.put("attachment_name", e.getName());

                            // 所属阶段需要区分是问题反馈还是问题评审的
                            if (problemFeedbackFileIdList.contains(e.getId())) {
                                attachmentInfoMap.put("attachment_belong_stage", localeService.getLanguageValue(apiRequestSubmit.getLocale(), "问题反馈"));
                            } else {
                                attachmentInfoMap.put("attachment_belong_stage", localeService.getLanguageValue(apiRequestSubmit.getLocale(), "问题评审"));
                            }

                            attachmentInfoMap.put("upload_person_id", apiRequestSubmit.getUserId());
                            attachmentInfoMap.put("upload_person_name", e.getUploadUserName());
                            return attachmentInfoMap;
                        }).collect(Collectors.toList());
                    }
                    digiwinActionSubmitParas.setValue(attachmentInfoList);
                }
            }

            if (!CollectionUtils.isEmpty(copyDigiwinActionSubmitParasList)) {
                digiwinActionSubmitParasList.addAll(copyDigiwinActionSubmitParasList);
            }

            // 复盘文件和附件提交给pc是共用的attachment_info字段，所以构建参数时需要合并到一起
            Optional<DigiwinActionSubmitParas> problemReviewAttachmentOpt = digiwinActionSubmitParasList.stream().filter(e -> "problem_review_attachment".equalsIgnoreCase(e.getSchema())).findFirst();
            if (problemReviewAttachmentOpt.isPresent()) {
                DigiwinActionSubmitParas problemReviewAttachment = problemReviewAttachmentOpt.get();
                if (Objects.nonNull(problemReviewAttachment.getValue()) && !CollectionUtils.isEmpty((List) problemReviewAttachment.getValue())) {
                    List<Map<String, Object>> problemReviewAttachmentList = (List<Map<String, Object>>) problemReviewAttachment.getValue();

                    Optional<DigiwinActionSubmitParas> attachmentInfoOpt = digiwinActionSubmitParasList.stream().filter(e -> "attachment_info".equalsIgnoreCase(e.getSchema())).findFirst();
                    if (attachmentInfoOpt.isPresent()) {
                        DigiwinActionSubmitParas attachmentInfo = attachmentInfoOpt.get();
                        if (Objects.nonNull(attachmentInfo.getValue()) && !CollectionUtils.isEmpty((List) attachmentInfo.getValue())) {
                            List<Map<String, Object>> attachmentInfoList = (List<Map<String, Object>>) attachmentInfo.getValue();
                            attachmentInfoList.addAll(problemReviewAttachmentList);
                        } else {
                            attachmentInfo.setValue(problemReviewAttachmentList);
                        }
                    }
                }
                digiwinActionSubmitParasList.remove(problemReviewAttachment);
            }

            // 应用接口会返回这个字段，但是提交的时候不能传，否则提交失败
            DigiwinActionSubmitParas solutionKeyIdParas = new DigiwinActionSubmitParas("solution_key_id",
                    "question_result.question_identify_info.solution_key_id", null);
            digiwinActionSubmitParasList.add(solutionKeyIdParas);
        }
        return digiwinActionSubmitParasList;
    }

    private void handleDigiwinActionSubmitParasList(Map<String, Object> data, List<DigiwinActionSubmitParas> digiwinActionSubmitParasList, String mobilePath, String schema) {
        digiwinActionSubmitParasList.add(new DigiwinActionSubmitParas(schema,
                mobilePath, UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema)));
    }

    /**
     * 进度回报备注详情页提交处理
     *
     * @param submitParam
     * @param dataDetail
     * @return
     */
    public void handleRemarkDetail(List<ActionSubmitParam> submitParam, Map<String, Object> dataDetail) {
        if (CollectionUtils.isEmpty(submitParam)) {
            return;
        }

        for (ActionSubmitParam actionSubmitParam : submitParam) {
            switch (actionSubmitParam.getType()) {
                case SingleSelectList.COMPONENT_TYPE:
                    // 进度百分比
                    SingleSelectList singleSelectList = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), SingleSelectList.class);
                    if (StringUtils.hasLength(singleSelectList.getText())) {
                        dataDetail.put(actionSubmitParam.getSchema(), Double.valueOf(singleSelectList.getText()));
                    }
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    // 备注
                    InputMultiText inputMultiText = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), InputMultiText.class);
                    dataDetail.put(actionSubmitParam.getSchema(), inputMultiText.getText());
                    break;
                default:
                    break;
            }
        }
    }
}